/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt;

import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTCompound;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

public class NBTFile {
    private final NBTCompound root;

    public NBTFile(File file, CompressionScheme scheme) throws IOException {
        block28: {
            if (!file.exists()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            try (FileInputStream fis = new FileInputStream(file);){
                if (scheme == CompressionScheme.GZIPPED) {
                    ByteBuffer buf;
                    try (GZIPInputStream zis = new GZIPInputStream(fis);){
                        buf = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)zis));
                    }
                    this.root = (NBTCompound)NBTag.parseByteBuffer(buf);
                    break block28;
                }
                if (scheme == CompressionScheme.NONE) {
                    this.root = (NBTCompound)NBTag.parseByteBuffer(ByteBuffer.wrap(IOUtils.toByteArray((InputStream)fis)));
                    break block28;
                }
                fis.close();
                throw new RuntimeException("Unknown CompressionScheme: " + (Object)((Object)scheme));
            }
        }
    }

    public NBTCompound getRoot() {
        return this.root;
    }

    public static enum CompressionScheme {
        NONE,
        GZIPPED;

    }
}

