/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.veintypes;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.SearchField;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.oregen.BW_OreLayer;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.veintypes.BartworksOreMaterialProvider;
import com.sinthoras.visualprospecting.database.veintypes.GregTechOreMaterialProvider;
import com.sinthoras.visualprospecting.database.veintypes.IOreMaterialProvider;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.common.GT_Worldgen_GT_Ore_Layer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;

public class VeinTypeCaching
implements Runnable {
    private static BiMap<Short, VeinType> veinTypeLookupTableForIds = HashBiMap.create();
    private static Map<String, VeinType> veinTypeLookupTableForNames = new HashMap<String, VeinType>();
    private static Map<String, Short> veinTypeStorageInfo;
    public static List<VeinType> veinTypes;
    public static Set<Short> largeVeinOres;
    private static int longesOreName;

    @Override
    public void run() {
        veinTypes = new ArrayList<VeinType>();
        largeVeinOres = new HashSet<Short>();
        veinTypes.add(VeinType.NO_VEIN);
        for (GT_Worldgen_GT_Ore_Layer vein : GT_Worldgen_GT_Ore_Layer.sList) {
            if (vein.mWorldGenName.equals("ore.mix.none")) break;
            Materials material = this.getGregTechMaterial(vein.mPrimaryMeta);
            veinTypes.add(new VeinType(vein.mWorldGenName, new GregTechOreMaterialProvider(material), vein.mSize, vein.mPrimaryMeta, vein.mSecondaryMeta, vein.mBetweenMeta, vein.mSporadicMeta, Math.max(0, vein.mMinY - 6), Math.min(255, vein.mMaxY - 6)));
        }
        if (Utils.isBartworksInstalled()) {
            for (GT_Worldgen_GT_Ore_Layer vein : BW_OreLayer.sList) {
                IOreMaterialProvider oreMaterialProvider = (vein.bwOres & 8) == 0 ? new GregTechOreMaterialProvider(this.getGregTechMaterial((short)vein.mPrimaryMeta)) : new BartworksOreMaterialProvider((Werkstoff)Werkstoff.werkstoffHashMap.get((short)vein.mPrimaryMeta));
                veinTypes.add(new VeinType(vein.mWorldGenName, oreMaterialProvider, vein.mSize, (short)vein.mPrimaryMeta, (short)vein.mSecondaryMeta, (short)vein.mBetweenMeta, (short)vein.mSporadicMeta, Math.max(0, vein.mMinY), Math.min(255, vein.mMaxY)));
            }
        }
        VeinTypeCaching.loadVeinTypeStorageInfo();
        Optional<Short> maxVeinTypeIdOptional = veinTypeStorageInfo.values().stream().max(Short::compare);
        short maxVeinTypeId = maxVeinTypeIdOptional.isPresent() ? maxVeinTypeIdOptional.get() : (short)0;
        for (VeinType veinType : veinTypes) {
            if (veinTypeStorageInfo.containsKey(veinType.name)) {
                veinType.veinId = veinTypeStorageInfo.get(veinType.name);
            } else {
                veinType.veinId = maxVeinTypeId = (short)(maxVeinTypeId + 1);
                veinTypeStorageInfo.put(veinType.name, veinType.veinId);
            }
            veinTypeLookupTableForIds.put((Object)veinType.veinId, (Object)veinType);
            veinTypeLookupTableForNames.put(veinType.name, veinType);
            if (!veinType.canOverlapIntoNeighborOreChunk()) continue;
            largeVeinOres.add(veinType.primaryOreMeta);
            largeVeinOres.add(veinType.secondaryOreMeta);
            largeVeinOres.add(veinType.inBetweenOreMeta);
            largeVeinOres.add(veinType.sporadicOreMeta);
        }
        VeinTypeCaching.saveVeinTypeStorageInfo();
        for (VeinType veinType : veinTypes) {
            if (veinType.name.length() <= longesOreName) continue;
            longesOreName = veinType.name.length();
        }
    }

    private Materials getGregTechMaterial(short metaId) {
        Materials material = GregTech_API.sGeneratedMaterials[metaId];
        if (material == null) {
            return Materials.getAll().stream().filter(m -> m.mMetaItemSubID == metaId).findAny().get();
        }
        return material;
    }

    public static int getLongesOreNameLength() {
        return longesOreName;
    }

    public static short getVeinTypeId(VeinType veinType) {
        return (Short)veinTypeLookupTableForIds.inverse().get((Object)veinType);
    }

    public static VeinType getVeinType(short veinTypeId) {
        return (VeinType)veinTypeLookupTableForIds.getOrDefault((Object)veinTypeId, (Object)VeinType.NO_VEIN);
    }

    public static VeinType getVeinType(String veinTypeName) {
        return veinTypeLookupTableForNames.getOrDefault(veinTypeName, VeinType.NO_VEIN);
    }

    private static File getVeinTypeStorageInfoFile() {
        File directory = Utils.getSubDirectory("visualprospecting/");
        directory.mkdirs();
        return new File(directory, "veintypesLUT");
    }

    private static void loadVeinTypeStorageInfo() {
        veinTypeStorageInfo = Utils.readFileToMap(VeinTypeCaching.getVeinTypeStorageInfoFile());
    }

    private static void saveVeinTypeStorageInfo() {
        Utils.writeMapToFile(VeinTypeCaching.getVeinTypeStorageInfoFile(), veinTypeStorageInfo);
    }

    public static void recalculateNEISearch() {
        if (Utils.isNEIInstalled()) {
            boolean isSearchActive = SearchField.searchInventories();
            String searchString = NEIClientConfig.getSearchExpression().toLowerCase();
            Pattern filterPattern = SearchField.getPattern((String)searchString);
            for (VeinType veinType : veinTypes) {
                if (veinType == VeinType.NO_VEIN) continue;
                if (isSearchActive && !searchString.equals("")) {
                    List<String> searchableStrings = veinType.getOreMaterialNames();
                    searchableStrings.add(I18n.func_135052_a((String)veinType.name, (Object[])new Object[0]));
                    boolean match = searchableStrings.stream().map(EnumChatFormatting::func_110646_a).map(String::toLowerCase).anyMatch(searchableString -> filterPattern.matcher((CharSequence)searchableString).find());
                    veinType.setNEISearchHeighlight(match);
                    continue;
                }
                veinType.setNEISearchHeighlight(true);
            }
        }
    }

    static {
        longesOreName = 0;
    }
}

