/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms;

import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.treasure.Treasure;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.MetaStair;
import greymerk.roguelike.worldgen.blocks.Anvil;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.blocks.Furnace;
import greymerk.roguelike.worldgen.blocks.Slab;
import greymerk.roguelike.worldgen.blocks.StairType;
import greymerk.roguelike.worldgen.redstone.Hopper;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.Random;

public class DungeonsSmithy
extends DungeonBase {
    @Override
    public boolean generate(IWorldEditor editor, Random rand, LevelSettings settings, Cardinal[] entrances, Coord origin) {
        ITheme theme = settings.getTheme();
        Cardinal dir = entrances[0];
        this.clearBoxes(editor, rand, theme, dir, origin);
        Coord cursor = new Coord(origin);
        cursor.add(dir, 6);
        this.sideRoom(editor, rand, settings, dir, cursor);
        this.anvilRoom(editor, rand, settings, dir, cursor);
        cursor = new Coord(origin);
        cursor.add(Cardinal.reverse(dir), 6);
        this.sideRoom(editor, rand, settings, dir, cursor);
        cursor = new Coord(origin);
        cursor.add(Cardinal.reverse(dir), 9);
        MetaBlock air = BlockType.get(BlockType.AIR);
        air.set(editor, cursor);
        cursor.add(Cardinal.UP);
        air.set(editor, cursor);
        this.mainRoom(editor, rand, settings, dir, origin);
        return true;
    }

    private void sideRoom(IWorldEditor editor, Random rand, LevelSettings settings, Cardinal dir, Coord origin) {
        Coord cursor;
        ITheme theme = settings.getTheme();
        IBlockFactory wall = theme.getPrimaryWall();
        IBlockFactory pillar = theme.getPrimaryPillar();
        IStair stair = theme.getPrimaryStair();
        for (Cardinal side : Cardinal.orthogonal(dir)) {
            Coord start = new Coord(origin);
            start.add(Cardinal.UP, 3);
            Coord end = new Coord(start);
            start.add(side, 2);
            start.add(Cardinal.reverse(dir), 2);
            end.add(side, 3);
            end.add(dir, 2);
            RectSolid.fill(editor, rand, start, end, wall);
            start.add(dir);
            end = new Coord(start);
            end.add(dir, 2);
            RectSolid.fill(editor, rand, start, end, stair.setOrientation(Cardinal.reverse(side), true));
            for (Cardinal o : Cardinal.orthogonal(side)) {
                start = new Coord(origin);
                start.add(side, 3);
                start.add(o, 2);
                end = new Coord(start);
                end.add(Cardinal.UP, 2);
                RectSolid.fill(editor, rand, start, end, pillar);
                cursor = new Coord(end);
                cursor.add(Cardinal.reverse(side));
                stair.setOrientation(Cardinal.reverse(side), true).set(editor, cursor);
                cursor.add(Cardinal.UP);
                cursor.add(Cardinal.reverse(side));
                stair.setOrientation(Cardinal.reverse(side), true).set(editor, cursor);
                cursor = new Coord(end);
                cursor.add(Cardinal.reverse(o));
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, cursor);
            }
        }
        cursor = new Coord(origin);
        cursor.add(Cardinal.UP, 4);
        this.overheadLight(editor, rand, settings, cursor);
    }

    private void clearBoxes(IWorldEditor editor, Random rand, ITheme theme, Cardinal dir, Coord origin) {
        IBlockFactory wall = theme.getPrimaryWall();
        Coord cursor = new Coord(origin);
        cursor.add(dir, 6);
        Coord start = new Coord(cursor);
        start.add(Cardinal.DOWN);
        start.add(dir, 3);
        start.add(Cardinal.left(dir), 4);
        Coord end = new Coord(cursor);
        end.add(Cardinal.UP, 4);
        end.add(Cardinal.reverse(dir), 3);
        end.add(Cardinal.right(dir), 4);
        RectHollow.fill(editor, rand, start, end, wall);
        cursor = new Coord(origin);
        cursor.add(Cardinal.reverse(dir), 6);
        start = new Coord(cursor);
        start.add(Cardinal.DOWN);
        start.add(dir, 3);
        start.add(Cardinal.left(dir), 4);
        end = new Coord(cursor);
        end.add(Cardinal.UP, 4);
        end.add(Cardinal.reverse(dir), 3);
        end.add(Cardinal.right(dir), 4);
        RectHollow.fill(editor, rand, start, end, wall);
        start = new Coord(origin);
        start.add(Cardinal.DOWN);
        start.add(Cardinal.left(dir), 6);
        start.add(Cardinal.reverse(dir), 4);
        end = new Coord(origin);
        end.add(Cardinal.UP, 6);
        end.add(Cardinal.right(dir), 6);
        end.add(dir, 4);
        RectHollow.fill(editor, rand, start, end, wall, false, true);
    }

    private void mainRoom(IWorldEditor editor, Random rand, LevelSettings settings, Cardinal dir, Coord origin) {
        Coord cursor;
        ITheme theme = settings.getTheme();
        IBlockFactory wall = theme.getPrimaryWall();
        Coord start = new Coord(origin);
        start.add(dir, 3);
        start.add(Cardinal.UP, 4);
        Coord end = new Coord(start);
        start.add(Cardinal.left(dir), 5);
        end.add(Cardinal.right(dir), 5);
        end.add(Cardinal.UP);
        RectSolid.fill(editor, rand, start, end, wall);
        start.add(Cardinal.reverse(dir), 6);
        end.add(Cardinal.reverse(dir), 6);
        RectSolid.fill(editor, rand, start, end, wall);
        for (Cardinal side : Cardinal.orthogonal(dir)) {
            for (Cardinal o : Cardinal.orthogonal(side)) {
                cursor = new Coord(origin);
                cursor.add(side, 2);
                cursor.add(o, 3);
                this.mainPillar(editor, rand, theme, o, cursor);
                cursor.add(side, 3);
                this.mainPillar(editor, rand, theme, o, cursor);
            }
        }
        cursor = new Coord(origin);
        this.smelterSide(editor, rand, settings, Cardinal.left(dir), origin);
        this.fireplace(editor, rand, settings, Cardinal.right(dir), origin);
        cursor = new Coord(origin);
        cursor.add(Cardinal.UP, 6);
        this.overheadLight(editor, rand, settings, cursor);
    }

    private void mainPillar(IWorldEditor editor, Random rand, ITheme theme, Cardinal dir, Coord origin) {
        IBlockFactory wall = theme.getPrimaryWall();
        IBlockFactory pillar = theme.getPrimaryPillar();
        IStair stair = theme.getPrimaryStair();
        Coord start = new Coord(origin);
        Coord end = new Coord(origin);
        end.add(Cardinal.UP, 3);
        RectSolid.fill(editor, rand, start, end, pillar);
        Coord cursor = new Coord(end);
        cursor.add(Cardinal.left(dir));
        stair.setOrientation(Cardinal.left(dir), true).set(editor, cursor);
        cursor = new Coord(end);
        cursor.add(Cardinal.right(dir));
        stair.setOrientation(Cardinal.right(dir), true).set(editor, cursor);
        cursor = new Coord(end);
        cursor.add(Cardinal.reverse(dir));
        stair.setOrientation(Cardinal.reverse(dir), true).set(editor, cursor);
        cursor.add(Cardinal.UP);
        wall.set(editor, rand, cursor);
        cursor.add(Cardinal.reverse(dir));
        stair.setOrientation(Cardinal.reverse(dir), true).set(editor, cursor);
        cursor.add(Cardinal.reverse(dir));
        cursor.add(Cardinal.UP);
        start = new Coord(cursor);
        end = new Coord(cursor);
        end.add(dir, 2);
        RectSolid.fill(editor, rand, start, end, wall);
        cursor = new Coord(end);
        cursor.add(Cardinal.left(dir));
        stair.setOrientation(Cardinal.left(dir), true).set(editor, cursor);
        cursor = new Coord(end);
        cursor.add(Cardinal.right(dir));
        stair.setOrientation(Cardinal.right(dir), true).set(editor, cursor);
    }

    private void smelterSide(IWorldEditor editor, Random rand, LevelSettings settings, Cardinal dir, Coord origin) {
        ITheme theme = settings.getTheme();
        IBlockFactory wall = theme.getPrimaryWall();
        Coord start = new Coord(origin);
        start.add(dir, 5);
        Coord end = new Coord(start);
        start.add(Cardinal.left(dir), 2);
        end.add(Cardinal.right(dir), 2);
        RectSolid.fill(editor, rand, start, end, wall);
        start.add(Cardinal.reverse(dir));
        end.add(Cardinal.reverse(dir));
        IStair stair = theme.getPrimaryStair();
        stair = stair.setOrientation(Cardinal.reverse(dir), false);
        RectSolid.fill(editor, rand, start, end, stair);
        for (Cardinal o : Cardinal.orthogonal(dir)) {
            Coord cursor = new Coord(origin);
            cursor.add(dir, 3);
            cursor.add(o);
            this.smelter(editor, rand, settings, dir, cursor);
            cursor.add(o, 2);
            wall.set(editor, rand, cursor);
            cursor.add(dir);
            wall.set(editor, rand, cursor);
        }
    }

    private void smelter(IWorldEditor editor, Random rand, LevelSettings settings, Cardinal dir, Coord origin) {
        Treasure.generate(editor, rand, origin, Treasure.EMPTY, 1, false);
        Coord cursor = new Coord(origin);
        cursor.add(dir, 2);
        cursor.add(Cardinal.UP, 2);
        Treasure.generate(editor, rand, cursor, Treasure.EMPTY, 1, false);
        cursor.add(Cardinal.UP);
        cursor.add(Cardinal.reverse(dir));
        Treasure.generate(editor, rand, cursor, Treasure.EMPTY, 1, false);
        cursor = new Coord(origin);
        cursor.add(Cardinal.UP);
        cursor.add(dir);
        Furnace.generate(editor, Cardinal.reverse(dir), cursor);
        cursor = new Coord(origin);
        cursor.add(dir);
        Hopper.generate(editor, Cardinal.reverse(dir), cursor);
        cursor.add(dir);
        cursor.add(Cardinal.UP);
        Hopper.generate(editor, Cardinal.reverse(dir), cursor);
        cursor.add(Cardinal.reverse(dir));
        cursor.add(Cardinal.UP);
        Hopper.generate(editor, Cardinal.DOWN, cursor);
    }

    private void fireplace(IWorldEditor editor, Random rand, LevelSettings settings, Cardinal dir, Coord origin) {
        MetaStair stair = new MetaStair(StairType.BRICK);
        MetaBlock brick = BlockType.get(BlockType.BRICK);
        MetaBlock brickSlab = Slab.get(Slab.BRICK);
        MetaBlock bars = BlockType.get(BlockType.IRON_BAR);
        MetaBlock air = BlockType.get(BlockType.AIR);
        Coord start = new Coord(origin);
        start.add(dir, 4);
        Coord end = new Coord(start);
        start.add(Cardinal.DOWN);
        start.add(Cardinal.left(dir));
        end.add(Cardinal.right(dir));
        end.add(dir, 2);
        end.add(Cardinal.UP, 5);
        RectSolid.fill(editor, rand, start, end, brick);
        start = new Coord(origin);
        start.add(dir, 5);
        end = new Coord(start);
        end.add(Cardinal.UP, 5);
        RectSolid.fill(editor, rand, start, end, air);
        Coord cursor = new Coord(origin);
        cursor.add(Cardinal.UP);
        cursor.add(dir, 4);
        air.set(editor, cursor);
        for (Cardinal side : Cardinal.orthogonal(dir)) {
            cursor = new Coord(origin);
            cursor.add(dir, 4);
            cursor.add(side);
            stair.setOrientation(Cardinal.reverse(side), false).set(editor, cursor);
            cursor.add(Cardinal.UP);
            stair.setOrientation(Cardinal.reverse(side), true).set(editor, cursor);
            cursor.add(Cardinal.UP);
            stair.setOrientation(side, false).set(editor, cursor);
            cursor.add(Cardinal.UP);
            bars.set(editor, cursor);
            cursor.add(Cardinal.UP);
            bars.set(editor, cursor);
            cursor.add(Cardinal.UP);
            stair.setOrientation(side, true).set(editor, cursor);
            cursor = new Coord(origin);
            cursor.add(dir, 3);
            cursor.add(side);
            stair.setOrientation(Cardinal.reverse(dir), false).set(editor, cursor);
            cursor.add(side);
            stair.setOrientation(Cardinal.reverse(dir), false).set(editor, cursor);
            cursor.add(side);
            brick.set(editor, cursor);
            cursor.add(dir);
            brick.set(editor, cursor);
            cursor.add(Cardinal.UP);
            stair.setOrientation(Cardinal.reverse(side), false).set(editor, cursor);
            cursor.add(Cardinal.reverse(dir));
            stair.setOrientation(Cardinal.reverse(side), false).set(editor, cursor);
            cursor = new Coord(origin);
            cursor.add(dir, 4);
            cursor.add(side, 2);
            brick.set(editor, cursor);
            cursor.add(dir);
            brick.set(editor, cursor);
            cursor.add(Cardinal.UP);
            brick.set(editor, cursor);
            cursor.add(Cardinal.UP);
            stair.setOrientation(Cardinal.reverse(dir), false).set(editor, cursor);
            cursor.add(Cardinal.DOWN);
            cursor.add(Cardinal.reverse(dir));
            stair.setOrientation(Cardinal.reverse(dir), false).set(editor, cursor);
            cursor = new Coord(origin);
            cursor.add(dir, 3);
            cursor.add(Cardinal.UP, 5);
            stair.setOrientation(Cardinal.reverse(dir), true).set(editor, cursor);
        }
        MetaBlock netherrack = BlockType.get(BlockType.NETHERRACK);
        MetaBlock fire = BlockType.get(BlockType.FIRE);
        start = new Coord(origin);
        start.add(dir, 5);
        start.add(Cardinal.DOWN);
        end = new Coord(start);
        start.add(Cardinal.left(dir));
        end.add(Cardinal.right(dir));
        RectSolid.fill(editor, rand, start, end, netherrack);
        start.add(Cardinal.UP);
        end.add(Cardinal.UP);
        RectSolid.fill(editor, rand, start, end, fire);
        cursor = new Coord(origin);
        cursor.add(dir, 3);
        brickSlab.set(editor, cursor);
        cursor.add(dir);
        brickSlab.set(editor, cursor);
    }

    private void anvilRoom(IWorldEditor editor, Random rand, LevelSettings settings, Cardinal dir, Coord origin) {
        ITheme theme = settings.getTheme();
        IStair stair = theme.getPrimaryStair();
        IBlockFactory wall = theme.getPrimaryWall();
        MetaBlock anvil = Anvil.get(RogueConfig.getBoolean(RogueConfig.GENEROUS) ? Anvil.NEW_ANVIL : Anvil.DAMAGED_ANVIL, Cardinal.left(dir));
        Coord cursor = new Coord(origin);
        cursor.add(dir);
        anvil.set(editor, cursor);
        Coord start = new Coord(origin);
        start.add(Cardinal.right(dir), 2);
        Coord end = new Coord(start);
        start.add(dir, 2);
        end.add(Cardinal.reverse(dir), 2);
        stair.setOrientation(Cardinal.left(dir), false);
        RectSolid.fill(editor, rand, start, end, stair);
        cursor = new Coord(origin);
        cursor.add(Cardinal.right(dir), 3);
        wall.set(editor, rand, cursor);
        cursor.add(dir);
        BlockType.get(BlockType.WATER_FLOWING).set(editor, cursor);
        cursor.add(Cardinal.reverse(dir), 2);
        BlockType.get(BlockType.LAVA_FLOWING).set(editor, cursor);
        cursor = new Coord(origin);
        cursor.add(Cardinal.left(dir), 3);
        start = new Coord(cursor);
        end = new Coord(start);
        start.add(dir);
        end.add(Cardinal.reverse(dir));
        stair.setOrientation(Cardinal.right(dir), true);
        RectSolid.fill(editor, rand, start, end, stair);
        cursor.add(Cardinal.UP);
        Treasure.generate(editor, rand, cursor, Treasure.SMITH, Dungeon.getLevel(cursor.getY()));
        cursor = new Coord(origin);
    }

    private void overheadLight(IWorldEditor editor, Random rand, LevelSettings settings, Coord origin) {
        Coord cursor;
        ITheme theme = settings.getTheme();
        IStair stair = theme.getPrimaryStair();
        BlockType.get(BlockType.AIR).set(editor, origin);
        for (Cardinal dir : Cardinal.directions) {
            cursor = new Coord(origin);
            cursor.add(dir);
            stair.setOrientation(Cardinal.reverse(dir), true).set(editor, cursor);
            cursor.add(Cardinal.left(dir));
            stair.set(editor, cursor);
        }
        cursor = new Coord(origin);
        cursor.add(Cardinal.UP, 2);
        BlockType.get(BlockType.REDSTONE_BLOCK).set(editor, cursor);
        cursor.add(Cardinal.DOWN);
        BlockType.get(BlockType.REDSTONE_LAMP_LIT).set(editor, cursor);
    }

    @Override
    public int getSize() {
        return 9;
    }
}

