/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.resources.textures;

import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class SimpleNoUVTexture
implements IGuiTexture {
    private static final IGuiColor defColor = new GuiColorStatic(255, 255, 255, 255);
    private final ResourceLocation texture;
    private final IGuiRect texBounds;
    private boolean maintainAspect = false;

    public SimpleNoUVTexture(ResourceLocation texture, IGuiRect bounds) {
        this.texture = texture;
        this.texBounds = bounds;
    }

    public SimpleNoUVTexture maintainAspect(boolean enable) {
        this.maintainAspect = enable;
        return this;
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float zLevel, float partialTick) {
        this.drawTexture(x, y, width, height, zLevel, partialTick, defColor);
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float zLevel, float partialTick, IGuiColor color) {
        if (width <= 0 || height <= 0) {
            return;
        }
        GL11.glPushMatrix();
        float sx = (float)width / (float)this.texBounds.getWidth();
        float sy = (float)height / (float)this.texBounds.getHeight();
        if (this.maintainAspect) {
            float sa = Math.min(sx, sy);
            float dx = (sx - sa) * (float)this.texBounds.getWidth() / 2.0f;
            float dy = (sy - sa) * (float)this.texBounds.getHeight() / 2.0f;
            sx = sa;
            sy = sa;
            GL11.glTranslatef((float)((float)x + dx), (float)((float)y + dy), (float)0.0f);
        } else {
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        }
        color.applyGlColor();
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, (double)((float)this.texBounds.getHeight() * sy), (double)zLevel, 0.0, 1.0);
        tessellator.func_78374_a((double)((float)this.texBounds.getWidth() * sx), (double)((float)this.texBounds.getHeight() * sy), (double)zLevel, 1.0, 1.0);
        tessellator.func_78374_a((double)((float)this.texBounds.getWidth() * sx), 0.0, (double)zLevel, 1.0, 0.0);
        tessellator.func_78374_a(0.0, 0.0, (double)zLevel, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public IGuiRect getBounds() {
        return this.texBounds;
    }
}

