/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.BookmarkRecipeId;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeHandlerQuery;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.recipe.stackinfo.GTFluidStackStringifyHandler;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;

public class GuiUsageRecipe
extends GuiRecipe<IUsageHandler> {
    public static ArrayList<IUsageHandler> usagehandlers = new ArrayList();
    public static ArrayList<IUsageHandler> serialUsageHandlers = new ArrayList();

    public static boolean openRecipeGui(String inputId, Object ... ingredients) {
        ArrayList<IUsageHandler> handlers;
        if ("item".equals(inputId)) {
            ingredients = Arrays.asList(ingredients).stream().map(ingr -> GuiUsageRecipe.normalizeItemStack((ItemStack)ingr)).toArray();
        }
        if (!(handlers = GuiUsageRecipe.getUsageHandlers(inputId, ingredients)).isEmpty()) {
            Minecraft mc = NEIClientUtils.mc();
            BookmarkRecipeId recipeId = GuiUsageRecipe.getCurrentRecipe(mc.field_71462_r);
            GuiUsageRecipe gui = new GuiUsageRecipe(handlers);
            mc.func_147108_a((GuiScreen)gui);
            gui.openTargetRecipe(recipeId);
            return true;
        }
        return false;
    }

    private GuiUsageRecipe(ArrayList<IUsageHandler> handlers) {
        super(NEIClientUtils.mc().field_71462_r);
        this.currenthandlers = handlers;
    }

    public static ArrayList<IUsageHandler> getUsageHandlers(String inputId, Object ... ingredients) {
        RecipeHandlerQuery<IUsageHandler> recipeQuery = new RecipeHandlerQuery<IUsageHandler>(h -> GuiUsageRecipe.getUsageOrCatalystHandler(h, inputId, ingredients), usagehandlers, serialUsageHandlers, "Error while looking up usage recipe", "inputId: " + inputId, "ingredients: " + Arrays.toString(ingredients));
        return recipeQuery.runWithProfiling("recipe.concurrent.usage");
    }

    private static ItemStack normalizeItemStack(ItemStack stack) {
        GTFluidStackStringifyHandler.replaceAE2FCFluidDrop = true;
        stack = StackInfo.loadFromNBT(StackInfo.itemStackToNBT(stack));
        GTFluidStackStringifyHandler.replaceAE2FCFluidDrop = false;
        return stack;
    }

    public static void registerUsageHandler(IUsageHandler handler) {
        String handlerId = handler.getHandlerId();
        if (usagehandlers.stream().anyMatch(h -> h.getHandlerId().equals(handlerId)) || serialUsageHandlers.stream().anyMatch(h -> h.getHandlerId().equals(handlerId))) {
            return;
        }
        if (NEIClientConfig.serialHandlers.contains(handlerId)) {
            serialUsageHandlers.add(handler);
        } else {
            usagehandlers.add(handler);
        }
    }

    private static IUsageHandler getUsageOrCatalystHandler(IUsageHandler handler, String inputId, Object ... ingredients) {
        boolean skipCatalyst = NEIClientUtils.controlKey();
        if (NEIClientConfig.areJEIStyleRecipeCatalystsVisible() && !skipCatalyst) {
            return handler.getUsageAndCatalystHandler(inputId, ingredients);
        }
        return handler.getUsageHandler(inputId, ingredients);
    }

    @Override
    public ArrayList<IUsageHandler> getCurrentRecipeHandlers() {
        return this.currenthandlers;
    }
}

