/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.BookmarkContainerInfo;
import codechicken.nei.BookmarkCraftingChain;
import codechicken.nei.Button;
import codechicken.nei.ButtonCycled;
import codechicken.nei.ItemPanel;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemStackMap;
import codechicken.nei.ItemsGrid;
import codechicken.nei.Label;
import codechicken.nei.LayoutManager;
import codechicken.nei.LayoutStyleMinecraft;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PanelWidget;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IBookmarkContainerHandler;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.BookmarkRecipeId;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.util.NBTJson;
import codechicken.nei.util.ReadableNumberConverter;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;

public class BookmarkPanel
extends PanelWidget {
    protected File bookmarkFile;
    protected BookmarkLoadingState bookmarksState;
    protected SortableItem sortableItem;
    protected GroupingItem groupingItem;
    public Button namespacePrev;
    public Button namespaceNext;
    public Button pullBookmarkedItems;
    public Label namespaceLabel;
    protected List<BookmarkGrid> namespaces = new ArrayList<BookmarkGrid>();
    protected int activeNamespaceIndex = 0;

    public BookmarkPanel() {
        this.grid = new BookmarkGrid();
    }

    @Override
    public void init() {
        super.init();
        this.namespaceLabel = new Label("1", true);
        this.namespacePrev = new Button("Prev"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (BookmarkPanel.this.inEditingState() || rightclick) {
                    return false;
                }
                return BookmarkPanel.this.prevNamespace();
            }

            @Override
            public String getRenderLabel() {
                return "<";
            }
        };
        this.namespaceNext = new Button("Next"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (BookmarkPanel.this.inEditingState() || rightclick) {
                    return false;
                }
                return BookmarkPanel.this.nextNamespace();
            }

            @Override
            public String getRenderLabel() {
                return ">";
            }
        };
        this.pullBookmarkedItems = new Button("Pull"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                return BookmarkPanel.this.pullBookmarkItems(-1, false);
            }

            @Override
            public String getRenderLabel() {
                return "P";
            }
        };
        this.namespaces.add(new BookmarkGrid());
        this.setNamespace(this.activeNamespaceIndex);
    }

    @Override
    public String getLabelText() {
        if (((BookmarkGrid)this.grid).getCraftingMode(0)) {
            return String.format("\u00a72[\u00a7r%d/%d\u00a72]\u00a7r", this.getPage(), Math.max(1, this.getNumPages()));
        }
        return String.format("%d/%d", this.getPage(), Math.max(1, this.getNumPages()));
    }

    public boolean inEditingState() {
        return this.sortableItem != null || this.draggedStack != null || this.groupingItem != null && this.groupingItem.rowIndexB != -1;
    }

    public void addItem(ItemStack itemStack) {
        this.addItem(itemStack, true);
    }

    public void addItem(ItemStack itemStack, boolean saveStackSize) {
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        int idx = BGrid.indexOf(itemStack, true);
        if (idx != -1) {
            BGrid.removeItem(idx);
        }
        this.addOrRemoveItem(itemStack, null, null, false, saveStackSize);
    }

    public void addOrRemoveItem(ItemStack stackA) {
        this.addOrRemoveItem(stackA, null, null, false, false);
    }

    public void addOrRemoveItem(ItemStack stackover, String handlerName, List<PositionedStack> ingredients, boolean saveIngredients, boolean saveStackSize) {
        this.loadBookmarksIfNeeded();
        Point mousePos = GuiDraw.getMousePosition();
        ItemPanel.ItemPanelSlot slot = this.getSlotMouseOver(mousePos.x, mousePos.y);
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        if (slot != null && StackInfo.equalItemAndNBT(slot.item, stackover, true)) {
            BGrid.removeRecipe(slot.slotIndex, saveIngredients);
        } else {
            int idx;
            NBTTagCompound nbTagA = StackInfo.itemStackToNBT(stackover, saveStackSize);
            ItemStack normalizedA = StackInfo.loadFromNBT(nbTagA, saveStackSize ? (long)nbTagA.func_74762_e("Count") : 0L);
            BookmarkRecipeId recipeId = null;
            if (handlerName != "" && ingredients != null) {
                recipeId = new BookmarkRecipeId(handlerName, ingredients);
            }
            if ((idx = BGrid.indexOf(normalizedA, recipeId)) != -1) {
                BGrid.removeRecipe(idx, saveIngredients);
            } else {
                if (saveIngredients && handlerName != "" && ingredients != null) {
                    HashMap<String, Integer> ingredientCount = new HashMap<String, Integer>();
                    LinkedHashMap<String, NBTTagCompound> uniqueIngredients = new LinkedHashMap<String, NBTTagCompound>();
                    BGrid.removeRecipe(recipeId, 0);
                    for (PositionedStack stack : ingredients) {
                        NBTTagCompound nbTag = StackInfo.itemStackToNBT(stack.item, saveStackSize);
                        String GUID = StackInfo.getItemStackGUID(stack.item);
                        if (!uniqueIngredients.containsKey(GUID)) {
                            ingredientCount.put(GUID, nbTag.func_74762_e("Count"));
                            uniqueIngredients.put(GUID, nbTag);
                            continue;
                        }
                        ingredientCount.put(GUID, (Integer)ingredientCount.get(GUID) + nbTag.func_74762_e("Count"));
                    }
                    for (String GUID : uniqueIngredients.keySet()) {
                        BGrid.addItem(StackInfo.loadFromNBT((NBTTagCompound)uniqueIngredients.get(GUID), saveStackSize ? (long)((Integer)ingredientCount.get(GUID)).intValue() : 0L), new ItemStackMetadata(recipeId != null ? recipeId.copy() : null, (Integer)ingredientCount.get(GUID), true, 0, ((NBTTagCompound)uniqueIngredients.get(GUID)).func_74764_b("gtFluidName")));
                    }
                }
                BGrid.addItem(normalizedA, new ItemStackMetadata(recipeId, nbTagA.func_74762_e("Count"), false, 0, nbTagA.func_74764_b("gtFluidName")));
            }
        }
        this.fixCountOfNamespaces();
        this.saveBookmarks();
    }

    public BookmarkRecipeId getBookmarkRecipeId(int slotIndex) {
        ItemStackMetadata meta = ((BookmarkGrid)this.grid).getMetadata(slotIndex);
        return meta.ingredient ? null : meta.recipeId;
    }

    public BookmarkRecipeId getBookmarkRecipeId(ItemStack stackA) {
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        BookmarkRecipeId recipeId = null;
        for (int idx = 0; idx < BGrid.realItems.size(); ++idx) {
            if (!StackInfo.equalItemAndNBT(stackA, (ItemStack)BGrid.realItems.get(idx), true) || (recipeId = this.getBookmarkRecipeId(idx)) == null) continue;
            return recipeId;
        }
        return null;
    }

    public int getHoveredGroupId(boolean groupPanel) {
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        int overRowIndex = BGrid.getHoveredRowIndex(groupPanel);
        return overRowIndex >= 0 ? BGrid.getRowGroupId(overRowIndex) : -1;
    }

    public void removeGroup(int groupId) {
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        if (groupId >= 0 || groupId < BGrid.groups.size()) {
            BGrid.removeGroup(groupId);
            this.saveBookmarks();
        }
    }

    protected String getNamespaceLabelText(boolean shortFormat) {
        String activePage = String.valueOf(this.activeNamespaceIndex + 1);
        return shortFormat ? activePage : activePage + "/" + this.fixCountOfNamespaces();
    }

    protected int fixCountOfNamespaces() {
        if (this.namespaces.get(this.getNameSpaceSize() - 1).size() > 0) {
            this.namespaces.add(new BookmarkGrid());
        } else if (this.activeNamespaceIndex == this.getNameSpaceSize() - 2 && this.grid.size() == 0) {
            this.namespaces.remove(this.getNameSpaceSize() - 1);
        }
        return this.getNameSpaceSize();
    }

    protected boolean removeEmptyNamespaces() {
        if (this.activeNamespaceIndex != this.getNameSpaceSize() - 1 && this.grid.size() == 0) {
            this.namespaces.remove(this.activeNamespaceIndex);
            this.setNamespace(this.activeNamespaceIndex);
            return true;
        }
        return false;
    }

    protected boolean prevNamespace() {
        if (this.bookmarksState != BookmarkLoadingState.LOADED) {
            return false;
        }
        this.fixCountOfNamespaces();
        this.removeEmptyNamespaces();
        if (this.activeNamespaceIndex == 0) {
            this.setNamespace(this.getNameSpaceSize() - 1);
        } else {
            this.setNamespace(this.activeNamespaceIndex - 1);
        }
        return true;
    }

    protected boolean nextNamespace() {
        if (this.bookmarksState != BookmarkLoadingState.LOADED) {
            return false;
        }
        if (this.removeEmptyNamespaces()) {
            return true;
        }
        if (this.activeNamespaceIndex == this.fixCountOfNamespaces() - 1) {
            this.setNamespace(0);
        } else {
            this.setNamespace(this.activeNamespaceIndex + 1);
        }
        return true;
    }

    protected void setNamespace(int namespaceIndex) {
        this.activeNamespaceIndex = namespaceIndex;
        this.grid = this.namespaces.get(this.activeNamespaceIndex);
        if (this.grid.size() == 0 && this.activeNamespaceIndex > 0) {
            ((BookmarkGrid)this.grid).setViewMode(0, this.namespaces.get(this.activeNamespaceIndex - 1).getViewMode(0));
        }
    }

    public int getNameSpaceSize() {
        return this.namespaces.size();
    }

    public void setBookmarkFile(String worldPath) {
        File dir = new File(CommonUtils.getMinecraftDir(), "saves/NEI/" + worldPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (this.bookmarksState == BookmarkLoadingState.LOADED) {
            this.saveBookmarks();
        }
        this.bookmarkFile = new File(dir, "bookmarks.ini");
        if (!this.bookmarkFile.exists()) {
            File defaultBookmarks;
            File globalBookmarks = new File(CommonUtils.getMinecraftDir(), "saves/NEI/global/bookmarks.ini");
            File configBookmarks = new File(NEIClientConfig.configDir, "bookmarks.ini");
            File file = defaultBookmarks = configBookmarks.exists() ? configBookmarks : globalBookmarks;
            if (defaultBookmarks.exists()) {
                try {
                    this.bookmarkFile.createNewFile();
                    FileInputStream src = new FileInputStream(defaultBookmarks);
                    FileOutputStream dst = new FileOutputStream(this.bookmarkFile);
                    IOUtils.copy((InputStream)src, (OutputStream)dst);
                    ((InputStream)src).close();
                    ((OutputStream)dst).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.bookmarksState = null;
    }

    public void saveBookmarks() {
        if (this.bookmarkFile == null || this.bookmarksState != BookmarkLoadingState.LOADED) {
            return;
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (int grpIdx = 0; grpIdx < this.getNameSpaceSize() - 1; ++grpIdx) {
            BookmarkGrid grid = this.namespaces.get(grpIdx);
            JsonObject settings = new JsonObject();
            JsonObject groups = new JsonObject();
            settings.add("active", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.activeNamespaceIndex == grpIdx)));
            for (int groupId : grid.groups.keySet()) {
                BookmarkGroup group = grid.groups.get(groupId);
                JsonObject groupJson = new JsonObject();
                groupJson.add("viewmode", (JsonElement)new JsonPrimitive(group.viewMode.toString()));
                groupJson.add("crafting", (JsonElement)new JsonPrimitive(Boolean.valueOf(group.crafting != null)));
                groups.add(String.valueOf(groupId), (JsonElement)groupJson);
            }
            settings.add("groups", (JsonElement)groups);
            strings.add("; " + NBTJson.toJson((JsonElement)settings));
            for (int idx = 0; idx < grid.size(); ++idx) {
                try {
                    NBTTagCompound nbTag = StackInfo.itemStackToNBT((ItemStack)grid.realItems.get(idx));
                    if (nbTag == null) continue;
                    JsonObject row = new JsonObject();
                    ItemStackMetadata meta = grid.metadata.get(idx);
                    row.add("item", NBTJson.toJsonObject((NBTBase)nbTag));
                    row.add("factor", (JsonElement)new JsonPrimitive((Number)meta.factor));
                    row.add("ingredient", (JsonElement)new JsonPrimitive(Boolean.valueOf(meta.ingredient)));
                    if (meta.groupId != 0) {
                        row.add("groupId", (JsonElement)new JsonPrimitive((Number)meta.groupId));
                    }
                    if (meta.recipeId != null) {
                        row.add("recipeId", (JsonElement)meta.recipeId.toJsonObject());
                    }
                    strings.add(NBTJson.toJson((JsonElement)row));
                    continue;
                }
                catch (JsonSyntaxException e) {
                    NEIClientConfig.logger.error("Failed to stringify bookmarked ItemStack to json string");
                }
            }
        }
        try (FileOutputStream output = new FileOutputStream(this.bookmarkFile);){
            IOUtils.writeLines(strings, (String)"\n", (OutputStream)output, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            NEIClientConfig.logger.error("Filed to save bookmarks list to file {}", new Object[]{this.bookmarkFile, e});
        }
    }

    public void loadBookmarksIfNeeded() {
        List itemStrings;
        if (this.bookmarksState != null || this.bookmarksState == BookmarkLoadingState.LOADING) {
            return;
        }
        this.bookmarksState = BookmarkLoadingState.LOADING;
        if (this.bookmarkFile == null || !this.bookmarkFile.exists()) {
            this.bookmarksState = BookmarkLoadingState.LOADED;
            return;
        }
        try (FileInputStream reader = new FileInputStream(this.bookmarkFile);){
            NEIClientConfig.logger.info("Loading bookmarks from file {}", new Object[]{this.bookmarkFile});
            itemStrings = IOUtils.readLines((InputStream)reader, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            NEIClientConfig.logger.error("Failed to load bookmarks from file {}", new Object[]{this.bookmarkFile, e});
            return;
        }
        JsonParser parser = new JsonParser();
        ArrayList<BookmarkGrid> namespaces = new ArrayList<BookmarkGrid>();
        namespaces.add(new BookmarkGrid());
        BookmarkGrid grid = (BookmarkGrid)namespaces.get(0);
        int groupId = 0;
        int namespaceIndex = 0;
        for (String itemStr : itemStrings) {
            try {
                ItemStack itemStack;
                if (itemStr.isEmpty()) {
                    itemStr = "; {}";
                }
                if (itemStr.startsWith("; ")) {
                    JsonObject settings = parser.parse(itemStr.substring(2)).getAsJsonObject();
                    if (grid.size() > 0) {
                        grid = new BookmarkGrid();
                        namespaces.add(grid);
                    }
                    if (settings.get("viewmode") != null) {
                        grid.groups.get((Object)Integer.valueOf((int)0)).viewMode = BookmarkViewMode.valueOf(settings.get("viewmode").getAsString());
                    } else if (settings.get("groups") != null && settings.get("groups") instanceof JsonObject) {
                        JsonObject jsonObject = (JsonObject)settings.get("groups");
                        for (Map.Entry jsonEntry : jsonObject.entrySet()) {
                            if (!(jsonEntry.getValue() instanceof JsonObject)) continue;
                            JsonObject value = (JsonObject)jsonEntry.getValue();
                            BookmarkGroup group = new BookmarkGroup(value.has("viewmode") ? BookmarkViewMode.valueOf(value.get("viewmode").getAsString()) : BookmarkViewMode.DEFAULT, value.has("crafting") ? value.get("crafting").getAsBoolean() : false);
                            grid.groups.put(Integer.valueOf((String)jsonEntry.getKey()), group);
                        }
                    }
                    if (settings.get("active") == null || !settings.get("active").getAsBoolean()) continue;
                    namespaceIndex = namespaces.size() - 1;
                    continue;
                }
                JsonObject jsonObject = parser.parse(itemStr).getAsJsonObject();
                BookmarkRecipeId recipeId = null;
                NBTTagCompound itemStackNBT = jsonObject.get("item") != null ? (NBTTagCompound)NBTJson.toNbt(jsonObject.get("item")) : (NBTTagCompound)NBTJson.toNbt((JsonElement)jsonObject);
                if (jsonObject.get("recipeId") != null && jsonObject.get("recipeId") instanceof JsonObject) {
                    recipeId = new BookmarkRecipeId((JsonObject)jsonObject.get("recipeId"));
                }
                if ((itemStack = StackInfo.loadFromNBT(itemStackNBT)) != null) {
                    groupId = jsonObject.has("groupId") ? jsonObject.get("groupId").getAsInt() : 0;
                    grid.realItems.add(itemStack);
                    grid.metadata.add(new ItemStackMetadata(recipeId, jsonObject.has("factor") ? Math.abs(jsonObject.get("factor").getAsInt()) : (itemStackNBT.func_74764_b("gtFluidName") ? 144 : 1), jsonObject.has("ingredient") ? jsonObject.get("ingredient").getAsBoolean() : false, grid.groups.containsKey(groupId) ? groupId : 0, itemStackNBT.func_74764_b("gtFluidName")));
                    continue;
                }
                NEIClientConfig.logger.warn("Failed to load bookmarked ItemStack from json string, the item no longer exists:\n{}", new Object[]{itemStr});
            }
            catch (JsonSyntaxException | IllegalArgumentException | IllegalStateException e) {
                NEIClientConfig.logger.error("Failed to load bookmarked ItemStack from json string:\n{}", new Object[]{itemStr});
            }
        }
        for (BookmarkGrid gr : namespaces) {
            gr.onItemsChanged();
        }
        this.namespaces = namespaces;
        this.bookmarksState = BookmarkLoadingState.LOADED;
        this.setNamespace(namespaceIndex);
    }

    @Override
    public void resize(GuiContainer gui) {
        this.loadBookmarksIfNeeded();
        super.resize(gui);
    }

    @Override
    protected int resizeHeader(GuiContainer gui) {
        LayoutStyleMinecraft layout = (LayoutStyleMinecraft)LayoutManager.getLayoutStyle();
        int rows = (int)Math.ceil((double)layout.buttonCount / (double)layout.numButtons);
        int diff = rows * 18 + this.getMarginTop(gui) - this.y;
        if (diff > 0) {
            this.y += diff;
            this.h -= diff;
        }
        return super.resizeHeader(gui);
    }

    @Override
    protected int resizeFooter(GuiContainer gui) {
        int BUTTON_SIZE = 16;
        ButtonCycled button = LayoutManager.bookmarksButton;
        int leftBorder = this.y + this.h > button.y ? button.x + button.w + 2 : this.x;
        int rightBorder = this.x + this.w;
        int center = leftBorder + Math.max(0, (rightBorder - leftBorder) / 2);
        int labelWidth = 2;
        this.pullBookmarkedItems.h = 16;
        this.namespaceNext.h = 16;
        this.namespacePrev.h = 16;
        this.pullBookmarkedItems.w = 16;
        this.namespaceNext.w = 16;
        this.namespacePrev.w = 16;
        this.namespaceNext.y = this.pullBookmarkedItems.y = this.y + this.h - 16;
        this.namespacePrev.y = this.pullBookmarkedItems.y;
        if (rightBorder - leftBorder >= 70) {
            labelWidth = 36;
            this.namespaceLabel.text = this.getNamespaceLabelText(false);
        } else {
            labelWidth = 18;
            this.namespaceLabel.text = this.getNamespaceLabelText(true);
        }
        this.namespaceLabel.y = this.namespacePrev.y + 5;
        this.namespaceLabel.x = center;
        this.namespacePrev.x = center - labelWidth / 2 - 2 - this.namespacePrev.w;
        this.namespaceNext.x = center + labelWidth / 2 + 2;
        this.pullBookmarkedItems.x = center + 2 * labelWidth / 2 + 2;
        return 18;
    }

    @Override
    public void setVisible() {
        super.setVisible();
        if (this.grid.getPerPage() > 0) {
            LayoutManager.addWidget(this.namespacePrev);
            LayoutManager.addWidget(this.namespaceNext);
            LayoutManager.addWidget(this.namespaceLabel);
            if (BookmarkContainerInfo.getBookmarkContainerHandler(NEIClientUtils.getGuiContainer()) != null) {
                LayoutManager.addWidget(this.pullBookmarkedItems);
            }
        }
    }

    @Override
    protected String getPositioningSettingName() {
        return "world.panels.bookmarks";
    }

    @Override
    public int getMarginLeft(GuiContainer gui) {
        return 2;
    }

    @Override
    public int getMarginTop(GuiContainer gui) {
        return 2;
    }

    @Override
    public int getWidth(GuiContainer gui) {
        return gui.field_146294_l - (gui.field_146999_f + gui.field_146294_l) / 2 - 4;
    }

    @Override
    public int getHeight(GuiContainer gui) {
        return gui.field_146295_m - this.getMarginTop(gui) - 2;
    }

    @Override
    protected ItemStack getDraggedStackWithQuantity(int mouseDownSlot) {
        ItemStack stack = this.grid.getItem(mouseDownSlot);
        if (stack == null) {
            return null;
        }
        ItemStackMetadata meta = ((BookmarkGrid)this.grid).getMetadata(mouseDownSlot);
        int amount = stack.field_77994_a;
        if (amount == 0 && !meta.fluidDisplay) {
            int n = amount = NEIClientConfig.showItemQuantityWidget() ? NEIClientConfig.getItemQuantity() : 0;
            if (amount == 0) {
                amount = stack.func_77976_d();
            }
        }
        return NEIServerUtils.copyStack(stack, amount);
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        if (button == 0 && NEIClientUtils.shiftKey() && this.mouseDownSlot >= 0) {
            ItemPanel.ItemPanelSlot mouseOverSlot = this.getSlotMouseOver(mousex, mousey);
            if (this.sortableItem == null) {
                if (this.grid.getItem(this.mouseDownSlot) != null && (mouseOverSlot == null || mouseOverSlot.slotIndex != this.mouseDownSlot || heldTime > 250L)) {
                    BookmarkGrid BGrid = (BookmarkGrid)this.grid;
                    ItemStackMetadata meta = BGrid.getMetadata(this.mouseDownSlot);
                    ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                    ArrayList<ItemStackMetadata> metadata = new ArrayList<ItemStackMetadata>();
                    if (meta.recipeId == null || meta.ingredient || BGrid.getViewMode(meta.groupId) == BookmarkViewMode.DEFAULT) {
                        items.add((ItemStack)BGrid.realItems.get(this.mouseDownSlot));
                        metadata.add(BGrid.metadata.get(this.mouseDownSlot));
                    } else {
                        for (int i = 0; i < BGrid.metadata.size(); ++i) {
                            if (BGrid.metadata.get((int)i).recipeId == null || meta.groupId != BGrid.metadata.get((int)i).groupId || !meta.recipeId.equals(BGrid.metadata.get((int)i).recipeId)) continue;
                            items.add((ItemStack)BGrid.realItems.get(i));
                            metadata.add(BGrid.metadata.get(i));
                        }
                    }
                    this.sortableItem = new SortableItem(items, metadata);
                    this.grid.onGridChanged();
                }
            } else {
                BookmarkGrid BGrid = (BookmarkGrid)this.grid;
                ItemStackMetadata sortMeta = this.sortableItem.metadata.get(0);
                BookmarkViewMode sortViewMode = BGrid.getViewMode(sortMeta.groupId);
                if (sortViewMode == BookmarkViewMode.TODO_LIST && !sortMeta.ingredient) {
                    mouseOverSlot = this.getSlotMouseOver(this.grid.marginLeft + this.grid.paddingLeft, mousey);
                    if (mouseOverSlot != null) {
                        float ySlot = (float)(mousey - BGrid.marginTop) / 18.0f;
                        int lastRowIndex = BGrid.getLastRowIndex();
                        int overRowIndex = (int)ySlot;
                        int beforeGroupId = overRowIndex > 0 ? BGrid.getRowGroupId(overRowIndex - 1) : 0;
                        int afterGroupId = overRowIndex < lastRowIndex ? BGrid.getRowGroupId(overRowIndex + 1) : 0;
                        int overGroupId = BGrid.metadata.get((int)mouseOverSlot.slotIndex).groupId;
                        ySlot -= (float)overRowIndex;
                        if (this.sortableItem.items.indexOf(BGrid.realItems.get(mouseOverSlot.slotIndex)) == -1 && overGroupId == sortMeta.groupId) {
                            if (mouseOverSlot.slotIndex < BGrid.realItems.indexOf(this.sortableItem.items.get(0))) {
                                BGrid.moveItem(this.sortableItem, mouseOverSlot.slotIndex, overGroupId, true);
                            } else {
                                BGrid.moveItem(this.sortableItem, BGrid.getRowItemIndex(overRowIndex, false), overGroupId, false);
                            }
                        } else if ((double)ySlot <= 0.25) {
                            if (BGrid.getViewMode(beforeGroupId) == BookmarkViewMode.TODO_LIST && !this.existsRecipeIdInGroupId(beforeGroupId, sortMeta.recipeId)) {
                                BGrid.moveItem(this.sortableItem, mouseOverSlot.slotIndex, beforeGroupId, true);
                            }
                        } else if ((double)ySlot > 0.25 && (double)ySlot <= 0.5) {
                            if (!(beforeGroupId == afterGroupId || beforeGroupId == 0 || afterGroupId == 0 && BGrid.getViewMode(overGroupId) != BookmarkViewMode.DEFAULT || BGrid.getViewMode(0) != BookmarkViewMode.TODO_LIST || this.existsRecipeIdInGroupId(0, sortMeta.recipeId))) {
                                beforeGroupId = 0;
                            }
                            if (BGrid.getViewMode(beforeGroupId) == BookmarkViewMode.TODO_LIST && !this.existsRecipeIdInGroupId(beforeGroupId, sortMeta.recipeId)) {
                                BGrid.moveItem(this.sortableItem, mouseOverSlot.slotIndex, beforeGroupId, true);
                            }
                        } else if ((double)ySlot > 0.5 && (double)ySlot < 0.75) {
                            if (!(beforeGroupId == afterGroupId || beforeGroupId == 0 && BGrid.getViewMode(overGroupId) != BookmarkViewMode.DEFAULT || afterGroupId == 0 || BGrid.getViewMode(0) != BookmarkViewMode.TODO_LIST || this.existsRecipeIdInGroupId(0, sortMeta.recipeId))) {
                                afterGroupId = 0;
                            }
                            if (BGrid.getViewMode(afterGroupId) == BookmarkViewMode.TODO_LIST && !this.existsRecipeIdInGroupId(afterGroupId, sortMeta.recipeId)) {
                                BGrid.moveItem(this.sortableItem, BGrid.getRowItemIndex(overRowIndex, false), afterGroupId, false);
                            }
                        } else if ((double)ySlot >= 0.75 && BGrid.getViewMode(afterGroupId) == BookmarkViewMode.TODO_LIST && !this.existsRecipeIdInGroupId(afterGroupId, sortMeta.recipeId)) {
                            BGrid.moveItem(this.sortableItem, BGrid.getRowItemIndex(overRowIndex, false), afterGroupId, false);
                        }
                    }
                } else if (mouseOverSlot != null && this.sortableItem.items.indexOf(BGrid.realItems.get(mouseOverSlot.slotIndex)) == -1) {
                    ItemStackMetadata meta = BGrid.getMetadata(mouseOverSlot.slotIndex);
                    if (meta.groupId == sortMeta.groupId) {
                        if (sortViewMode == BookmarkViewMode.DEFAULT) {
                            BGrid.moveItem(this.sortableItem, mouseOverSlot.slotIndex);
                        } else if (sortViewMode == BookmarkViewMode.TODO_LIST && meta.recipeId != null && meta.recipeId.equals(sortMeta.recipeId)) {
                            BGrid.moveItem(this.sortableItem, mouseOverSlot.slotIndex);
                        }
                    }
                }
            }
            return;
        }
        if (this.groupingItem != null) {
            int overRowIndex = (mousey - this.grid.marginTop) / 18;
            if (this.groupingItem.rowIndexB != -1 || overRowIndex != this.groupingItem.rowIndexA || heldTime > 250L) {
                this.groupingItem.rowIndexB = Math.max(0, Math.min(overRowIndex, this.grid.getLastRowIndex()));
            }
            return;
        }
        super.mouseDragged(mousex, mousey, button, heldTime);
    }

    private boolean existsRecipeIdInGroupId(int groupId, BookmarkRecipeId recipeId) {
        if (recipeId == null) {
            return false;
        }
        for (ItemStackMetadata meta : ((BookmarkGrid)this.grid).metadata) {
            if (meta.groupId != groupId || this.sortableItem.metadata.indexOf(meta) != -1 || !recipeId.equals(meta.recipeId)) continue;
            return true;
        }
        return false;
    }

    private int getNextSlot() {
        List<Integer> mask = this.grid.getMask();
        int columns = this.grid.getColumns();
        int perPage = this.grid.getRows() * columns;
        boolean line = ((BookmarkGrid)this.grid).getViewMode(0) == BookmarkViewMode.TODO_LIST;
        for (int i = mask.size(); i < perPage; ++i) {
            if (this.grid.isInvalidSlot(i) || line && i % columns != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void postDraw(int mousex, int mousey) {
        int idx;
        if (this.sortableItem != null) {
            GuiContainerManager.drawItems.field_77023_b += 100.0f;
            GuiContainerManager.drawItem(mousex - 8, mousey - 8, this.sortableItem.items.get(0).func_77946_l(), true);
            GuiContainerManager.drawItems.field_77023_b -= 100.0f;
        }
        if (ItemPanels.itemPanel.draggedStack != null && this.contains(mousex, mousey) && (idx = this.getNextSlot()) >= 0) {
            Rectangle4i rect = this.grid.getSlotRect(idx);
            GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-296397483);
        }
        super.postDraw(mousex, mousey);
    }

    @Override
    public boolean handleClickExt(int mousex, int mousey, int button) {
        int overRowIndex;
        if ((button == 0 || button == 1) && (overRowIndex = ((BookmarkGrid)this.grid).getHoveredRowIndex(true)) != -1) {
            this.groupingItem = new GroupingItem(button == 1, overRowIndex);
            return true;
        }
        if (new Rectangle4i(this.pagePrev.x + this.pagePrev.w, this.pagePrev.y, this.pageNext.x - (this.pagePrev.x + this.pagePrev.w), this.pagePrev.h).contains(mousex, mousey)) {
            BookmarkGrid BGrid = (BookmarkGrid)this.grid;
            if (button == 0) {
                BGrid.toggleViewMode(0);
            } else if (button == 1) {
                BGrid.toggleCraftingMode(0);
            }
            return true;
        }
        return super.handleClickExt(mousex, mousey, button);
    }

    @Override
    public List<String> handleTooltip(int mx, int my, List<String> tooltip) {
        if (new Rectangle4i(this.pagePrev.x + this.pagePrev.w, this.pagePrev.y, this.pageNext.x - (this.pagePrev.x + this.pagePrev.w), this.pagePrev.h).contains(mx, my)) {
            tooltip.add(NEIClientUtils.translate("bookmark.viewmode.toggle.tip", new Object[0]));
        }
        if (new Rectangle4i(this.pullBookmarkedItems.x, this.pullBookmarkedItems.y, this.pullBookmarkedItems.w, this.pullBookmarkedItems.h).contains(mx, my) && BookmarkContainerInfo.getBookmarkContainerHandler(NEIClientUtils.getGuiContainer()) != null) {
            tooltip.add(NEIClientUtils.translate("bookmark.pullBookmarkedItems.tip", new Object[0]));
        }
        return super.handleTooltip(mx, my, tooltip);
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        if (this.sortableItem != null) {
            this.sortableItem = null;
            this.mouseDownSlot = -1;
            this.grid.onItemsChanged();
            this.saveBookmarks();
        } else if (this.groupingItem != null) {
            BookmarkGrid BGrid = (BookmarkGrid)this.grid;
            if (this.groupingItem.rowIndexB != -1) {
                BGrid.createGroup(this.groupingItem);
            } else {
                int groupId = BGrid.getRowGroupId(this.groupingItem.rowIndexA);
                if (groupId != 0) {
                    if (button == 0) {
                        BGrid.toggleViewMode(groupId);
                    } else if (button == 1) {
                        BGrid.toggleCraftingMode(groupId);
                    }
                }
            }
            this.mouseDownSlot = -1;
            this.groupingItem = null;
            this.grid.onItemsChanged();
            this.saveBookmarks();
        } else {
            super.mouseUp(mousex, mousey, button);
        }
    }

    @Override
    public boolean onMouseWheel(int shift, int mousex, int mousey) {
        ItemPanel.ItemPanelSlot slot;
        if (!this.inEditingState() && new Rectangle4i(this.namespacePrev.x, this.namespacePrev.y, this.namespaceNext.x + this.namespaceNext.w - this.namespacePrev.x, this.namespacePrev.h).contains(mousex, mousey)) {
            if (shift > 0) {
                this.prevNamespace();
            } else {
                this.nextNamespace();
            }
            this.saveBookmarks();
            return true;
        }
        if (!this.contains(mousex, mousey)) {
            return false;
        }
        if (NEIClientUtils.controlKey() && (slot = this.getSlotMouseOver(mousex, mousey)) != null) {
            int slotIndex;
            BookmarkGrid BGrid = (BookmarkGrid)this.grid;
            ItemStackMetadata overMeta = BGrid.getMetadata(slot.slotIndex);
            HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
            int shiftMultiplier = 1;
            if (NEIClientUtils.altKey()) {
                int n = shiftMultiplier = NEIClientConfig.showItemQuantityWidget() ? NEIClientConfig.getItemQuantity() : 0;
                if (shiftMultiplier == 0) {
                    shiftMultiplier = slot.item.func_77976_d();
                }
            }
            if (NEIClientUtils.shiftKey()) {
                for (slotIndex = this.grid.size() - 1; slotIndex >= 0; --slotIndex) {
                    ItemStackMetadata ingrMeta = BGrid.getMetadata(slotIndex);
                    if (ingrMeta.recipeId == null || ingrMeta.groupId != overMeta.groupId || !ingrMeta.recipeId.equals(overMeta.recipeId) || slotIndex == slot.slotIndex) continue;
                    items.put(slotIndex, this.shiftStackSize(BGrid, slotIndex, shift, shiftMultiplier));
                }
            }
            items.put(slot.slotIndex, this.shiftStackSize(BGrid, slot.slotIndex, shift, shiftMultiplier));
            Iterator iterator = items.keySet().iterator();
            while (iterator.hasNext()) {
                slotIndex = (Integer)iterator.next();
                if (items.get(slotIndex) == null) continue;
                BGrid.realItems.set(slotIndex, items.get(slotIndex));
            }
            BGrid.onItemsChanged();
            this.saveBookmarks();
            return true;
        }
        return super.onMouseWheel(shift, mousex, mousey);
    }

    private ItemStack shiftStackSize(BookmarkGrid BGrid, int slotIndex, int shift, int shiftMultiplier) {
        int multiplier;
        long count;
        NBTTagCompound nbTag = StackInfo.itemStackToNBT(BGrid.getItem(slotIndex));
        ItemStackMetadata meta = BGrid.getMetadata(slotIndex);
        if (meta.factor > 0 && (count = (long)((multiplier = nbTag.func_74762_e("Count") / meta.factor) + shift * shiftMultiplier) / (long)shiftMultiplier * (long)shiftMultiplier * (long)meta.factor) <= Integer.MAX_VALUE) {
            return StackInfo.loadFromNBT(nbTag, Math.max(count, 0L));
        }
        return null;
    }

    public boolean pullBookmarkItems(int groupId, boolean onlyIngredients) {
        IBookmarkContainerHandler containerHandler = BookmarkContainerInfo.getBookmarkContainerHandler(NEIClientUtils.getGuiContainer());
        if (containerHandler == null) {
            return false;
        }
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStackMap<Long> uniqueItems = new ItemStackMap<Long>();
        BookmarkGroup group = groupId >= 0 ? BGrid.groups.get(groupId) : null;
        for (int idx = 0; idx < BGrid.realItems.size(); ++idx) {
            ItemStackMetadata meta = BGrid.metadata.get(idx);
            if (groupId != -1 && groupId != meta.groupId) continue;
            ItemStack stack = BGrid.getItem(idx);
            if (onlyIngredients && (!meta.ingredient || group != null && group.crafting != null && !group.crafting.inputs.containsKey(BGrid.realItems.get(idx)))) continue;
            uniqueItems.put(stack, uniqueItems.getOrDefault(stack, 0L) + (long)StackInfo.itemStackToNBT(stack).func_74762_e("Count"));
        }
        for (ItemStackMap.Entry entry : uniqueItems.entries()) {
            if ((Long)entry.value <= 0L) continue;
            items.add(StackInfo.loadFromNBT(StackInfo.itemStackToNBT(entry.key), Math.min((Long)entry.value, (long)(36 * entry.key.func_77976_d()))));
        }
        if (items.isEmpty()) {
            return false;
        }
        containerHandler.pullBookmarkItemsFromContainer(NEIClientUtils.getGuiContainer(), items);
        return true;
    }

    public static class BookmarkGrid
    extends ItemsGrid {
        protected static final int GROUP_PANEL_WIDTH = 7;
        protected static final int DEFAULT_GROUP_ID = 0;
        protected static final float SCALE_SPEED = 0.1f;
        protected List<ItemStackMetadata> metadata = new ArrayList<ItemStackMetadata>();
        protected WeakHashMap<ItemStack, Float> animation = new WeakHashMap();
        protected RecipeTooltipRenderer recipeTooltipRenderer = null;
        protected Map<Integer, BookmarkGroup> groups = new HashMap<Integer, BookmarkGroup>();
        protected List<Integer> gridGroupMask = new ArrayList<Integer>();
        protected int previousPageGroupId = 0;
        protected int nextPageGroupId = 0;
        protected int focusedGroupId = -1;
        protected int pageCount = 0;

        public BookmarkGrid() {
            this.groups.put(0, new BookmarkGroup(BookmarkViewMode.DEFAULT));
        }

        public BookmarkViewMode getViewMode(int groupId) {
            return this.groups.get((Object)Integer.valueOf((int)groupId)).viewMode;
        }

        public void setViewMode(int groupId, BookmarkViewMode mode) {
            if (this.groups.get((Object)Integer.valueOf((int)groupId)).viewMode != mode) {
                this.groups.get((Object)Integer.valueOf((int)groupId)).viewMode = mode;
                if (mode == BookmarkViewMode.DEFAULT) {
                    this.sortGroup(groupId);
                }
                this.onItemsChanged();
            }
        }

        public void toggleViewMode(int groupId) {
            this.groups.get(groupId).toggleViewMode();
            if (this.groups.get((Object)Integer.valueOf((int)groupId)).viewMode == BookmarkViewMode.DEFAULT) {
                this.sortGroup(groupId);
            }
            this.onItemsChanged();
        }

        public boolean getCraftingMode(int groupId) {
            return this.groups.get((Object)Integer.valueOf((int)groupId)).crafting != null;
        }

        public void setCraftingMode(int groupId, boolean on) {
            if (this.groups.get((Object)Integer.valueOf((int)groupId)).crafting != null != on) {
                this.groups.get((Object)Integer.valueOf((int)groupId)).crafting = on ? new BookmarkCraftingChain() : null;
                this.onItemsChanged();
            }
        }

        public void toggleCraftingMode(int groupId) {
            this.groups.get(groupId).toggleCraftingMode();
            this.onItemsChanged();
        }

        @Override
        public int getNumPages() {
            if (this.gridMask == null) {
                this.getMask();
            }
            return this.pageCount;
        }

        @Override
        protected List<Integer> getMask() {
            if (this.gridMask != null) {
                return this.gridMask;
            }
            if (this.perPage == 0 || this.size() == 0) {
                this.gridGroupMask = new ArrayList<Integer>();
                this.gridMask = new ArrayList();
                return this.gridMask;
            }
            ItemStackMetadata previousMeta = new ItemStackMetadata(null, 1, false, 0, false);
            ArrayList<Integer> itemsMask = new ArrayList<Integer>();
            ArrayList<Integer> groupsMask = new ArrayList<Integer>();
            int size = this.size();
            int lastIdx = -1;
            int index = 0;
            int idx = 0;
            while (idx < size && lastIdx != idx) {
                lastIdx = idx;
                for (int r = 0; r < this.rows && idx < size; ++r) {
                    for (int c = 0; c < this.columns && idx < size; ++c) {
                        index = r * this.columns + c;
                        if (this.isInvalidSlot(index)) {
                            itemsMask.add(null);
                            continue;
                        }
                        ItemStackMetadata meta = this.metadata.get(idx);
                        if (c > 0 && previousMeta.groupId != meta.groupId) {
                            itemsMask.add(null);
                            continue;
                        }
                        if (this.getViewMode(meta.groupId) == BookmarkViewMode.DEFAULT) {
                            previousMeta = meta;
                            itemsMask.add(idx++);
                            continue;
                        }
                        if (c == 0 && (meta.recipeId == null || !meta.ingredient || index + 1 < this.rows * this.columns && this.isInvalidSlot(index + 1) || previousMeta.groupId != meta.groupId || meta.ingredient && !meta.recipeId.equals(previousMeta.recipeId))) {
                            previousMeta = meta;
                            itemsMask.add(idx++);
                            continue;
                        }
                        if (c > 0 && meta.recipeId != null && meta.recipeId.equals(previousMeta.recipeId)) {
                            previousMeta = meta;
                            itemsMask.add(idx++);
                            continue;
                        }
                        itemsMask.add(null);
                    }
                    groupsMask.add(previousMeta.groupId);
                }
            }
            this.pageCount = (int)Math.ceil((float)itemsMask.size() / (float)(this.rows * this.columns));
            this.page = Math.max(0, Math.min(this.page, this.pageCount - 1));
            this.gridMask = itemsMask.subList(this.page * this.rows * this.columns, Math.min(itemsMask.size(), (this.page + 1) * this.rows * this.columns));
            this.previousPageGroupId = 0;
            this.nextPageGroupId = 0;
            if (this.page > 0 && this.page * this.rows < groupsMask.size() && groupsMask.get(this.page * this.rows) == groupsMask.get(this.page * this.rows - 1)) {
                this.previousPageGroupId = (Integer)groupsMask.get(this.page * this.rows);
            }
            if ((this.page + 1) * this.rows < groupsMask.size() && groupsMask.get((this.page + 1) * this.rows) == groupsMask.get((this.page + 1) * this.rows - 1)) {
                this.nextPageGroupId = (Integer)groupsMask.get((this.page + 1) * this.rows);
            }
            this.gridGroupMask = groupsMask.subList(this.page * this.rows, Math.min(groupsMask.size(), (this.page + 1) * this.rows));
            return this.gridMask;
        }

        protected int getRowGroupId(int rowIndex) {
            if (this.gridMask == null) {
                this.getMask();
            }
            return rowIndex < this.gridGroupMask.size() ? this.gridGroupMask.get(rowIndex) : 0;
        }

        protected int getRowItemIndex(int rowIndex, boolean dir) {
            int i;
            List<Integer> mask = this.getMask();
            int size = mask.size();
            int n = i = dir ? 0 : this.columns - 1;
            while (i >= 0 && i < this.columns) {
                if (rowIndex * this.columns + i < size && mask.get(rowIndex * this.columns + i) != null) {
                    return mask.get(rowIndex * this.columns + i);
                }
                i += dir ? 1 : -1;
            }
            return -1;
        }

        protected int getHoveredRowIndex(boolean groupPanel) {
            Point mouse = GuiDraw.getMousePosition();
            int leftBorder = this.marginLeft + this.paddingLeft;
            int r = (mouse.y - this.marginTop) / 18;
            if (!new Rectangle4i(leftBorder - (groupPanel ? 7 : 0), this.marginTop, this.columns * 18, (this.getLastRowIndex() + 1) * 18).contains(mouse.x, mouse.y)) {
                return -1;
            }
            if (groupPanel && mouse.x >= leftBorder - 7 && mouse.x < leftBorder) {
                return r;
            }
            if (!groupPanel && !this.isInvalidSlot(this.columns * r + (mouse.x - leftBorder) / 18)) {
                return r;
            }
            return -1;
        }

        @Override
        public void setGridSize(int mleft, int mtop, int w, int h) {
            super.setGridSize(mleft + 7, mtop, w, h);
        }

        @Override
        public void draw(int mousex, int mousey) {
            ItemPanel.ItemPanelSlot focused;
            int rowId;
            int rowIndex;
            if (this.getPerPage() == 0) {
                return;
            }
            int focusedRowIndex = this.getHoveredRowIndex(true);
            if (focusedRowIndex != -1) {
                GuiDraw.drawRect((int)(this.marginLeft + this.paddingLeft - 7), (int)(this.marginTop + focusedRowIndex * 18), (int)7, (int)18, (int)-296397483);
            }
            GroupingItem groupingItem = LayoutManager.bookmarkPanel.groupingItem;
            List<Integer> groupMask = this.gridGroupMask;
            int groupStartIndex = -2;
            int previoudGroupId = 0;
            if (groupingItem != null && groupingItem.rowIndexB != -1) {
                int rowIndex2;
                int topRowIndex = groupingItem.getTopRowIndex(this);
                int bottomRowIndex = groupingItem.getBottomRowIndex(this);
                int groupIdA = groupMask.get(groupingItem.rowIndexA);
                int groupId = groupingItem.ungroup ? 0 : (groupIdA == 0 ? -1 : groupIdA);
                groupMask = new ArrayList<Integer>(groupMask);
                for (rowIndex2 = topRowIndex; rowIndex2 <= bottomRowIndex; ++rowIndex2) {
                    groupMask.set(rowIndex2, groupId);
                }
                if (groupIdA != 0 && !groupingItem.ungroup && groupingItem.rowIndexA != groupingItem.rowIndexB) {
                    if (groupingItem.rowIndexB < groupingItem.rowIndexA) {
                        for (rowIndex2 = topRowIndex - 1; rowIndex2 >= 0 && groupMask.get(rowIndex2) == groupIdA; --rowIndex2) {
                            groupMask.set(rowIndex2, 0);
                        }
                    } else if (groupingItem.rowIndexB > groupingItem.rowIndexA) {
                        for (rowIndex2 = bottomRowIndex + 1; rowIndex2 < groupMask.size() && groupMask.get(rowIndex2) == groupIdA; ++rowIndex2) {
                            groupMask.set(rowIndex2, 0);
                        }
                    }
                }
            }
            if (this.previousPageGroupId != 0 && this.previousPageGroupId == groupMask.get(0)) {
                previoudGroupId = this.previousPageGroupId;
                groupStartIndex = -1;
            }
            for (rowIndex = 0; rowIndex < groupMask.size(); ++rowIndex) {
                int groupId = groupMask.get(rowIndex);
                if (groupStartIndex != -2 && previoudGroupId != 0 && previoudGroupId != groupId) {
                    this.drawGroup(Math.max(0, previoudGroupId), groupStartIndex, rowIndex - 1);
                    groupStartIndex = -2;
                }
                if (groupStartIndex == -2 && groupId != 0) {
                    groupStartIndex = rowIndex;
                }
                previoudGroupId = groupId;
            }
            if (groupStartIndex != -2) {
                rowIndex = this.nextPageGroupId != 0 && this.nextPageGroupId == groupMask.get(groupMask.size() - 1) ? this.rows : this.getLastRowIndex();
                this.drawGroup(Math.max(0, previoudGroupId), groupStartIndex, rowIndex);
            }
            this.focusedGroupId = NEIClientUtils.shiftKey() && !LayoutManager.bookmarkPanel.inEditingState() ? ((rowId = this.getHoveredRowIndex(true)) != -1 ? this.getRowGroupId(rowId) : ((focused = this.getSlotMouseOver(mousex, mousey)) != null ? this.metadata.get((int)focused.slotIndex).groupId : -1)) : -1;
            super.draw(mousex, mousey);
        }

        private void drawGroup(int groupId, int rowIndexStart, int rowIndexEnd) {
            int halfWidth = 3;
            int heightPadding = 4;
            int leftPosition = this.marginLeft + this.paddingLeft - 3 - 1;
            int color = this.groups.get((Object)Integer.valueOf((int)groupId)).crafting != null ? 1715853941 : -10066330;
            int width = (Math.min(rowIndexEnd, this.rows - 1) - Math.max(0, rowIndexStart) + 1) * 18;
            int top = this.marginTop + Math.max(0, rowIndexStart) * 18;
            if (rowIndexStart >= 0) {
                GuiDraw.drawRect((int)leftPosition, (int)(this.marginTop + rowIndexStart * 18 + 4), (int)3, (int)1, (int)color);
                top += 5;
                width -= 5;
            }
            if (rowIndexEnd < this.rows) {
                GuiDraw.drawRect((int)leftPosition, (int)(this.marginTop + (rowIndexEnd + 1) * 18 - 4), (int)3, (int)1, (int)color);
                width -= 4;
            }
            GuiDraw.drawRect((int)leftPosition, (int)top, (int)1, (int)width, (int)color);
        }

        private void removeDuplicateItems() {
            HashMap recipeCache = new HashMap();
            HashMap itemsCache = new HashMap();
            HashSet<String> unique = new HashSet<String>();
            int index = 0;
            while (index < this.metadata.size()) {
                ItemStack stack = (ItemStack)this.realItems.get(index);
                ItemStackMetadata meta = this.metadata.get(index);
                String key = String.valueOf(meta.groupId);
                if (!itemsCache.containsKey(stack)) {
                    for (Object item : itemsCache.keySet()) {
                        if (!StackInfo.equalItemAndNBT(stack, (ItemStack)item, true)) continue;
                        itemsCache.put(stack, itemsCache.get(item));
                        break;
                    }
                }
                if (!itemsCache.containsKey(stack)) {
                    itemsCache.put(stack, itemsCache.size());
                }
                key = key + ":" + itemsCache.get(stack);
                if (meta.recipeId != null) {
                    if (!recipeCache.containsKey(meta.recipeId)) {
                        for (Object item : recipeCache.keySet()) {
                            if (!((BookmarkRecipeId)item).equals(meta.recipeId)) continue;
                            recipeCache.put(meta.recipeId, recipeCache.get(item));
                            break;
                        }
                    }
                    if (!recipeCache.containsKey(meta.recipeId)) {
                        recipeCache.put(meta.recipeId, recipeCache.size());
                    }
                    key = key + ":" + recipeCache.get(meta.recipeId);
                }
                if (unique.contains(key)) {
                    this.realItems.remove(index);
                    this.metadata.remove(index);
                    continue;
                }
                unique.add(key);
                ++index;
            }
        }

        private void sortGroup(int groupId) {
            int dir = this.getViewMode(groupId) == BookmarkViewMode.TODO_LIST ? 1 : -1;
            int size = this.metadata.size();
            int idx = 0;
            while (idx < size) {
                ItemStackMetadata meta = this.metadata.get(idx);
                if (meta.groupId == groupId && meta.recipeId != null) {
                    HashMap<Integer, Integer> sortingRank = new HashMap<Integer, Integer>();
                    ArrayList<ItemStackMetadata> sortedMetadata = new ArrayList<ItemStackMetadata>();
                    ArrayList sortedItems = new ArrayList();
                    ArrayList<Integer> items = new ArrayList<Integer>();
                    for (int index = idx; index < size; ++index) {
                        if (this.metadata.get((int)index).groupId != groupId || !meta.recipeId.equals(this.metadata.get((int)index).recipeId)) continue;
                        sortingRank.put(index, (this.metadata.get((int)index).ingredient ? 1 : -1) * dir);
                        items.add(index);
                    }
                    items.sort((a, b) -> (Integer)sortingRank.get(a) - (Integer)sortingRank.get(b));
                    Iterator iterator = items.iterator();
                    while (iterator.hasNext()) {
                        int index = (Integer)iterator.next();
                        sortedItems.add(this.realItems.get(index));
                        sortedMetadata.add(this.metadata.get(index));
                    }
                    this.realItems.removeAll(sortedItems);
                    this.metadata.removeAll(sortedMetadata);
                    this.realItems.addAll(idx, sortedItems);
                    this.metadata.addAll(idx, sortedMetadata);
                    idx += sortedItems.size();
                    continue;
                }
                ++idx;
            }
        }

        private void sortIngredients() {
            if (this.size() == 0) {
                return;
            }
            this.removeDuplicateItems();
            boolean inEditingState = LayoutManager.bookmarkPanel.inEditingState();
            for (int groupId : this.groups.keySet()) {
                BookmarkGroup group = this.groups.get(groupId);
                if (group.viewMode == BookmarkViewMode.TODO_LIST) {
                    this.sortGroup(groupId);
                }
                if (group.crafting == null || inEditingState) continue;
                ArrayList<ItemStackMetadata> groupMetadata = new ArrayList<ItemStackMetadata>();
                ArrayList<ItemStack> groupItems = new ArrayList<ItemStack>();
                for (int idx = 0; idx < this.metadata.size(); ++idx) {
                    if (this.metadata.get((int)idx).groupId != groupId) continue;
                    groupItems.add((ItemStack)this.realItems.get(idx));
                    groupMetadata.add(this.metadata.get(idx));
                }
                group.crafting.refresh(groupItems, groupMetadata);
            }
        }

        @Override
        protected void onItemsChanged() {
            this.sortIngredients();
            this.onGridChanged();
        }

        protected void createGroup(GroupingItem groupingItem) {
            List<Integer> mask = this.getMask();
            int topRowIndex = groupingItem.getTopRowIndex(this);
            int bottomRowIndex = groupingItem.getBottomRowIndex(this);
            int groupIdA = this.getRowGroupId(groupingItem.rowIndexA);
            int startMaskIndex = topRowIndex * this.columns;
            int endMaskIntex = Math.min((bottomRowIndex + 1) * this.columns, mask.size());
            int startItemIndex = -1;
            int endItemIndex = -1;
            int groupId = 0;
            if (!groupingItem.ungroup) {
                if (groupIdA == 0) {
                    for (ItemStackMetadata meta : this.metadata) {
                        if (meta.groupId <= groupId) continue;
                        groupId = meta.groupId;
                    }
                    this.groups.put(++groupId, new BookmarkGroup(this.getViewMode(0)));
                } else {
                    groupId = groupIdA;
                }
            }
            for (int index = startMaskIndex; index < endMaskIntex; ++index) {
                if (mask.get(index) == null) continue;
                startItemIndex = startItemIndex == -1 ? mask.get(index) : startItemIndex;
                this.metadata.get((int)mask.get((int)index).intValue()).groupId = groupId;
                endItemIndex = mask.get(index);
            }
            if (startItemIndex != -1 && endItemIndex != -1 && groupIdA != 0 && !groupingItem.ungroup && groupingItem.rowIndexA != groupingItem.rowIndexB) {
                int idx;
                if (groupingItem.rowIndexB == topRowIndex) {
                    for (idx = startItemIndex - 1; idx >= 0 && this.metadata.get((int)idx).groupId == groupIdA; --idx) {
                        this.metadata.get((int)idx).groupId = 0;
                    }
                } else {
                    for (idx = endItemIndex + 1; idx < this.metadata.size() && this.metadata.get((int)idx).groupId == groupIdA; ++idx) {
                        this.metadata.get((int)idx).groupId = 0;
                    }
                }
            }
            HashSet<Integer> usedSetIds = new HashSet<Integer>();
            for (ItemStackMetadata meta : this.metadata) {
                usedSetIds.add(meta.groupId);
            }
            this.groups.keySet().removeIf(k -> k != 0 && !usedSetIds.contains(k));
            this.onItemsChanged();
        }

        protected void removeGroup(int groupId) {
            for (int i = this.metadata.size() - 1; i >= 0; --i) {
                if (this.metadata.get((int)i).groupId != groupId) continue;
                this.metadata.remove(i);
                this.realItems.remove(i);
            }
            if (groupId != 0) {
                this.groups.remove(groupId);
            }
            this.onItemsChanged();
        }

        public int indexOf(ItemStack stackA, BookmarkRecipeId recipeId) {
            return this.indexOf(stackA, recipeId, 0);
        }

        public int indexOf(ItemStack stackA, BookmarkRecipeId recipeId, int groupId) {
            for (int idx = 0; idx < this.realItems.size(); ++idx) {
                ItemStackMetadata meta = this.getMetadata(idx);
                if (meta.groupId != groupId || (recipeId != null || meta.recipeId != null) && (recipeId == null || meta.recipeId == null || !recipeId.equals(meta.recipeId)) || !StackInfo.equalItemAndNBT(stackA, this.getItem(idx), true)) continue;
                return idx;
            }
            return -1;
        }

        @Override
        public ItemStack getItem(int idx) {
            ItemStack stack = this.realItems.get(idx);
            ItemStackMetadata meta = this.getMetadata(idx);
            BookmarkCraftingChain crafting = this.groups.get((Object)meta.groupId).crafting;
            if (crafting != null && crafting.calculatedItems.containsKey(stack)) {
                return crafting.calculatedItems.get(stack);
            }
            return stack;
        }

        public ItemStackMetadata getMetadata(int idx) {
            return this.metadata.get(idx);
        }

        public void addItem(ItemStack stackA, ItemStackMetadata meta) {
            this.addItem(stackA, meta, true);
        }

        public void addItem(ItemStack stackA, ItemStackMetadata meta, boolean animate) {
            this.realItems.add(stackA);
            this.metadata.add(meta);
            if (animate && !NEIClientConfig.shouldCacheItemRendering() && NEIClientConfig.areBookmarksAnimated()) {
                this.animation.put(stackA, Float.valueOf(0.0f));
            }
            this.onItemsChanged();
        }

        protected void removeRecipe(int idx, boolean removeFullRecipe) {
            ItemStackMetadata meta = this.getMetadata(idx);
            if (meta.recipeId != null && (removeFullRecipe || !meta.ingredient)) {
                this.removeRecipe(meta.recipeId, meta.groupId);
            } else {
                this.removeItem(idx);
            }
        }

        protected void removeRecipe(BookmarkRecipeId recipeIdA, int groupId) {
            for (int slotIndex = this.metadata.size() - 1; slotIndex >= 0; --slotIndex) {
                BookmarkRecipeId recipeIdB = this.metadata.get((int)slotIndex).recipeId;
                if (recipeIdB == null || this.metadata.get((int)slotIndex).groupId != groupId || !recipeIdB.equals(recipeIdA)) continue;
                this.removeItem(slotIndex);
            }
        }

        protected boolean removeItem(int idx) {
            this.realItems.remove(idx);
            this.metadata.remove(idx);
            this.onItemsChanged();
            return true;
        }

        public BookmarkRecipeId getRecipeId(int idx) {
            return this.getMetadata((int)idx).recipeId;
        }

        protected void moveItem(SortableItem sortableItem, int slotIndex) {
            this.moveItem(sortableItem, slotIndex, slotIndex < 0 ? 0 : this.metadata.get((int)slotIndex).groupId, slotIndex < this.realItems.indexOf(sortableItem.items.get(0)));
        }

        protected void moveItem(SortableItem sortableItem, int slotIndex, int groupId, boolean moveUp) {
            if (slotIndex == -1) {
                return;
            }
            if (sortableItem.items.indexOf(this.realItems.get(slotIndex)) == -1) {
                ItemStack stackA = (ItemStack)this.realItems.get(slotIndex);
                this.realItems.removeAll(sortableItem.items);
                this.metadata.removeAll(sortableItem.metadata);
                slotIndex = this.realItems.indexOf(stackA) + (moveUp ? 0 : 1);
                for (ItemStackMetadata sm : sortableItem.metadata) {
                    sm.groupId = groupId;
                }
                this.realItems.addAll(slotIndex, sortableItem.items);
                this.metadata.addAll(slotIndex, sortableItem.metadata);
                this.onItemsChanged();
            } else if (sortableItem.metadata.get((int)0).groupId != groupId) {
                for (ItemStackMetadata meta : sortableItem.metadata) {
                    meta.groupId = groupId;
                }
                this.onItemsChanged();
            }
        }

        @Override
        protected boolean shouldCacheItemRendering() {
            return NEIClientConfig.shouldCacheItemRendering() && this.focusedGroupId == -1;
        }

        @Override
        protected void beforeDrawSlot(@Nullable ItemPanel.ItemPanelSlot focus, int idx, Rectangle4i rect) {
            if (LayoutManager.bookmarkPanel.sortableItem != null || !NEIClientUtils.shiftKey()) {
                super.beforeDrawSlot(focus, idx, rect);
            } else if (NEIClientUtils.shiftKey() && !LayoutManager.bookmarkPanel.inEditingState()) {
                ItemStack stack = (ItemStack)this.realItems.get(idx);
                ItemStackMetadata meta = this.getMetadata(idx);
                BookmarkGroup groupMeta = this.groups.get(meta.groupId);
                if (groupMeta.crafting != null && meta.groupId == this.focusedGroupId) {
                    if (groupMeta.crafting.inputs.containsKey(stack)) {
                        GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)1715853941);
                    } else if (groupMeta.crafting.outputs.containsKey(stack)) {
                        GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-1721316097);
                    }
                } else if (focus != null && meta.recipeId != null && meta.groupId == this.getMetadata((int)focus.slotIndex).groupId && meta.recipeId.equals(this.getRecipeId(focus.slotIndex))) {
                    GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)(meta.ingredient ? 1715853941 : -1721316097));
                } else {
                    super.beforeDrawSlot(focus, idx, rect);
                }
            }
        }

        @Override
        protected void afterDrawSlot(@Nullable ItemPanel.ItemPanelSlot focus, int idx, Rectangle4i rect) {
            ItemStackMetadata meta = this.getMetadata(idx);
            if (meta.ingredient || meta.recipeId == null || LayoutManager.bookmarkPanel.sortableItem != null) {
                return;
            }
            ItemStack stack = (ItemStack)this.realItems.get(idx);
            BookmarkGroup groupMeta = this.groups.get(meta.groupId);
            int multiplier = 0;
            if (NEIClientUtils.shiftKey()) {
                ItemStackMetadata prevMeta;
                ItemStackMetadata itemStackMetadata = prevMeta = idx > 0 ? this.getMetadata(idx - 1) : null;
                if (prevMeta == null || prevMeta.ingredient || !meta.recipeId.equals(prevMeta.recipeId)) {
                    if (groupMeta.crafting != null && meta.groupId == this.focusedGroupId && groupMeta.crafting.multiplier.containsKey(stack)) {
                        multiplier = this.groups.get((Object)meta.groupId).crafting.multiplier.get(stack);
                    } else if (focus != null && meta.factor > 0 && meta.groupId == this.metadata.get((int)focus.slotIndex).groupId && meta.recipeId.equals(this.metadata.get((int)focus.slotIndex).recipeId)) {
                        multiplier = StackInfo.itemStackToNBT(stack).func_74762_e("Count") / meta.factor;
                    }
                }
            }
            if (multiplier > 0) {
                this.drawRecipeMarker(rect.x, rect.y, GuiContainerManager.getFontRenderer(stack), "x" + ReadableNumberConverter.INSTANCE.toWideReadableForm(multiplier), 0xFFFFFF);
            } else if (meta.recipeId != null && !meta.ingredient && NEIClientConfig.showRecipeMarker()) {
                this.drawRecipeMarker(rect.x, rect.y, GuiContainerManager.getFontRenderer(stack), "R", 0xA0A0A0);
            }
        }

        @Override
        protected void drawItem(Rectangle4i rect, int idx) {
            if (LayoutManager.bookmarkPanel.sortableItem == null || LayoutManager.bookmarkPanel.sortableItem.items.get(0) != this.realItems.get(idx)) {
                String stackSize;
                ItemStack realStack = (ItemStack)this.realItems.get(idx);
                ItemStackMetadata meta = this.getMetadata(idx);
                BookmarkGroup groupMeta = this.groups.get(meta.groupId);
                ItemStack drawStack = realStack;
                if (groupMeta.crafting != null && meta.groupId == this.focusedGroupId) {
                    if (groupMeta.crafting.inputs.containsKey(drawStack)) {
                        drawStack = groupMeta.crafting.inputs.get(drawStack);
                    } else if (groupMeta.crafting.outputs.containsKey(drawStack)) {
                        drawStack = groupMeta.crafting.outputs.get(drawStack);
                    } else if (groupMeta.crafting.intermediate.containsKey(drawStack)) {
                        drawStack = groupMeta.crafting.intermediate.get(drawStack);
                    }
                } else if (groupMeta.crafting != null && groupMeta.crafting.calculatedItems.containsKey(drawStack)) {
                    drawStack = groupMeta.crafting.calculatedItems.get(drawStack);
                }
                String string = stackSize = meta.fluidDisplay || drawStack.field_77994_a == 0 ? "" : ReadableNumberConverter.INSTANCE.toWideReadableForm(drawStack.field_77994_a);
                if (this.animation.containsKey(realStack) && this.animation.get(realStack).floatValue() < 1.0f) {
                    float currentScale = this.animation.get(realStack).floatValue() + 0.1f;
                    if (currentScale >= 1.0f) {
                        this.animation.remove(realStack);
                    } else {
                        this.animation.put(realStack, Float.valueOf(currentScale));
                    }
                    this.drawPoppingItem(rect, drawStack, stackSize, currentScale);
                } else {
                    GuiContainerManager.drawItem(rect.x + 1, rect.y + 1, drawStack, true, stackSize);
                }
            }
        }

        protected void drawPoppingItem(Rectangle4i rect, ItemStack stack, String stackSize, float currentScale) {
            GL11.glScalef((float)currentScale, (float)currentScale, (float)currentScale);
            GuiContainerManager.drawItem(Math.round(((float)(rect.x + 1) + (9.0f - currentScale * 18.0f / 2.0f)) / currentScale), Math.round(((float)(rect.y + 1) + (9.0f - currentScale * 18.0f / 2.0f)) / currentScale), stack, true, stackSize);
            GL11.glScalef((float)(1.0f / currentScale), (float)(1.0f / currentScale), (float)(1.0f / currentScale));
        }

        protected void drawRecipeMarker(int offsetX, int offsetY, FontRenderer fontRenderer, String text, int color) {
            float scaleFactor = fontRenderer.func_82883_a() ? 0.85f : 0.5f;
            float inverseScaleFactor = 1.0f / scaleFactor;
            GuiContainerManager.enable2DRender();
            GL11.glScaled((double)scaleFactor, (double)scaleFactor, (double)scaleFactor);
            int X = (int)(((float)offsetX + 1.0f) * inverseScaleFactor);
            int Y = (int)(((float)offsetY + 1.0f) * inverseScaleFactor);
            fontRenderer.func_78261_a(text, X, Y, color);
            GL11.glScaled((double)inverseScaleFactor, (double)inverseScaleFactor, (double)inverseScaleFactor);
            GuiContainerManager.enable3DRender();
        }

        @Override
        public void update() {
            if (this.recipeTooltipRenderer != null) {
                if (this.recipeTooltipRenderer.createRecipeGui != null) {
                    this.recipeTooltipRenderer.createRecipeGui.run();
                    this.recipeTooltipRenderer.createRecipeGui = null;
                }
                if (this.recipeTooltipRenderer.gui != null) {
                    this.recipeTooltipRenderer.gui.updateAsTooltip();
                }
            }
        }

        @Override
        public void postDrawTooltips(int mousex, int mousey, List<String> tooltip) {
            if (NEIClientConfig.getRecipeTooltipsMode() != 0) {
                try {
                    this.drawRecipeTooltip(mousex, mousey, tooltip);
                }
                catch (Exception e) {
                    NEIClientConfig.logger.warn("Cannot draw recipe tooltip", (Throwable)e);
                }
            }
        }

        private void drawRecipeTooltip(int mousex, int mousey, List<String> itemTooltip) {
            if (!NEIClientConfig.isLoaded()) {
                return;
            }
            ItemPanel.ItemPanelSlot focused = this.getSlotMouseOver(mousex, mousey);
            if (focused == null) {
                this.recipeTooltipRenderer = null;
                return;
            }
            ItemStackMetadata meta = this.metadata.get(focused.slotIndex);
            int tooltipMode = NEIClientConfig.getRecipeTooltipsMode();
            if (meta.recipeId == null || meta.ingredient) {
                this.recipeTooltipRenderer = null;
                return;
            }
            if (this.groups.get((Object)meta.groupId).viewMode == BookmarkViewMode.DEFAULT && tooltipMode != 1 && tooltipMode != 3) {
                this.recipeTooltipRenderer = null;
                return;
            }
            if (this.groups.get((Object)meta.groupId).viewMode == BookmarkViewMode.TODO_LIST && tooltipMode != 2 && tooltipMode != 3) {
                this.recipeTooltipRenderer = null;
                return;
            }
            if (this.recipeTooltipRenderer == null || this.recipeTooltipRenderer.recipeId != meta.recipeId) {
                this.recipeTooltipRenderer = new RecipeTooltipRenderer();
                this.recipeTooltipRenderer.stack = (ItemStack)this.realItems.get(focused.slotIndex);
                this.recipeTooltipRenderer.recipeId = meta.recipeId;
                this.recipeTooltipRenderer.createRecipeGui = () -> {
                    GuiRecipe<?> gui = GuiCraftingRecipe.createRecipeGui("recipeId", false, this.recipeTooltipRenderer.stack, this.recipeTooltipRenderer.recipeId);
                    if (gui != null) {
                        gui.func_73866_w_();
                        gui.field_147009_r = 0;
                        gui.field_147003_i = 0;
                    }
                    this.recipeTooltipRenderer.gui = gui;
                };
            }
            if (this.recipeTooltipRenderer.gui != null) {
                Minecraft mc = Minecraft.func_71410_x();
                int recipeTooltipLines = Math.max(1, itemTooltip.size());
                GL11.glPushMatrix();
                float tooltipYOffset = mousey - this.marginTop > this.height / 2 ? (float)(mousey - this.recipeTooltipRenderer.gui.getHeightAsWidget() + 8) : (float)(mousey + (recipeTooltipLines < 2 ? 1 : 3 + (recipeTooltipLines - 1) * 10));
                GL11.glTranslatef((float)mousex, (float)tooltipYOffset, (float)500.0f);
                GL11.glPushAttrib((int)1048575);
                RenderHelper.func_74518_a();
                this.recipeTooltipRenderer.gui.func_146976_a(0.0f, -100, -100);
                GL11.glPopAttrib();
                if (this.recipeTooltipRenderer.gui.slotcontainer != null) {
                    GL11.glPushAttrib((int)1048575);
                    RenderHelper.func_74520_c();
                    GL11.glEnable((int)32826);
                    List slots = this.recipeTooltipRenderer.gui.slotcontainer.field_75151_b;
                    for (Slot slot : slots) {
                        if (slot == null || slot.func_75211_c() == null) continue;
                        GuiContainerManager.drawItem(slot.field_75223_e, slot.field_75221_f, slot.func_75211_c());
                    }
                    GL11.glPopAttrib();
                }
                this.recipeTooltipRenderer.gui.func_146979_b(-100, -100);
                for (GuiButton btn : this.recipeTooltipRenderer.gui.getOverlayButtons()) {
                    btn.func_146112_a(mc, -100, -100);
                }
                GL11.glPopMatrix();
            }
        }

        private static class RecipeTooltipRenderer {
            public ItemStack stack = null;
            public BookmarkRecipeId recipeId = null;
            public GuiRecipe<?> gui = null;
            public Runnable createRecipeGui = null;

            private RecipeTooltipRenderer() {
            }
        }
    }

    protected static class BookmarkGroup {
        public BookmarkCraftingChain crafting = null;
        public BookmarkViewMode viewMode;

        public BookmarkGroup(BookmarkViewMode viewMode) {
            this.viewMode = viewMode;
        }

        public BookmarkGroup(BookmarkViewMode viewMode, boolean crafting) {
            this.viewMode = viewMode;
            this.crafting = crafting ? new BookmarkCraftingChain() : null;
        }

        public void toggleViewMode() {
            this.viewMode = this.viewMode == BookmarkViewMode.DEFAULT ? BookmarkViewMode.TODO_LIST : BookmarkViewMode.DEFAULT;
        }

        public void toggleCraftingMode() {
            this.crafting = this.crafting == null ? new BookmarkCraftingChain() : null;
        }

        public BookmarkGroup copy() {
            return new BookmarkGroup(this.viewMode);
        }
    }

    public static enum BookmarkLoadingState {
        LOADING,
        LOADED;

    }

    public static enum BookmarkViewMode {
        DEFAULT,
        TODO_LIST;

    }

    protected static class ItemStackMetadata {
        public int factor;
        public Integer groupId;
        public BookmarkRecipeId recipeId;
        public boolean ingredient = false;
        public boolean fluidDisplay = false;

        public ItemStackMetadata(BookmarkRecipeId recipeId, int factor, boolean ingredient, Integer groupId, boolean fluidDisplay) {
            this.recipeId = recipeId;
            this.factor = factor;
            this.ingredient = ingredient;
            this.groupId = groupId;
            this.fluidDisplay = fluidDisplay;
        }

        public ItemStackMetadata copy() {
            return new ItemStackMetadata(this.recipeId, this.factor, this.ingredient, this.groupId, this.fluidDisplay);
        }
    }

    protected static class GroupingItem {
        public boolean ungroup;
        public int rowIndexA;
        public int rowIndexB = -1;

        public GroupingItem(boolean ungroup, int rowIndexA) {
            this.ungroup = ungroup;
            this.rowIndexA = rowIndexA;
        }

        public int getTopRowIndex(BookmarkGrid BGrid) {
            ItemStackMetadata meta;
            int topRowIndex = Math.min(this.rowIndexA, this.rowIndexB);
            int topItemIndex = BGrid.getRowItemIndex(topRowIndex, true);
            ItemStackMetadata itemStackMetadata = meta = topItemIndex >= 0 ? BGrid.metadata.get(topItemIndex) : null;
            if (meta != null && meta.recipeId != null) {
                while (topItemIndex > 0 && meta.groupId == BGrid.metadata.get((int)(topItemIndex - 1)).groupId && meta.recipeId.equals(BGrid.metadata.get((int)(topItemIndex - 1)).recipeId)) {
                    --topItemIndex;
                }
                int index = BGrid.getMask().indexOf(topItemIndex);
                topRowIndex = index == -1 ? 0 : index / BGrid.columns;
            }
            return topRowIndex;
        }

        public int getBottomRowIndex(BookmarkGrid BGrid) {
            ItemStackMetadata meta;
            int bottomRowIndex = Math.max(this.rowIndexA, this.rowIndexB);
            int bottomItemIndex = BGrid.getRowItemIndex(bottomRowIndex, false);
            ItemStackMetadata itemStackMetadata = meta = bottomItemIndex >= 0 ? BGrid.metadata.get(bottomItemIndex) : null;
            if (meta != null && meta.recipeId != null) {
                int size = BGrid.size();
                while (bottomItemIndex < size - 1 && meta.groupId == BGrid.metadata.get((int)(bottomItemIndex + 1)).groupId && meta.recipeId.equals(BGrid.metadata.get((int)(bottomItemIndex + 1)).recipeId)) {
                    ++bottomItemIndex;
                }
                int index = BGrid.getMask().indexOf(bottomItemIndex);
                bottomRowIndex = index == -1 ? BGrid.getLastRowIndex() : index / BGrid.columns;
            }
            return bottomRowIndex;
        }
    }

    protected static class SortableItem {
        public List<ItemStack> items = new ArrayList<ItemStack>();
        public List<ItemStackMetadata> metadata = new ArrayList<ItemStackMetadata>();

        public SortableItem(List<ItemStack> items, List<ItemStackMetadata> metadata) {
            this.items = items;
            this.metadata = metadata;
        }
    }
}

