/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import com.google.common.collect.ImmutableSet;
import com.gtnewhorizons.modularui.api.drawable.FallbackableUITexture;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.common.builder.UIInfo;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularUIContainer;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IAlleleBeeAcceleratableEffect;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorState;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.errors.EnumErrorCode;
import forestry.plugins.PluginApiculture;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.recipe.BasicUIProperties;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ApiaryModifier;
import gregtech.api.util.GT_ApiaryUpgrade;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Client;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_IndustrialApiary
extends GT_MetaTileEntity_BasicMachine
implements IBeeHousing,
IBeeHousingInventory,
IErrorLogic,
IBeeModifier,
IBeeListener,
IAddUIWidgets {
    public static final int beeCycleLength = 550;
    public static final int baseEUtUsage = 37;
    private static final int queen = 5;
    private static final int drone = 6;
    private static final int upgradeSlot = 7;
    private static final int upgradeSlotCount = 4;
    private static Field AlleleBeeEffectThrottledField;
    final IBeeRoot beeRoot = (IBeeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
    public int mSpeed = 0;
    public boolean mLockedSpeed = true;
    public boolean mAutoQueen = true;
    private ItemStack usedQueen = null;
    private IBee usedQueenBee = null;
    private IEffectData[] effectData = new IEffectData[2];
    boolean retrievingPollenInThisOperation = false;
    IIndividual retrievedpollen = null;
    int pollinationDelay = 100;
    float usedBeeLife = 0.0f;
    GameProfile owner = null;
    public HashSet<IErrorState> mErrorStates = new HashSet();
    private String flowerType = "";
    private ChunkCoordinates flowercoords = null;
    private Block flowerBlock;
    private int flowerBlockMeta;
    private float terrorityMod = 1.0f;
    private float mutationMod = 1.0f;
    private float lifespanMod = 1.0f;
    private float productionMod = 2.0f;
    private float floweringMod = 1.0f;
    private float geneticDecayMod = 1.0f;
    private float energyMod = 1.0f;
    private boolean sealedMod = false;
    private boolean selfLightedMod = false;
    private boolean selfUnlightedMod = false;
    private boolean sunlightSimulatedMod = false;
    private BiomeGenBase biomeOverride = null;
    private float humidityMod = 0.0f;
    private float temperatureMod = 0.0f;
    private boolean isAutomated = false;
    private boolean isRetrievingPollen = false;
    private int maxspeed = 0;
    static final IBeekeepingLogic dummylogic;
    private static final String POWER_SOURCE_POWER = "GT5U.machines.powersource.power";
    private static final String CANCEL_PROCESS_TOOLTIP = "GT5U.machines.industrialapiary.cancel.tooltip";
    private static final String SPEED_TOOLTIP = "GT5U.machines.industrialapiary.speed.tooltip";
    private static final String SPEED_LOCKED_TOOLTIP = "GT5U.machines.industrialapiary.speedlocked.tooltip";
    private static final String INFO_TOOLTIP = "GT5U.machines.industrialapiary.info.tooltip";
    private static final String INFO_WITH_BEE_TOOLTIP = "GT5U.machines.industrialapiary.infoextended.tooltip";
    private static final String UPGRADE_TOOLTIP = "GT5U.machines.industrialapiary.upgradeslot.tooltip";
    private static final String AUTOQUEEN_TOOLTIP = "GT5U.machines.industrialapiary.autoqueen.tooltip";
    private static final FallbackableUITexture progressBarTexture;
    private static final UIInfo<?, ?> IndustrialApiaryUI;

    public GT_MetaTileEntity_IndustrialApiary(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 4, new String[]{"BEES GOES BRRRR", EnumChatFormatting.GRAY + GT_Values.AuthorKuba, "Effective production chance as a percent is", "2.8 * b^0.52 * (p + t)^0.52 * s^0.37", "where b is the base production chance as a percent,", "p is the production modifier (2 w/o upgrades, or 4 * 1.2^n with n production upgrades),", "t is 8 for the industrial apiary, and", "s is the speed value for the bee", "Outputs are generated at the end of every bee tick (...)", "Primary outputs are rolled once with base chance, once with half base"}, 6, 9, TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_INDUSTRIAL_APIARY_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_INDUSTRIAL_APIARY_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_INDUSTRIAL_APIARY), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_INDUSTRIAL_APIARY_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_INDUSTRIAL_APIARY_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_INDUSTRIAL_APIARY_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_INDUSTRIAL_APIARY), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_INDUSTRIAL_APIARY_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_INDUSTRIAL_APIARY_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_INDUSTRIAL_APIARY_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_INDUSTRIAL_APIARY), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_INDUSTRIAL_APIARY_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_INDUSTRIAL_APIARY_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_INDUSTRIAL_APIARY_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_INDUSTRIAL_APIARY), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_INDUSTRIAL_APIARY_GLOW).glow().build()));
    }

    public GT_MetaTileEntity_IndustrialApiary(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 4, aDescription, aTextures, 6, 9);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_IndustrialApiary(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (!GT_Mod.gregtechproxy.mForceFreeFace) {
            this.openGUI(aBaseMetaTileEntity, aPlayer);
            return true;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!aBaseMetaTileEntity.getAirAtSide(side)) continue;
            this.openGUI(aBaseMetaTileEntity, aPlayer);
            return true;
        }
        GT_Utility.sendChatToPlayer(aPlayer, "No free Side!");
        return true;
    }

    private void openGUI(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        IndustrialApiaryUI.open(aPlayer, aBaseMetaTileEntity.getWorld(), aBaseMetaTileEntity.getXCoord(), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord());
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mSpeed", this.mSpeed);
        aNBT.func_74757_a("mLockedSpeed", this.mLockedSpeed);
        aNBT.func_74757_a("mAutoQueen", this.mAutoQueen);
        if (this.usedQueen != null) {
            aNBT.func_74782_a("usedQueen", (NBTBase)this.usedQueen.func_77955_b(new NBTTagCompound()));
        }
        aNBT.func_74757_a("retrievingPollenInThisOperation", this.retrievingPollenInThisOperation);
        aNBT.func_74768_a("pollinationDelay", this.pollinationDelay);
        aNBT.func_74776_a("usedBeeLife", this.usedBeeLife);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mSpeed = aNBT.func_74762_e("mSpeed");
        this.mLockedSpeed = aNBT.func_74767_n("mLockedSpeed");
        if (aNBT.func_74764_b("mAutoQueen")) {
            this.mAutoQueen = aNBT.func_74767_n("mAutoQueen");
        }
        if (aNBT.func_74764_b("usedQueen")) {
            this.usedQueen = ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l("usedQueen"));
        }
        this.retrievingPollenInThisOperation = aNBT.func_74767_n("retrievingPollenInThisOperation");
        this.pollinationDelay = aNBT.func_74762_e("pollinationDelay");
        this.usedBeeLife = aNBT.func_74760_g("usedBeeLife");
    }

    @Override
    public int checkRecipe() {
        this.updateModifiers();
        if (this.canWork()) {
            ItemStack queen = this.getQueen();
            this.usedQueen = queen.func_77946_l();
            if (this.beeRoot.getType(queen) == EnumBeeType.QUEEN) {
                int n;
                GT_Utility.ItemId id;
                IBee bee;
                this.usedQueenBee = bee = this.beeRoot.getMember(queen);
                float mod = this.getLifespanModifier(null, null, 1.0f);
                IBeekeepingMode mode = this.beeRoot.getBeekeepingMode(this.getWorld());
                IBeeModifier beemodifier = mode.getBeeModifier();
                mod *= beemodifier.getLifespanModifier(null, null, 1.0f);
                int h = bee.getHealth();
                mod = 1.0f / mod;
                float cycles = (float)h / mod;
                HashMap<GT_Utility.ItemId, ItemStack> pollen = new HashMap<GT_Utility.ItemId, ItemStack>();
                if (this.isRetrievingPollen && this.floweringMod > 0.0f) {
                    int icycles = (int)cycles + (this.getWorld().field_73012_v.nextFloat() < cycles - (float)((int)cycles) ? 1 : 0);
                    for (int z = 0; z < icycles; ++z) {
                        ItemStack s;
                        IIndividual p = bee.retrievePollen((IBeeHousing)this);
                        if (p == null || (s = p.getGenome().getSpeciesRoot().getMemberStack(p, EnumGermlingType.POLLEN.ordinal())) == null) continue;
                        GT_Utility.ItemId id2 = GT_Utility.ItemId.createNoCopy(s);
                        pollen.computeIfAbsent(id2, k -> {
                            ItemStack ns = s.func_77946_l();
                            ns.field_77994_a = 0;
                            return ns;
                        });
                        ((ItemStack)pollen.get((Object)id2)).field_77994_a += s.field_77994_a;
                    }
                }
                this.retrievedpollen = null;
                this.retrievingPollenInThisOperation = this.isRetrievingPollen;
                IBeeGenome genome = bee.getGenome();
                IAlleleBeeSpecies primary = genome.getPrimary();
                IAlleleBeeSpecies secondary = genome.getSecondary();
                float speed = genome.getSpeed();
                float prodMod = this.getProductionModifier(null, 0.0f) + beemodifier.getProductionModifier(null, 0.0f);
                HashMap<GT_Utility.ItemId, Float> drops = new HashMap<GT_Utility.ItemId, Float>();
                HashMap<GT_Utility.ItemId, ItemStack> dropstacks = new HashMap<GT_Utility.ItemId, ItemStack>();
                for (Map.Entry entry : primary.getProductChances().entrySet()) {
                    id = GT_Utility.ItemId.createNoCopy((ItemStack)entry.getKey());
                    drops.merge(id, Float.valueOf(Bee.getFinalChance((float)((Float)entry.getValue()).floatValue(), (float)speed, (float)prodMod, (float)8.0f) * (float)((ItemStack)entry.getKey()).field_77994_a * cycles), Float::sum);
                    dropstacks.computeIfAbsent(id, k -> (ItemStack)entry.getKey());
                }
                for (Map.Entry entry : secondary.getProductChances().entrySet()) {
                    id = GT_Utility.ItemId.createNoCopy((ItemStack)entry.getKey());
                    drops.merge(id, Float.valueOf(Bee.getFinalChance((float)(((Float)entry.getValue()).floatValue() / 2.0f), (float)speed, (float)prodMod, (float)8.0f) * (float)((ItemStack)entry.getKey()).field_77994_a * cycles), Float::sum);
                    dropstacks.computeIfAbsent(id, k -> (ItemStack)entry.getKey());
                }
                if (primary.isJubilant(genome, (IBeeHousing)this) && secondary.isJubilant(genome, (IBeeHousing)this)) {
                    for (Map.Entry entry : primary.getSpecialtyChances().entrySet()) {
                        id = GT_Utility.ItemId.createNoCopy((ItemStack)entry.getKey());
                        drops.merge(id, Float.valueOf(Bee.getFinalChance((float)((Float)entry.getValue()).floatValue(), (float)speed, (float)prodMod, (float)8.0f) * (float)((ItemStack)entry.getKey()).field_77994_a * cycles), Float::sum);
                        dropstacks.computeIfAbsent(id, k -> (ItemStack)entry.getKey());
                    }
                }
                int i = 0;
                int imax = this.mOutputItems.length;
                IApiaristTracker breedingTracker = this.beeRoot.getBreedingTracker(this.getWorld(), this.getOwner());
                if (!bee.canSpawn()) {
                    ItemStack convert = new ItemStack((Item)PluginApiculture.items.beePrincessGE);
                    NBTTagCompound nbttagcompound = new NBTTagCompound();
                    queen.func_77955_b(nbttagcompound);
                    convert.func_77982_d(nbttagcompound);
                    this.mOutputItems[i++] = convert;
                } else {
                    Object d;
                    IBee b = bee.spawnPrincess((IBeeHousing)this);
                    if (b != null) {
                        ItemStack princess = this.beeRoot.getMemberStack((IIndividual)b, EnumBeeType.PRINCESS.ordinal());
                        breedingTracker.registerPrincess((IIndividual)b);
                        this.mOutputItems[i++] = princess;
                    }
                    if ((d = bee.spawnDrones((IBeeHousing)this)) != null && ((IBee[])d).length > 0) {
                        HashMap<GT_Utility.ItemId, ItemStack> hashMap = new HashMap<GT_Utility.ItemId, ItemStack>(((IBee[])d).length);
                        for (Object dr : d) {
                            ItemStack drone = this.beeRoot.getMemberStack((IIndividual)dr, EnumBeeType.DRONE.ordinal());
                            breedingTracker.registerDrone((IIndividual)dr);
                            GT_Utility.ItemId drid = GT_Utility.ItemId.createNoCopy(drone);
                            if (hashMap.containsKey(drid)) {
                                ((ItemStack)hashMap.get((Object)drid)).field_77994_a += drone.field_77994_a;
                                continue;
                            }
                            this.mOutputItems[i++] = drone;
                            hashMap.put(drid, drone);
                        }
                    }
                }
                int imin = i;
                this.setQueen(null);
                block5: for (Map.Entry entry : drops.entrySet()) {
                    ItemStack s = ((ItemStack)dropstacks.get(entry.getKey())).func_77946_l();
                    s.field_77994_a = ((Float)entry.getValue()).intValue() + (this.getWorld().field_73012_v.nextFloat() < ((Float)entry.getValue()).floatValue() - (float)((Float)entry.getValue()).intValue() ? 1 : 0);
                    if (s.field_77994_a <= 0 || i >= imax) continue;
                    do {
                        if (s.field_77994_a <= s.func_77976_d()) {
                            this.mOutputItems[i++] = s;
                            continue block5;
                        }
                        this.mOutputItems[i++] = s.func_77979_a(s.func_77976_d());
                    } while (i < imax);
                }
                for (ItemStack itemStack : pollen.values()) {
                    if (i >= imax) break;
                    this.mOutputItems[i++] = itemStack;
                }
                this.usedBeeLife = cycles * 550.0f;
                this.mMaxProgresstime = (int)this.usedBeeLife;
                int timemaxdivider = this.mMaxProgresstime / 100;
                int actualdivider = n = 1 << this.mSpeed;
                this.mMaxProgresstime /= Math.min(actualdivider, timemaxdivider);
                actualdivider /= Math.min(actualdivider, timemaxdivider);
                --i;
                while (i >= imin) {
                    this.mOutputItems[i].field_77994_a *= actualdivider;
                    --i;
                }
                this.pollinationDelay = Math.max((int)((float)this.mMaxProgresstime / cycles), 20);
                this.mProgresstime = 0;
                this.mEUt = (int)(37.0f * this.energyMod * (float)n);
                if (n == 2) {
                    this.mEUt += 32;
                } else if (n > 2) {
                    this.mEUt += 32 * (n << this.mSpeed - 2);
                }
            } else {
                IBee princess;
                this.retrievingPollenInThisOperation = true;
                this.mMaxProgresstime = 100;
                this.mProgresstime = 0;
                int useddivider = Math.min(100, 1 << this.mSpeed);
                this.mMaxProgresstime /= useddivider;
                this.mEUt = (int)(37.0f * this.energyMod * (float)useddivider);
                if (useddivider == 2) {
                    this.mEUt += 32;
                } else if (useddivider > 2) {
                    this.mEUt += 32 * (useddivider << this.mSpeed - 2);
                }
                this.usedQueenBee = princess = this.beeRoot.getMember(this.getQueen());
                IBee drone = this.beeRoot.getMember(this.getDrone());
                princess.mate((IIndividual)drone);
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                princess.writeToNBT(nbttagcompound);
                this.mOutputItems[0] = new ItemStack((Item)PluginApiculture.items.beeQueenGE);
                this.mOutputItems[0].func_77982_d(nbttagcompound);
                this.beeRoot.getBreedingTracker(this.getWorld(), this.getOwner()).registerQueen((IIndividual)princess);
                this.setQueen(null);
                --this.getDrone().field_77994_a;
                if (this.getDrone().field_77994_a == 0) {
                    this.setDrone(null);
                }
            }
            return 2;
        }
        return 0;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        this.updateModifiers();
    }

    @Override
    protected boolean hasEnoughEnergyToCheckRecipe() {
        return this.getBaseMetaTileEntity().isUniversalEnergyStored(GT_Values.V[this.mSpeed] * 8L);
    }

    @Override
    public long maxAmperesIn() {
        return 4L;
    }

    private void doEffect() {
        IBeeGenome genome = this.usedQueenBee.getGenome();
        IAlleleBeeEffect effect = genome.getEffect();
        if (!(effect instanceof IAlleleBeeAcceleratableEffect)) {
            this.effectData[0] = effect.validateStorage(this.effectData[0]);
            effect.doEffect(genome, this.effectData[0], (IBeeHousing)this);
        }
        if (!effect.isCombinable()) {
            return;
        }
        IAlleleBeeEffect secondary = (IAlleleBeeEffect)genome.getInactiveAllele((IChromosomeType)EnumBeeChromosome.EFFECT);
        if (!secondary.isCombinable()) {
            return;
        }
        if (!(secondary instanceof IAlleleBeeAcceleratableEffect)) {
            this.effectData[1] = secondary.validateStorage(this.effectData[1]);
            secondary.doEffect(genome, this.effectData[1], (IBeeHousing)this);
        }
    }

    private void doAcceleratedEffects() {
        IBeeGenome genome = this.usedQueenBee.getGenome();
        IAlleleBeeEffect effect = genome.getEffect();
        try {
            if (AlleleBeeEffectThrottledField == null) {
                AlleleBeeEffectThrottledField = AlleleEffectThrottled.class.getDeclaredField("throttle");
                AlleleBeeEffectThrottledField.setAccessible(true);
            }
            if (effect instanceof IAlleleBeeAcceleratableEffect) {
                this.effectData[0] = effect.validateStorage(this.effectData[0]);
                this.effectData[0] = ((IAlleleBeeAcceleratableEffect)effect).doEffectAccelerated(genome, this.effectData[0], (IBeeHousing)this, this.usedBeeLife / (effect instanceof AlleleEffectThrottled ? (float)AlleleBeeEffectThrottledField.getInt(effect) : 1.0f));
            }
            if (!effect.isCombinable()) {
                return;
            }
            IAlleleBeeEffect secondary = (IAlleleBeeEffect)genome.getInactiveAllele((IChromosomeType)EnumBeeChromosome.EFFECT);
            if (!secondary.isCombinable()) {
                return;
            }
            if (secondary instanceof IAlleleBeeAcceleratableEffect) {
                this.effectData[1] = secondary.validateStorage(this.effectData[1]);
                this.effectData[1] = ((IAlleleBeeAcceleratableEffect)secondary).doEffectAccelerated(genome, this.effectData[0], (IBeeHousing)this, this.usedBeeLife / (secondary instanceof AlleleEffectThrottled ? (float)AlleleBeeEffectThrottledField.getInt(secondary) : 1.0f));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isClientSide()) {
            if (GT_Client.changeDetected == 4) {
                aBaseMetaTileEntity.issueTextureUpdate();
            }
            if (aBaseMetaTileEntity.isActive() && this.usedQueen != null && aTick % 2L == 0L) {
                IBee bee = this.beeRoot.getMember(this.usedQueen);
                this.effectData = bee.doFX(this.effectData, (IBeeHousing)this);
            }
        }
        if (aBaseMetaTileEntity.isServerSide()) {
            this.mCharge = aBaseMetaTileEntity.getStoredEU() / 2L > aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.mDecharge = aBaseMetaTileEntity.getStoredEU() < aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.doDisplayThings();
            if (!aBaseMetaTileEntity.isActive()) {
                int check;
                if (aBaseMetaTileEntity.isAllowedToWork() && (aBaseMetaTileEntity.hasInventoryBeenModified() || aTick % 600L == 0L || aBaseMetaTileEntity.hasWorkJustBeenEnabled()) && this.hasEnoughEnergyToCheckRecipe() && (check = this.checkRecipe()) == 2) {
                    aBaseMetaTileEntity.setActive(true);
                }
            } else {
                if (this.mProgresstime < 0) {
                    ++this.mProgresstime;
                    return;
                }
                if (this.mStuttering) {
                    if (!aBaseMetaTileEntity.isAllowedToWork()) {
                        return;
                    }
                    if (aTick % 100L == 0L) {
                        this.mStuttering = false;
                    }
                    return;
                }
                if (this.hasErrors()) {
                    if (!aBaseMetaTileEntity.isAllowedToWork()) {
                        return;
                    }
                    if (aTick % 100L == 0L && !this.canWork(this.usedQueen)) {
                        this.stutterProcess();
                    }
                    return;
                }
                if (!this.drainEnergyForProcess(this.mEUt)) {
                    this.mStuttering = true;
                    this.stutterProcess();
                    return;
                }
                ++this.mProgresstime;
                if (this.usedQueen != null) {
                    if (this.usedQueenBee == null) {
                        this.usedQueenBee = this.beeRoot.getMember(this.usedQueen);
                    }
                    this.doEffect();
                    if (!this.retrievingPollenInThisOperation && this.floweringMod > 0.0f && this.mProgresstime % this.pollinationDelay == 0) {
                        if (this.retrievedpollen == null) {
                            this.retrievedpollen = this.usedQueenBee.retrievePollen((IBeeHousing)this);
                        }
                        if (this.retrievedpollen != null && (this.usedQueenBee.pollinateRandom((IBeeHousing)this, this.retrievedpollen) || this.mProgresstime % (this.pollinationDelay * 5) == 0)) {
                            this.retrievedpollen = null;
                        }
                    }
                }
                if (this.mProgresstime % 100 == 0 && !this.canWork(this.usedQueen)) {
                    this.stutterProcess();
                    return;
                }
                if (this.mProgresstime >= this.mMaxProgresstime) {
                    if (this.usedQueenBee != null) {
                        this.doAcceleratedEffects();
                    }
                    this.updateModifiers();
                    for (int i = 0; i < this.mOutputItems.length; ++i) {
                        if (this.mOutputItems[i] == null) continue;
                        for (int j = 0; j < this.mOutputItems.length && !(j != 0 || !this.isAutomated ? this.mAutoQueen && i == 0 && j == 0 && this.beeRoot.isMember(this.mOutputItems[0], EnumBeeType.QUEEN.ordinal()) && aBaseMetaTileEntity.addStackToSlot(5, this.mOutputItems[0]) : (this.beeRoot.isMember(this.mOutputItems[i], EnumBeeType.QUEEN.ordinal()) || this.beeRoot.isMember(this.mOutputItems[i], EnumBeeType.PRINCESS.ordinal()) ? aBaseMetaTileEntity.addStackToSlot(5, this.mOutputItems[i]) : this.beeRoot.isMember(this.mOutputItems[i], EnumBeeType.DRONE.ordinal()) && aBaseMetaTileEntity.addStackToSlot(6, this.mOutputItems[i]))) && !aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot() + (j + i) % this.mOutputItems.length, this.mOutputItems[i]); ++j) {
                        }
                    }
                    Arrays.fill(this.mOutputItems, null);
                    this.mEUt = 0;
                    this.mProgresstime = 0;
                    this.mMaxProgresstime = 0;
                    this.mStuttering = false;
                    aBaseMetaTileEntity.setActive(false);
                    if (this.doesAutoOutput() && !this.isOutputEmpty() && aBaseMetaTileEntity.getFrontFacing() != this.mMainFacing) {
                        TileEntity tTileEntity2 = aBaseMetaTileEntity.getTileEntityAtSide(aBaseMetaTileEntity.getFrontFacing());
                        long tStoredEnergy = aBaseMetaTileEntity.getUniversalEnergyStored();
                        int tMaxStacks = (int)(tStoredEnergy / 64L);
                        if (tMaxStacks > this.mOutputItems.length) {
                            tMaxStacks = this.mOutputItems.length;
                        }
                        GT_Utility.moveMultipleItemStacks(aBaseMetaTileEntity, tTileEntity2, aBaseMetaTileEntity.getFrontFacing(), aBaseMetaTileEntity.getBackFacing(), null, false, (byte)64, (byte)1, (byte)64, (byte)1, tMaxStacks);
                    }
                    if (aBaseMetaTileEntity.isAllowedToWork() && this.checkRecipe() == 2) {
                        aBaseMetaTileEntity.setActive(true);
                    }
                }
            }
        }
    }

    public void cancelProcess() {
        if (this.getBaseMetaTileEntity().isActive() && this.getBaseMetaTileEntity().isServerSide() && this.usedQueen != null && this.beeRoot.isMember(this.usedQueen, EnumBeeType.QUEEN.ordinal())) {
            Arrays.fill(this.mOutputItems, null);
            this.mEUt = 0;
            this.mProgresstime = 0;
            this.mMaxProgresstime = 0;
            this.mStuttering = false;
            this.getBaseMetaTileEntity().setActive(false);
            this.setQueen(this.usedQueen);
            this.getBaseMetaTileEntity().disableWorking();
        }
    }

    @Override
    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        if (aStack == null) {
            return false;
        }
        if (aIndex < this.getInputSlot()) {
            return true;
        }
        if (aIndex == 5) {
            return this.beeRoot.isMember(aStack, EnumBeeType.QUEEN.ordinal()) || this.beeRoot.isMember(aStack, EnumBeeType.PRINCESS.ordinal());
        }
        if (aIndex == 6) {
            return this.beeRoot.isMember(aStack, EnumBeeType.DRONE.ordinal());
        }
        if (aIndex < this.getOutputSlot()) {
            if (!GT_ApiaryUpgrade.isUpgrade(aStack)) {
                return false;
            }
            for (int i = 7; i < 11; ++i) {
                ItemStack s;
                if (aIndex == i || (s = this.func_70301_a(i)) == null) continue;
                if (GT_Utility.areStacksEqual(this.func_70301_a(i), aStack)) {
                    return false;
                }
                if (!(GT_ApiaryUpgrade.isUpgrade(aStack) ? !GT_ApiaryUpgrade.getUpgrade(aStack).isAllowedToWorkWith(this.func_70301_a(i)) : GT_ApiaryUpgrade.isUpgrade(s) && !GT_ApiaryUpgrade.getUpgrade(s).isAllowedToWorkWith(aStack))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (!super.allowPutStack(aBaseMetaTileEntity, aIndex, side, aStack)) {
            return false;
        }
        return this.func_94041_b(aIndex, aStack);
    }

    @Override
    public void func_70299_a(int aIndex, ItemStack aStack) {
        if (aIndex == 5 && aStack != null && this.getBaseMetaTileEntity().isClientSide()) {
            this.usedQueen = aStack.func_77946_l();
        }
        super.func_70299_a(aIndex, aStack);
    }

    public void onInventoryUpdate(int aIndex) {
        if (aIndex > 6 && aIndex < this.getOutputSlot()) {
            this.updateModifiers();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getUsedQueen() {
        return this.usedQueen;
    }

    public Iterable<IBeeModifier> getBeeModifiers() {
        return Collections.singletonList(this);
    }

    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singletonList(this);
    }

    public IBeeHousingInventory getBeeInventory() {
        return this;
    }

    public IBeekeepingLogic getBeekeepingLogic() {
        return dummylogic;
    }

    public int getBlockLightValue() {
        return this.getBaseMetaTileEntity().getLightLevelAtSide(ForgeDirection.UP);
    }

    public boolean canBlockSeeTheSky() {
        return this.getBaseMetaTileEntity().getSkyAtSide(ForgeDirection.UP);
    }

    public World getWorld() {
        return this.getBaseMetaTileEntity().getWorld();
    }

    public GameProfile getOwner() {
        if (this.owner == null) {
            this.owner = new GameProfile(this.getBaseMetaTileEntity().getOwnerUuid(), this.getBaseMetaTileEntity().getOwnerName());
        }
        return this.owner;
    }

    public Vec3 getBeeFXCoordinates() {
        return Vec3.func_72443_a((double)((double)this.getBaseMetaTileEntity().getXCoord() + 0.5), (double)((double)this.getBaseMetaTileEntity().getYCoord() + 0.5), (double)((double)this.getBaseMetaTileEntity().getZCoord() + 0.5));
    }

    public BiomeGenBase getBiome() {
        if (this.biomeOverride == null) {
            return this.getBaseMetaTileEntity().getBiome();
        }
        return this.biomeOverride;
    }

    public EnumTemperature getTemperature() {
        if (BiomeHelper.isBiomeHellish((BiomeGenBase)this.getBiome())) {
            return EnumTemperature.HELLISH;
        }
        return EnumTemperature.getFromValue((float)(this.getBiome().field_76750_F + this.temperatureMod));
    }

    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue((float)(this.getBiome().field_76751_G + this.humidityMod));
    }

    public IErrorLogic getErrorLogic() {
        return this;
    }

    public ChunkCoordinates getCoordinates() {
        return this.getBaseMetaTileEntity().getCoords();
    }

    public ItemStack getQueen() {
        return this.func_70301_a(5);
    }

    public ItemStack getDrone() {
        return this.func_70301_a(6);
    }

    public void setQueen(ItemStack itemStack) {
        this.func_70299_a(5, itemStack);
    }

    public void setDrone(ItemStack itemStack) {
        this.func_70299_a(6, itemStack);
    }

    public boolean addProduct(ItemStack itemStack, boolean b) {
        throw new RuntimeException("Should not happen :F");
    }

    public boolean setCondition(boolean b, IErrorState iErrorState) {
        if (b) {
            this.mErrorStates.add(iErrorState);
        } else {
            this.mErrorStates.remove(iErrorState);
        }
        return b;
    }

    public boolean contains(IErrorState iErrorState) {
        return this.mErrorStates.contains(iErrorState);
    }

    public boolean hasErrors() {
        return !this.mErrorStates.isEmpty();
    }

    public void clearErrors() {
        this.mErrorStates.clear();
    }

    public void writeData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.mErrorStates.size());
        for (IErrorState s : this.mErrorStates) {
            dataOutputStream.writeUTF(s.getUniqueName());
        }
    }

    public void readData(DataInputStream dataInputStream) throws IOException {
        for (int i = dataInputStream.readInt(); i > 0; --i) {
            this.mErrorStates.add(ForestryAPI.errorStateRegistry.getErrorState(dataInputStream.readUTF()));
        }
    }

    public ImmutableSet<IErrorState> getErrorStates() {
        return ImmutableSet.copyOf(this.mErrorStates);
    }

    private boolean checkFlower(IBee bee) {
        String flowerType = bee.getGenome().getFlowerProvider().getFlowerType();
        if (!this.flowerType.equals(flowerType)) {
            this.flowercoords = null;
        }
        if (this.flowercoords != null && (this.getWorld().func_147439_a(this.flowercoords.field_71574_a, this.flowercoords.field_71572_b, this.flowercoords.field_71573_c) != this.flowerBlock || this.getWorld().func_72805_g(this.flowercoords.field_71574_a, this.flowercoords.field_71572_b, this.flowercoords.field_71573_c) != this.flowerBlockMeta)) {
            if (!FlowerManager.flowerRegistry.isAcceptedFlower(flowerType, this.getWorld(), this.flowercoords.field_71574_a, this.flowercoords.field_71572_b, this.flowercoords.field_71573_c)) {
                this.flowercoords = null;
            } else {
                this.flowerBlock = this.getWorld().func_147439_a(this.flowercoords.field_71574_a, this.flowercoords.field_71572_b, this.flowercoords.field_71573_c);
                this.flowerBlockMeta = this.getWorld().func_72805_g(this.flowercoords.field_71574_a, this.flowercoords.field_71572_b, this.flowercoords.field_71573_c);
            }
        }
        if (this.flowercoords == null) {
            this.flowercoords = FlowerManager.flowerRegistry.getAcceptedFlowerCoordinates((IBeeHousing)this, bee, flowerType);
            if (this.flowercoords != null) {
                this.flowerBlock = this.getWorld().func_147439_a(this.flowercoords.field_71574_a, this.flowercoords.field_71572_b, this.flowercoords.field_71573_c);
                this.flowerBlockMeta = this.getWorld().func_72805_g(this.flowercoords.field_71574_a, this.flowercoords.field_71572_b, this.flowercoords.field_71573_c);
                this.flowerType = flowerType;
            }
        }
        return this.flowercoords != null;
    }

    private boolean canWork(ItemStack queen) {
        this.clearErrors();
        if (queen == null) {
            return true;
        }
        if (this.beeRoot.isMember(queen, EnumBeeType.PRINCESS.ordinal())) {
            return true;
        }
        IBee bee = this.beeRoot.getMember(queen);
        for (IErrorState err : bee.getCanWork((IBeeHousing)this)) {
            this.setCondition(true, err);
        }
        this.setCondition(!this.checkFlower(bee), (IErrorState)EnumErrorCode.NO_FLOWER);
        return !this.hasErrors();
    }

    private boolean canWork() {
        this.clearErrors();
        EnumBeeType beeType = this.beeRoot.getType(this.getQueen());
        if (beeType == EnumBeeType.PRINCESS) {
            this.setCondition(!this.beeRoot.isDrone(this.getDrone()), (IErrorState)EnumErrorCode.NO_DRONE);
            return !this.hasErrors();
        }
        if (beeType == EnumBeeType.QUEEN) {
            IBee bee = this.beeRoot.getMember(this.getQueen());
            for (IErrorState err : bee.getCanWork((IBeeHousing)this)) {
                this.setCondition(true, err);
            }
            this.setCondition(!this.checkFlower(bee), (IErrorState)EnumErrorCode.NO_FLOWER);
            return !this.hasErrors();
        }
        this.setCondition(true, (IErrorState)EnumErrorCode.NO_QUEEN);
        return false;
    }

    public void updateModifiers() {
        GT_ApiaryModifier mods = new GT_ApiaryModifier();
        for (int i = 0; i < 4; ++i) {
            ItemStack s = this.func_70301_a(7 + i);
            if (s == null || !GT_ApiaryUpgrade.isUpgrade(s)) continue;
            GT_ApiaryUpgrade upgrade = GT_ApiaryUpgrade.getUpgrade(s);
            upgrade.applyModifiers(mods, s);
        }
        this.terrorityMod = mods.territory;
        this.mutationMod = mods.mutation;
        this.lifespanMod = mods.lifespan;
        this.productionMod = mods.production;
        this.floweringMod = mods.flowering;
        this.geneticDecayMod = mods.geneticDecay;
        this.energyMod = mods.energy;
        this.sealedMod = mods.isSealed;
        this.selfLightedMod = mods.isSelfLighted;
        this.selfUnlightedMod = mods.isSelfUnlighted;
        this.sunlightSimulatedMod = mods.isSunlightSimulated;
        this.biomeOverride = mods.biomeOverride;
        this.humidityMod = mods.humidity;
        this.temperatureMod = mods.temperature;
        this.isAutomated = mods.isAutomated;
        this.isRetrievingPollen = mods.isCollectingPollen;
        this.maxspeed = mods.maxSpeed;
        this.mSpeed = this.mLockedSpeed ? this.maxspeed : Math.min(this.mSpeed, this.maxspeed);
    }

    public void addUpgrade(ItemStack stack) {
        if (stack == null || !GT_ApiaryUpgrade.isUpgrade(stack)) {
            return;
        }
        int amount = stack.field_77994_a;
        for (int i = 7; i < 11; ++i) {
            if (!this.func_94041_b(i, stack)) continue;
            int maxStackSize = GT_ApiaryUpgrade.getUpgrade(stack).getMaxNumber();
            ItemStack stackInSlot = this.func_70301_a(i);
            if (stackInSlot == null) {
                amount = Math.min(amount, maxStackSize);
                this.func_70299_a(i, stack.func_77979_a(amount));
                return;
            }
            if (!GT_Utility.areStacksEqual(stack, stackInSlot)) continue;
            if ((amount = Math.max(Math.min(amount, maxStackSize - stackInSlot.field_77994_a), 0)) == 0) {
                return;
            }
            stackInSlot.field_77994_a += amount;
            stack.field_77994_a -= amount;
            return;
        }
    }

    public ItemStack getUpgrade(int index) {
        if (index < 0 || index >= 4) {
            return null;
        }
        return this.func_70301_a(7 + index);
    }

    public ItemStack removeUpgrade(int index, int amount) {
        if (index < 0 || index >= 4 || amount <= 0) {
            return null;
        }
        ItemStack stackInSlot = this.getUpgrade(index);
        if (stackInSlot == null) {
            return null;
        }
        amount = Math.min(amount, stackInSlot.field_77994_a);
        ItemStack result = stackInSlot.func_77979_a(amount);
        if (stackInSlot.field_77994_a <= 0) {
            this.func_70299_a(7 + index, null);
        }
        return result;
    }

    public static int getMaxUpgradeCount() {
        return 4;
    }

    public float getTerritoryModifier(IBeeGenome iBeeGenome, float v) {
        return Math.min(5.0f, this.terrorityMod);
    }

    public float getMutationModifier(IBeeGenome iBeeGenome, IBeeGenome iBeeGenome1, float v) {
        return this.mutationMod;
    }

    public float getLifespanModifier(IBeeGenome iBeeGenome, IBeeGenome iBeeGenome1, float v) {
        return this.lifespanMod;
    }

    public float getProductionModifier(IBeeGenome iBeeGenome, float v) {
        return this.productionMod;
    }

    public float getFloweringModifier(IBeeGenome iBeeGenome, float v) {
        return this.floweringMod;
    }

    public float getGeneticDecay(IBeeGenome iBeeGenome, float v) {
        return this.geneticDecayMod;
    }

    public float getEnergyModifier() {
        return this.energyMod;
    }

    public boolean isSealed() {
        return this.sealedMod;
    }

    public boolean isSelfLighted() {
        return this.selfLightedMod;
    }

    public boolean isSelfUnlighted() {
        return this.selfUnlightedMod;
    }

    public boolean isSunlightSimulated() {
        return this.sunlightSimulatedMod;
    }

    public boolean isHellish() {
        return this.getBiome() == BiomeGenBase.field_76778_j;
    }

    public int getMaxSpeed() {
        return this.maxspeed;
    }

    public void wearOutEquipment(int i) {
    }

    public void onQueenDeath() {
    }

    public boolean onPollenRetrieved(IIndividual iIndividual) {
        return false;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new SlotWidget((BaseSlot)new ApiarySlot((IItemHandlerModifiable)this.inventoryHandler, 5)).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_BEE_QUEEN}).setPos(36, 21))).widget(new SlotWidget((BaseSlot)new ApiarySlot((IItemHandlerModifiable)this.inventoryHandler, 6)).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_BEE_DRONE}).setPos(36, 41))).widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)2).startFromSlot(7).endAtSlot(10).slotCreator(i -> new ApiarySlot((IItemHandlerModifiable)this.inventoryHandler, (int)i)).applyForWidget(widget -> widget.setGTTooltip(() -> this.mTooltipCache.getData(UPGRADE_TOOLTIP, new Object[0])).setTooltipShowUpDelay(5)).build().setPos(61, 23));
        super.addUIWidgets(builder, buildContext);
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> this.cancelProcess()).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_BUTTON_CROSS}).setGTTooltip(() -> this.mTooltipCache.getData(CANCEL_PROCESS_TOOLTIP, new Object[0])).setTooltipShowUpDelay(5).setPos(7, 26).setSize(18, 18))).widget(new CycleButtonWidget().setToggle(() -> this.mAutoQueen, x -> {
            this.mAutoQueen = x;
        }).setTextureGetter(i -> i == 0 ? GT_UITextures.OVERLAY_BUTTON_CROSS : GT_UITextures.OVERLAY_BUTTON_CHECKMARK).setGTTooltip(() -> this.mTooltipCache.getData(AUTOQUEEN_TOOLTIP, new Object[0])).setTooltipShowUpDelay(5).setPos(7, 44).setSize(18, 18).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_SLOT_BEE_QUEEN}))).widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_INFORMATION).setGTTooltip(() -> {
            IBee bee;
            String energyreq = GT_Utility.formatNumbers((int)(37.0f * this.getEnergyModifier() * (float)this.getAcceleration()) + this.getAdditionalEnergyUsage());
            String Temp = StatCollector.func_74838_a((String)this.getTemperature().getName());
            String Hum = StatCollector.func_74838_a((String)this.getHumidity().getName());
            if (this.getUsedQueen() != null && BeeManager.beeRoot.isMember(this.getUsedQueen(), EnumBeeType.QUEEN.ordinal()) && (bee = BeeManager.beeRoot.getMember(this.getUsedQueen())).isAnalyzed()) {
                IBeeGenome genome = bee.getGenome();
                IBeeModifier mod = BeeManager.beeRoot.getBeekeepingMode(this.getWorld()).getBeeModifier();
                float tmod = this.getTerritoryModifier(null, 1.0f) * mod.getTerritoryModifier(null, 1.0f);
                int[] t = Arrays.stream(genome.getTerritory()).map(i -> (int)((float)i * tmod)).toArray();
                return this.mTooltipCache.getUncachedTooltipData(INFO_WITH_BEE_TOOLTIP, energyreq, Temp, Hum, Float.valueOf(genome.getSpeed()), Float.valueOf(this.getProductionModifier(null, 0.0f) + mod.getProductionModifier(null, 0.0f)), Math.round(this.getFloweringModifier(null, 1.0f) * (float)genome.getFlowering() * mod.getFloweringModifier(null, 1.0f)), Math.round(this.getLifespanModifier(null, null, 1.0f) * (float)genome.getLifespan() * mod.getLifespanModifier(null, null, 1.0f)), t[0], t[1], t[2]);
            }
            return this.mTooltipCache.getUncachedTooltipData(INFO_TOOLTIP, energyreq, Temp, Hum);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.ItemStackSyncer(() -> this.usedQueen, val -> {
            this.usedQueen = val;
        }), (IWidgetBuilder)builder, (widget, val) -> widget.notifyTooltipChange()).setPos(163, 5).setSize(7, 18))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (clickData.mouseButton == 0) {
                if (this.mLockedSpeed) {
                    return;
                }
                if (!clickData.shift) {
                    ++this.mSpeed;
                    if (this.mSpeed > this.getMaxSpeed()) {
                        this.mSpeed = 0;
                    }
                } else {
                    --this.mSpeed;
                    if (this.mSpeed < 0) {
                        this.mSpeed = this.getMaxSpeed();
                    }
                }
            } else if (clickData.mouseButton == 1) {
                boolean bl = this.mLockedSpeed = !this.mLockedSpeed;
                if (this.mLockedSpeed) {
                    this.mSpeed = this.getMaxSpeed();
                }
            }
        }).setGTTooltip(() -> this.mTooltipCache.getUncachedTooltipData(this.mLockedSpeed ? SPEED_LOCKED_TOOLTIP : SPEED_TOOLTIP, this.getAcceleration(), GT_Utility.formatNumbers(this.getAdditionalEnergyUsage()))).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(() -> this.mSpeed, val -> {
            this.mSpeed = val;
        }), (IWidgetBuilder)builder, (widget, val) -> widget.notifyTooltipChange()).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> this.mLockedSpeed, val -> {
            this.mLockedSpeed = val;
        }), (IWidgetBuilder)builder, (widget, val) -> widget.notifyTooltipChange()).setTooltipShowUpDelay(5).setBackground(new IDrawable[]{GT_UITextures.PICTURE_SQUARE_LIGHT_GRAY}).setPos(25, 62).setSize(18, 18))).widget(new TextWidget("x").setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(30, 63))).widget(TextWidget.dynamicString(() -> String.valueOf(1 << this.mSpeed)).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(26, 72));
    }

    @Override
    protected BasicUIProperties getUIProperties() {
        return super.getUIProperties().toBuilder().progressBarTexture(progressBarTexture).progressBarPos(new Pos2d(70, 3)).build();
    }

    @Override
    protected SlotWidget createItemInputSlot(int index, IDrawable[] backgrounds, Pos2d pos) {
        return null;
    }

    @Override
    protected CycleButtonWidget createItemAutoOutputButton() {
        return (CycleButtonWidget)super.createItemAutoOutputButton().setPos(7, 62);
    }

    @Override
    protected CycleButtonWidget createFluidAutoOutputButton() {
        return null;
    }

    @Override
    protected SlotWidget createChargerSlot(int x, int y, String tooltipKey, Object[] tooltipArgs) {
        return (SlotWidget)super.createChargerSlot(x, y, tooltipKey, tooltipArgs).setPos(79, 62);
    }

    @Override
    protected DrawableWidget createErrorStatusArea(ModularWindow.Builder builder, IDrawable picture) {
        return (DrawableWidget)super.createErrorStatusArea(builder, picture).setPos(100, 62).attachSyncer((FakeSyncWidget)new FakeSyncWidget.ListSyncer(() -> Arrays.asList(this.mErrorStates.toArray(new IErrorState[0])), val -> {
            this.mErrorStates.clear();
            this.mErrorStates.addAll(new HashSet(val));
        }, (buffer, val) -> buffer.writeShort((int)val.getID()), buffer -> ForestryAPI.errorStateRegistry.getErrorState(buffer.readShort())), (IWidgetBuilder)builder, (widget, val) -> widget.notifyTooltipChange());
    }

    @Override
    protected List<String> getErrorDescriptions() {
        if (!this.mErrorStates.isEmpty()) {
            return this.mErrorStates.stream().map(state -> EnumChatFormatting.RED + StatCollector.func_74838_a((String)("for." + state.getDescription()))).collect(Collectors.toList());
        }
        if (this.mStuttering) {
            return this.mTooltipCache.getData((String)"GT5U.machines.stalled_stuttering.tooltip", (Object[])new Object[]{StatCollector.func_74838_a((String)POWER_SOURCE_POWER)}).text;
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getErrorDescriptionsShift() {
        return this.getErrorDescriptions();
    }

    private int getAcceleration() {
        return 1 << this.mSpeed;
    }

    private int getAdditionalEnergyUsage() {
        int accelerated = this.getAcceleration();
        int energyusage = 0;
        if (accelerated == 2) {
            energyusage = 32;
        } else if (accelerated > 2) {
            energyusage = 32 * accelerated << this.mSpeed - 2;
        }
        return energyusage;
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74764_b("queen")) {
            currenttip.add("Current Queen: " + EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)tag.func_74779_i("queen")));
        }
        if (tag.func_74764_b("dummyProduction")) {
            currenttip.add("Effective Production: " + EnumChatFormatting.AQUA + String.format("b^0.52 * %.2f", Float.valueOf(tag.func_74760_g("dummyProduction"))));
        }
        if (tag.func_74764_b("errors")) {
            NBTTagCompound errorNbt = tag.func_74775_l("errors");
            for (int i = 0; i < errorNbt.func_74762_e("size"); ++i) {
                currenttip.add("Error: " + EnumChatFormatting.RED + StatCollector.func_74838_a((String)("for." + errorNbt.func_74779_i("e" + i))));
            }
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        if (this.usedQueen != null) {
            IBeeGenome genome = this.beeRoot.getMember(this.usedQueen).getGenome();
            tag.func_74778_a("queen", genome.getPrimary().getUnlocalizedName());
            float prodModifier = this.getProductionModifier(genome, 0.0f);
            prodModifier += this.beeRoot.getBeekeepingMode(world).getBeeModifier().getProductionModifier(genome, prodModifier);
            float dummyProduction = 100.0f * Bee.getFinalChance((float)0.01f, (float)genome.getSpeed(), (float)prodModifier, (float)8.0f);
            tag.func_74776_a("dummyProduction", dummyProduction);
        }
        if (this.hasErrors()) {
            NBTTagCompound errorNbt = new NBTTagCompound();
            int errorCounter = 0;
            for (IErrorState error : this.mErrorStates) {
                errorNbt.func_74778_a("e" + errorCounter++, error.getDescription());
            }
            errorNbt.func_74768_a("size", errorCounter);
            tag.func_74782_a("errors", (NBTBase)errorNbt);
        }
    }

    static {
        dummylogic = new IBeekeepingLogic(){

            public boolean canWork() {
                return true;
            }

            public void doWork() {
            }

            public void syncToClient() {
            }

            public void syncToClient(EntityPlayerMP entityPlayerMP) {
            }

            public int getBeeProgressPercent() {
                return 0;
            }

            public boolean canDoBeeFX() {
                return false;
            }

            public void doBeeFX() {
            }

            public void readFromNBT(NBTTagCompound nbtTagCompound) {
            }

            public void writeToNBT(NBTTagCompound nbtTagCompound) {
            }
        };
        progressBarTexture = GT_UITextures.fallbackableProgressbar("iapiary", GT_UITextures.PROGRESSBAR_ARROW);
        IndustrialApiaryUI = GT_UIInfos.GTTileEntityUIFactory.apply(GT_ModularUIContainer_IndustrialApiary::new);
    }

    private class ApiarySlot
    extends BaseSlot {
        public ApiarySlot(IItemHandlerModifiable inventory, int index) {
            super(inventory, index);
        }

        public boolean isItemValidPhantom(ItemStack stack) {
            return super.isItemValidPhantom(stack) && GT_MetaTileEntity_IndustrialApiary.this.getBaseMetaTileEntity().func_94041_b(this.getSlotIndex(), stack);
        }

        public void func_75218_e() {
            super.func_75218_e();
            GT_MetaTileEntity_IndustrialApiary.this.onInventoryUpdate(this.getSlotIndex());
        }
    }

    private static class GT_ModularUIContainer_IndustrialApiary
    extends ModularUIContainer {
        private final int playerInventorySlot = 36;

        public GT_ModularUIContainer_IndustrialApiary(ModularUIContext context, ModularWindow mainWindow) {
            super(context, mainWindow);
        }

        public ItemStack func_75144_a(int aSlotNumber, int aMouseclick, int aShifthold, EntityPlayer aPlayer) {
            if (aSlotNumber < 38 || aSlotNumber >= 42) {
                return super.func_75144_a(aSlotNumber, aMouseclick, aShifthold, aPlayer);
            }
            if (aShifthold == 5) {
                return null;
            }
            if (aShifthold != 0) {
                return super.func_75144_a(aSlotNumber, aMouseclick, aShifthold, aPlayer);
            }
            if (aMouseclick > 1) {
                return super.func_75144_a(aSlotNumber, aMouseclick, aShifthold, aPlayer);
            }
            ItemStack s = aPlayer.field_71071_by.func_70445_o();
            if (s == null) {
                return super.func_75144_a(aSlotNumber, aMouseclick, aShifthold, aPlayer);
            }
            Slot slot = this.func_75139_a(aSlotNumber);
            ItemStack slotStack = slot.func_75211_c();
            if (slotStack != null && !GT_Utility.areStacksEqual(slotStack, s)) {
                return null;
            }
            if (slotStack == null && !slot.func_75214_a(s)) {
                return super.func_75144_a(aSlotNumber, aMouseclick, aShifthold, aPlayer);
            }
            if (!GT_ApiaryUpgrade.isUpgrade(s)) {
                return super.func_75144_a(aSlotNumber, aMouseclick, aShifthold, aPlayer);
            }
            int max = GT_ApiaryUpgrade.getUpgrade(s).getMaxNumber();
            if (slotStack != null) {
                max = Math.max(0, max - slotStack.field_77994_a);
            }
            if ((max = Math.min(max, s.field_77994_a)) == 0) {
                return null;
            }
            if (aMouseclick == 1) {
                max = 1;
            }
            if (max == s.field_77994_a) {
                return super.func_75144_a(aSlotNumber, aMouseclick, aShifthold, aPlayer);
            }
            ItemStack newStack = s.func_77979_a(s.field_77994_a - max);
            ItemStack result = super.func_75144_a(aSlotNumber, aMouseclick, aShifthold, aPlayer);
            aPlayer.field_71071_by.func_70437_b(newStack);
            return result;
        }

        public ItemStack func_82846_b(EntityPlayer aPlayer, int aSlotIndex) {
            Slot s = this.func_75139_a(aSlotIndex);
            if (s == null) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            if (aSlotIndex >= 36) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            ItemStack aStack = s.func_75211_c();
            if (aStack == null) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            if (!GT_ApiaryUpgrade.isUpgrade(aStack)) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            for (int i = 38; i < 42; ++i) {
                Slot iSlot = this.func_75139_a(i);
                ItemStack iStack = iSlot.func_75211_c();
                if (iStack == null ? !iSlot.func_75214_a(aStack) : !GT_Utility.areStacksEqual(aStack, iStack)) continue;
                int max = GT_ApiaryUpgrade.getUpgrade(aStack).getMaxNumber();
                if (iStack == null) {
                    max = Math.min(max, aStack.field_77994_a);
                    ItemStack newstack = aStack.func_77979_a(max);
                    iSlot.func_75215_d(newstack);
                } else {
                    max = Math.max(0, max - iStack.field_77994_a);
                    max = Math.min(max, aStack.field_77994_a);
                    iStack.field_77994_a += max;
                    aStack.field_77994_a -= max;
                    iSlot.func_75218_e();
                }
                if (aStack.field_77994_a == 0) {
                    s.func_75215_d(null);
                    break;
                }
                s.func_75218_e();
                break;
            }
            return null;
        }
    }
}

