/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.logic.FluidInventoryLogic;
import gregtech.api.logic.ItemInventoryLogic;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.recipe.RecipeCategory;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.RecipeMetadataKey;
import gregtech.api.recipe.metadata.EmptyRecipeMetadataStorage;
import gregtech.api.recipe.metadata.IRecipeMetadataStorage;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.extensions.ArrayExt;
import gregtech.api.util.item.ItemHolder;
import ic2.core.Ic2Items;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

public class GT_Recipe
implements Comparable<GT_Recipe> {
    public ItemStack[] mInputs;
    public ItemStack[] mOutputs;
    public FluidStack[] mFluidInputs;
    public FluidStack[] mFluidOutputs;
    public int[] mChances;
    public Object mSpecialItems;
    public int mDuration;
    public int mEUt;
    public int mSpecialValue;
    public boolean mEnabled = true;
    public boolean mHidden = false;
    public boolean mFakeRecipe = false;
    public boolean mCanBeBuffered = true;
    public boolean mNeedsEmptyOutput = false;
    public boolean isNBTSensitive = false;
    private String[] neiDesc = null;
    @Nonnull
    private final IRecipeMetadataStorage metadataStorage;
    private RecipeCategory recipeCategory;
    public List<ModContainer> owners = new ArrayList<ModContainer>();
    public List<List<String>> stackTraces = new ArrayList<List<String>>();
    public static boolean GTppRecipeHelper;
    private static final List<String> excludedStacktraces;

    private GT_Recipe(GT_Recipe aRecipe, boolean shallow) {
        this.mInputs = shallow ? aRecipe.mInputs : GT_Utility.copyItemArray(aRecipe.mInputs);
        this.mOutputs = shallow ? aRecipe.mOutputs : GT_Utility.copyItemArray(aRecipe.mOutputs);
        this.mSpecialItems = aRecipe.mSpecialItems;
        this.mChances = aRecipe.mChances;
        this.mFluidInputs = shallow ? aRecipe.mFluidInputs : GT_Utility.copyFluidArray(aRecipe.mFluidInputs);
        this.mFluidOutputs = shallow ? aRecipe.mFluidOutputs : GT_Utility.copyFluidArray(aRecipe.mFluidOutputs);
        this.mDuration = aRecipe.mDuration;
        this.mSpecialValue = aRecipe.mSpecialValue;
        this.mEUt = aRecipe.mEUt;
        this.mNeedsEmptyOutput = aRecipe.mNeedsEmptyOutput;
        this.isNBTSensitive = aRecipe.isNBTSensitive;
        this.mCanBeBuffered = aRecipe.mCanBeBuffered;
        this.mFakeRecipe = aRecipe.mFakeRecipe;
        this.mEnabled = aRecipe.mEnabled;
        this.mHidden = aRecipe.mHidden;
        this.metadataStorage = EmptyRecipeMetadataStorage.INSTANCE;
        this.owners = new ArrayList<ModContainer>(aRecipe.owners);
        this.reloadOwner();
    }

    GT_Recipe(ItemStack[] mInputs, ItemStack[] mOutputs, FluidStack[] mFluidInputs, FluidStack[] mFluidOutputs, int[] mChances, Object mSpecialItems, int mDuration, int mEUt, int mSpecialValue, boolean mEnabled, boolean mHidden, boolean mFakeRecipe, boolean mCanBeBuffered, boolean mNeedsEmptyOutput, boolean nbtSensitive, String[] neiDesc, @Nullable IRecipeMetadataStorage metadataStorage, RecipeCategory recipeCategory) {
        this.mInputs = mInputs;
        this.mOutputs = mOutputs;
        this.mFluidInputs = mFluidInputs;
        this.mFluidOutputs = mFluidOutputs;
        this.mChances = mChances;
        this.mSpecialItems = mSpecialItems;
        this.mDuration = mDuration;
        this.mEUt = mEUt;
        this.mSpecialValue = mSpecialValue;
        this.mEnabled = mEnabled;
        this.mHidden = mHidden;
        this.mFakeRecipe = mFakeRecipe;
        this.mCanBeBuffered = mCanBeBuffered;
        this.mNeedsEmptyOutput = mNeedsEmptyOutput;
        this.isNBTSensitive = nbtSensitive;
        this.neiDesc = neiDesc;
        this.metadataStorage = metadataStorage == null ? EmptyRecipeMetadataStorage.INSTANCE : metadataStorage.copy();
        this.recipeCategory = recipeCategory;
        this.reloadOwner();
    }

    public GT_Recipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
        int i;
        if (aInputs == null) {
            aInputs = new ItemStack[]{};
        }
        if (aOutputs == null) {
            aOutputs = new ItemStack[]{};
        }
        if (aFluidInputs == null) {
            aFluidInputs = new FluidStack[]{};
        }
        if (aFluidOutputs == null) {
            aFluidOutputs = new FluidStack[]{};
        }
        if (aChances == null) {
            aChances = new int[aOutputs.length];
        }
        if (aChances.length < aOutputs.length) {
            aChances = Arrays.copyOf(aChances, aOutputs.length);
        }
        aInputs = ArrayExt.withoutTrailingNulls(aInputs, ItemStack[]::new);
        aOutputs = ArrayExt.withoutTrailingNulls(aOutputs, ItemStack[]::new);
        aFluidInputs = ArrayExt.withoutNulls(aFluidInputs, FluidStack[]::new);
        aFluidOutputs = ArrayExt.withoutNulls(aFluidOutputs, FluidStack[]::new);
        GT_OreDictUnificator.setStackArray(true, aInputs);
        GT_OreDictUnificator.setStackArray(true, aOutputs);
        for (ItemStack tStack : aOutputs) {
            GT_Utility.updateItemStack(tStack);
        }
        for (i = 0; i < aChances.length; ++i) {
            if (aChances[i] > 0) continue;
            aChances[i] = 10000;
        }
        for (i = 0; i < aFluidInputs.length; ++i) {
            aFluidInputs[i] = aFluidInputs[i].copy();
        }
        for (i = 0; i < aFluidOutputs.length; ++i) {
            aFluidOutputs[i] = aFluidOutputs[i].copy();
        }
        if (aOptimize && aDuration >= 32) {
            ArrayList<ItemStack> tList = new ArrayList<ItemStack>();
            tList.addAll(Arrays.asList(aInputs));
            tList.addAll(Arrays.asList(aOutputs));
            for (int i2 = 0; i2 < tList.size(); ++i2) {
                if (tList.get(i2) != null) continue;
                tList.remove(i2--);
            }
            for (byte i2 = (byte)Math.min(64, aDuration / 16); i2 > 1; i2 = (byte)(i2 - 1)) {
                if (aDuration / i2 < 16) continue;
                boolean temp = true;
                for (ItemStack stack : tList) {
                    if (stack.field_77994_a % i2 == 0) continue;
                    temp = false;
                    break;
                }
                if (temp) {
                    for (FluidStack fluidStack : aFluidInputs) {
                        if (fluidStack.amount % i2 == 0) continue;
                        temp = false;
                        break;
                    }
                }
                if (temp) {
                    for (FluidStack fluidStack : aFluidOutputs) {
                        if (fluidStack.amount % i2 == 0) continue;
                        temp = false;
                        break;
                    }
                }
                if (!temp) continue;
                for (ItemStack itemStack : tList) {
                    itemStack.field_77994_a /= i2;
                }
                for (FluidStack fluidStack : aFluidInputs) {
                    fluidStack.amount /= i2;
                }
                for (FluidStack fluidStack : aFluidOutputs) {
                    fluidStack.amount /= i2;
                }
                aDuration /= i2;
            }
        }
        this.mInputs = aInputs;
        this.mOutputs = aOutputs;
        this.mSpecialItems = aSpecialItems;
        this.mChances = aChances;
        this.mFluidInputs = aFluidInputs;
        this.mFluidOutputs = aFluidOutputs;
        this.mDuration = aDuration;
        this.mSpecialValue = aSpecialValue;
        this.mEUt = aEUt;
        this.metadataStorage = EmptyRecipeMetadataStorage.INSTANCE;
        this.reloadOwner();
    }

    public GT_Recipe(ItemStack aInput1, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4, int aSpecialValue, int aType) {
        this(true, new ItemStack[]{aInput1}, new ItemStack[]{aOutput1, aOutput2, aOutput3, aOutput4}, null, null, null, null, 0, 0, Math.max(1, aSpecialValue));
        if (this.mInputs.length > 0 && aSpecialValue > 0) {
            switch (aType) {
                case 0: {
                    RecipeMaps.dieselFuels.addRecipe(this);
                    RecipeMaps.largeBoilerFakeFuels.getBackend().addDieselRecipe(this);
                    break;
                }
                case 1: {
                    RecipeMaps.gasTurbineFuels.addRecipe(this);
                    break;
                }
                case 2: {
                    RecipeMaps.hotFuels.addRecipe(this);
                    break;
                }
                case 4: {
                    RecipeMaps.plasmaFuels.addRecipe(this);
                    break;
                }
                case 5: {
                    RecipeMaps.magicFuels.addRecipe(this);
                    break;
                }
                default: {
                    RecipeMaps.denseLiquidFuels.addRecipe(this);
                    RecipeMaps.largeBoilerFakeFuels.getBackend().addDenseLiquidRecipe(this);
                }
            }
        }
    }

    public GT_Recipe(ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
        this(true, aInputs, aOutputs, aSpecialItems, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue);
    }

    public static void reInit() {
        GT_Log.out.println("GT_Mod: Re-Unificating Recipes.");
        for (RecipeMap<?> map : RecipeMap.ALL_RECIPE_MAPS.values()) {
            ((RecipeMapBackend)map.getBackend()).reInit();
        }
    }

    public ItemStack getRepresentativeInput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mInputs.length) {
            return null;
        }
        return GT_Utility.copyOrNull(this.mInputs[aIndex]);
    }

    public ItemStack getOutput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mOutputs.length) {
            return null;
        }
        return GT_Utility.copyOrNull(this.mOutputs[aIndex]);
    }

    public ItemStack getRepresentativeOutput(int i) {
        return this.getOutput(i);
    }

    public int getOutputChance(int aIndex) {
        if (this.mChances == null) {
            return 10000;
        }
        if (aIndex < 0 || aIndex >= this.mChances.length) {
            return 10000;
        }
        return this.mChances[aIndex];
    }

    public FluidStack getRepresentativeFluidInput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mFluidInputs.length || this.mFluidInputs[aIndex] == null) {
            return null;
        }
        return this.mFluidInputs[aIndex].copy();
    }

    public FluidStack getFluidOutput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mFluidOutputs.length || this.mFluidOutputs[aIndex] == null) {
            return null;
        }
        return this.mFluidOutputs[aIndex].copy();
    }

    public void checkCellBalance() {
        int tOutputAmount;
        if (!GT_Values.D2 || this.mInputs.length < 1) {
            return;
        }
        int tInputAmount = GT_ModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(this.mInputs);
        if (tInputAmount < (tOutputAmount = GT_ModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(this.mOutputs))) {
            if (!Materials.Tin.contains(this.mInputs)) {
                GT_Log.err.println("You get more Cells, than you put in? There must be something wrong.");
                new Exception().printStackTrace(GT_Log.err);
            }
        } else if (tInputAmount > tOutputAmount && !Materials.Tin.contains(this.mOutputs)) {
            GT_Log.err.println("You get less Cells, than you put in? GT Machines usually don't destroy Cells.");
            new Exception().printStackTrace(GT_Log.err);
        }
    }

    public GT_Recipe copy() {
        return new GT_Recipe(this, false);
    }

    public GT_Recipe copyShallow() {
        return new GT_Recipe(this, true);
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        return this.isRecipeInputEqual(aDecreaseStacksizeBySuccess, false, 1, aFluidInputs, aInputs);
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, boolean aDontCheckStackSizes, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        return this.isRecipeInputEqual(aDecreaseStacksizeBySuccess, aDontCheckStackSizes, 1, aFluidInputs, aInputs);
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, boolean aDontCheckStackSizes, int amountMultiplier, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        double maxParallel = this.maxParallelCalculatedByInputs(amountMultiplier, aFluidInputs, aInputs);
        if (aDontCheckStackSizes) {
            return maxParallel > 0.0;
        }
        if (maxParallel >= (double)amountMultiplier) {
            if (aDecreaseStacksizeBySuccess) {
                this.consumeInput(amountMultiplier, aFluidInputs, aInputs);
            }
            return true;
        }
        return false;
    }

    public void consumeInput(int amountMultiplier, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        long remainingCost;
        if (amountMultiplier <= 0) {
            return;
        }
        if (aFluidInputs != null) {
            block0: for (FluidStack fluidStack : this.mFluidInputs) {
                if (fluidStack == null) continue;
                remainingCost = (long)fluidStack.amount * (long)amountMultiplier;
                for (FluidStack providedFluid : aFluidInputs) {
                    if (providedFluid == null || !providedFluid.isFluidEqual(fluidStack)) continue;
                    if ((long)providedFluid.amount >= remainingCost) {
                        providedFluid.amount = (int)((long)providedFluid.amount - remainingCost);
                        continue block0;
                    }
                    remainingCost -= (long)providedFluid.amount;
                    providedFluid.amount = 0;
                }
            }
        }
        if (aInputs != null) {
            block2: for (FluidStack fluidStack : this.mInputs) {
                ItemStack unifiedItemCost = GT_OreDictUnificator.get_nocopy(true, (ItemStack)fluidStack);
                if (unifiedItemCost == null) continue;
                remainingCost = (long)fluidStack.field_77994_a * (long)amountMultiplier;
                for (ItemStack providedItem : aInputs) {
                    if (this.isNBTSensitive && !GT_Utility.areStacksEqual(providedItem, unifiedItemCost, false) || !this.isNBTSensitive && !GT_OreDictUnificator.isInputStackEqual(providedItem, unifiedItemCost) || GTppRecipeHelper && (GT_Utility.areStacksEqual(providedItem, Ic2Items.FluidCell.func_77946_l(), true) || GT_Utility.areStacksEqual(providedItem, ItemList.Tool_DataStick.get(1L, new Object[0]), true) || GT_Utility.areStacksEqual(providedItem, ItemList.Tool_DataOrb.get(1L, new Object[0]), true)) && !GT_Utility.areStacksEqual(providedItem, (ItemStack)fluidStack, false)) continue;
                    if ((long)providedItem.field_77994_a >= remainingCost) {
                        providedItem.field_77994_a = (int)((long)providedItem.field_77994_a - remainingCost);
                        continue block2;
                    }
                    remainingCost -= (long)providedItem.field_77994_a;
                    providedItem.field_77994_a = 0;
                }
            }
        }
    }

    public double maxParallelCalculatedByInputs(int maxParallel, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        if (this.mInputs.length > 0 && aInputs == null) {
            return 0.0;
        }
        if (this.mFluidInputs.length > 0 && aFluidInputs == null) {
            return 0.0;
        }
        double currentParallel = maxParallel;
        if (this.mFluidInputs.length > 0) {
            Reference2LongArrayMap fluidMap = new Reference2LongArrayMap(2);
            Reference2LongArrayMap fluidCost = new Reference2LongArrayMap(2);
            for (FluidStack fluidStack : aFluidInputs) {
                if (fluidStack == null) continue;
                fluidMap.mergeLong((Object)fluidStack.getFluid(), (long)fluidStack.amount, Long::sum);
            }
            for (FluidStack fluidStack : this.mFluidInputs) {
                if (fluidStack == null) continue;
                fluidCost.mergeLong((Object)fluidStack.getFluid(), (long)fluidStack.amount, Long::sum);
            }
            for (Reference2LongMap.Entry costEntry : fluidCost.reference2LongEntrySet()) {
                if (costEntry.getLongValue() > 0L) {
                    currentParallel = Math.min(currentParallel, (double)fluidMap.getOrDefault(costEntry.getKey(), 0L) / (double)costEntry.getLongValue());
                }
                if (!(currentParallel <= 0.0)) continue;
                return 0.0;
            }
        }
        if (this.mInputs.length > 0) {
            Object2LongArrayMap itemCostMap = new Object2LongArrayMap(2);
            for (ItemStack itemStack : this.mInputs) {
                if (itemStack == null) continue;
                if (this.shouldCheckNBT(itemStack)) {
                    GT_Utility.ItemId itemId = GT_Utility.ItemId.createNoCopy(itemStack);
                    itemCostMap.mergeLong((Object)itemId, (long)itemStack.field_77994_a, Long::sum);
                    continue;
                }
                ItemStack unifiedItem = GT_OreDictUnificator.get_nocopy(true, itemStack);
                if (unifiedItem == null) continue;
                GT_Utility.ItemId unifiedId = this.isNBTSensitive ? GT_Utility.ItemId.createNoCopy(unifiedItem) : GT_Utility.ItemId.createWithoutNBT(unifiedItem);
                itemCostMap.mergeLong((Object)unifiedId, (long)itemStack.field_77994_a, Long::sum);
            }
            block4: for (Map.Entry costEntry : itemCostMap.entrySet()) {
                ItemStack unifiedItemCost = ((GT_Utility.ItemId)costEntry.getKey()).getItemStack();
                if (unifiedItemCost == null) continue;
                double remainingCost = (double)((Long)costEntry.getValue()).longValue() * currentParallel;
                long providedAmount = 0L;
                for (ItemStack providedItem : aInputs) {
                    if (this.areInputStackAndRecipeCostMatched(providedItem, unifiedItemCost) && ((Long)costEntry.getValue() == 0L || (double)(providedAmount += (long)providedItem.field_77994_a) >= remainingCost)) continue block4;
                }
                if (providedAmount == 0L) {
                    return 0.0;
                }
                currentParallel = Math.min(currentParallel, (double)providedAmount / (double)((Long)costEntry.getValue()).longValue());
            }
        }
        return currentParallel;
    }

    private boolean areInputStackAndRecipeCostMatched(ItemStack providedItem, ItemStack unifiedItemCost) {
        if (this.isNBTSensitive || this.shouldCheckNBT(providedItem)) {
            return GT_Utility.areStacksEqual(providedItem, unifiedItemCost, false);
        }
        return GT_OreDictUnificator.isInputStackEqual(providedItem, unifiedItemCost);
    }

    private boolean shouldCheckNBT(ItemStack item) {
        if (GTppRecipeHelper) {
            return GT_Utility.areStacksEqual(item, Ic2Items.FluidCell.func_77946_l(), true) || GT_Utility.areStacksEqual(item, ItemList.Tool_DataStick.get(1L, new Object[0]), true) || GT_Utility.areStacksEqual(item, ItemList.Tool_DataOrb.get(1L, new Object[0]), true);
        }
        return false;
    }

    public boolean isRecipePossible(@Nullable ItemInventoryLogic itemInput, @Nullable FluidInventoryLogic fluidInput) {
        return this.getAmountOfRecipesDone(itemInput, fluidInput, 1L, true) > 0L;
    }

    public long getAmountOfRecipesDone(@Nullable ItemInventoryLogic itemInput, @Nullable FluidInventoryLogic fluidInput, long maxParallel, boolean simulate) {
        if (itemInput == null) {
            itemInput = new ItemInventoryLogic(0);
        }
        if (fluidInput == null) {
            fluidInput = new FluidInventoryLogic(0, 0L);
        }
        itemInput.startRecipeCheck();
        Map<ItemHolder, Long> recipeItems = this.getItemInputsAsItemMap();
        for (Map.Entry<ItemHolder, Long> entry : recipeItems.entrySet()) {
            maxParallel = Math.min(maxParallel, itemInput.calculateAmountOfTimesItemCanBeTaken(entry.getKey(), entry.getValue()));
        }
        for (Object fluid : this.mFluidInputs) {
            if (fluid == null) continue;
            maxParallel = Math.min(maxParallel, fluidInput.calculateAmountOfTimesFluidCanBeTaken(fluid.getFluid(), fluid.amount));
        }
        if (simulate) {
            itemInput.stopRecipeCheck();
            return maxParallel;
        }
        for (Map.Entry entry : recipeItems.entrySet()) {
            itemInput.subtractItemAmount((ItemHolder)entry.getKey(), (Long)entry.getValue() * maxParallel, false);
        }
        for (Object fluid : this.mFluidInputs) {
            if (fluid == null) continue;
            fluidInput.drain(fluid.getFluid(), (long)fluid.amount * maxParallel, false);
        }
        itemInput.stopRecipeCheck();
        return maxParallel;
    }

    private Map<ItemHolder, Long> getItemInputsAsItemMap() {
        HashMap<ItemHolder, Long> items = new HashMap<ItemHolder, Long>();
        for (ItemStack item : this.mInputs) {
            if (item == null) continue;
            ItemHolder itemHolder = new ItemHolder(item);
            items.put(itemHolder, items.getOrDefault(itemHolder, 0L) + (long)item.field_77994_a);
        }
        return items;
    }

    @Override
    public int compareTo(GT_Recipe recipe) {
        if (this.mEUt != recipe.mEUt) {
            return this.mEUt - recipe.mEUt;
        }
        if (this.mDuration != recipe.mDuration) {
            return this.mDuration - recipe.mDuration;
        }
        if (this.mSpecialValue != recipe.mSpecialValue) {
            return this.mSpecialValue - recipe.mSpecialValue;
        }
        if (this.mFluidInputs.length != recipe.mFluidInputs.length) {
            return this.mFluidInputs.length - recipe.mFluidInputs.length;
        }
        if (this.mInputs.length != recipe.mInputs.length) {
            return this.mInputs.length - recipe.mInputs.length;
        }
        return 0;
    }

    public String[] getNeiDesc() {
        return this.neiDesc;
    }

    public void setNeiDesc(String ... neiDesc) {
        this.neiDesc = neiDesc;
    }

    @Nullable
    public <T> T getMetadata(RecipeMetadataKey<T> key) {
        return key.cast(this.metadataStorage.getMetadata(key));
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public <T> T getMetadataOrDefault(RecipeMetadataKey<T> key, @Nullable T defaultValue) {
        return key.cast(this.metadataStorage.getMetadataOrDefault(key, defaultValue));
    }

    @Nonnull
    public IRecipeMetadataStorage getMetadataStorage() {
        return this.metadataStorage;
    }

    public RecipeCategory getRecipeCategory() {
        return this.recipeCategory;
    }

    public void setRecipeCategory(RecipeCategory recipeCategory) {
        this.recipeCategory = recipeCategory;
    }

    public void reloadOwner() {
        this.setOwner(Loader.instance().activeModContainer());
        if (GT_Mod.gregtechproxy.mNEIRecipeOwnerStackTrace) {
            ArrayList<String> toAdd = new ArrayList<String>();
            for (StackTraceElement stackTrace : Thread.currentThread().getStackTrace()) {
                if (!excludedStacktraces.stream().noneMatch(c -> stackTrace.getClassName().equals(c))) continue;
                toAdd.add(GT_Recipe.formatStackTrace(stackTrace));
            }
            this.stackTraces.add(toAdd);
        }
    }

    private static String formatStackTrace(StackTraceElement stackTraceElement) {
        String raw = stackTraceElement.toString();
        int startParen = raw.lastIndexOf(40);
        int colon = raw.lastIndexOf(58);
        if (colon == -1) {
            return raw;
        }
        return raw.substring(0, startParen + 1) + raw.substring(colon);
    }

    public void setOwner(ModContainer newOwner) {
        ModContainer oldOwner;
        ModContainer modContainer = oldOwner = !this.owners.isEmpty() ? this.owners.get(this.owners.size() - 1) : null;
        if (newOwner != null && newOwner != oldOwner) {
            this.owners.add(newOwner);
        }
    }

    public void setOwner(String modId) {
        for (ModContainer mod : Loader.instance().getModList()) {
            if (!mod.getModId().equals(modId)) continue;
            this.setOwner(mod);
            return;
        }
    }

    public GT_Recipe setInputs(ItemStack ... aInputs) {
        this.mInputs = ArrayExt.withoutTrailingNulls(aInputs, ItemStack[]::new);
        return this;
    }

    public GT_Recipe setOutputs(ItemStack ... aOutputs) {
        this.mOutputs = ArrayExt.withoutTrailingNulls(aOutputs, ItemStack[]::new);
        return this;
    }

    public GT_Recipe setFluidInputs(FluidStack ... aInputs) {
        this.mFluidInputs = ArrayExt.withoutTrailingNulls(aInputs, FluidStack[]::new);
        return this;
    }

    public GT_Recipe setFluidOutputs(FluidStack ... aOutputs) {
        this.mFluidOutputs = ArrayExt.withoutTrailingNulls(aOutputs, FluidStack[]::new);
        return this;
    }

    public GT_Recipe setDuration(int aDuration) {
        this.mDuration = aDuration;
        return this;
    }

    public GT_Recipe setEUt(int aEUt) {
        this.mEUt = aEUt;
        return this;
    }

    static {
        excludedStacktraces = Arrays.asList("java.lang.Thread", "gregtech.api.interfaces.IRecipeMap", "gregtech.api.interfaces.IRecipeMap$1", "gregtech.api.recipe.RecipeMap", "gregtech.api.recipe.RecipeMapBackend", "gregtech.api.recipe.RecipeMapBackendPropertiesBuilder", "gregtech.api.util.GT_Recipe", "gregtech.api.util.GT_RecipeBuilder", "gregtech.api.util.GT_RecipeConstants", "gregtech.api.util.GT_RecipeMapUtil", "gregtech.common.GT_RecipeAdder");
    }

    public static class GT_Recipe_WithAlt
    extends GT_Recipe {
        public ItemStack[][] mOreDictAlt;

        GT_Recipe_WithAlt(ItemStack[] mInputs, ItemStack[] mOutputs, FluidStack[] mFluidInputs, FluidStack[] mFluidOutputs, int[] mChances, Object mSpecialItems, int mDuration, int mEUt, int mSpecialValue, boolean mEnabled, boolean mHidden, boolean mFakeRecipe, boolean mCanBeBuffered, boolean mNeedsEmptyOutput, boolean nbtSensitive, String[] neiDesc, @Nullable IRecipeMetadataStorage metadataStorage, RecipeCategory recipeCategory, ItemStack[][] mOreDictAlt) {
            super(mInputs, mOutputs, mFluidInputs, mFluidOutputs, mChances, mSpecialItems, mDuration, mEUt, mSpecialValue, mEnabled, mHidden, mFakeRecipe, mCanBeBuffered, mNeedsEmptyOutput, nbtSensitive, neiDesc, metadataStorage, recipeCategory);
            this.mOreDictAlt = mOreDictAlt;
        }

        public GT_Recipe_WithAlt(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue, ItemStack[][] aAlt) {
            super(aOptimize, aInputs, aOutputs, aSpecialItems, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue);
            this.mOreDictAlt = aAlt;
        }

        public Object getAltRepresentativeInput(int aIndex) {
            if (aIndex < 0) {
                return null;
            }
            if (aIndex < this.mOreDictAlt.length && this.mOreDictAlt[aIndex] != null && this.mOreDictAlt[aIndex].length > 0) {
                ItemStack[] rStacks = new ItemStack[this.mOreDictAlt[aIndex].length];
                for (int i = 0; i < this.mOreDictAlt[aIndex].length; ++i) {
                    rStacks[i] = GT_Utility.copyOrNull(this.mOreDictAlt[aIndex][i]);
                }
                return rStacks;
            }
            if (aIndex >= this.mInputs.length) {
                return null;
            }
            return GT_Utility.copyOrNull(this.mInputs[aIndex]);
        }
    }

    public static class GT_Recipe_AssemblyLine {
        public static final ArrayList<GT_Recipe_AssemblyLine> sAssemblylineRecipes = new ArrayList();
        public ItemStack mResearchItem;
        public int mResearchTime;
        public ItemStack[] mInputs;
        public FluidStack[] mFluidInputs;
        public ItemStack mOutput;
        public int mDuration;
        public int mEUt;
        public ItemStack[][] mOreDictAlt;
        private int mPersistentHash;

        private static void checkInvalidRecipes() {
            int invalidCount = 0;
            GT_Log.out.println("Started assline validation");
            for (GT_Recipe_AssemblyLine recipe : sAssemblylineRecipes) {
                if (recipe.getPersistentHash() != 0) continue;
                ++invalidCount;
                GT_Log.err.printf("Invalid recipe: %s%n", recipe);
            }
            if (invalidCount > 0) {
                throw new RuntimeException("There are " + invalidCount + " invalid assembly line recipe(s)! Check GregTech.log for details!");
            }
        }

        public GT_Recipe_AssemblyLine(ItemStack aResearchItem, int aResearchTime, ItemStack[] aInputs, FluidStack[] aFluidInputs, ItemStack aOutput, int aDuration, int aEUt) {
            this(aResearchItem, aResearchTime, aInputs, aFluidInputs, aOutput, aDuration, aEUt, new ItemStack[aInputs.length][]);
            int tPersistentHash = 1;
            for (ItemStack itemStack : aInputs) {
                tPersistentHash = tPersistentHash * 31 + GT_Utility.persistentHash(itemStack, true, false);
            }
            tPersistentHash = tPersistentHash * 31 + GT_Utility.persistentHash(aResearchItem, true, false);
            tPersistentHash = tPersistentHash * 31 + GT_Utility.persistentHash(aOutput, true, false);
            for (ItemStack itemStack : aFluidInputs) {
                tPersistentHash = tPersistentHash * 31 + GT_Utility.persistentHash((FluidStack)itemStack, true, false);
            }
            tPersistentHash = tPersistentHash * 31 + aResearchTime;
            tPersistentHash = tPersistentHash * 31 + aDuration;
            tPersistentHash = tPersistentHash * 31 + aEUt;
            this.setPersistentHash(tPersistentHash);
        }

        public GT_Recipe_AssemblyLine(ItemStack aResearchItem, int aResearchTime, ItemStack[] aInputs, FluidStack[] aFluidInputs, ItemStack aOutput, int aDuration, int aEUt, ItemStack[][] aAlt) {
            this.mResearchItem = aResearchItem;
            this.mResearchTime = aResearchTime;
            this.mInputs = aInputs;
            this.mFluidInputs = aFluidInputs;
            this.mOutput = aOutput;
            this.mDuration = aDuration;
            this.mEUt = aEUt;
            this.mOreDictAlt = aAlt;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            Object[] thisInputs = new GT_ItemStack[this.mInputs.length];
            int totalInputStackSize = 0;
            for (int i = 0; i < this.mInputs.length; ++i) {
                thisInputs[i] = new GT_ItemStack(this.mInputs[i]);
                totalInputStackSize += ((GT_ItemStack)thisInputs[i]).mStackSize;
            }
            int inputHash = Arrays.deepHashCode(thisInputs);
            int inputFluidHash = Arrays.deepHashCode(this.mFluidInputs);
            GT_ItemStack thisOutput = new GT_ItemStack(this.mOutput);
            GT_ItemStack thisResearch = new GT_ItemStack(this.mResearchItem);
            int miscRecipeDataHash = Arrays.deepHashCode(new Object[]{totalInputStackSize, this.mDuration, this.mEUt, thisOutput, thisResearch, this.mResearchTime});
            result = 31 * result + inputFluidHash;
            result = 31 * result + inputHash;
            result = 31 * result + miscRecipeDataHash;
            return result;
        }

        public boolean equals(Object obj) {
            int i;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GT_Recipe_AssemblyLine)) {
                return false;
            }
            GT_Recipe_AssemblyLine other = (GT_Recipe_AssemblyLine)obj;
            if (this.mInputs.length != other.mInputs.length) {
                return false;
            }
            if (this.mFluidInputs.length != other.mFluidInputs.length) {
                return false;
            }
            GT_ItemStack output1 = new GT_ItemStack(this.mOutput);
            GT_ItemStack output2 = new GT_ItemStack(other.mOutput);
            if (!output1.equals(output2)) {
                return false;
            }
            GT_ItemStack scan1 = new GT_ItemStack(this.mResearchItem);
            GT_ItemStack scan2 = new GT_ItemStack(other.mResearchItem);
            if (!scan1.equals(scan2)) {
                return false;
            }
            GT_ItemStack[] thisInputs = new GT_ItemStack[this.mInputs.length];
            GT_ItemStack[] otherInputs = new GT_ItemStack[other.mInputs.length];
            for (i = 0; i < thisInputs.length; ++i) {
                thisInputs[i] = new GT_ItemStack(this.mInputs[i]);
                otherInputs[i] = new GT_ItemStack(other.mInputs[i]);
            }
            for (i = 0; i < thisInputs.length; ++i) {
                if (thisInputs[i].equals(otherInputs[i]) && thisInputs[i].mStackSize == otherInputs[i].mStackSize) continue;
                return false;
            }
            for (i = 0; i < this.mFluidInputs.length; ++i) {
                if (this.mFluidInputs[i].isFluidStackIdentical(other.mFluidInputs[i])) continue;
                return false;
            }
            return this.mDuration == other.mDuration && this.mEUt == other.mEUt && this.mResearchTime == other.mResearchTime;
        }

        public int getPersistentHash() {
            if (this.mPersistentHash == 0) {
                GT_Log.err.println("Assline recipe persistent hash has not been set! Recipe: " + this.mOutput);
            }
            return this.mPersistentHash;
        }

        public String toString() {
            return "GT_Recipe_AssemblyLine{mResearchItem=" + this.mResearchItem + ", mResearchTime=" + this.mResearchTime + ", mInputs=" + Arrays.toString(this.mInputs) + ", mFluidInputs=" + Arrays.toString(this.mFluidInputs) + ", mOutput=" + this.mOutput + ", mDuration=" + this.mDuration + ", mEUt=" + this.mEUt + ", mOreDictAlt=" + Arrays.toString((Object[])this.mOreDictAlt) + '}';
        }

        public void setPersistentHash(int aPersistentHash) {
            if (this.mPersistentHash != 0) {
                throw new IllegalStateException("Cannot set persistent hash twice!");
            }
            this.mPersistentHash = aPersistentHash == 0 ? 1 : aPersistentHash;
        }

        static {
            if (!Boolean.getBoolean("com.gtnh.gt5u.ignore-invalid-assline-recipe")) {
                GregTech_API.sFirstWorldTick.add(GT_Recipe_AssemblyLine::checkInvalidRecipes);
            } else {
                GT_Log.out.println("NOT CHECKING INVALID ASSLINE RECIPE.");
            }
        }
    }
}

