/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.recipe.RecipeCategory;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackendProperties;
import gregtech.api.recipe.RecipeMapBackendPropertiesBuilder;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeBuilder;
import gregtech.api.util.GT_StreamUtil;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Unmodifiable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RecipeMapBackend {
    private RecipeMap<?> recipeMap;
    private final SetMultimap<GT_ItemStack, GT_Recipe> itemIndex = HashMultimap.create();
    private final SetMultimap<String, GT_Recipe> fluidIndex = HashMultimap.create();
    private final Map<RecipeCategory, Collection<GT_Recipe>> recipesByCategory = new HashMap<RecipeCategory, Collection<GT_Recipe>>();
    private final List<IRecipeMap> downstreams = new ArrayList<IRecipeMap>(0);
    protected final RecipeMapBackendProperties properties;

    public RecipeMapBackend(RecipeMapBackendPropertiesBuilder propertiesBuilder) {
        this.properties = propertiesBuilder.build();
        GregTech_API.itemStackMultiMaps.add(this.itemIndex);
    }

    void setRecipeMap(RecipeMap<?> recipeMap) {
        this.recipeMap = recipeMap;
    }

    public RecipeMapBackendProperties getProperties() {
        return this.properties;
    }

    public @Unmodifiable Collection<GT_Recipe> getAllRecipes() {
        return Collections.unmodifiableCollection(this.allRecipes());
    }

    private Collection<GT_Recipe> allRecipes() {
        return this.recipesByCategory.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
    }

    public @Unmodifiable Collection<GT_Recipe> getRecipesByCategory(RecipeCategory recipeCategory) {
        return Collections.unmodifiableCollection(this.recipesByCategory.getOrDefault(recipeCategory, Collections.emptyList()));
    }

    public @Unmodifiable Map<RecipeCategory, Collection<GT_Recipe>> getRecipeCategoryMap() {
        return Collections.unmodifiableMap(this.recipesByCategory);
    }

    public GT_Recipe compileRecipe(GT_Recipe recipe) {
        if (recipe.getRecipeCategory() == null) {
            recipe.setRecipeCategory(this.recipeMap.getDefaultRecipeCategory());
        }
        this.recipesByCategory.computeIfAbsent(recipe.getRecipeCategory(), v -> new ArrayList()).add(recipe);
        for (FluidStack fluid : recipe.mFluidInputs) {
            if (fluid == null) continue;
            this.fluidIndex.put((Object)fluid.getFluid().getName(), (Object)recipe);
        }
        return this.addToItemMap(recipe);
    }

    protected GT_Recipe addToItemMap(GT_Recipe recipe) {
        for (ItemStack item : recipe.mInputs) {
            if (item == null) continue;
            this.itemIndex.put((Object)new GT_ItemStack(item), (Object)recipe);
        }
        if (recipe instanceof GT_Recipe.GT_Recipe_WithAlt) {
            GT_Recipe.GT_Recipe_WithAlt recipeWithAlt = (GT_Recipe.GT_Recipe_WithAlt)recipe;
            for (ItemStack[] itemStacks : recipeWithAlt.mOreDictAlt) {
                if (itemStacks == null) continue;
                for (ItemStack item : itemStacks) {
                    if (item == null) continue;
                    this.itemIndex.put((Object)new GT_ItemStack(item), (Object)recipe);
                }
            }
        }
        return recipe;
    }

    /*
     * WARNING - void declaration
     */
    protected Collection<GT_Recipe> doAdd(GT_RecipeBuilder builder) {
        Iterable<? extends GT_Recipe> recipes = this.properties.recipeEmitter.apply(builder);
        ArrayList<GT_Recipe> ret = new ArrayList<GT_Recipe>();
        for (GT_Recipe gT_Recipe : recipes) {
            void var5_5;
            if (this.properties.recipeConfigCategory != null) {
                assert (this.properties.recipeConfigKeyConvertor != null);
                String configKey = this.properties.recipeConfigKeyConvertor.apply(gT_Recipe);
                if (configKey != null && (gT_Recipe.mDuration = GregTech_API.sRecipeFile.get((Object)this.properties.recipeConfigCategory, configKey, gT_Recipe.mDuration)) <= 0) continue;
            }
            if (gT_Recipe.mFluidInputs.length < this.properties.minFluidInputs || gT_Recipe.mInputs.length < this.properties.minItemInputs) {
                return Collections.emptyList();
            }
            if (this.properties.recipeTransformer != null) {
                GT_Recipe gT_Recipe2 = this.properties.recipeTransformer.apply(gT_Recipe);
            }
            if (var5_5 == null) continue;
            if (builder.isCheckForCollision() && this.checkCollision((GT_Recipe)var5_5)) {
                this.handleCollision((GT_Recipe)var5_5);
                continue;
            }
            if (var5_5.getRecipeCategory() != null && var5_5.getRecipeCategory().recipeMap != this.recipeMap) {
                GT_RecipeBuilder.handleInvalidRecipe();
                continue;
            }
            ret.add(this.compileRecipe((GT_Recipe)var5_5));
        }
        if (!ret.isEmpty()) {
            builder.clearInvalid();
            for (IRecipeMap iRecipeMap : this.downstreams) {
                iRecipeMap.doAdd(builder);
            }
        }
        return ret;
    }

    private void handleCollision(GT_Recipe recipe) {
        StringBuilder errorInfo = new StringBuilder();
        boolean hasAnEntry = false;
        for (FluidStack fluidStack : recipe.mFluidInputs) {
            String s;
            if (fluidStack == null || (s = fluidStack.getLocalizedName()) == null) continue;
            if (hasAnEntry) {
                errorInfo.append("+").append(s);
            } else {
                errorInfo.append(s);
            }
            hasAnEntry = true;
        }
        for (FluidStack fluidStack : recipe.mInputs) {
            if (fluidStack == null) continue;
            String itemName = fluidStack.func_82833_r();
            if (hasAnEntry) {
                errorInfo.append("+").append(itemName);
            } else {
                errorInfo.append(itemName);
            }
            hasAnEntry = true;
        }
        GT_RecipeBuilder.handleRecipeCollision(errorInfo.toString());
    }

    void addDownstream(IRecipeMap downstream) {
        this.downstreams.add(downstream);
    }

    public void removeRecipes(Collection<? extends GT_Recipe> recipesToRemove) {
        for (Collection<GT_Recipe> recipes : this.recipesByCategory.values()) {
            recipes.removeAll(recipesToRemove);
        }
        for (Object key : new HashMap(this.itemIndex.asMap()).keySet()) {
            this.itemIndex.get(key).removeAll(recipesToRemove);
        }
        for (Object key : new HashMap(this.fluidIndex.asMap()).keySet()) {
            this.fluidIndex.get(key).removeAll(recipesToRemove);
        }
    }

    public void removeRecipe(GT_Recipe recipe) {
        this.removeRecipes(Collections.singleton(recipe));
    }

    public void clearRecipes() {
        this.recipesByCategory.clear();
    }

    public void reInit() {
        this.itemIndex.clear();
        for (GT_Recipe recipe : this.allRecipes()) {
            GT_OreDictUnificator.setStackArray(true, recipe.mInputs);
            GT_OreDictUnificator.setStackArray(true, recipe.mOutputs);
            this.addToItemMap(recipe);
        }
    }

    public boolean containsInput(ItemStack item) {
        return this.itemIndex.containsKey((Object)new GT_ItemStack(item)) || this.itemIndex.containsKey((Object)new GT_ItemStack(item, true));
    }

    public boolean containsInput(Fluid fluid) {
        return this.fluidIndex.containsKey((Object)fluid.getName());
    }

    boolean checkCollision(GT_Recipe recipe) {
        return this.matchRecipeStream(recipe.mInputs, recipe.mFluidInputs, null, null, false, true, true).findAny().isPresent();
    }

    @Nullable
    protected GT_Recipe overwriteFindRecipe(ItemStack[] items, FluidStack[] fluids, @Nullable ItemStack specialSlot, @Nullable GT_Recipe cachedRecipe) {
        return null;
    }

    protected boolean doesOverwriteFindRecipe() {
        return false;
    }

    @Nullable
    protected GT_Recipe modifyFoundRecipe(GT_Recipe recipe, ItemStack[] items, FluidStack[] fluids, @Nullable ItemStack specialSlot) {
        return recipe;
    }

    @Nullable
    protected GT_Recipe findFallback(ItemStack[] items, FluidStack[] fluids, @Nullable ItemStack specialSlot) {
        return null;
    }

    Stream<GT_Recipe> matchRecipeStream(ItemStack[] rawItems, FluidStack[] fluids, @Nullable ItemStack specialSlot, @Nullable GT_Recipe cachedRecipe, boolean notUnificated, boolean dontCheckStackSizes, boolean forCollisionCheck) {
        if (this.doesOverwriteFindRecipe()) {
            return GT_StreamUtil.ofNullable(this.overwriteFindRecipe(rawItems, fluids, specialSlot, cachedRecipe));
        }
        if (this.recipesByCategory.isEmpty()) {
            return Stream.empty();
        }
        if (!forCollisionCheck) {
            int count;
            if (this.properties.minFluidInputs > 0) {
                count = 0;
                for (FluidStack fluidStack2 : fluids) {
                    if (fluidStack2 == null) continue;
                    ++count;
                }
                if (count < this.properties.minFluidInputs) {
                    return Stream.empty();
                }
            }
            if (this.properties.minItemInputs > 0) {
                count = 0;
                for (FluidStack fluidStack3 : rawItems) {
                    if (fluidStack3 == null) continue;
                    ++count;
                }
                if (count < this.properties.minItemInputs) {
                    return Stream.empty();
                }
            }
        }
        ItemStack[] items = notUnificated ? GT_OreDictUnificator.getStackArray(true, rawItems) : rawItems;
        Stream[] streamArray = new Stream[4];
        streamArray[0] = GT_StreamUtil.ofNullable(cachedRecipe).filter(recipe -> recipe.mCanBeBuffered).filter(recipe -> this.filterFindRecipe((GT_Recipe)recipe, items, fluids, specialSlot, dontCheckStackSizes)).map(recipe -> this.modifyFoundRecipe((GT_Recipe)recipe, items, fluids, specialSlot)).filter(Objects::nonNull);
        streamArray[1] = GT_StreamUtil.ofConditional(!this.itemIndex.isEmpty(), items).filter(Objects::nonNull).flatMap(item -> Stream.of(new GT_ItemStack((ItemStack)item), new GT_ItemStack((ItemStack)item, true))).map(arg_0 -> this.itemIndex.get(arg_0)).flatMap(Collection::stream).filter(recipe -> this.filterFindRecipe((GT_Recipe)recipe, items, fluids, specialSlot, dontCheckStackSizes)).map(recipe -> this.modifyFoundRecipe((GT_Recipe)recipe, items, fluids, specialSlot)).filter(Objects::nonNull);
        streamArray[2] = GT_StreamUtil.ofConditional(this.properties.minItemInputs == 0, fluids).filter(Objects::nonNull).map(fluidStack -> this.fluidIndex.get((Object)fluidStack.getFluid().getName())).flatMap(Collection::stream).filter(recipe -> this.filterFindRecipe((GT_Recipe)recipe, items, fluids, specialSlot, dontCheckStackSizes)).map(recipe -> this.modifyFoundRecipe((GT_Recipe)recipe, items, fluids, specialSlot)).filter(Objects::nonNull);
        streamArray[3] = forCollisionCheck ? Stream.empty() : GT_StreamUtil.ofSupplier(() -> this.findFallback(items, fluids, specialSlot)).filter(Objects::nonNull);
        return Stream.of(streamArray).flatMap(Function.identity());
    }

    protected boolean filterFindRecipe(GT_Recipe recipe, ItemStack[] items, FluidStack[] fluids, @Nullable ItemStack specialSlot, boolean dontCheckStackSizes) {
        if (recipe.mEnabled && !recipe.mFakeRecipe && recipe.isRecipeInputEqual(false, dontCheckStackSizes, fluids, items)) {
            return !this.properties.specialSlotSensitive || GT_Utility.areStacksEqualOrNull((ItemStack)recipe.mSpecialItems, specialSlot);
        }
        return false;
    }

    @FunctionalInterface
    public static interface BackendCreator<B extends RecipeMapBackend> {
        public B create(RecipeMapBackendPropertiesBuilder var1);
    }
}

