/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import gregtech.api.objects.GT_UO_Dimension;
import java.util.Arrays;
import java.util.Map;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class GT_UO_DimensionList {
    private Configuration fConfig;
    private String fCategory;
    private final BiMap<String, GT_UO_Dimension> fDimensionList;
    public int[] blackList = new int[0];

    public GT_UO_DimensionList() {
        this.fDimensionList = HashBiMap.create();
    }

    public GT_UO_Dimension GetDimension(int aDimension) {
        if (this.CheckBlackList(aDimension)) {
            return null;
        }
        if (this.fDimensionList.containsKey((Object)Integer.toString(aDimension))) {
            return (GT_UO_Dimension)this.fDimensionList.get((Object)Integer.toString(aDimension));
        }
        for (Map.Entry dl : this.fDimensionList.entrySet()) {
            if (!DimensionManager.getProvider((int)aDimension).getClass().getName().contains(((GT_UO_Dimension)dl.getValue()).Dimension)) continue;
            return (GT_UO_Dimension)dl.getValue();
        }
        return (GT_UO_Dimension)this.fDimensionList.get((Object)"Default");
    }

    private boolean CheckBlackList(int aDimensionId) {
        try {
            return Arrays.binarySearch(this.blackList, aDimensionId) >= 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void SetConfigValues(String aDimensionName, String aDimension, String aName, String aRegistry, int aMinAmount, int aMaxAmount, int aChance, int aDecreasePerOperationAmount) {
        String Category2 = this.fCategory + "." + aDimensionName;
        this.fConfig.get(Category2, "Dimension", aDimension).getString();
        Category2 = Category2 + "." + aName;
        this.fConfig.get(Category2, "Registry", aRegistry).getString();
        this.fConfig.get(Category2, "MinAmount", aMinAmount).getInt(aMinAmount);
        this.fConfig.get(Category2, "MaxAmount", aMaxAmount).getInt(aMaxAmount);
        this.fConfig.get(Category2, "Chance", aChance).getInt(aChance);
        this.fConfig.get(Category2, "DecreasePerOperationAmount", aDecreasePerOperationAmount).getInt(aDecreasePerOperationAmount);
    }

    public void SetDafultValues() {
        this.SetConfigValues("Overworld", "0", "gas_natural_gas", "gas_natural_gas", 0, 700, 20, 7);
        this.SetConfigValues("Overworld", "0", "liquid_light_oil", "liquid_light_oil", 0, 650, 20, 6);
        this.SetConfigValues("Overworld", "0", "liquid_medium_oil", "liquid_medium_oil", 0, 600, 20, 5);
        this.SetConfigValues("Overworld", "0", "liquid_heavy_oil", "liquid_heavy_oil", 0, 550, 20, 4);
        this.SetConfigValues("Overworld", "0", "oil", "oil", 0, 600, 20, 5);
        this.SetConfigValues("Moon", "Moon", "helium-3", "helium-3", 24, 128, 100, 1);
    }

    public void getConfig(Configuration aConfig, String aCategory) {
        this.fCategory = aCategory;
        this.fConfig = aConfig;
        if (!this.fConfig.hasCategory(this.fCategory)) {
            this.SetDafultValues();
        }
        this.fConfig.setCategoryComment(this.fCategory, "Config Underground Fluids (Delete this Category for regenerate)");
        this.fConfig.setCategoryComment(this.fCategory + ".Default", "Set Default Generating (Use this Category for Default settings)");
        this.fConfig.setCategoryComment(this.fCategory + ".Overworld", "Set Overworld Generating");
        this.fConfig.setCategoryComment(this.fCategory + ".Moon", "Set Moon Generating");
        this.blackList = new int[]{-1, 1};
        this.blackList = aConfig.get(this.fCategory, "DimBlackList", this.blackList, "Dimension IDs Black List").getIntList();
        Arrays.sort(this.blackList);
        for (int i = 0; i < this.fConfig.getCategory(this.fCategory).getChildren().size(); ++i) {
            GT_UO_Dimension Dimension2 = new GT_UO_Dimension((ConfigCategory)this.fConfig.getCategory(this.fCategory).getChildren().toArray()[i]);
            this.fDimensionList.put((Object)Dimension2.Dimension, (Object)Dimension2);
        }
    }
}

