/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.thing.block.TileForgeOfGods;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.gui.TecTechUITextures;
import com.github.technus.tectech.thing.metaTileEntity.multi.ForgeofGodsStructureString;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.github.technus.tectech.thing.metaTileEntity.multi.godforge_modules.GT_MetaTileEntity_EM_BaseModule;
import com.github.technus.tectech.util.CommonValues;
import com.github.technus.tectech.util.GodforgeMath;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.FluidNameHolderWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.util.GT_HatchElementBuilder;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.IGT_HatchAdder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class GT_MetaTileEntity_EM_ForgeOfGods
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable,
ISurvivalConstructable {
    private static Textures.BlockIcons.CustomIcon ScreenOFF;
    private static Textures.BlockIcons.CustomIcon ScreenON;
    private int fuelConsumptionFactor = 1;
    private int selectedFuelType = 0;
    private long fuelConsumption = 0L;
    private int internalBattery = 0;
    public ArrayList<GT_MetaTileEntity_EM_BaseModule> moduleHatches = new ArrayList();
    private static int spacetimeCompressionFieldMetadata;
    private int solenoidCoilMetadata = -1;
    private static final int FUEL_CONFIG_WINDOW_ID = 9;
    private static final int UPGRADE_TREE_WINDOW_ID = 10;
    private static final int INDIVIDUAL_UPGRADE_WINDOW_ID = 11;
    private static final int[] FIRST_SPLIT_UPGRADES;
    private static final int[] RING_UPGRADES;
    protected static final String STRUCTURE_PIECE_MAIN = "main";
    private Boolean debugMode = true;
    public static final IStructureDefinition<GT_MetaTileEntity_EM_ForgeOfGods> STRUCTURE_DEFINITION;
    private final ArrayList<FluidStack> validFuelList = new ArrayList<FluidStack>(){
        {
            this.add(MaterialsUEVplus.DimensionallyTranscendentResidue.getFluid(1L));
            this.add(MaterialsUEVplus.RawStarMatter.getFluid(1L));
            this.add(MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(1L));
        }
    };
    int ticker = 0;
    private int currentUpgradeID = 0;
    private int currentColorCode = 0;
    private int[] prereqUpgrades = new int[0];
    private int[] followupUpgrades = new int[0];
    private boolean allPrereqRequired = false;
    private boolean isUpradeSplitStart = false;
    private boolean[] upgrades = new boolean[31];

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 31, 34, 0, realBudget, source, actor, false, true);
    }

    public IStructureDefinition<GT_MetaTileEntity_EM_ForgeOfGods> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public GT_MetaTileEntity_EM_ForgeOfGods(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_EM_ForgeOfGods(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_EM_ForgeOfGods(this.mName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ScreenOFF = new Textures.BlockIcons.CustomIcon("iconsets/EM_BHG");
        ScreenON = new Textures.BlockIcons.CustomIcon("iconsets/EM_BHG_ACTIVE");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][12], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? ScreenON : ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][12]};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(STRUCTURE_PIECE_MAIN, 31, 34, 0, stackSize, hintsOnly);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        spacetimeCompressionFieldMetadata = -1;
        this.moduleHatches.clear();
        if (!this.structureCheck_EM(STRUCTURE_PIECE_MAIN, 31, 34, 0)) {
            return false;
        }
        if (this.mInputBusses.size() != 1) {
            return false;
        }
        if (this.mEnergyHatches.size() > 0) {
            return false;
        }
        if (this.mExoticEnergyHatches.size() > 0) {
            return false;
        }
        if (this.mInputHatches.size() != 1) {
            return false;
        }
        this.mHardHammer = true;
        this.mSoftHammer = true;
        this.mScrewdriver = true;
        this.mCrowbar = true;
        this.mSolderingTool = true;
        this.mWrench = true;
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.getBaseMetaTileEntity().isAllowedToWork()) {
                ++this.ticker;
                if (this.ticker % 20 == 0) {
                    this.ticker = 0;
                    FluidStack fluidInHatch = ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get(0)).getFluid();
                    this.fuelConsumption = (long)GodforgeMath.calculateFuelConsumption(this);
                    if (fluidInHatch != null && fluidInHatch.isFluidEqual(this.validFuelList.get(this.selectedFuelType))) {
                        FluidStack fluidNeeded = new FluidStack(this.validFuelList.get(this.selectedFuelType), (int)this.fuelConsumption);
                        FluidStack fluidReal = ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get(0)).drain(fluidNeeded.amount, true);
                        if (fluidReal == null || fluidReal.amount < fluidNeeded.amount) {
                            this.reduceBattery(1);
                        } else {
                            this.increaseBattery(1);
                        }
                    } else {
                        this.reduceBattery(1);
                    }
                    if (this.moduleHatches.size() > 0 && this.internalBattery > 0) {
                        for (GT_MetaTileEntity_EM_BaseModule module : this.moduleHatches) {
                            module.connect();
                            module.setHeat(GodforgeMath.calculateMaxHeatForModules(module, this));
                            module.setSpeedBonus(Float.valueOf(GodforgeMath.calucateSpeedBonusForModules(module, this)));
                            module.setMaxParallel(GodforgeMath.calucateMaxParallelForModules(module, this));
                        }
                    }
                }
            } else if (this.moduleHatches.size() > 0) {
                for (GT_MetaTileEntity_EM_BaseModule module : this.moduleHatches) {
                    module.disconnect();
                }
            }
            if (this.mEfficiency < 0) {
                this.mEfficiency = 0;
            }
            this.fixAllMaintenance();
        }
    }

    public boolean addModuleToMachineList(IGregTechTileEntity tileEntity, int baseCasingIndex) {
        if (tileEntity == null) {
            return false;
        }
        IMetaTileEntity metaTileEntity = tileEntity.getMetaTileEntity();
        if (metaTileEntity == null) {
            return false;
        }
        if (metaTileEntity instanceof GT_MetaTileEntity_EM_BaseModule) {
            return this.moduleHatches.add((GT_MetaTileEntity_EM_BaseModule)metaTileEntity);
        }
        return false;
    }

    private void createRenderBlock() {
        IGregTechTileEntity gregTechTileEntity = this.getBaseMetaTileEntity();
        int x = gregTechTileEntity.getXCoord();
        short y = gregTechTileEntity.getYCoord();
        int z = gregTechTileEntity.getZCoord();
        double xOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        double zOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        double yOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetY;
        this.getBaseMetaTileEntity().getWorld().func_147449_b((int)((double)x + xOffset), (int)((double)y + yOffset), (int)((double)z + zOffset), Blocks.field_150350_a);
        this.getBaseMetaTileEntity().getWorld().func_147449_b((int)((double)x + xOffset), (int)((double)y + yOffset), (int)((double)z + zOffset), TT_Container_Casings.forgeOfGodsRenderBlock);
        TileForgeOfGods rendererTileEntity = (TileForgeOfGods)this.getBaseMetaTileEntity().getWorld().func_147438_o((int)((double)x + xOffset), (int)((double)y + yOffset), (int)((double)z + zOffset));
        rendererTileEntity.setRenderSize(20.0f);
        rendererTileEntity.setRenderRotationSpeed(5.0f);
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> str = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        str.add("Output Buses:" + GT_Utility.formatNumbers((long)this.mOutputBusses.size()));
        str.add("Output Hatches:" + GT_Utility.formatNumbers((long)this.mOutputHatches.size()));
        str.add("Input Buses:" + GT_Utility.formatNumbers((long)this.mInputBusses.size()));
        str.add("Input Hatches:" + GT_Utility.formatNumbers((long)this.mInputHatches.size()));
        str.add("Max Parallel:" + GT_Utility.formatNumbers((double)Math.pow(4.0, spacetimeCompressionFieldMetadata + 1)));
        return str.toArray(new String[0]);
    }

    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.createRenderBlock();
    }

    @Override
    public void onRemoval() {
        if (this.moduleHatches != null && this.moduleHatches.size() > 0) {
            for (GT_MetaTileEntity_EM_BaseModule module : this.moduleHatches) {
                module.disconnect();
            }
        }
        super.onRemoval();
    }

    protected void fixAllMaintenance() {
        this.mWrench = true;
        this.mScrewdriver = true;
        this.mSoftHammer = true;
        this.mHardHammer = true;
        this.mSolderingTool = true;
        this.mCrowbar = true;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.doesBindPlayerInventory()) {
            builder.widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.BACKGROUND_SCREEN_BLUE).setPos(4, 4).setSize(190, 91));
        } else {
            builder.widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.BACKGROUND_SCREEN_BLUE_NO_INVENTORY).setPos(4, 4).setSize(190, 171));
        }
        buildContext.addSyncedWindow(10, this::createUpgradeTreeWindow);
        buildContext.addSyncedWindow(11, this::createIndividualUpgradeWindow);
        buildContext.addSyncedWindow(9, this::createFuelConfigWindow);
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(10);
            }
        }).setSize(16, 16).setBackground(() -> {
            ArrayList<UITexture> button = new ArrayList<UITexture>();
            button.add(TecTechUITextures.BUTTON_CELESTIAL_32x32);
            button.add(TecTechUITextures.OVERLAY_BUTTON_ARROW_BLUE_UP);
            return button.toArray(new IDrawable[0]);
        }).addTooltip("Path of Celestial Transcendence").setPos(174, 167))).widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.PICTURE_HEAT_SINK_SMALL).setPos(174, 183).setSize(16, 6))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(9);
            }
        }).setSize(16, 16).setBackground(() -> {
            ArrayList<UITexture> button = new ArrayList<UITexture>();
            button.add(TecTechUITextures.BUTTON_CELESTIAL_32x32);
            button.add(TecTechUITextures.OVERLAY_BUTTON_HEAT_ON);
            return button.toArray(new IDrawable[0]);
        }).addTooltip(StatCollector.func_74838_a((String)"fog.button.fuelconfig.tooltip")).setPos(174, 129))).widget(TextWidget.dynamicText(this::storedFuel).setDefaultColor(EnumChatFormatting.WHITE).setPos(3, 5).setSize(74, 34));
        ButtonWidget powerSwitchButton = this.createPowerSwitchButton();
        ((ModularWindow.Builder)builder.widget((Widget)powerSwitchButton)).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().isAllowedToWork(), val -> {
            if (val.booleanValue()) {
                this.getBaseMetaTileEntity().enableWorking();
            } else {
                this.getBaseMetaTileEntity().disableWorking();
            }
        }));
    }

    @Override
    protected ButtonWidget createPowerSwitchButton() {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            if (this.getBaseMetaTileEntity().isAllowedToWork()) {
                this.getBaseMetaTileEntity().disableWorking();
            } else {
                this.getBaseMetaTileEntity().enableWorking();
            }
        }).setPlayClickSound(false).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(TecTechUITextures.BUTTON_CELESTIAL_32x32);
            if (this.getBaseMetaTileEntity().isAllowedToWork()) {
                ret.add(TecTechUITextures.OVERLAY_BUTTON_POWER_SWITCH_ON);
            } else {
                ret.add(TecTechUITextures.OVERLAY_BUTTON_POWER_SWITCH_DISABLED);
            }
            return ret.toArray(new IDrawable[0]);
        }).setPos(174, this.doesBindPlayerInventory() ? 148 : 172).setSize(16, 16);
        button.addTooltip("Power Switch").setTooltipShowUpDelay(5);
        return (ButtonWidget)button;
    }

    protected ModularWindow createFuelConfigWindow(EntityPlayer player) {
        int WIDTH = 78;
        int HEIGHT = 130;
        int PARENT_WIDTH = this.getGUIWidth();
        int PARENT_HEIGHT = this.getGUIHeight();
        ModularWindow.Builder builder = ModularWindow.builder((int)78, (int)130);
        builder.setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.setDraggable(true);
        builder.setPos((size, window) -> Alignment.Center.getAlignedPos(size, new Size(PARENT_WIDTH, PARENT_HEIGHT)).add(Alignment.TopRight.getAlignedPos(new Size(PARENT_WIDTH, PARENT_HEIGHT), new Size(78, 130)).add(75, 0)));
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"gt.blockmachines.multimachine.FOG.fuelconsumption", (Object[])new Object[0]).setPos(3, 2).setSize(74, 34))).widget(new NumericWidget().setSetter(val -> {
            this.fuelConsumptionFactor = (int)val;
        }).setGetter(() -> this.fuelConsumptionFactor).setBounds(1.0, (double)GodforgeMath.calculateMaxFuelFactor(this)).setDefaultValue(1.0).setScrollValues(1.0, 4.0, 64.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(70, 18).setPos(3, 35).setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_TEXT_FIELD}))).widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_INFORMATION).setPos(65, 25).setSize(4, 10).addTooltip(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.fuelinfo.0")).addTooltip(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.fuelinfo.1")).addTooltip(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.fuelinfo.2")).addTooltip(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.fuelinfo.3")).addTooltip(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.fuelinfo.4")))).widget(TextWidget.localised((String)"gt.blockmachines.multimachine.FOG.fueltype", (Object[])new Object[0]).setPos(3, 57).setSize(74, 24))).widget(TextWidget.localised((String)"gt.blockmachines.multimachine.FOG.fuelusage", (Object[])new Object[0]).setPos(3, 100).setSize(74, 20))).widget(TextWidget.dynamicText(this::fuelUsage).setPos(3, 115).setSize(74, 15))).widget(new MultiChildWidget().addChild(new FluidNameHolderWidget(() -> MaterialsUEVplus.DimensionallyTranscendentResidue.getFluid(1L).getUnlocalizedName().substring(6), String2 -> MaterialsUEVplus.DimensionallyTranscendentResidue.getFluid(1L).getUnlocalizedName()){

            public void buildTooltip(List<Text> tooltip) {
                FluidStack fluid = this.createFluidStack();
                this.addFluidNameInfo(tooltip, fluid);
                this.addAdditionalFluidInfo(tooltip, fluid);
            }
        }.setPos(1, 1).setSize(16, 16)).addChild(new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            this.selectedFuelType = 0;
        }).setBackground(() -> {
            if (this.selectedFuelType == 0) {
                return new IDrawable[]{TecTechUITextures.SLOT_OUTLINE_GREEN};
            }
            return new IDrawable[0];
        }).setSize(18, 18).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(this::getFuelType, this::setFuelType), (IWidgetBuilder)builder)).setPos(6, 82).setSize(18, 18))).widget(new MultiChildWidget().addChild(new FluidNameHolderWidget(() -> MaterialsUEVplus.RawStarMatter.getFluid(1L).getUnlocalizedName().substring(6), String2 -> MaterialsUEVplus.RawStarMatter.getFluid(1L).getUnlocalizedName()){

            public void buildTooltip(List<Text> tooltip) {
                FluidStack fluid = this.createFluidStack();
                this.addFluidNameInfo(tooltip, fluid);
                this.addAdditionalFluidInfo(tooltip, fluid);
            }
        }.setPos(1, 1).setSize(16, 16)).addChild(new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            this.selectedFuelType = 1;
        }).setBackground(() -> {
            if (this.selectedFuelType == 1) {
                return new IDrawable[]{TecTechUITextures.SLOT_OUTLINE_GREEN};
            }
            return new IDrawable[0];
        }).setSize(18, 18)).setPos(29, 82).setSize(18, 18).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(this::getFuelType, this::setFuelType), (IWidgetBuilder)builder))).widget(new MultiChildWidget().addChild(new FluidNameHolderWidget(() -> MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(1L).getUnlocalizedName().substring(6), String2 -> MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(1L).getUnlocalizedName()){

            public void buildTooltip(List<Text> tooltip) {
                FluidStack fluid = this.createFluidStack();
                this.addFluidNameInfo(tooltip, fluid);
                this.addAdditionalFluidInfo(tooltip, fluid);
            }
        }.setPos(1, 1).setSize(16, 16)).addChild(new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            this.selectedFuelType = 2;
        }).setBackground(() -> {
            if (this.selectedFuelType == 2) {
                return new IDrawable[]{TecTechUITextures.SLOT_OUTLINE_GREEN};
            }
            return new IDrawable[0];
        }).setSize(18, 18)).setPos(52, 82).setSize(18, 18).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(this::getFuelType, this::setFuelType), (IWidgetBuilder)builder));
        return builder.build();
    }

    protected ModularWindow createUpgradeTreeWindow(EntityPlayer player) {
        Scrollable scrollable = new Scrollable().setVerticalScroll();
        int PARENT_WIDTH = 300;
        int PARENT_HEIGHT = 1000;
        ModularWindow.Builder builder = ModularWindow.builder((int)300, (int)1000);
        ((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)scrollable.widget(this.createUpgradeBox(0, 0, new int[0], false, new int[]{1}, false, new Pos2d(126, 56), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(1, 0, new int[]{0}, false, new int[]{2, 3}, false, new Pos2d(126, 116), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(2, 0, new int[]{1}, false, new int[]{4, 5}, false, new Pos2d(96, 176), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(3, 0, new int[]{1}, false, new int[]{5, 6}, false, new Pos2d(156, 176), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(4, 0, new int[]{2}, false, new int[]{8}, false, new Pos2d(66, 236), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(5, 0, new int[]{2, 3}, false, new int[]{7}, false, new Pos2d(126, 236), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(6, 0, new int[]{3}, false, new int[]{10}, false, new Pos2d(186, 236), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(7, 0, new int[]{5}, false, new int[]{8, 9, 10}, false, new Pos2d(126, 296), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(8, 0, new int[]{4, 7}, true, new int[]{11}, false, new Pos2d(56, 356), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(9, 0, new int[]{7}, false, new int[0], false, new Pos2d(126, 356), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(10, 0, new int[]{6, 7}, true, new int[]{11}, false, new Pos2d(196, 356), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(11, 0, new int[]{8, 10}, false, new int[]{12, 13, 14}, false, new Pos2d(126, 416), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(12, 1, new int[]{11}, false, new int[]{17}, true, new Pos2d(66, 476), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(13, 2, new int[]{11}, false, new int[]{18}, true, new Pos2d(126, 476), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(14, 3, new int[]{11}, false, new int[]{15, 19}, true, new Pos2d(186, 476), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(15, 3, new int[]{14}, false, new int[0], false, new Pos2d(246, 496), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(16, 1, new int[]{17}, false, new int[0], false, new Pos2d(6, 556), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(17, 1, new int[]{12}, false, new int[]{16, 20}, false, new Pos2d(66, 536), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(18, 2, new int[]{13}, false, new int[]{21}, false, new Pos2d(126, 536), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(19, 3, new int[]{14}, false, new int[]{22}, false, new Pos2d(186, 536), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(20, 1, new int[]{17}, false, new int[]{23}, false, new Pos2d(66, 596), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(21, 2, new int[]{18}, false, new int[]{23}, false, new Pos2d(126, 596), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(22, 3, new int[]{19}, false, new int[]{23}, false, new Pos2d(186, 596), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(23, 0, new int[]{20, 21, 22}, false, new int[]{24}, false, new Pos2d(126, 656), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(24, 0, new int[]{23}, false, new int[]{25}, false, new Pos2d(126, 718), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(25, 0, new int[]{24}, false, new int[]{26}, false, new Pos2d(36, 758), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(26, 0, new int[]{25}, false, new int[]{27}, false, new Pos2d(36, 848), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(27, 0, new int[]{26}, false, new int[]{28}, false, new Pos2d(126, 888), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(28, 0, new int[]{27}, false, new int[]{29}, false, new Pos2d(216, 848), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(29, 0, new int[]{28}, false, new int[]{30}, false, new Pos2d(216, 758), (IWidgetBuilder<?>)scrollable))).widget(this.createUpgradeBox(30, 0, new int[]{29}, false, new int[0], false, new Pos2d(126, 798), (IWidgetBuilder<?>)scrollable))).widget(new TextWidget("").setPos(0, 1000));
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.BACKGROUND_STAR).setPos(0, 350).setSize(300, 300))).widget(scrollable.setSize(292, 292).setPos(4, 354))).widget(ButtonWidget.closeWindowButton((boolean)true).setPos(282, 354));
        if (this.debugMode.booleanValue()) {
            builder.widget(new MultiChildWidget().addChild(new ButtonWidget().setOnClick((clickData, widget) -> {
                this.upgrades = new boolean[31];
            }).setSize(40, 15).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD}).addTooltip(StatCollector.func_74838_a((String)"fog.debug.resetbutton.tooltip"))).addChild(new TextWidget(StatCollector.func_74838_a((String)"fog.debug.resetbutton.text")).setTextAlignment(Alignment.Center).setScale(0.57f).setMaxWidth(36).setPos(3, 3)).setPos(4, 354));
        }
        return builder.build();
    }

    protected ModularWindow createIndividualUpgradeWindow(EntityPlayer player) {
        UITexture uITexture;
        switch (this.currentColorCode) {
            case 1: {
                uITexture = TecTechUITextures.BACKGROUND_GLOW_PURPLE;
                break;
            }
            case 2: {
                uITexture = TecTechUITextures.BACKGROUND_GLOW_ORANGE;
                break;
            }
            case 3: {
                uITexture = TecTechUITextures.BACKGROUND_GLOW_GREEN;
                break;
            }
            default: {
                uITexture = TecTechUITextures.BACKGROUND_GLOW_BLUE;
            }
        }
        UITexture background = uITexture;
        ModularWindow.Builder builder = (ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)ModularWindow.builder((int)200, (int)200).setBackground(new IDrawable[]{background}).widget(ButtonWidget.closeWindowButton((boolean)true).setPos(185, 3))).widget(new MultiChildWidget().addChild(new TextWidget(StatCollector.func_74838_a((String)("fog.upgrade.text." + this.currentUpgradeID))).setTextAlignment(Alignment.Center).setMaxWidth(185).setDefaultColor(0x9C9C9C).setPos(9, 35)).addChild(new TextWidget(StatCollector.func_74838_a((String)("fog.upgrade.lore." + this.currentUpgradeID))).setTextAlignment(Alignment.Center).setMaxWidth(185).setDefaultColor(0x9C9C9C).setPos(9, 110)).setSize(200, 200))).widget(new MultiChildWidget().addChild(new ButtonWidget().setOnClick((clickData, widget) -> {
            int unlockedPrereqUpgrades = 0;
            int unlockedFollowupUpgrades = 0;
            int unlockedSplitUpgrades = 0;
            if (!this.upgrades[this.currentUpgradeID]) {
                for (int prereqUpgrade : this.prereqUpgrades) {
                    if (!this.upgrades[prereqUpgrade]) continue;
                    ++unlockedPrereqUpgrades;
                }
                if (this.allPrereqRequired) {
                    if (unlockedPrereqUpgrades == this.prereqUpgrades.length) {
                        this.upgrades[this.currentUpgradeID] = true;
                    }
                } else if (unlockedPrereqUpgrades > 0 || this.prereqUpgrades.length == 0) {
                    if (this.isUpradeSplitStart) {
                        for (int splitUpgrade : FIRST_SPLIT_UPGRADES) {
                            if (!this.upgrades[splitUpgrade]) continue;
                            ++unlockedSplitUpgrades;
                        }
                        for (int maxSplitUpgrades : RING_UPGRADES) {
                            if (!this.upgrades[maxSplitUpgrades]) continue;
                            --unlockedSplitUpgrades;
                        }
                    }
                    if (unlockedSplitUpgrades <= 0) {
                        this.upgrades[this.currentUpgradeID] = true;
                    }
                }
            } else {
                for (int followupUpgrade : this.followupUpgrades) {
                    if (!this.upgrades[followupUpgrade]) continue;
                    ++unlockedFollowupUpgrades;
                }
                if (unlockedFollowupUpgrades == 0) {
                    this.upgrades[this.currentUpgradeID] = false;
                }
            }
        }).setSize(40, 15).setBackground(() -> {
            if (this.upgrades[this.currentUpgradeID]) {
                return new IDrawable[]{GT_UITextures.BUTTON_STANDARD_PRESSED};
            }
            return new IDrawable[]{GT_UITextures.BUTTON_STANDARD};
        }).addTooltip(StatCollector.func_74838_a((String)"fog.upgrade.confirm"))).addChild(new TextWidget(StatCollector.func_74838_a((String)"fog.upgrade.confirm")).setTextAlignment(Alignment.Center).setScale(0.7f).setMaxWidth(36).setPos(3, 5)).setPos(79, 177));
        return builder.build();
    }

    private Widget createUpgradeBox(int upgradeID, int colorCode, int[] prerequisiteUpgradeIDs, boolean requireAllPrerequisites, int[] followingUpgradeIDs, boolean isStartOfSplit, Pos2d pos, IWidgetBuilder<?> builder) {
        return new MultiChildWidget().addChild(new ButtonWidget().setOnClick((clickData, widget) -> {
            this.currentUpgradeID = upgradeID;
            this.currentColorCode = colorCode;
            this.prereqUpgrades = prerequisiteUpgradeIDs;
            this.allPrereqRequired = requireAllPrerequisites;
            this.followupUpgrades = followingUpgradeIDs;
            this.isUpradeSplitStart = isStartOfSplit;
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(11);
            }
        }).setSize(40, 15).setBackground(() -> {
            if (this.upgrades[upgradeID]) {
                return new IDrawable[]{GT_UITextures.BUTTON_STANDARD_PRESSED};
            }
            return new IDrawable[]{GT_UITextures.BUTTON_STANDARD};
        }).addTooltip(StatCollector.func_74838_a((String)("fog.upgrade.tt." + upgradeID)))).addChild(new TextWidget(StatCollector.func_74838_a((String)("fog.upgrade.tt." + upgradeID))).setTextAlignment(Alignment.Center).setScale(0.57f).setMaxWidth(36).setPos(3, 3)).setPos(pos).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> this.upgrades[upgradeID], val -> {
            this.upgrades[upgradeID] = val;
        }), builder);
    }

    @Override
    public GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Material Manipulator").addInfo("Controller block for the Forge of Gods").addInfo("Uses a Star to to manipulate metals").addSeparator().beginStructureBlock(1, 4, 2, false).addStructureInfo("Output bus/hatch has to be the ME variant").addStructureInfo("Dot 2 of Input Hatch is the Fuel Input Hatch").addInputHatch("Any Infinite Spacetime Casing", new int[]{1}).addInputHatch("Any Infinite Spacetime Casing", new int[]{2}).addInputBus("Any Infinite Spacetime Casing", new int[]{1}).addOutputBus("Any Infinite Spacetime Casing", new int[]{1}).addOutputHatch("Any Infinite Spacetime Casing", new int[]{1}).toolTipFinisher(CommonValues.GODFORGE_MARK);
        return tt;
    }

    @Override
    public boolean energyFlowOnRunningTick(ItemStack aStack, boolean allowProduction) {
        return true;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return new String[]{"Forge of Gods multiblock"};
    }

    public Integer getFuelType() {
        return this.selectedFuelType;
    }

    private void setFuelType(Integer fuelType) {
        this.selectedFuelType = fuelType;
    }

    public Integer getFuelFactor() {
        return this.fuelConsumptionFactor;
    }

    public Boolean isUpgradeActive(Integer upgradeID) {
        return this.upgrades[upgradeID];
    }

    public Integer getTotalActiveUpgrades() {
        int totalUpgrades = 0;
        for (boolean upgrade : this.upgrades) {
            if (!upgrade) continue;
            ++totalUpgrades;
        }
        return totalUpgrades;
    }

    private Text fuelUsage() {
        return new Text(this.fuelConsumption + " L/s");
    }

    private Text storedFuel() {
        return new Text(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.storedfuel") + " " + this.internalBattery + "/100");
    }

    private void increaseBattery(Integer amount) {
        if (this.internalBattery + amount <= 100) {
            this.internalBattery += amount.intValue();
        }
    }

    private void reduceBattery(Integer amount) {
        this.internalBattery -= amount.intValue();
        if (this.internalBattery <= 0) {
            this.internalBattery = 0;
            if (this.moduleHatches.size() > 0) {
                for (GT_MetaTileEntity_EM_BaseModule module : this.moduleHatches) {
                    module.disconnect();
                }
            }
        }
    }

    protected void setHatchRecipeMap(GT_MetaTileEntity_Hatch_Input hatch) {
    }

    @Override
    public void saveNBTData(NBTTagCompound NBT2) {
        NBT2.func_74768_a("spacetimeCompressionTier", spacetimeCompressionFieldMetadata + 1);
        NBT2.func_74768_a("solenoidCoilTier", this.solenoidCoilMetadata - 7);
        NBT2.func_74768_a("selectedFuelType", this.selectedFuelType);
        NBT2.func_74768_a("fuelConsumptionFactor", this.fuelConsumptionFactor);
        NBT2.func_74768_a("internalBattery", this.internalBattery);
        NBTTagCompound upgradeBooleanArrayNBTTag = new NBTTagCompound();
        int upgradeIndex = 0;
        boolean[] blArray = this.upgrades;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            Boolean upgrade = blArray[i];
            upgradeBooleanArrayNBTTag.func_74757_a("upgrade" + upgradeIndex, upgrade.booleanValue());
            ++upgradeIndex;
        }
        NBT2.func_74782_a("upgrades", (NBTBase)upgradeBooleanArrayNBTTag);
        super.saveNBTData(NBT2);
    }

    @Override
    public void loadNBTData(NBTTagCompound NBT2) {
        spacetimeCompressionFieldMetadata = NBT2.func_74762_e("spacetimeCompressionTier") - 1;
        this.solenoidCoilMetadata = NBT2.func_74762_e("solenoidCoilTier") + 7;
        this.selectedFuelType = NBT2.func_74762_e("selectedFuelType");
        this.fuelConsumptionFactor = NBT2.func_74762_e("fuelConsumptionFactor");
        this.internalBattery = NBT2.func_74762_e("internalBattery");
        NBTTagCompound tempBooleanTag = NBT2.func_74775_l("upgrades");
        for (int upgradeIndex = 0; upgradeIndex < 31; ++upgradeIndex) {
            boolean upgrade;
            this.upgrades[upgradeIndex] = upgrade = tempBooleanTag.func_74767_n("upgrade" + upgradeIndex);
        }
        super.loadNBTData(NBT2);
    }

    static {
        spacetimeCompressionFieldMetadata = -1;
        FIRST_SPLIT_UPGRADES = new int[]{12, 13, 14};
        RING_UPGRADES = new int[]{26, 29};
        STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])ForgeofGodsStructureString.godForge)).addElement('A', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_EM_ForgeOfGods.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus}).casingIndex(1024).dot(1).buildAndChain(TT_Container_Casings.sBlockCasingsBA0, 12)).addElement('B', StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)11)).addElement('C', StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)12)).addElement('D', StructureUtility.ofBlocksTiered((block, meta) -> block == GregTech_API.sSolenoidCoilCasings ? meta : -1, (List)ImmutableList.of((Object)Pair.of((Object)GregTech_API.sSolenoidCoilCasings, (Object)7), (Object)Pair.of((Object)GregTech_API.sSolenoidCoilCasings, (Object)8), (Object)Pair.of((Object)GregTech_API.sSolenoidCoilCasings, (Object)9), (Object)Pair.of((Object)GregTech_API.sSolenoidCoilCasings, (Object)10)), (Object)-1, (t, meta) -> {
            t.solenoidCoilMetadata = meta;
        }, t -> t.solenoidCoilMetadata)).addElement('E', StructureUtility.ofBlocksTiered((block, meta) -> block == TT_Container_Casings.SpacetimeCompressionFieldGenerators ? meta : -1, (List)ImmutableList.of((Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)0), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)1), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)2), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)3), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)4), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)5), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)6), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)7), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)8)), (Object)-1, (t, meta) -> {
            spacetimeCompressionFieldMetadata = meta;
        }, t -> spacetimeCompressionFieldMetadata)).addElement('F', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_EM_ForgeOfGods.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch}).casingIndex(1024).dot(2).buildAndChain(TT_Container_Casings.sBlockCasingsBA0, 12)).addElement('G', (IStructureElement)GT_HatchElementBuilder.builder().atLeast(new IHatchElement[]{moduleElement.Module}).casingIndex(1024).dot(3).buildAndChain(TT_Container_Casings.sBlockCasingsBA0, 12)).build();
    }

    public static enum moduleElement implements IHatchElement<GT_MetaTileEntity_EM_ForgeOfGods>
    {
        Module(GT_MetaTileEntity_EM_ForgeOfGods::addModuleToMachineList, new Class[]{GT_MetaTileEntity_EM_BaseModule.class}){

            public long count(GT_MetaTileEntity_EM_ForgeOfGods tileEntity) {
                return tileEntity.moduleHatches.size();
            }
        };

        private final List<Class<? extends IMetaTileEntity>> mteClasses;
        private final IGT_HatchAdder<GT_MetaTileEntity_EM_ForgeOfGods> adder;

        @SafeVarargs
        private moduleElement(IGT_HatchAdder<GT_MetaTileEntity_EM_ForgeOfGods> adder, Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Collections.unmodifiableList(Arrays.asList(mteClasses));
            this.adder = adder;
        }

        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        public IGT_HatchAdder<? super GT_MetaTileEntity_EM_ForgeOfGods> adder() {
            return this.adder;
        }
    }
}

