/*
 * Decompiled with CFR 0.152.
 */
package serverutils.aurora.tag;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.util.EnumChatFormatting;
import serverutils.aurora.tag.PairedTag;
import serverutils.aurora.tag.Style;
import serverutils.aurora.tag.TagBase;
import serverutils.aurora.tag.TextTag;
import serverutils.aurora.tag.UnpairedTag;

public abstract class Tag
extends TagBase {
    public final String name;
    protected Map<String, String> attributes;

    public static String fixHTML(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public Tag(String n) {
        this.name = n;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String getAttribute(String key) {
        return this.attributes == null || this.attributes.isEmpty() ? "" : this.attributes.getOrDefault(key, "");
    }

    public Tag attr(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, String>();
        }
        this.attributes.put(key, value);
        return this;
    }

    public Tag title(String title) {
        return this.attr("title", title);
    }

    public Tag title(Iterable<String> title) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String t : title) {
            String s = EnumChatFormatting.func_110646_a((String)t);
            if (first) {
                first = false;
            } else {
                sb.append('\n');
            }
            sb.append(s);
            sb.append(' ');
        }
        return this.title(sb.toString());
    }

    public Style style() {
        Style style = new Style();
        this.append(style);
        return style;
    }

    public Tag style(String key, String value) {
        this.attr("style", this.getAttribute("style") + key + ':' + value + ';');
        return this;
    }

    public Tag id(String id) {
        return this.attr("id", id);
    }

    public Tag meta(String name, String content) {
        return this.unpaired("meta").attr("name", name).attr("content", content);
    }

    public Tag addClass(String c) {
        if (c.isEmpty()) {
            return this;
        }
        String s = this.getAttribute("class");
        this.attr("class", s.isEmpty() ? c : s + " " + c);
        return this;
    }

    public <T extends TagBase> T append(T child) {
        return child;
    }

    public Tag text(Object txt) {
        String text = String.valueOf(txt);
        if (!text.isEmpty()) {
            this.append(new TextTag(text));
        }
        return this;
    }

    public Tag paired(String tag, String text) {
        return this.append(new PairedTag(tag, text));
    }

    public Tag paired(String tag) {
        return this.paired(tag, "");
    }

    public Tag unpaired(String tag) {
        return this.append(new UnpairedTag(tag));
    }

    public Tag h1(String text) {
        return this.paired("h1", text);
    }

    public Tag h2(String text) {
        return this.paired("h2", text);
    }

    public Tag h3(String text) {
        return this.paired("h3", text);
    }

    public Tag p(String text) {
        return this.paired("p", text);
    }

    public Tag p() {
        return this.p("");
    }

    public Tag a(String text, String url) {
        return this.paired("a", text).attr("href", url);
    }

    public Tag img(String img) {
        return this.unpaired("img").attr("src", img);
    }

    public Tag span(String text) {
        return this.paired("span", text);
    }

    public Tag span(String text, String c) {
        return this.span(text).addClass(c);
    }

    public Tag br() {
        return this.unpaired("br");
    }

    public Tag ul() {
        return this.paired("ul");
    }

    public Tag ol() {
        return this.paired("ol");
    }

    public Tag li() {
        return this.paired("li");
    }

    public Tag table() {
        return this.paired("table");
    }

    public Tag tr() {
        return this.paired("tr");
    }

    public Tag th() {
        return this.paired("th");
    }

    public Tag td() {
        return this.paired("td");
    }

    public Tag tooltip() {
        this.addClass("tooltip");
        Tag div = this.paired("div");
        div.addClass("tooltiptext");
        return div;
    }

    public Tag tooltip(String text) {
        this.tooltip().text(text);
        return this;
    }

    public Tag icon(String name) {
        return this.img("https://aurora.latvian.dev/icons/" + name + ".png").addClass("icon");
    }

    public Tag yesNoSpan(boolean value) {
        return this.span(value ? "Yes" : "No", value ? "yes" : "no");
    }
}

