/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.helpers;

import cpw.mods.fml.common.FMLCommonHandler;
import mcp.mobius.opis.data.holders.basetypes.CoordinatesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class Teleport {
    private static Teleport _instance = new Teleport();

    public static Teleport instance() {
        return _instance;
    }

    public boolean movePlayerToDimension(EntityPlayerMP player, int dim) {
        return this.transferPlayerToDimension(player.field_71133_b.func_71203_ab(), player, dim);
    }

    public boolean transferPlayerToDimension(ServerConfigurationManager manager, EntityPlayerMP player, int targetID) {
        int sourceID = player.field_71093_bK;
        WorldServer sourceWorld = DimensionManager.getWorld((int)player.field_71093_bK);
        WorldServer targetWorld = DimensionManager.getWorld((int)targetID);
        if (sourceID == targetID) {
            return true;
        }
        if (sourceWorld == null || targetWorld == null) {
            return false;
        }
        player.field_71093_bK = targetID;
        player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        sourceWorld.func_72973_f((Entity)player);
        player.field_70128_L = false;
        this.transferEntityToWorld((Entity)player, sourceID, sourceWorld, targetWorld);
        this.preloadChunk(player, sourceWorld);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(targetWorld);
        manager.func_72354_b(player, targetWorld);
        manager.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, sourceID, targetID);
        return true;
    }

    public void preloadChunk(EntityPlayerMP player, WorldServer sourceWorld) {
        WorldServer otherWorld = player.func_71121_q();
        if (sourceWorld != null) {
            sourceWorld.func_73040_p().func_72695_c(player);
        }
        otherWorld.func_73040_p().func_72683_a(player);
        otherWorld.field_73059_b.func_73158_c((int)player.field_70165_t >> 4, (int)player.field_70161_v >> 4);
    }

    public void transferEntityToWorld(Entity ent, int dim, WorldServer srcWorld, WorldServer trgWorld) {
        WorldProvider pOld = srcWorld.field_73011_w;
        WorldProvider pNew = trgWorld.field_73011_w;
        double moveFactor = pOld.getMovementFactor() / pNew.getMovementFactor();
        double d0 = ent.field_70165_t * moveFactor;
        double d1 = ent.field_70161_v * moveFactor;
        double d3 = ent.field_70165_t;
        double d4 = ent.field_70163_u;
        double d5 = ent.field_70161_v;
        float f = ent.field_70177_z;
        srcWorld.field_72984_F.func_76320_a("placing");
        d0 = MathHelper.func_76125_a((int)((int)d0), (int)-29999872, (int)29999872);
        d1 = MathHelper.func_76125_a((int)((int)d1), (int)-29999872, (int)29999872);
        if (ent.func_70089_S()) {
            trgWorld.func_72838_d(ent);
            ent.func_70012_b(d0, ent.field_70163_u, d1, ent.field_70177_z, ent.field_70125_A);
            trgWorld.func_72866_a(ent, false);
        }
        ent.func_70029_a((World)trgWorld);
    }

    public boolean moveEntityToDimension(Entity target, int targetID) {
        if (!target.field_70170_p.field_72995_K && !target.field_70128_L) {
            MinecraftServer server = MinecraftServer.func_71276_C();
            int sourceID = target.field_71093_bK;
            WorldServer sourceWorld = DimensionManager.getWorld((int)sourceID);
            WorldServer targetWorld = DimensionManager.getWorld((int)targetID);
            if (sourceID == targetID) {
                return true;
            }
            if (sourceWorld == null || targetWorld == null) {
                return false;
            }
            target.field_71093_bK = targetID;
            target.field_70170_p.func_72900_e(target);
            target.field_70128_L = false;
            this.transferEntityToWorld(target, sourceID, sourceWorld, targetWorld);
            Entity entity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)target), (World)targetWorld);
            if (entity != null) {
                entity.func_82141_a(target, true);
                targetWorld.func_72838_d(entity);
            }
            target.field_70128_L = true;
            sourceWorld.func_82742_i();
            targetWorld.func_82742_i();
        }
        return true;
    }

    public CoordinatesBlock getTeleportTarget(CoordinatesBlock coord) {
        WorldServer world = DimensionManager.getWorld((int)coord.dim);
        if (world == null) {
            return null;
        }
        int maxOffset = 16;
        boolean targetFound = false;
        if (coord.y > 0) {
            for (int xoffset = 0; xoffset <= maxOffset; ++xoffset) {
                for (int zoffset = 0; zoffset <= maxOffset; ++zoffset) {
                    if (world.func_147437_c(coord.x + xoffset, coord.y, coord.z + zoffset) && world.func_147437_c(coord.x + xoffset, coord.y + 1, coord.z + zoffset) && !world.func_147437_c(coord.x + xoffset, coord.y - 1, coord.z + zoffset)) {
                        return new CoordinatesBlock(coord.dim, coord.x + xoffset, coord.y, coord.z + zoffset);
                    }
                    if (world.func_147437_c(coord.x - xoffset, coord.y, coord.z + zoffset) && world.func_147437_c(coord.x - xoffset, coord.y + 1, coord.z + zoffset) && !world.func_147437_c(coord.x - xoffset, coord.y - 1, coord.z + zoffset)) {
                        return new CoordinatesBlock(coord.dim, coord.x - xoffset, coord.y, coord.z + zoffset);
                    }
                    if (world.func_147437_c(coord.x + xoffset, coord.y, coord.z - zoffset) && world.func_147437_c(coord.x + xoffset, coord.y + 1, coord.z - zoffset) && !world.func_147437_c(coord.x + xoffset, coord.y - 1, coord.z - zoffset)) {
                        return new CoordinatesBlock(coord.dim, coord.x + xoffset, coord.y, coord.z - zoffset);
                    }
                    if (!world.func_147437_c(coord.x - xoffset, coord.y, coord.z - zoffset) || !world.func_147437_c(coord.x - xoffset, coord.y + 1, coord.z - zoffset) || world.func_147437_c(coord.x - xoffset, coord.y - 1, coord.z - zoffset)) continue;
                    return new CoordinatesBlock(coord.dim, coord.x - xoffset, coord.y, coord.z - zoffset);
                }
            }
        } else {
            int y = 256;
            while (world.func_147437_c(coord.x, y, coord.z) || world.func_147439_a(coord.x, y, coord.z) == Blocks.field_150395_bd) {
                --y;
            }
            for (int xoffset = 0; xoffset <= maxOffset; ++xoffset) {
                for (int zoffset = 0; zoffset <= maxOffset; ++zoffset) {
                    if (world.func_147437_c(coord.x + xoffset, y, coord.z + zoffset) && world.func_147437_c(coord.x + xoffset, y + 1, coord.z + zoffset)) {
                        return new CoordinatesBlock(coord.dim, coord.x + xoffset, y, coord.z + zoffset);
                    }
                    if (world.func_147437_c(coord.x - xoffset, y, coord.z + zoffset) && world.func_147437_c(coord.x - xoffset, y + 1, coord.z + zoffset)) {
                        return new CoordinatesBlock(coord.dim, coord.x - xoffset, y, coord.z + zoffset);
                    }
                    if (world.func_147437_c(coord.x + xoffset, y, coord.z - zoffset) && world.func_147437_c(coord.x + xoffset, y + 1, coord.z - zoffset)) {
                        return new CoordinatesBlock(coord.dim, coord.x + xoffset, y, coord.z - zoffset);
                    }
                    if (!world.func_147437_c(coord.x - xoffset, y, coord.z - zoffset) || !world.func_147437_c(coord.x - xoffset, y + 1, coord.z - zoffset)) continue;
                    return new CoordinatesBlock(coord.dim, coord.x - xoffset, y, coord.z - zoffset);
                }
            }
        }
        return null;
    }

    public CoordinatesBlock fixNetherTP(CoordinatesBlock target) {
        CoordinatesBlock finalTarget;
        WorldServer targetWorld = DimensionManager.getWorld((int)target.dim);
        boolean isBedrock = targetWorld.func_147439_a(target.x, target.y - 1, target.z) == Blocks.field_150357_h;
        boolean canTeleport = false;
        if (target.y > 64 && isBedrock) {
            int tempY;
            for (tempY = target.y - 1; tempY > 1; --tempY) {
                if (!targetWorld.func_147437_c(target.x, tempY, target.z) || !targetWorld.func_147437_c(target.x, tempY - 1, target.z)) continue;
                canTeleport = true;
                while (targetWorld.func_147437_c(target.x, tempY, target.z)) {
                    --tempY;
                }
                break;
            }
            finalTarget = new CoordinatesBlock(target.dim, target.x, tempY + 1, target.z);
        } else {
            canTeleport = true;
            finalTarget = target;
        }
        if (canTeleport) {
            return finalTarget;
        }
        return null;
    }
}

