/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.io.IOException;
import lumien.randomthings.Blocks.ModBlocks;
import lumien.randomthings.Client.GuiHandler;
import lumien.randomthings.Configuration.RTConfiguration;
import lumien.randomthings.Configuration.Settings;
import lumien.randomthings.Core.Commands.ExitSpectreCommand;
import lumien.randomthings.Core.Commands.RTCommand;
import lumien.randomthings.Core.RTCreativeTab;
import lumien.randomthings.Entity.ModEntitys;
import lumien.randomthings.Handler.BackgroundHandler;
import lumien.randomthings.Handler.LetterHandler;
import lumien.randomthings.Handler.MagneticForceHandler;
import lumien.randomthings.Handler.ModCompHandler;
import lumien.randomthings.Handler.Notifications.NotificationHandler;
import lumien.randomthings.Handler.PeripheralProvider;
import lumien.randomthings.Handler.RTEventHandler;
import lumien.randomthings.Handler.RTTickHandler;
import lumien.randomthings.Handler.SoundRecorderHandler;
import lumien.randomthings.Handler.Spectre.SpectreHandler;
import lumien.randomthings.Handler.Spectre.WorldProviderSpectre;
import lumien.randomthings.Items.ItemBiomeCapsule;
import lumien.randomthings.Items.ModItems;
import lumien.randomthings.Library.Recipes;
import lumien.randomthings.Network.PacketHandler;
import lumien.randomthings.Potions.ModPotions;
import lumien.randomthings.Proxy.CommonProxy;
import lumien.randomthings.TileEntities.ModTileEntities;
import net.minecraft.command.ICommand;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="RandomThings", name="RandomThings", version="2.6.1", guiFactory="lumien.randomthings.Client.Config.RandomThingsGuiFactory")
public class RandomThings {
    @Mod.Instance(value="RandomThings")
    public static RandomThings instance;
    public static final String AUTHOR_USERNAME = "XxsumsumxX";
    @SidedProxy(clientSide="lumien.randomthings.Proxy.ClientProxy", serverSide="lumien.randomthings.Proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final RTCreativeTab creativeTab;
    public Logger logger;
    public SpectreHandler spectreHandler;
    File nbtFile;
    public NBTTagCompound modNBT;
    public LetterHandler letterHandler;
    public NotificationHandler notificationHandler;
    public SoundRecorderHandler soundRecorderHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        RTConfiguration.init(event);
        RTConfiguration.syncConfig();
        ModItems.init();
        ModBlocks.init();
        ModTileEntities.init();
        ModEntitys.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        FMLCommonHandler.instance().bus().register((Object)new RTTickHandler());
        RTEventHandler rte = new RTEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)rte);
        FMLCommonHandler.instance().bus().register((Object)rte);
        proxy.registerTickHandler();
        if (event.getSide().isClient()) {
            this.notificationHandler = new NotificationHandler();
            BackgroundHandler.setRandomBackground();
            this.soundRecorderHandler = new SoundRecorderHandler();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PacketHandler.init();
        proxy.registerRenderers();
        if (Settings.SPECTRE_DIMENSON_ID == -1) {
            int dimensionID = DimensionManager.getNextFreeDimId();
            this.logger.log(Level.INFO, "Auto Resolved Spectre Dimension ID to " + dimensionID);
            RTConfiguration.spectreDimensionID.set(dimensionID);
            RTConfiguration.syncConfig();
        }
        DimensionManager.registerProviderType((int)Settings.SPECTRE_DIMENSON_ID, WorldProviderSpectre.class, (boolean)true);
        DimensionManager.registerDimension((int)Settings.SPECTRE_DIMENSON_ID, (int)Settings.SPECTRE_DIMENSON_ID);
        Recipes.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        try {
            PeripheralProvider.register();
        }
        catch (Exception e) {
            this.logger.log(Level.WARN, "Couldn't reflect on cc, no cc peripheral support for CreativePlayerInterface and OnlineDetector and Notification Interface");
            e.printStackTrace();
        }
        ModPotions.init();
        ModCompHandler.postInit();
    }

    public boolean canBeDeactivated() {
        return false;
    }

    public void saveNBT() {
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)this.modNBT, (File)this.nbtFile);
        }
        catch (IOException e) {
            ChatComponentTranslation cct = new ChatComponentTranslation("text.error.nbt", new Object[0]);
            this.logger.log(Level.WARN, cct.func_150260_c());
            e.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        this.initializeModNBT();
        this.letterHandler = new LetterHandler();
        this.letterHandler.readFromNBT();
        MagneticForceHandler.INSTANCE.readFromNBT(this.modNBT);
        event.registerServerCommand((ICommand)new RTCommand());
        event.registerServerCommand((ICommand)new ExitSpectreCommand());
    }

    @Mod.EventHandler
    public void imcMessages(FMLInterModComms.IMCEvent event) {
        ImmutableList messages = event.getMessages();
        if (messages.size() > 0) {
            for (FMLInterModComms.IMCMessage m : messages) {
                String action = m.key;
                if (!action.equals("setSolutionColor")) continue;
                NBTTagCompound nbt = m.getNBTValue();
                int biomeID = nbt.func_74762_e("biomeID");
                int color = nbt.func_74762_e("color");
                ItemBiomeCapsule.biomeColors.put(biomeID, color);
            }
        }
    }

    private void initializeModNBT() {
        this.nbtFile = new File(DimensionManager.getCurrentSaveRootDirectory(), "RandomThings.dat");
        if (!this.nbtFile.exists()) {
            this.logger.log(Level.INFO, "Creating NBT File");
            try {
                this.nbtFile.createNewFile();
                CompressedStreamTools.func_74795_b((NBTTagCompound)new NBTTagCompound(), (File)this.nbtFile);
                this.modNBT = CompressedStreamTools.func_74797_a((File)this.nbtFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.modNBT = CompressedStreamTools.func_74797_a((File)this.nbtFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.modNBT == null) {
            ChatComponentTranslation cct = new ChatComponentTranslation("text.error.nbt", new Object[0]);
            this.logger.log(Level.WARN, cct.func_150260_c());
            this.modNBT = new NBTTagCompound();
        }
    }

    static {
        creativeTab = new RTCreativeTab();
    }
}

