/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import com.google.common.collect.Lists;
import ganymedes01.etfuturum.blocks.BaseBlock;
import ganymedes01.etfuturum.core.utils.IInitAction;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.lib.RenderIDs;
import ganymedes01.etfuturum.recipes.ModRecipes;
import ganymedes01.etfuturum.world.EtFuturumWorldListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBubbleColumn
extends BaseBlock
implements IInitAction {
    public IIcon[] inner_icons;
    public IIcon[] outer_icons;
    public IIcon[] top_icons;
    public final List<Block> supportBlocks = Lists.newArrayList();
    protected final boolean isUp;
    public ThreadLocal<Boolean> renderingInner = ThreadLocal.withInitial(() -> false);

    public BlockBubbleColumn(boolean up, Block ... blocks) {
        super(Material.field_151586_h);
        this.supportBlocks.addAll(Arrays.asList(blocks));
        this.isUp = up;
        this.func_149713_g(Blocks.field_150355_j.func_149717_k());
        this.func_149663_c("bubble_column_" + (up ? "up" : "down"));
        this.func_149658_d("bubble_column");
        this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    protected int innerIconCount() {
        return 1;
    }

    protected int outerIconCount() {
        return 4;
    }

    protected int topIconCount() {
        return 4;
    }

    public void func_149651_a(IIconRegister reg) {
        int largest = Collections.max(Arrays.asList(this.innerIconCount(), this.outerIconCount(), this.topIconCount()));
        this.inner_icons = new IIcon[this.innerIconCount()];
        this.outer_icons = new IIcon[this.outerIconCount()];
        this.top_icons = new IIcon[this.topIconCount()];
        int i = 0;
        for (char a = 'a'; i < largest && a < 'z'; a = (char)((char)(a + 1)), ++i) {
            if (i < this.innerIconCount()) {
                this.inner_icons[i] = reg.func_94245_a(this.func_149641_N() + "_inner_" + (char)(a + (this.isUp ? 0 : this.innerIconCount())));
            }
            if (i < this.outerIconCount()) {
                this.outer_icons[i] = reg.func_94245_a(this.func_149641_N() + "_outer_" + (char)(a + (this.isUp ? 0 : this.outerIconCount())));
            }
            if (i >= this.topIconCount()) continue;
            this.top_icons[i] = reg.func_94245_a(this.func_149641_N() + "_" + (this.isUp ? "up" : "down") + "_top_" + a);
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.outer_icons[0];
    }

    public IIcon func_149673_e(IBlockAccess worldIn, int x, int y, int z, int side) {
        int pseudoRand = (int)Utils.cantor(x, z);
        if (side < 2) {
            return this.top_icons[pseudoRand % this.top_icons.length];
        }
        return this.renderingInner.get() != false ? this.inner_icons[pseudoRand % this.inner_icons.length] : this.outer_icons[pseudoRand % this.outer_icons.length];
    }

    public void func_149734_b(World worldIn, int x, int y, int z, Random random) {
        super.func_149734_b(worldIn, x, y, z, random);
        if (random.nextInt(256) == 0) {
            worldIn.func_72980_b((double)((float)x + random.nextFloat()), (double)((float)y + random.nextFloat()), (double)((float)z + random.nextFloat()), this.getBubblingNoise(worldIn, x, y, z, random), 1.0f, 1.0f, false);
        }
    }

    public void func_149670_a(World worldIn, int x, int y, int z, Entity entityIn) {
        if (entityIn instanceof EntityFX) {
            return;
        }
        Block blockAbove = worldIn.func_147439_a(x, y + 1, z);
        if (blockAbove == Blocks.field_150350_a) {
            entityIn.field_70181_x = this.isUp ? Math.min(1.8, entityIn.field_70181_x + 0.1) : Math.max(-0.9, entityIn.field_70181_x - 0.03);
            if (worldIn.field_72995_K) {
                for (int i = 0; i < 2; ++i) {
                    worldIn.func_72869_a("splash", (double)x + worldIn.field_73012_v.nextDouble(), (double)(y + 1), (double)z + worldIn.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
                    worldIn.func_72869_a("bubble", (double)x + worldIn.field_73012_v.nextDouble(), (double)(y + 1), (double)z + worldIn.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
                }
            }
        } else {
            entityIn.field_70181_x = this.isUp ? Math.min(0.7, entityIn.field_70181_x + 0.6) : Math.max(-0.3, entityIn.field_70181_x - 0.3);
            entityIn.field_70143_R = 0.0f;
        }
    }

    protected String getBubblingNoise(World world, int x, int y, int z, Random random) {
        return "minecraft_1.21:block.bubble_column." + (this.isUp ? "upwards" : "whirlpool") + "_ambient";
    }

    public AxisAlignedBB func_149633_g(World worldIn, int x, int y, int z) {
        return null;
    }

    public AxisAlignedBB func_149668_a(World worldIn, int x, int y, int z) {
        return null;
    }

    public void func_149726_b(World worldIn, int x, int y, int z) {
        this.manageColumn(worldIn, x, y, z);
    }

    public void func_149695_a(World worldIn, int x, int y, int z, Block neighbor) {
        this.manageColumn(worldIn, x, y, z);
    }

    protected void manageColumn(World world, int x, int y, int z) {
        Block below = world.func_147439_a(x, y - 1, z);
        if (below != this && !this.supportBlocks.contains(below)) {
            world.func_147449_b(x, y, z, Blocks.field_150355_j);
        } else if (BlockBubbleColumn.isFullVanillaWater(world.func_147439_a(x, y + 1, z), world.func_72805_g(x, y + 1, z))) {
            world.func_147465_d(x, y + 1, z, (Block)this, 0, 3);
        }
    }

    public static boolean isFullVanillaWater(Block block, int meta) {
        return meta == 0 && (block == Blocks.field_150355_j || block == Blocks.field_150358_i);
    }

    public boolean canRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public int func_149701_w() {
        return 1;
    }

    public int func_149645_b() {
        return RenderIDs.BUBBLE_COLUMN;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public void postInitAction() {
        if (ModRecipes.validateItems(this)) {
            this.supportBlocks.stream().filter(xva$0 -> ModRecipes.validateItems(xva$0)).forEach(block -> EtFuturumWorldListener.bubbleColumnMap.put((Block)block, this));
        }
    }

    public Item func_149694_d(World worldIn, int x, int y, int z) {
        return Item.func_150898_a((Block)Blocks.field_150355_j);
    }
}

