/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.items.BaseSubtypesItem;
import ganymedes01.etfuturum.lib.RenderIDs;
import ganymedes01.etfuturum.tileentities.TileEntityBarrel;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class BlockBarrel
extends BlockContainer {
    private final TileEntityBarrel.BarrelType type;
    private IIcon innerTopIcon;
    private IIcon bottomIcon;
    private IIcon topIcon;
    private final Random rand = new Random();

    public BlockBarrel() {
        this(TileEntityBarrel.BarrelType.VANILLA);
    }

    public BlockBarrel(TileEntityBarrel.BarrelType type) {
        super(type == TileEntityBarrel.BarrelType.VANILLA ? Material.field_151575_d : Material.field_151573_f);
        this.type = type;
        if (type == TileEntityBarrel.BarrelType.VANILLA) {
            this.func_149672_a(field_149766_f);
            this.setHarvestLevel("axe", 0);
            this.func_149663_c(Utils.getUnlocalisedName("barrel"));
        } else {
            this.func_149672_a(field_149777_j);
            this.setHarvestLevel("pickaxe", 1);
            this.func_149663_c(Utils.getUnlocalisedName(type.name().toLowerCase() + "_barrel"));
        }
        this.func_149711_c(2.5f);
        this.func_149752_b(2.5f);
        this.func_149658_d("barrel");
        this.field_149783_u = true;
        this.func_149713_g(500);
        this.func_149647_a(EtFuturum.creativeTabBlocks);
    }

    public int func_149645_b() {
        return RenderIDs.BARREL;
    }

    public IIcon func_149691_a(int side, int meta) {
        int k = BlockPistonBase.func_150076_b((int)meta);
        return k > 5 ? (meta > 7 ? this.innerTopIcon : this.topIcon) : (side == k ? (meta > 7 ? this.innerTopIcon : this.topIcon) : (side == Facing.field_71588_a[k] ? this.bottomIcon : this.field_149761_L));
    }

    public void func_149689_a(World worldIn, int x, int y, int z, EntityLivingBase placer, ItemStack itemIn) {
        TileEntityBarrel box = (TileEntityBarrel)worldIn.func_147438_o(x, y, z);
        if (itemIn.func_77942_o() && itemIn.func_82837_s()) {
            box.setCustomName(itemIn.func_82833_r());
        }
        int l = BlockPistonBase.func_150071_a((World)worldIn, (int)x, (int)y, (int)z, (EntityLivingBase)placer);
        worldIn.func_72921_c(x, y, z, l, 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister i) {
        if (this.type == TileEntityBarrel.BarrelType.VANILLA) {
            this.field_149761_L = i.func_94245_a(this.func_149641_N() + "_side");
            this.topIcon = i.func_94245_a(this.func_149641_N() + "_top");
            this.innerTopIcon = i.func_94245_a(this.func_149641_N() + "_top_open");
            this.bottomIcon = i.func_94245_a(this.func_149641_N() + "_bottom");
        } else {
            this.field_149761_L = i.func_94245_a(String.format("metalbarrels:%s_barrel_side", this.type.name().toLowerCase()));
            this.topIcon = i.func_94245_a(String.format("metalbarrels:%s_barrel_top", this.type.name().toLowerCase()));
            this.innerTopIcon = i.func_94245_a(String.format("metalbarrels:%s_barrel_top_open", this.type.name().toLowerCase()));
            this.bottomIcon = i.func_94245_a(String.format("metalbarrels:%s_barrel_bottom", this.type.name().toLowerCase()));
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityBarrel) {
            ItemStack stack;
            String[] upgrades;
            TileEntityBarrel barrel = (TileEntityBarrel)tileEntity;
            if (!player.func_70093_af() && barrel.numPlayersUsing == 0 && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.BARREL_UPGRADE.get() && (upgrades = ((BaseSubtypesItem)player.func_70694_bm().func_77973_b()).types[(stack = player.func_70694_bm()).func_77960_j()].split("_"))[0].equals(barrel.type.toString().toLowerCase())) {
                barrel.upgrading = true;
                ItemStack[] tempCopy = barrel.chestContents == null ? new ItemStack[barrel.func_70302_i_()] : (ItemStack[])ArrayUtils.clone((Object[])barrel.chestContents);
                TileEntityBarrel newTE = (TileEntityBarrel)TileEntityBarrel.BarrelType.valueOf(upgrades[1].toUpperCase()).getBlock().createTileEntity(world, barrel.func_145832_p());
                System.arraycopy(tempCopy, 0, newTE.chestContents, 0, tempCopy.length);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                world.func_147465_d(x, y, z, newTE.type.getBlock(), barrel.func_145832_p(), 3);
                world.func_147455_a(x, y, z, (TileEntity)newTE);
                world.func_147471_g(x, y, z);
                return true;
            }
            player.openGui((Object)EtFuturum.instance, 3, world, x, y, z);
            return true;
        }
        return false;
    }

    public IInventory getInventory(World p_149951_1_, int p_149951_2_, int p_149951_3_, int p_149951_4_) {
        TileEntity object = p_149951_1_.func_147438_o(p_149951_2_, p_149951_3_, p_149951_4_);
        if (object == null) {
            return null;
        }
        return (IInventory)object;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntityBarrel tileentitychest = (TileEntityBarrel)world.func_147438_o(x, y, z);
        if (tileentitychest != null) {
            if (!tileentitychest.upgrading) {
                for (int i1 = 0; i1 < tileentitychest.func_70302_i_(); ++i1) {
                    ItemStack itemstack = tileentitychest.func_70301_a(i1);
                    if (itemstack == null) continue;
                    float f = this.rand.nextFloat() * 0.8f + 0.1f;
                    float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                    float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                    while (itemstack.field_77994_a > 0) {
                        int j1 = this.rand.nextInt(21) + 10;
                        if (j1 > itemstack.field_77994_a) {
                            j1 = itemstack.field_77994_a;
                        }
                        itemstack.field_77994_a -= j1;
                        EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                        float f3 = 0.05f;
                        entityitem.field_70159_w = (float)this.rand.nextGaussian() * f3;
                        entityitem.field_70181_x = (float)this.rand.nextGaussian() * f3 + 0.2f;
                        entityitem.field_70179_y = (float)this.rand.nextGaussian() * f3;
                        if (itemstack.func_77942_o()) {
                            entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                        }
                        world.func_72838_d((Entity)entityitem);
                    }
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World worldIn, int x, int y, int z, int side) {
        return Container.func_94526_b((IInventory)this.getInventory(worldIn, x, y, z));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBarrel(this.type);
    }
}

