/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import com.glodblock.github.client.gui.container.ContainerFluidLevelEmitter;
import com.glodblock.github.common.item.ItemBaseWirelessTerminal;
import com.glodblock.github.inventory.item.WirelessCraftingTerminalInventory;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CPacketValueConfig
implements IMessage {
    private long amount;
    private int valueIndex;

    public CPacketValueConfig() {
    }

    public CPacketValueConfig(long amount, int valueIndex) {
        this.amount = amount;
        this.valueIndex = valueIndex;
    }

    public void fromBytes(ByteBuf buf) {
        this.amount = buf.readLong();
        this.valueIndex = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.amount);
        buf.writeInt(this.valueIndex);
    }

    public static class Handler
    implements IMessageHandler<CPacketValueConfig, IMessage> {
        public IMessage onMessage(CPacketValueConfig message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            if (container != null) {
                if (container instanceof ContainerFluidLevelEmitter) {
                    ((ContainerFluidLevelEmitter)container).setLevel(message.amount, (EntityPlayer)player);
                } else if (container instanceof ContainerPlayer) {
                    ImmutablePair<Integer, ItemStack> result = Util.getUltraWirelessTerm((EntityPlayer)player);
                    if (result == null) {
                        return null;
                    }
                    if (message.valueIndex == 1) {
                        ItemBaseWirelessTerminal.toggleRestockItemsMode((ItemStack)result.getRight(), !Util.isRestock((ItemStack)result.getRight()));
                        return null;
                    }
                    if (Util.isRestock((ItemStack)result.getRight())) {
                        this.restockItems((ItemStack)result.getRight(), (Integer)result.getLeft(), (EntityPlayer)player);
                    }
                }
            }
            return null;
        }

        private void restockItems(ItemStack terminal, int slot, EntityPlayer player) {
            IGridNode iGridNode = Util.getWirelessGrid(terminal);
            if (iGridNode == null) {
                return;
            }
            WirelessCraftingTerminalInventory inv = new WirelessCraftingTerminalInventory(terminal, slot, iGridNode, player);
            for (int i = 0; i < 9; ++i) {
                int maxSize;
                ItemStack is = player.field_71071_by.field_70462_a[i];
                if (is == null || is.field_77994_a == (maxSize = is.func_77976_d())) continue;
                int fillSize = maxSize - is.field_77994_a;
                IAEItemStack ias = AEApi.instance().storage().createItemStack(is);
                ias.setStackSize((long)fillSize);
                IAEItemStack extractedItem = (IAEItemStack)inv.extractItems((IAEStack)ias, Actionable.MODULATE, (BaseActionSource)inv.getActionSource());
                if (extractedItem == null) continue;
                player.field_71071_by.func_70441_a(extractedItem.getItemStack());
            }
        }
    }
}

