/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory.item;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGridNode;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.IConfigManager;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import com.glodblock.github.inventory.ItemBiggerAppEngInventory;
import com.glodblock.github.inventory.item.BaseWirelessInventory;
import com.glodblock.github.inventory.item.IWirelessMagnetFilter;
import com.glodblock.github.inventory.item.WirelessMagnet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class WirelessMagnetCardFilterInventory
extends BaseWirelessInventory
implements IWirelessMagnetFilter {
    private boolean nbt;
    private boolean mata;
    private boolean ore;
    private WirelessMagnet.ListMode listMode = WirelessMagnet.ListMode.WhiteList;
    protected AppEngInternalInventory filterList;

    public WirelessMagnetCardFilterInventory(ItemStack is, int slot, IGridNode gridNode, EntityPlayer player) {
        super(is, slot, gridNode, player, StorageChannel.ITEMS);
        this.filterList = new ItemBiggerAppEngInventory(is, WirelessMagnet.filterKey, 27);
        this.readFromNBT();
    }

    public void readFromNBT() {
        NBTTagCompound data = Platform.openNbtData((ItemStack)this.target);
        if (!data.func_74764_b(WirelessMagnet.filterConfigKey)) {
            this.writeToNBT();
        }
        NBTTagCompound tag = (NBTTagCompound)data.func_74781_a(WirelessMagnet.filterConfigKey);
        this.nbt = tag.func_74767_n("nbt");
        this.mata = tag.func_74767_n("meta");
        this.ore = tag.func_74767_n("ore");
        this.listMode = WirelessMagnet.ListMode.values()[tag.func_74762_e("list")];
    }

    public void writeToNBT() {
        NBTTagCompound data = Platform.openNbtData((ItemStack)this.target);
        NBTTagCompound tmp = new NBTTagCompound();
        tmp.func_74757_a("nbt", this.nbt);
        tmp.func_74757_a("meta", this.mata);
        tmp.func_74757_a("ore", this.ore);
        tmp.func_74768_a("list", this.listMode.ordinal());
        data.func_74782_a(WirelessMagnet.filterConfigKey, (NBTBase)tmp);
    }

    @Override
    public WirelessMagnet.ListMode getListMode() {
        return this.listMode;
    }

    @Override
    public boolean getNBTMode() {
        return this.nbt;
    }

    @Override
    public boolean getMetaMode() {
        return this.mata;
    }

    @Override
    public boolean getOreMode() {
        return this.ore;
    }

    @Override
    public void setListMode(WirelessMagnet.ListMode mode) {
        this.listMode = mode;
    }

    @Override
    public void setNBTMode(boolean ignoreNBT) {
        this.nbt = ignoreNBT;
    }

    @Override
    public void setMetaMode(boolean ignoreMeta) {
        this.mata = ignoreMeta;
    }

    @Override
    public void setOreMode(boolean useOre) {
        this.ore = useOre;
    }

    @Override
    public void clearConfig() {
        IInventory inv = this.getInventoryByName("config");
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            inv.func_70299_a(i, null);
        }
    }

    @Override
    public StorageChannel getChannel() {
        return null;
    }

    public IInventory getViewCellStorage() {
        return null;
    }

    @Override
    public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
        return 0.0;
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        return this;
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        return null;
    }

    public IConfigManager getConfigManager() {
        return null;
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    @Override
    public void saveSettings() {
        super.saveSettings();
        this.writeToNBT();
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.filterList;
        }
        return null;
    }

    public boolean doInject(IAEItemStack is, EntityItem itemToGet, World world) {
        IAEItemStack ais = (IAEItemStack)this.injectItems((IAEStack)is);
        if (ais != null) {
            this.player.func_71001_a((Entity)itemToGet, ais.getItemStack().field_77994_a);
            this.player.field_71071_by.func_70441_a(ais.getItemStack());
            world.func_72956_a((Entity)this.player, "random.pop", 0.15f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            return false;
        }
        return true;
    }

    public List<ItemStack> getFilteredItems() {
        return WirelessMagnet.getFilteredItems(this.target);
    }

    public IItemList<IAEItemStack> getAEFilteredItems() {
        IItemList list = AEApi.instance().storage().createItemList();
        for (ItemStack is : this.getFilteredItems()) {
            list.add((IAEStack)AEApi.instance().storage().createItemStack(is));
        }
        return list;
    }

    public boolean isItemFiltered(ItemStack is, IItemList<IAEItemStack> list) {
        if (is == null && list.isEmpty()) {
            return false;
        }
        IAEItemStack ais = AEApi.instance().storage().createItemStack(is);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            IAEItemStack i = (IAEItemStack)iterator.next();
            if (this.ore) {
                return i.sameOre(ais);
            }
            if (!this.mata && !this.nbt) {
                return Platform.isSameItem((ItemStack)i.getItemStack(), (ItemStack)ais.getItemStack());
            }
            if (!this.mata && this.nbt) {
                return Platform.isSameItemPrecise((ItemStack)i.getItemStack(), (ItemStack)ais.getItemStack());
            }
            if (this.mata) {
                return i.getItemDamage() == ais.getItemDamage();
            }
            return list.findPrecise((IAEStack)ais) != null;
        }
        return false;
    }
}

