/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory.item;

import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.util.Platform;
import com.glodblock.github.common.Config;
import com.glodblock.github.common.item.ItemWirelessUltraTerminal;
import com.glodblock.github.inventory.ItemBiggerAppEngInventory;
import com.glodblock.github.inventory.item.WirelessMagnetCardFilterInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class WirelessMagnet {
    public static String modeKey = "MagnetMode";
    public static String filterKey = "MagnetFilter";
    public static String filterConfigKey = "MagnetConfig";

    public static List<?> getEntitiesInRange(Class<?> entityType, World world, int x, int y, int z, int distance) {
        return world.func_72872_a(entityType, AxisAlignedBB.func_72330_a((double)(x - distance), (double)(y - distance), (double)(z - distance), (double)(x + distance), (double)(y + distance), (double)(z + distance)));
    }

    public static List<ItemStack> getFilteredItems(ItemStack wirelessTerm) {
        if (wirelessTerm == null) {
            return null;
        }
        if (wirelessTerm.func_77973_b() instanceof ItemWirelessUltraTerminal && wirelessTerm.func_77942_o()) {
            NBTTagCompound data = Platform.openNbtData((ItemStack)wirelessTerm);
            if (!data.func_74764_b(filterKey)) {
                return Collections.emptyList();
            }
            ItemBiggerAppEngInventory filterList = new ItemBiggerAppEngInventory(wirelessTerm, filterKey, 27);
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            filterList.iterator().forEachRemaining(list::add);
            return list;
        }
        return Collections.emptyList();
    }

    public static boolean isConfigured(ItemStack wirelessTerm) {
        NBTTagCompound data = Platform.openNbtData((ItemStack)wirelessTerm);
        return data.func_74764_b(modeKey);
    }

    public static void doMagnet(ItemStack wirelessTerm, World world, EntityPlayer player, WirelessMagnetCardFilterInventory inv) {
        if (Platform.isClient() || wirelessTerm == null || WirelessMagnet.getMode(wirelessTerm) == Mode.Off || player == null || player.func_70093_af() || !WirelessMagnet.isConfigured(wirelessTerm)) {
            return;
        }
        Iterator<Object> iterator = WirelessMagnet.getEntitiesInRange(EntityItem.class, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, Config.magnetRange).iterator();
        IItemList<IAEItemStack> filteredList = inv.getAEFilteredItems();
        while (iterator.hasNext()) {
            EntityPlayer closestPlayer;
            EntityItem itemToGet = (EntityItem)iterator.next();
            if (itemToGet.func_145800_j() != null && itemToGet.func_145800_j().equals(player.func_70005_c_()) || (closestPlayer = world.func_72890_a((Entity)itemToGet, (double)Config.magnetRange)) != null && closestPlayer != player) continue;
            ItemStack stack = itemToGet.func_92059_d();
            if ((inv.getListMode() != ListMode.WhiteList || filteredList.isEmpty() || !inv.isItemFiltered(stack, filteredList)) && (inv.getListMode() != ListMode.BlackList || inv.isItemFiltered(stack, filteredList))) continue;
            if (itemToGet.field_145804_b > 0) {
                itemToGet.field_145804_b = 0;
            }
            itemToGet.field_70179_y = 0.0;
            itemToGet.field_70181_x = 0.0;
            itemToGet.field_70159_w = 0.0;
            itemToGet.func_70107_b(player.field_70165_t - 0.2 + world.field_73012_v.nextDouble() * 0.4, player.field_70163_u - 0.6, player.field_70161_v - 0.2 + world.field_73012_v.nextDouble() * 0.4);
        }
        for (EntityXPOrb xpToGet : WirelessMagnet.getEntitiesInRange(EntityXPOrb.class, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, Config.magnetRange)) {
            if (xpToGet.field_70128_L || xpToGet.func_82150_aj()) continue;
            int xpAmount = xpToGet.field_70530_e;
            xpToGet.field_70530_e = 0;
            player.field_71090_bL = 0;
            player.func_71023_q(xpAmount);
            xpToGet.func_70106_y();
            xpToGet.func_82142_c(true);
            world.func_72956_a((Entity)player, "random.orb", 0.08f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.8f));
        }
    }

    public static Mode getMode(ItemStack is) {
        if (is != null && is.func_77973_b() instanceof ItemWirelessUltraTerminal) {
            NBTTagCompound data = Platform.openNbtData((ItemStack)is);
            if (data.func_74764_b(modeKey)) {
                return Mode.values()[data.func_74762_e(modeKey)];
            }
            WirelessMagnet.setMode(is, Mode.Off);
        }
        return Mode.Off;
    }

    public static void setMode(ItemStack is, Mode mode) {
        if (is != null && is.func_77973_b() instanceof ItemWirelessUltraTerminal) {
            NBTTagCompound data = Platform.openNbtData((ItemStack)is);
            data.func_74768_a(modeKey, mode.ordinal());
        }
    }

    public static enum Mode {
        Off,
        Inv,
        ME;

    }

    public static enum ListMode {
        WhiteList,
        BlackList;

    }
}

