/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory.item;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.MEMonitorHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.items.tools.powered.ToolWirelessTerminal;
import appeng.util.Platform;
import com.glodblock.github.common.item.ItemBaseWirelessTerminal;
import com.glodblock.github.inventory.item.IWirelessExtendCard;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.inventory.item.WirelessMagnet;
import com.glodblock.github.util.Util;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BaseWirelessInventory
extends MEMonitorHandler
implements IWirelessTerminal,
IWirelessExtendCard {
    protected final ItemStack target;
    protected final IAEItemPowerStorage ips;
    protected final int inventorySlot;
    protected final IGridNode grid;
    protected final PlayerSource source;
    protected final StorageChannel channel;
    protected WirelessMagnet.Mode magnetMode = WirelessMagnet.Mode.Off;
    protected EntityPlayer player;
    protected boolean restock;

    public BaseWirelessInventory(ItemStack is, int slot, IGridNode gridNode, EntityPlayer player, StorageChannel channel) {
        super(Objects.requireNonNull(Util.getWirelessInv(is, player, channel)));
        this.ips = (ToolWirelessTerminal)is.func_77973_b();
        this.grid = gridNode;
        this.target = is;
        this.inventorySlot = slot;
        this.channel = channel;
        this.source = new PlayerSource(player, (IActionHost)this);
        this.readFromNBT();
    }

    private void readFromNBT() {
        NBTTagCompound data = Platform.openNbtData((ItemStack)this.target);
        this.setMagnetCardMode(WirelessMagnet.Mode.values()[data.func_74762_e(WirelessMagnet.modeKey)]);
        this.setRestock(data.func_74767_n(ItemBaseWirelessTerminal.restockItems));
    }

    @Override
    public StorageChannel getChannel() {
        return this.channel;
    }

    public ItemStack getItemStack() {
        return this.target;
    }

    public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
        amt = usePowerMultiplier.multiply(amt);
        if (mode == Actionable.SIMULATE) {
            return usePowerMultiplier.divide(Math.min(amt, this.ips.getAECurrentPower(this.target)));
        }
        return usePowerMultiplier.divide(this.ips.extractAEPower(this.target, amt));
    }

    public int getInventorySlot() {
        return this.inventorySlot;
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        return this.grid;
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.NONE;
    }

    public void securityBreak() {
        this.getGridNode(ForgeDirection.UNKNOWN).getMachine().securityBreak();
    }

    public void saveChanges() {
    }

    public IGridNode getActionableNode() {
        return this.grid;
    }

    @Override
    public PlayerSource getActionSource() {
        return this.source;
    }

    @Override
    public void setMagnetCardMode(WirelessMagnet.Mode mode) {
        this.magnetMode = mode;
    }

    @Override
    public WirelessMagnet.Mode getMagnetCardMode() {
        return this.magnetMode;
    }

    @Override
    public void setMagnetCardNextMode() {
        this.setMagnetCardMode(WirelessMagnet.Mode.values()[(this.getMagnetCardMode().ordinal() + 1) % WirelessMagnet.Mode.values().length]);
    }

    @Override
    public void setRestock(boolean val) {
        this.restock = val;
    }

    @Override
    public boolean isRestock() {
        return this.restock;
    }

    @Override
    public IAEStack injectItems(IAEStack aeStack) {
        try {
            if (aeStack.isItem()) {
                return ((IStorageGrid)this.getActionableNode().getGrid().getCache(IStorageGrid.class)).getItemInventory().injectItems((IAEStack)((IAEItemStack)aeStack), Actionable.MODULATE, (BaseActionSource)this.getActionSource());
            }
            return ((IStorageGrid)this.getActionableNode().getGrid().getCache(IStorageGrid.class)).getFluidInventory().injectItems((IAEStack)((IAEFluidStack)aeStack), Actionable.MODULATE, (BaseActionSource)this.getActionSource());
        }
        catch (Exception e) {
            return aeStack;
        }
    }

    @Override
    public IAEStack extractItems(IAEStack aeStack) {
        try {
            if (aeStack.isItem()) {
                return ((IStorageGrid)this.getActionableNode().getGrid().getCache(IStorageGrid.class)).getItemInventory().extractItems((IAEStack)((IAEItemStack)aeStack), Actionable.MODULATE, (BaseActionSource)this.getActionSource());
            }
            return ((IStorageGrid)this.getActionableNode().getGrid().getCache(IStorageGrid.class)).getFluidInventory().extractItems((IAEStack)((IAEFluidStack)aeStack), Actionable.MODULATE, (BaseActionSource)this.getActionSource());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void saveSettings() {
        NBTTagCompound data = Platform.openNbtData((ItemStack)this.target);
        data.func_74757_a(ItemBaseWirelessTerminal.restockItems, this.restock);
        data.func_74768_a(WirelessMagnet.modeKey, this.getMagnetCardMode().ordinal());
    }
}

