/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container.base;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import com.glodblock.github.client.gui.container.base.FCBaseContainer;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.network.SPacketMEUpdateBuffer;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;

public abstract class FCContainerMonitor<T extends IAEStack<T>>
extends FCBaseContainer
implements IConfigManagerHost,
IConfigurableObject,
IMEMonitorHandlerReceiver<T> {
    protected final SlotRestrictedInput[] cellView = new SlotRestrictedInput[5];
    protected final IConfigManager clientCM;
    protected final ITerminalHost host;
    @GuiSync(value=99)
    public boolean canAccessViewCells = false;
    @GuiSync(value=98)
    public boolean hasPower = false;
    protected IConfigManagerHost gui;
    protected IConfigManager serverCM;
    protected IGridNode networkNode;
    protected IMEMonitor<T> monitor;

    public FCContainerMonitor(InventoryPlayer ip, ITerminalHost monitorable) {
        this(ip, monitorable, true);
    }

    protected FCContainerMonitor(InventoryPlayer ip, ITerminalHost monitorable, boolean bindInventory) {
        super(ip, monitorable);
        this.host = monitorable;
        this.clientCM = new ConfigManager((IConfigManagerHost)this);
        this.clientCM.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.clientCM.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        this.clientCM.registerSetting(Settings.TYPE_FILTER, (Enum)TypeFilter.ALL);
    }

    public IMEMonitor<T> getMonitor() {
        return this.monitor;
    }

    public IGridNode getNetworkNode() {
        return this.networkNode;
    }

    @Override
    public void func_75142_b() {
        if (Platform.isServer()) {
            if (this.isInvalid()) {
                this.setValidContainer(false);
            }
            if (this.serverCM != null) {
                for (Settings set : this.serverCM.getSettings()) {
                    Enum sideRemote;
                    Enum sideLocal = this.serverCM.getSetting(set);
                    if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
                    this.clientCM.putSetting(set, sideLocal);
                    for (Object crafter : this.field_75149_d) {
                        try {
                            NetworkHandler.instance.sendTo((AppEngPacket)new PacketValueConfig(set.name(), sideLocal.name()), (EntityPlayerMP)crafter);
                        }
                        catch (IOException e) {
                            AELog.debug((Throwable)e);
                        }
                    }
                }
            }
            this.processItemList();
            this.updatePowerStatus();
            boolean oldAccessible = this.canAccessViewCells;
            boolean bl = this.canAccessViewCells = this.host instanceof WirelessTerminalGuiObject || this.host instanceof IWirelessTerminal || this.hasAccess(SecurityPermissions.BUILD, false);
            if (this.canAccessViewCells != oldAccessible) {
                for (int y = 0; y < 5; ++y) {
                    if (this.cellView[y] == null) continue;
                    this.cellView[y].setAllowEdit(this.canAccessViewCells);
                }
            }
            super.func_75142_b();
        }
    }

    protected abstract void processItemList();

    protected boolean isInvalid() {
        return this.monitor == null;
    }

    protected void updatePowerStatus() {
        try {
            if (this.networkNode != null) {
                this.setPowered(this.networkNode.isActive());
            } else if (this.getPowerSource() instanceof IEnergyGrid) {
                this.setPowered(((IEnergyGrid)this.getPowerSource()).isNetworkPowered());
            } else {
                this.setPowered(this.getPowerSource().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.8);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
        if (field.equals("canAccessViewCells")) {
            for (int y = 0; y < 5; ++y) {
                if (this.cellView[y] == null) continue;
                this.cellView[y].setAllowEdit(this.canAccessViewCells);
            }
        }
        super.onUpdate(field, oldValue, newValue);
    }

    public void func_75132_a(ICrafting c) {
        super.func_75132_a(c);
        this.queueInventory(c);
    }

    protected abstract void queueInventory(ICrafting var1);

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
            if (player instanceof EntityPlayerMP && Platform.isServer()) {
                SPacketMEUpdateBuffer.clear((EntityPlayerMP)player);
            }
        }
    }

    public IConfigManager getConfigManager() {
        if (Platform.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public ItemStack[] getViewCells() {
        ItemStack[] list = new ItemStack[this.cellView.length];
        for (int x = 0; x < this.cellView.length; ++x) {
            list[x] = this.cellView[x].func_75211_c();
        }
        return list;
    }

    public SlotRestrictedInput getCellViewSlot(int index) {
        return this.cellView[index];
    }

    public boolean isPowered() {
        return this.hasPower;
    }

    protected void setPowered(boolean isPowered) {
        this.hasPower = isPowered;
    }

    protected IConfigManagerHost getGui() {
        return this.gui;
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void onListUpdate() {
        for (Object c : this.field_75149_d) {
            if (!(c instanceof ICrafting)) continue;
            ICrafting cr = (ICrafting)c;
            this.queueInventory(cr);
        }
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }
}

