/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.tile.multi;

import bartworks.system.material.WerkstoffLoader;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.gtnhintergalactic.block.IGBlocks;
import com.gtnewhorizons.gtnhintergalactic.client.IGTextures;
import com.gtnewhorizons.gtnhintergalactic.client.TooltipUtil;
import com.gtnewhorizons.gtnhintergalactic.recipe.GasSiphonRecipes;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IChunkLoader;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.objects.GTChunkManager;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.Map;
import java.util.Objects;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class TileEntityPlanetaryGasSiphon
extends MTEEnhancedMultiBlockBase<TileEntityPlanetaryGasSiphon>
implements IChunkLoader,
ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final double LOG4 = Math.log10(4.0);
    private static final IStructureDefinition<TileEntityPlanetaryGasSiphon> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"   ", " f ", "   "}, {"   ", " f ", "   "}, {"   ", " f ", "   "}, {" f ", "fcf", " f "}, {" f ", "fcf", " f "}, {" f ", "fcf", " f "}, {"b~b", "bcb", "bbb"}})).addElement('f', GTStructureUtility.ofFrame((Materials)Materials.TungstenSteel)).addElement('c', StructureUtility.ofBlock((Block)WerkstoffLoader.BWBlockCasingsAdvanced, (int)WerkstoffLoader.LuVTierMaterial.getmID())).addElement('b', (IStructureElement)GTStructureUtility.buildHatchAdder(TileEntityPlanetaryGasSiphon.class).atLeast(new IHatchElement[]{HatchElement.Maintenance, HatchElement.InputBus, HatchElement.OutputHatch, HatchElement.Energy}).dot(1).casingIndex(154).buildAndChain((Block)IGBlocks.GasSiphonCasing, 0)).build();
    private int depth;
    private FluidStack fluid = new FluidStack(FluidRegistry.WATER, 0){

        public String getLocalizedName() {
            return "None";
        }
    };
    private boolean mChunkLoadingEnabled = true;
    private ChunkCoordIntPair mCurrentChunk = null;
    private boolean mWorkChunkNeedsReload = true;

    public TileEntityPlanetaryGasSiphon(int id, String name, String regionalName) {
        super(id, name, regionalName);
    }

    public TileEntityPlanetaryGasSiphon(String name) {
        super(name);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 6, 0);
    }

    public int survivalConstruct(ItemStack stack, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stack, 1, 6, 0, elementBudget, env, false, true);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
        return new TileEntityPlanetaryGasSiphon(this.mName);
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.type"));
        if (TooltipUtil.siphonLoreText != null) {
            tt.addInfo(EnumChatFormatting.ITALIC + TooltipUtil.siphonLoreText);
        }
        tt.addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.desc3")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.desc4")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.desc5")).beginStructureBlock(3, 7, 3, false).addController(GCCoreUtil.translate((String)"ig.siphon.structure.ControllerPos")).addOtherStructurePart(GCCoreUtil.translate((String)"ig.siphon.structure.SiphonCasing"), GCCoreUtil.translate((String)"ig.siphon.structure.Base")).addOtherStructurePart(GCCoreUtil.translate((String)"ig.siphon.structure.ReboltedRhodiumPalladiumCasing"), GCCoreUtil.translate((String)"ig.siphon.structure.PillarMiddle")).addOtherStructurePart(GCCoreUtil.translate((String)"ig.siphon.structure.FrameTungstensteel"), GCCoreUtil.translate((String)"ig.siphon.structure.Sides")).addEnergyHatch(GCCoreUtil.translate((String)"ig.siphon.structure.AnySiphonCasing"), new int[]{1}).addMaintenanceHatch(GCCoreUtil.translate((String)"ig.siphon.structure.AnySiphonCasing"), new int[]{1}).addInputBus(GCCoreUtil.translate((String)"ig.siphon.structure.AnySiphonCasing"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.siphon.structure.AnySiphonCasing"), new int[]{1}).toolTipFinisher(new String[0]);
        return tt;
    }

    public IStructureDefinition<TileEntityPlanetaryGasSiphon> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public ChunkCoordIntPair getActiveChunk() {
        return this.mCurrentChunk;
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstone) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)154), TextureFactory.of((ITexture[])new ITexture[]{IGTextures.SIPHON_OVERLAY_FRONT}), TextureFactory.builder().addIcon(new IIconContainer[]{IGTextures.SIPHON_OVERLAY_FRONT_ACTIVE_GLOW}).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)154), TextureFactory.of((ITexture[])new ITexture[]{IGTextures.SIPHON_OVERLAY_FRONT}), TextureFactory.builder().addIcon(new IIconContainer[]{IGTextures.SIPHON_OVERLAY_FRONT_GLOW}).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)154)};
    }

    public boolean isCorrectMachinePart(ItemStack stack) {
        return true;
    }

    @NotNull
    public CheckRecipeResult checkProcessing() {
        ItemStack stack;
        int i;
        this.depth = 0;
        if (this.mInputBusses.isEmpty() || !((MTEHatchInputBus)this.mInputBusses.get(0)).isValid()) {
            this.resetMachine();
            return SimpleCheckRecipeResult.ofFailure((String)"no_mining_pipe");
        }
        WorldProvider worldProvider = this.getBaseMetaTileEntity().getWorld().field_73011_w;
        if (!(worldProvider instanceof IOrbitDimension)) {
            this.resetMachine();
            return SimpleCheckRecipeResult.ofFailure((String)"no_space_station");
        }
        IOrbitDimension provider = (IOrbitDimension)worldProvider;
        Map<Integer, FluidStack> planetRecipes = GasSiphonRecipes.RECIPES.get(provider.getPlanetToOrbit());
        if (planetRecipes == null) {
            this.resetMachine();
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        MTEHatchInputBus bus = (MTEHatchInputBus)this.mInputBusses.get(0);
        int numPipes = 0;
        for (i = 0; i < this.mInventory.length; ++i) {
            stack = this.mInventory[i];
            if (stack == null) continue;
            if (stack.func_77973_b() == ItemList.Circuit_Integrated.getItem()) {
                this.depth = stack.func_77960_j();
                continue;
            }
            if (!Objects.equals(stack.func_77973_b(), GTModHandler.getIC2Item((String)"miningPipe", (long)0L).func_77973_b())) continue;
            numPipes += stack.field_77994_a;
        }
        for (i = 0; i < bus.getBaseMetaTileEntity().func_70302_i_(); ++i) {
            stack = bus.getBaseMetaTileEntity().func_70301_a(i);
            if (stack == null) continue;
            if (stack.func_77973_b() == ItemList.Circuit_Integrated.getItem()) {
                this.depth = stack.func_77960_j();
                continue;
            }
            if (!Objects.equals(stack.func_77973_b(), GTModHandler.getIC2Item((String)"miningPipe", (long)0L).func_77973_b())) continue;
            numPipes += stack.field_77994_a;
        }
        if (this.depth == 0) {
            this.resetMachine();
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        if (numPipes < this.depth * 64) {
            this.resetMachine();
            return SimpleCheckRecipeResult.ofFailure((String)"no_mining_pipe");
        }
        FluidStack recipeFluid = planetRecipes.get(this.depth);
        if (recipeFluid == null) {
            this.resetMachine();
            return SimpleCheckRecipeResult.ofFailure((String)"invalid_depth");
        }
        if (!this.canOutputAll(new FluidStack[]{recipeFluid})) {
            return CheckRecipeResultRegistry.FLUID_OUTPUT_FULL;
        }
        int recipeEUt = this.depth * (4 << 2 * provider.getCelestialBody().getTierRequirement() + 2);
        int ocLevel = MathHelper.func_76128_c((double)(Math.log10((double)this.getMaxInputVoltage() / (double)recipeEUt) / LOG4));
        if (ocLevel < 0) {
            this.resetMachine();
            return CheckRecipeResultRegistry.insufficientPower((long)recipeEUt);
        }
        this.fluid = recipeFluid.copy();
        if (ocLevel == 0) {
            this.mEUt = -recipeEUt;
        } else {
            this.fluid.amount *= 2 << --ocLevel;
            this.mEUt = -recipeEUt * (4 << 2 * ocLevel);
        }
        this.mOutputFluids = new FluidStack[]{this.fluid};
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = 20;
        return SimpleCheckRecipeResult.ofSuccess((String)"siphoning");
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack stack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 6, 0) && this.mMaintenanceHatches.size() == 1 && this.mInputBusses.size() == 1 && this.mOutputHatches.size() == 1 && this.mEnergyHatches.size() == 1 && this.mInputHatches.isEmpty() && this.mOutputBusses.isEmpty();
    }

    public int getMaxEfficiency(ItemStack stack) {
        return 10000;
    }

    public int getDamageToComponent(ItemStack stack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack stack) {
        return false;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("chunkLoadingEnabled", this.mChunkLoadingEnabled);
        aNBT.func_74757_a("isChunkloading", this.mCurrentChunk != null);
        if (this.mCurrentChunk != null) {
            aNBT.func_74768_a("loadedChunkXPos", this.mCurrentChunk.field_77276_a);
            aNBT.func_74768_a("loadedChunkZPos", this.mCurrentChunk.field_77275_b);
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("chunkLoadingEnabled")) {
            this.mChunkLoadingEnabled = aNBT.func_74767_n("chunkLoadingEnabled");
        }
        if (aNBT.func_74767_n("isChunkloading")) {
            this.mCurrentChunk = new ChunkCoordIntPair(aNBT.func_74762_e("loadedChunkXPos"), aNBT.func_74762_e("loadedChunkZPos"));
        }
    }

    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer player, float x, float y, float z) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.mChunkLoadingEnabled = !this.mChunkLoadingEnabled;
            GTUtility.sendChatToPlayer((EntityPlayer)player, (String)(this.mChunkLoadingEnabled ? GTUtility.trans((String)"502", (String)"Mining chunk loading enabled") : GTUtility.trans((String)"503", (String)"Mining chunk loading disabled")));
            return true;
        }
        return super.onSolderingToolRightClick(side, wrenchingSide, player, x, y, z);
    }

    private void resetMachine() {
        this.mEUt = 0;
        this.mEfficiency = 0;
    }

    public void onRemoval() {
        if (this.mChunkLoadingEnabled) {
            GTChunkManager.releaseTicket((TileEntity)((TileEntity)this.getBaseMetaTileEntity()));
        }
        super.onRemoval();
    }

    public void onPostTick(IGregTechTileEntity baseMetaTileEntity, long tick) {
        super.onPostTick(baseMetaTileEntity, tick);
        if (baseMetaTileEntity.isServerSide() && this.mCurrentChunk != null && !this.mWorkChunkNeedsReload && !baseMetaTileEntity.isAllowedToWork()) {
            GTChunkManager.releaseTicket((TileEntity)((TileEntity)baseMetaTileEntity));
            this.mWorkChunkNeedsReload = true;
        }
    }

    public String[] getInfoData() {
        return new String[]{EnumChatFormatting.LIGHT_PURPLE + "Operational Data:" + EnumChatFormatting.RESET, "Depth: " + EnumChatFormatting.YELLOW + this.depth + EnumChatFormatting.RESET, "Fluid: " + EnumChatFormatting.YELLOW + this.fluid.amount + EnumChatFormatting.RESET + "L/s " + EnumChatFormatting.BLUE + this.fluid.getLocalizedName() + EnumChatFormatting.RESET, "EU/t required: " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers((long)(-this.mEUt)) + EnumChatFormatting.RESET + " EU/t", "Maintenance Status: " + (this.getRepairStatus() == this.getIdealStatus() ? EnumChatFormatting.GREEN + "Working perfectly" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "Has problems" + EnumChatFormatting.RESET), "---------------------------------------------"};
    }

    public boolean supportsVoidProtection() {
        return true;
    }
}

