/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.recipe.maps;

import com.gtnewhorizons.gtnhintergalactic.recipe.IGRecipeMaps;
import com.gtnewhorizons.gtnhintergalactic.recipe.SpaceMiningData;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.common.gui.modularui.UIHelper;
import gregtech.nei.RecipeDisplayInfo;
import gregtech.nei.formatter.INEISpecialInfoFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SpaceMiningFrontend
extends RecipeMapFrontend {
    public SpaceMiningFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder, neiPropertiesBuilder.neiSpecialInfoFormatter((INEISpecialInfoFormatter)new SpaceMiningSpecialValueFormatter()));
    }

    public List<Pos2d> getItemInputPositions(int itemInputCount) {
        ArrayList<Pos2d> results = new ArrayList<Pos2d>();
        results.add(new Pos2d(143, 15));
        results.addAll(UIHelper.getGridPositions((int)(itemInputCount - 1), (int)10, (int)6, (int)2));
        return results;
    }

    public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
        return UIHelper.getGridPositions((int)itemOutputCount, (int)69, (int)6, (int)4);
    }

    public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
        return UIHelper.getGridPositions((int)fluidInputCount, (int)10, (int)51, (int)fluidInputCount);
    }

    private static class SpaceMiningSpecialValueFormatter
    implements INEISpecialInfoFormatter {
        private SpaceMiningSpecialValueFormatter() {
        }

        public List<String> format(RecipeDisplayInfo recipeInfo) {
            ArrayList<String> result = new ArrayList<String>();
            int recipeTier = (Integer)recipeInfo.recipe.getMetadataOrDefault(IGRecipeMaps.MODULE_TIER, (Object)1);
            result.add(GCCoreUtil.translateWithFormat((String)"ig.nei.module", (Object[])new Object[]{recipeTier}));
            SpaceMiningData data = (SpaceMiningData)recipeInfo.recipe.getMetadata(IGRecipeMaps.SPACE_MINING_DATA);
            if (data != null) {
                result.add(GCCoreUtil.translate((String)"ig.nei.spacemining.distance") + " " + data.minDistance + "-" + data.maxDistance);
                result.add(GCCoreUtil.translate((String)"ig.nei.spacemining.size") + " " + data.minSize + "-" + data.maxSize);
                result.add(GCCoreUtil.translateWithFormat((String)"tt.nei.research.min_computation", (Object[])new Object[]{GTUtility.formatNumbers((long)data.computation)}));
                result.add(GCCoreUtil.translate((String)"ig.nei.spacemining.weight") + " " + data.recipeWeight);
            }
            return result;
        }
    }
}

