/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.recipe;

import bartworks.system.material.WerkstoffLoader;
import com.gtnewhorizons.gtnhintergalactic.item.IGItems;
import com.gtnewhorizons.gtnhintergalactic.item.ItemMiningDrones;
import com.gtnewhorizons.gtnhintergalactic.recipe.IGRecipeMaps;
import com.gtnewhorizons.gtnhintergalactic.recipe.IG_RecipeAdder;
import com.gtnewhorizons.gtnhintergalactic.recipe.SpaceMiningData;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import goodgenerator.items.GGMaterial;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class SpaceMiningRecipes {
    private static final ItemStack[] MINING_DRONES = new ItemStack[ItemMiningDrones.DroneTiers.values().length];
    private static final ItemStack[] MINING_DRILLS = new ItemStack[ItemMiningDrones.DroneMaterials.values().length];
    private static final ItemStack[] MINING_RODS = new ItemStack[ItemMiningDrones.DroneMaterials.values().length];
    private static final Map<GTUtility.ItemId, Integer> DRONE_TIERS = new HashMap<GTUtility.ItemId, Integer>();

    public static void addAsteroids() {
        SpaceMiningRecipes.addRecipesToDrones("coalAsteroid", null, null, new int[]{7000, 1000, 2000}, new Materials[]{Materials.Coal, Materials.Lignite, Materials.Graphite}, OrePrefixes.oreEndstone, 30, 120, 1, 40, 20, 1, 200, (int)TierEU.RECIPE_EV, ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.ZPM.ordinal(), 200);
        SpaceMiningRecipes.addRecipesToDrones("saltAsteroid", null, null, new int[]{4000, 2000, 4000}, new Materials[]{Materials.Salt, Materials.RockSalt, Materials.Saltpeter}, OrePrefixes.oreEndstone, 30, 120, 1, 250, 20, 1, 200, (int)TierEU.RECIPE_EV, ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.IV.ordinal(), 300);
        SpaceMiningRecipes.addRecipesToDrones("ironAsteroid", null, null, new int[]{4000, 2000, 1000, 1000, 500, 500}, new Materials[]{Materials.Iron, Materials.Gold, Materials.Magnetite, Materials.Pyrite, Materials.BasalticMineralSand, Materials.GraniticMineralSand}, OrePrefixes.oreEndstone, 30, 150, 1, 180, 10, 1, 200, (int)TierEU.RECIPE_EV, ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.ZPM.ordinal(), 600);
        SpaceMiningRecipes.addRecipesToDrones("copperAsteroid", null, null, new int[]{5000, 3000, 2000}, new Materials[]{Materials.Copper, Materials.Chalcopyrite, Materials.Malachite}, OrePrefixes.oreEndstone, 30, 150, 3, 12, 10, 1, 200, (int)TierEU.RECIPE_EV, ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.LuV.ordinal(), 500);
        SpaceMiningRecipes.addRecipesToDrones("tinAsteroid", null, null, new int[]{2000, 1500, 6000, 500}, new Materials[]{Materials.Cassiterite, Materials.CassiteriteSand, Materials.Tin, Materials.Asbestos}, OrePrefixes.oreEndstone, 50, 200, 2, 100, 10, 1, 50, (int)TierEU.RECIPE_IV, ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.IV.ordinal(), 400);
        SpaceMiningRecipes.addRecipesToDrones("aluminiumAsteroid", null, null, new int[]{5000, 3500, 1500}, new Materials[]{Materials.Aluminium, Materials.Bauxite, Materials.Rutile}, OrePrefixes.oreEndstone, 10, 20, 5, 20, 20, 1, 50, (int)TierEU.RECIPE_IV, ItemMiningDrones.DroneTiers.MV.ordinal(), ItemMiningDrones.DroneTiers.EV.ordinal(), 120);
        SpaceMiningRecipes.addRecipesToDrones("nickelAsteroid", null, null, new int[]{4000, 3000, 3000}, new Materials[]{Materials.Nickel, Materials.Pentlandite, Materials.Garnierite}, OrePrefixes.oreEndstone, 20, 40, 5, 20, 20, 1, 50, (int)TierEU.RECIPE_IV, ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.IV.ordinal(), 170);
        SpaceMiningRecipes.addRecipesToDrones("chromeAsteroid", null, null, new int[]{5000, 3000, 2000}, new Materials[]{Materials.Chrome, Materials.Ruby, Materials.Chromite}, OrePrefixes.oreEndstone, 16, 32, 10, 20, 40, 1, 50, (int)TierEU.RECIPE_LuV, ItemMiningDrones.DroneTiers.MV.ordinal(), ItemMiningDrones.DroneTiers.LuV.ordinal(), 100);
        SpaceMiningRecipes.addRecipesToDrones("platlineOreAsteroid", null, null, new int[]{6000, 2000, 1500, 500}, new Materials[]{Materials.Platinum, Materials.Palladium, Materials.Iridium, Materials.Osmium}, OrePrefixes.oreEndstone, 20, 40, 10, 50, 60, 1, 50, (int)TierEU.RECIPE_LuV, ItemMiningDrones.DroneTiers.HV.ordinal(), ItemMiningDrones.DroneTiers.ZPM.ordinal(), 130);
        SpaceMiningRecipes.addRecipesToDrones("gemAsteroid", null, null, new int[]{1500, 1500, 1500, 1500, 750, 750, 750, 1000, 500, 500, 400, 100}, new Materials[]{Materials.Ruby, Materials.Emerald, Materials.Sapphire, Materials.GreenSapphire, Materials.Diamond, Materials.Opal, Materials.Amethyst, Materials.Topaz, Materials.BlueTopaz, Materials.Bauxite, Materials.Vinteum, Materials.NetherStar}, OrePrefixes.oreEndstone, 30, 160, 17, 40, 60, 1, 100, (int)TierEU.RECIPE_LuV, ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.LuV.ordinal(), 180);
        SpaceMiningRecipes.addRecipesToDrones("indiumAsteroid", null, null, new int[]{6000, 2000, 1000, 1000}, new Materials[]{Materials.Indium, Materials.Sphalerite, Materials.Zinc, Materials.Cadmium}, OrePrefixes.oreEndstone, 30, 120, 50, 90, 120, 2, 500, (int)TierEU.RECIPE_LuV, ItemMiningDrones.DroneTiers.IV.ordinal(), ItemMiningDrones.DroneTiers.UEV.ordinal(), 170);
        SpaceMiningRecipes.addRecipesToDrones("thaumiumAsteroid", null, null, new int[]{6000, 4000}, new Materials[]{Materials.Thaumium, Materials.Void}, OrePrefixes.dust, 20, 50, 10, 70, 120, 1, 600, (int)TierEU.RECIPE_LuV, ItemMiningDrones.DroneTiers.HV.ordinal(), ItemMiningDrones.DroneTiers.LuV.ordinal(), 150);
        SpaceMiningRecipes.addRecipesToDrones("basicMagicAsteroid", null, null, new int[]{3500, 3500, 500, 500, 500, 500, 500, 500}, new Materials[]{Materials.InfusedGold, Materials.Shadow, Materials.InfusedAir, Materials.InfusedEarth, Materials.InfusedFire, Materials.InfusedWater, Materials.InfusedEntropy, Materials.InfusedOrder}, OrePrefixes.oreEndstone, 24, 60, 8, 24, 120, 1, 100, (int)TierEU.RECIPE_LuV, ItemMiningDrones.DroneTiers.HV.ordinal(), ItemMiningDrones.DroneTiers.LuV.ordinal(), 200);
        SpaceMiningRecipes.addRecipesToDrones("niobiumAsteroid", null, null, new int[]{3000, 2000, 1500, 3500}, new Materials[]{Materials.Niobium, Materials.Quantium, Materials.Ytterbium, Materials.Yttrium}, OrePrefixes.oreEndstone, 30, 120, 30, 160, 120, 1, 500, (int)TierEU.RECIPE_LuV, ItemMiningDrones.DroneTiers.IV.ordinal(), ItemMiningDrones.DroneTiers.UHV.ordinal(), 160);
        SpaceMiningRecipes.addRecipesToDrones("quartzAsteroid", null, null, new int[]{3000, 2250, 2250, 2500}, new Materials[]{Materials.Quartzite, Materials.CertusQuartz, Materials.NetherQuartz, Materials.Vanadium}, OrePrefixes.oreEndstone, 20, 80, 20, 120, 50, 1, 500, (int)TierEU.RECIPE_IV, ItemMiningDrones.DroneTiers.MV.ordinal(), ItemMiningDrones.DroneTiers.ZPM.ordinal(), 230);
        SpaceMiningRecipes.addRecipesToDrones("lutetiumAsteroid", null, null, new int[]{1500, 1000, 1500, 500, 5500}, new Materials[]{Materials.Tellurium, Materials.Thulium, Materials.Tantalum, Materials.Lutetium, Materials.Redstone}, OrePrefixes.oreEndstone, 20, 80, 40, 240, 90, 1, 500, (int)TierEU.RECIPE_LuV, ItemMiningDrones.DroneTiers.IV.ordinal(), ItemMiningDrones.DroneTiers.UHV.ordinal(), 100);
        SpaceMiningRecipes.addRecipesToDrones("siliconAsteroid", null, null, new int[]{2000, 4500, 2500}, new Materials[]{Materials.Mica, Materials.Silicon, Materials.SiliconSG}, OrePrefixes.oreEndstone, 20, 80, 50, 250, 60, 2, 500, (int)TierEU.RECIPE_LuV, ItemMiningDrones.DroneTiers.HV.ordinal(), ItemMiningDrones.DroneTiers.LuV.ordinal(), 200);
        SpaceMiningRecipes.addRecipesToDrones("phosphateAsteroid", null, null, new int[]{4500, 2500, 3000}, new Materials[]{Materials.Phosphate, Materials.TricalciumPhosphate, Materials.Sulfur}, OrePrefixes.oreEndstone, 20, 150, 60, 250, 60, 1, 500, (int)TierEU.RECIPE_LuV, ItemMiningDrones.DroneTiers.IV.ordinal(), ItemMiningDrones.DroneTiers.UIV.ordinal(), 150);
        SpaceMiningRecipes.addRecipesToDrones("leadAsteroid", null, null, new int[]{3000, 2500, 2500, 2000}, new Materials[]{Materials.Lead, Materials.Arsenic, Materials.Barium, Materials.Lepidolite}, OrePrefixes.oreEndstone, 30, 100, 5, 150, 20, 1, 500, (int)TierEU.RECIPE_EV, ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.UV.ordinal(), 220);
        SpaceMiningRecipes.addRecipesToDrones("adamantiumAsteroid", null, null, new int[]{2500, 2000, 2000, 2000, 1500}, new Materials[]{Materials.Adamantium, Materials.Bismuth, Materials.Antimony, Materials.Gallium, Materials.Lithium}, OrePrefixes.oreEndstone, 30, 120, 5, 120, 20, 1, 500, (int)TierEU.RECIPE_EV, ItemMiningDrones.DroneTiers.EV.ordinal(), ItemMiningDrones.DroneTiers.ZPM.ordinal(), 300);
        SpaceMiningRecipes.addRecipesToDrones("tungstenTitaniumAsteroid", null, null, new int[]{3000, 3000, 2000, 1500, 500}, new Materials[]{Materials.Tungsten, Materials.Titanium, Materials.Neodymium, Materials.Molybdenum, Materials.Tungstate}, OrePrefixes.oreEndstone, 30, 70, 60, 200, 120, 1, 500, (int)TierEU.RECIPE_LuV, ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.LuV.ordinal(), 100);
        SpaceMiningRecipes.addRecipesToDrones("blueAsteroid", null, null, new int[]{6000, 2000, 1000, 1000}, new Materials[]{Materials.Lapis, Materials.Calcite, Materials.Lazurite, Materials.Sodalite}, OrePrefixes.oreEndstone, 10, 50, 20, 200, 60, 1, 500, (int)TierEU.RECIPE_IV, ItemMiningDrones.DroneTiers.HV.ordinal(), ItemMiningDrones.DroneTiers.UV.ordinal(), 250);
        SpaceMiningRecipes.addRecipesToDrones("aluminiumLanthlineAsteroid", null, null, new int[]{3500, 1500, 2500, 2500}, new Materials[]{Materials.Aluminium, Materials.Bauxite, Materials.Monazite, Materials.Bastnasite}, OrePrefixes.oreEndstone, 10, 80, 40, 120, 60, 1, 500, (int)TierEU.RECIPE_IV, ItemMiningDrones.DroneTiers.MV.ordinal(), ItemMiningDrones.DroneTiers.ZPM.ordinal(), 250);
        if (Loader.isModLoaded((String)"miscutils")) {
            SpaceMiningRecipes.addRecipesToDrones("evergladesAsteroid", null, null, new int[]{600, 400, 1500, 1500, 1000, 400, 1000, 600, 1000, 1000, 1000}, new ItemStack[]{new ItemStack(GameRegistry.findItem((String)"miscutils", (String)"oreKoboldite"), 64), new ItemStack(GameRegistry.findItem((String)"miscutils", (String)"oreCrocoite"), 64), new ItemStack(GameRegistry.findItem((String)"miscutils", (String)"oreGadoliniteY"), 64), new ItemStack(GameRegistry.findItem((String)"miscutils", (String)"oreLepersonnite"), 64), new ItemStack(GameRegistry.findItem((String)"miscutils", (String)"oreZircon"), 64), new ItemStack(GameRegistry.findItem((String)"miscutils", (String)"oreLautarite"), 64), new ItemStack(GameRegistry.findItem((String)"miscutils", (String)"oreHoneaite"), 64), new ItemStack(GameRegistry.findItem((String)"miscutils", (String)"oreAlburnite"), 64), new ItemStack(GameRegistry.findItem((String)"miscutils", (String)"oreRareEarthI"), 64), new ItemStack(GameRegistry.findItem((String)"miscutils", (String)"oreRareEarthII"), 64), new ItemStack(GameRegistry.findItem((String)"miscutils", (String)"oreRareEarthIII"), 64)}, 10, 20, 110, 230, 200, 1, 500, (int)TierEU.RECIPE_IV, ItemMiningDrones.DroneTiers.ZPM.ordinal(), ItemMiningDrones.DroneTiers.UHV.ordinal(), 100);
        }
        SpaceMiningRecipes.addRecipesToDrones("draconicAsteroid", null, null, new int[]{6500, 2500, 1000}, new Materials[]{Materials.Draconium, Materials.DraconiumAwakened, Materials.ElectrumFlux}, OrePrefixes.oreEndstone, 15, 60, 60, 200, 360, 2, 600, (int)TierEU.RECIPE_LuV, ItemMiningDrones.DroneTiers.LuV.ordinal(), ItemMiningDrones.DroneTiers.UHV.ordinal(), 190);
        SpaceMiningRecipes.addRecipesToDrones("cheeseAsteroid", null, null, new int[]{10000}, new Materials[]{Materials.Cheese}, OrePrefixes.oreEndstone, 1, 30, 90, 200, 240, 2, 1000, (int)TierEU.RECIPE_ZPM, ItemMiningDrones.DroneTiers.IV.ordinal(), ItemMiningDrones.DroneTiers.UXV.ordinal(), 10);
        SpaceMiningRecipes.addRecipesToDrones("arditeCobaltAsteroid", null, null, new int[]{3750, 3750, 2500}, new Materials[]{Materials.Cobalt, Materials.Ardite, Materials.Manyullyn}, OrePrefixes.ore, 20, 90, 30, 100, 180, 1, 1000, (int)TierEU.RECIPE_IV, ItemMiningDrones.DroneTiers.EV.ordinal(), ItemMiningDrones.DroneTiers.UHV.ordinal(), 150);
        SpaceMiningRecipes.addRecipesToDrones("europiumAsteroid", null, null, new int[]{4000, 4000, 1500, 500}, new Materials[]{Materials.Ledox, Materials.CallistoIce, Materials.Borax, Materials.Europium}, OrePrefixes.oreEndstone, 40, 120, 40, 60, 240, 2, 1000, (int)TierEU.RECIPE_ZPM, ItemMiningDrones.DroneTiers.ZPM.ordinal(), ItemMiningDrones.DroneTiers.UXV.ordinal(), 150);
        SpaceMiningRecipes.addRecipesToDrones("cosmicAsteroid", null, null, new int[]{2500, 2500, 2500, 2500}, new Materials[]{Materials.CosmicNeutronium, Materials.Neutronium, Materials.BlackPlutonium, Materials.Bedrockium}, OrePrefixes.oreEndstone, 10, 70, 60, 100, 240, 2, 500, (int)TierEU.RECIPE_UV, ItemMiningDrones.DroneTiers.ZPM.ordinal(), ItemMiningDrones.DroneTiers.UXV.ordinal(), 170);
        SpaceMiningRecipes.addRecipesToDrones("infinityCatalystAsteroid", null, null, new int[]{5000, 3000, 2000}, new Materials[]{Materials.InfinityCatalyst, Materials.CosmicNeutronium, Materials.Neutronium}, OrePrefixes.oreEndstone, 30, 120, 70, 100, 320, 2, 1000, (int)TierEU.RECIPE_UV, ItemMiningDrones.DroneTiers.UV.ordinal(), ItemMiningDrones.DroneTiers.UXV.ordinal(), 150);
        SpaceMiningRecipes.addRecipesToDrones("ichoriumAsteroid", null, null, new int[]{4500, 3000, 1500, 500, 500}, new Materials[]{Materials.ShadowIron, Materials.MeteoricIron, Materials.Ichorium, Materials.Desh, Materials.Americium}, OrePrefixes.oreEndstone, 30, 120, 70, 100, 320, 3, 1000, (int)TierEU.RECIPE_UV, ItemMiningDrones.DroneTiers.UEV.ordinal(), ItemMiningDrones.DroneTiers.UXV.ordinal(), 150);
        SpaceMiningRecipes.addRecipesToDrones("clayAsteroid", null, null, new int[]{10000}, new ItemStack[]{new ItemStack(Blocks.field_150435_aG, 64)}, 30, 60, 20, 100, 30, 1, 800, (int)TierEU.RECIPE_IV, ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.LuV.ordinal(), 200);
        if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
            SpaceMiningRecipes.addRecipesToDrones("mysteriousCrystalAsteroid", null, null, new int[]{7400, 2000, 500, 98, 2}, new ItemStack[]{GTOreDictUnificator.get((OrePrefixes)OrePrefixes.oreEndstone, (Object)Materials.MysteriousCrystal, (long)64L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.oreEndstone, (Object)Materials.Mytryl, (long)64L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.oreEndstone, (Object)Materials.Oriharukon, (long)64L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.oreEndstone, (Object)Materials.HeeEndium, (long)64L), new ItemStack(GameRegistry.findItem((String)"HardcoreEnderExpansion", (String)"end_powder_ore"), 64)}, 30, 60, 65, 120, 300, 1, 500, (int)TierEU.RECIPE_ZPM, ItemMiningDrones.DroneTiers.IV.ordinal(), ItemMiningDrones.DroneTiers.UXV.ordinal(), 220);
        }
        if (Loader.isModLoaded((String)"bartworks")) {
            SpaceMiningRecipes.addRecipesToDrones("uraniumPlutoniumAsteroid", null, null, new int[]{3000, 2450, 2450, 2000, 100}, new Materials[]{Materials.Uranium, Materials.Uranium235, Materials.Plutonium, Materials.Plutonium241, WerkstoffLoader.Thorianit.getBridgeMaterial()}, OrePrefixes.ore, 40, 180, 30, 70, 120, 1, 400, (int)TierEU.RECIPE_LuV, ItemMiningDrones.DroneTiers.HV.ordinal(), ItemMiningDrones.DroneTiers.ZPM.ordinal(), 150);
            SpaceMiningRecipes.addRecipesToDrones("holmiumSamariumAsteroid", null, null, new int[]{2000, 3000, 3000, 2000}, new Materials[]{Materials.Holmium, Materials.Samarium, WerkstoffLoader.Tiberium.getBridgeMaterial(), Materials.Strontium}, OrePrefixes.ore, 15, 50, 40, 80, 260, 2, 500, (int)TierEU.RECIPE_LuV, ItemMiningDrones.DroneTiers.UV.ordinal(), ItemMiningDrones.DroneTiers.UXV.ordinal(), 75);
            SpaceMiningRecipes.addRecipesToDrones("platlinePureAsteroid", null, null, new int[]{3800, 2000, 1500, 500, 1200, 1000}, new Materials[]{Materials.Platinum, Materials.Palladium, Materials.Iridium, Materials.Osmium, WerkstoffLoader.Ruthenium.getBridgeMaterial(), WerkstoffLoader.Rhodium.getBridgeMaterial()}, OrePrefixes.dust, 10, 30, 25, 200, 360, 3, 500, (int)TierEU.RECIPE_ZPM, ItemMiningDrones.DroneTiers.ZPM.ordinal(), ItemMiningDrones.DroneTiers.UEV.ordinal(), 60);
            SpaceMiningRecipes.addRecipesToDrones("magnesiumAsteroid", null, null, new int[]{4000, 3000, 3000}, new Materials[]{Materials.Magnesium, Materials.Manganese, WerkstoffLoader.Fluorspar.getBridgeMaterial()}, OrePrefixes.ore, 10, 80, 10, 200, 60, 1, 400, (int)TierEU.RECIPE_IV, ItemMiningDrones.DroneTiers.EV.ordinal(), ItemMiningDrones.DroneTiers.UHV.ordinal(), 250);
        }
        if (Loader.isModLoaded((String)"GoodGenerator")) {
            SpaceMiningRecipes.addRecipesToDrones("lanthanumAsteroid", null, null, new int[]{1500, 2000, 3000, 3500}, new Materials[]{Materials.Trinium, Materials.Lanthanum, GGMaterial.orundum.getBridgeMaterial(), Materials.Silver}, OrePrefixes.ore, 30, 120, 30, 230, 120, 2, 500, (int)TierEU.RECIPE_LuV, ItemMiningDrones.DroneTiers.IV.ordinal(), ItemMiningDrones.DroneTiers.UIV.ordinal(), 150);
            SpaceMiningRecipes.addRecipesToDrones("tengamAsteroid", null, null, new int[]{100, 1650, 3500, 2250, 2500}, new Materials[]{Materials.Dilithium, GGMaterial.orundum.getBridgeMaterial(), Materials.Vanadium, Materials.Ytterbium, Materials.TengamRaw}, OrePrefixes.ore, 5, 100, 20, 100, 120, 3, 500, (int)TierEU.RECIPE_LuV, ItemMiningDrones.DroneTiers.UEV.ordinal(), ItemMiningDrones.DroneTiers.UXV.ordinal(), 50);
            SpaceMiningRecipes.addRecipesToDrones("naquadahAsteroid", null, null, new int[]{4000, 3500, 2500}, new Materials[]{GGMaterial.naquadahEarth.getBridgeMaterial(), GGMaterial.enrichedNaquadahEarth.getBridgeMaterial(), GGMaterial.naquadriaEarth.getBridgeMaterial()}, OrePrefixes.ore, 20, 80, 50, 150, 240, 1, 1000, (int)TierEU.RECIPE_LuV, ItemMiningDrones.DroneTiers.IV.ordinal(), ItemMiningDrones.DroneTiers.UV.ordinal(), 200);
        }
        if (Loader.isModLoaded((String)"kubatech")) {
            SpaceMiningRecipes.addRecipesToDrones("draconicCoreRuin", null, null, new int[]{100, 100, 9800}, new ItemStack[]{GTModHandler.getModItem((String)"kubatech", (String)"kubaitems", (long)1L, (int)38), GTModHandler.getModItem((String)"DraconicEvolution", (String)"draconicCore", (long)1L, (int)0), ItemList.ZPM.getWithCharge(1L, 0x7FFFFFFE, new Object[0])}, 1, 1, 50, 200, 1000, 3, 2000, (int)TierEU.RECIPE_UEV, ItemMiningDrones.DroneTiers.UHV.ordinal(), ItemMiningDrones.DroneTiers.UIV.ordinal(), 1);
        }
    }

    public static ItemStack[] getTieredInputs(int tier) {
        return new ItemStack[]{MINING_DRONES[tier], MINING_DRILLS[tier], MINING_RODS[tier]};
    }

    public static Optional<Integer> getTierFromDrone(ItemStack drone) {
        return Optional.ofNullable(DRONE_TIERS.getOrDefault(GTUtility.ItemId.createWithoutNBT((ItemStack)drone), null));
    }

    private static void addRecipesToDrones(String asteroidName, ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int[] aChances, ItemStack[] aItemOutputs, int minSize, int maxSize, int minDistance, int maxDistance, int computationRequiredPerSec, int minModuleTier, int duration, int EUt, int startDroneTier, int endDroneTier, int recipeWeight) {
        ItemStack[] tItemInputs;
        if (aItemInputs == null) {
            tItemInputs = new ItemStack[3];
        } else {
            tItemInputs = new ItemStack[aItemInputs.length + 3];
            System.arraycopy(aItemInputs, 0, tItemInputs, 3, aItemInputs.length);
        }
        for (int i = startDroneTier; i <= endDroneTier; ++i) {
            tItemInputs[0] = MINING_DRONES[i];
            tItemInputs[1] = MINING_DRILLS[i];
            tItemInputs[2] = MINING_RODS[i];
            IG_RecipeAdder.addSpaceMiningRecipe(asteroidName, tItemInputs, aFluidInputs, aChances, aItemOutputs, minSize + (int)Math.pow(2.0, i - startDroneTier) - 1, maxSize + (int)Math.pow(2.0, i - startDroneTier) - 1, minDistance, maxDistance, computationRequiredPerSec, minModuleTier, (int)Math.ceil((double)duration / Math.sqrt(i - startDroneTier + 1)), EUt, recipeWeight);
        }
    }

    private static void addRecipesToDrones(String asteroidName, ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int[] aChances, Materials[] ores, OrePrefixes orePrefixes, int minSize, int maxSize, int minDistance, int maxDistance, int computationRequiredPerSec, int minModuleTier, int duration, int EUt, int startDroneTier, int endDroneTier, int recipeWeight) {
        ItemStack[] tItemInputs;
        if (aItemInputs == null) {
            tItemInputs = new ItemStack[3];
        } else {
            tItemInputs = new ItemStack[aItemInputs.length + 3];
            System.arraycopy(aItemInputs, 0, tItemInputs, 3, aItemInputs.length);
        }
        for (int i = startDroneTier; i <= endDroneTier; ++i) {
            tItemInputs[0] = MINING_DRONES[i];
            tItemInputs[1] = MINING_DRILLS[i];
            tItemInputs[2] = MINING_RODS[i];
            IG_RecipeAdder.addSpaceMiningRecipe(asteroidName, tItemInputs, aFluidInputs, aChances, ores, orePrefixes, minSize + (int)Math.pow(2.0, i - startDroneTier) - 1, maxSize + (int)Math.pow(2.0, i - startDroneTier) - 1, minDistance, maxDistance, computationRequiredPerSec, minModuleTier, (int)Math.ceil((double)duration / Math.sqrt(i - startDroneTier + 1)), (int)Math.ceil((double)EUt * Math.sqrt(i - startDroneTier + 1)), recipeWeight);
        }
    }

    static {
        for (ItemMiningDrones.DroneTiers droneTiers : ItemMiningDrones.DroneTiers.values()) {
            ItemStack drone;
            int i = droneTiers.ordinal();
            SpaceMiningRecipes.MINING_DRONES[i] = drone = new ItemStack(IGItems.MiningDrones, 0, i);
            DRONE_TIERS.put(GTUtility.ItemId.createWithoutNBT((ItemStack)drone), i);
        }
        for (Enum enum_ : ItemMiningDrones.DroneMaterials.values()) {
            SpaceMiningRecipes.MINING_DRILLS[enum_.ordinal()] = GTOreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadDrill, (Object)((ItemMiningDrones.DroneMaterials)enum_).getMaterial(), (long)4L);
            SpaceMiningRecipes.MINING_RODS[enum_.ordinal()] = GTOreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)((ItemMiningDrones.DroneMaterials)enum_).getMaterial(), (long)4L);
        }
    }

    public static class WeightedAsteroidList {
        public List<GTRecipe> recipes = new ArrayList<GTRecipe>();
        public int totalWeight;
        public int totalTimedensity;

        public WeightedAsteroidList(Stream<GTRecipe> inRecipes) {
            inRecipes.forEach(r -> {
                SpaceMiningData data = (SpaceMiningData)r.getMetadata(IGRecipeMaps.SPACE_MINING_DATA);
                if (data != null) {
                    this.recipes.add((GTRecipe)r);
                    this.totalWeight += data.recipeWeight;
                    this.totalTimedensity += data.recipeWeight * r.mDuration;
                }
            });
        }

        public GTRecipe getRandom() {
            int i;
            double r = Math.random() * (double)this.totalWeight;
            for (i = 0; i < this.recipes.size() - 1; ++i) {
                SpaceMiningData data = (SpaceMiningData)this.recipes.get(i).getMetadata(IGRecipeMaps.SPACE_MINING_DATA);
                if (data == null) {
                    throw new IllegalStateException("Illegal space miner recipe found");
                }
                if ((r -= (double)data.recipeWeight) <= 0.0) break;
            }
            return this.recipes.get(i);
        }
    }
}

