/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.AEApi;
import appeng.api.exceptions.FailedConnection;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.core.AEConfig;
import appeng.helpers.SuperWirelessToolDataObject;
import appeng.me.helpers.AENetworkProxy;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import appeng.tile.networking.TileWirelessHub;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileWirelessConnector
extends AENetworkTile
implements IColorableTile {
    private IGridConnection connection;
    private DimensionalCoord target;
    private AEColor color = AEColor.Transparent;

    private void tryRestoreConnection() {
        if (this.connection == null && this.target != null) {
            this.setupConnection(this.target);
        }
    }

    @Override
    protected AENetworkProxy createProxy() {
        AENetworkProxy ae = super.createProxy();
        ae.setFlags(GridFlags.DENSE_CAPACITY);
        return ae;
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    public void updateActive() {
        if (this.hasConnection()) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 3);
        } else {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
        }
    }

    public void setPowerDraw(double d) {
        this.getProxy().setIdlePowerUsage(d);
    }

    public boolean setupConnection(DimensionalCoord dc) {
        if (this.hasConnection()) {
            return false;
        }
        try {
            TileEntity te = this.field_145850_b.func_147438_o(dc.x, dc.y, dc.z);
            if (te instanceof TileWirelessConnector) {
                TileWirelessConnector wc = (TileWirelessConnector)te;
                IGridNode selfNode = this.getGridNode(ForgeDirection.UNKNOWN);
                IGridNode targetNode = wc.getGridNode(ForgeDirection.UNKNOWN);
                if (selfNode != null && targetNode != null) {
                    double pw = this.getConnectionPowerDraw(dc);
                    this.connection = AEApi.instance().createGridConnection(selfNode, targetNode);
                    this.target = dc;
                    this.setPowerDraw(pw);
                    this.updateActive();
                    if (wc instanceof TileWirelessHub) {
                        TileWirelessHub wh = (TileWirelessHub)wc;
                        wh.addConnectionList(this.getLocation());
                    } else {
                        wc.connection = this.connection;
                        wc.target = this.getLocation();
                    }
                    wc.setPowerDraw(pw);
                    wc.updateActive();
                    return true;
                }
            }
        }
        catch (FailedConnection failedConnection) {
            // empty catch block
        }
        return false;
    }

    public void breakConnection() {
        if (this.hasConnection()) {
            this.connection.destroy();
            TileEntity te = this.field_145850_b.func_147438_o(this.target.x, this.target.y, this.target.z);
            if (te instanceof TileWirelessConnector) {
                TileWirelessConnector wc = (TileWirelessConnector)te;
                if (te instanceof TileWirelessHub) {
                    TileWirelessHub wh = (TileWirelessHub)te;
                    wh.removeConnectionList(this.getLocation());
                    wh.setPowerDraw(-this.getPowerUsage());
                }
                wc.cleanUp();
            }
            this.cleanUp();
        }
    }

    public void breakConnectionNoCall() {
        if (this.hasConnection()) {
            this.connection.destroy();
            this.cleanUp();
        }
    }

    public void cleanUp() {
        this.connection = null;
        this.target = null;
        this.setPowerDraw(0.0);
        this.updateActive();
    }

    private double getConnectionPowerDraw(DimensionalCoord dc) {
        int dx = this.field_145851_c - dc.x;
        int dy = this.field_145848_d - dc.y;
        int dz = this.field_145849_e - dc.z;
        double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        return AEConfig.instance.getWirelessConnectorPowerBase() + AEConfig.instance.getWirelessConnectorPowerDistanceMultiplier() * dist * Math.log(dist * dist + 3.0);
    }

    public boolean hasConnection() {
        return this.connection != null;
    }

    public DimensionalCoord getTarget() {
        return this.target;
    }

    public int getChannelUsage() {
        return this.hasConnection() ? this.connection.getUsedChannels() : 0;
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileSecurity(ByteBuf data) {
        AEColor oldColor = this.color;
        this.color = AEColor.values()[data.readByte()];
        return oldColor != this.color;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileSecurity(ByteBuf data) {
        data.writeByte(this.color.ordinal());
        this.tryRestoreConnection();
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileWirelessConnector(NBTTagCompound data) {
        data.func_74777_a("Color", (short)this.color.ordinal());
        if (this.target != null) {
            data.func_74768_a("Xc", this.target.x);
            data.func_74768_a("Yc", this.target.y);
            data.func_74768_a("Zc", this.target.z);
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileWirelessConnector(NBTTagCompound data) {
        if (data.func_74764_b("Color")) {
            this.color = AEColor.values()[data.func_74765_d("Color")];
            this.getProxy().setColor(this.color);
        }
        if (data.func_74764_b("Xc")) {
            this.target = new DimensionalCoord(data.func_74762_e("Xc"), data.func_74762_e("Yc"), data.func_74762_e("Zc"), 0);
        }
    }

    @Override
    public AEColor getColor() {
        return this.color;
    }

    public double getPowerUsage() {
        return this.getProxy().getIdlePowerUsage();
    }

    @Override
    public boolean recolourBlock(ForgeDirection side, AEColor colour, EntityPlayer who) {
        if (this.color == colour) {
            return false;
        }
        this.color = colour;
        this.getProxy().setColor(this.color);
        if (this.getGridNode(side) != null) {
            this.getGridNode(side).updateState();
        }
        this.func_70296_d();
        this.markForUpdate();
        return true;
    }

    public void madChameleonRecolor() {
        DimensionalCoord dc = this.getLocation();
        ArrayList<Integer> ic = new ArrayList<Integer>();
        int i = 0;
        for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.field_145850_b.func_147438_o(dc.x + fd.offsetX, dc.y + fd.offsetY, dc.z + fd.offsetZ);
            if (!(te instanceof TileWirelessConnector)) continue;
            TileWirelessConnector tw = (TileWirelessConnector)te;
            ic.add(tw.getColor().ordinal());
            while (ic.contains(i)) {
                ++i;
            }
        }
        AEColor colour = AEColor.values()[i];
        if (this.color == colour) {
            return;
        }
        this.color = colour;
        this.getProxy().setColor(this.color);
        if (this.getGridNode(ForgeDirection.UNKNOWN) != null) {
            this.getGridNode(ForgeDirection.UNKNOWN).updateState();
        }
        this.func_70296_d();
        this.markForUpdate();
    }

    public boolean isHub() {
        return false;
    }

    public int getFreeSlots() {
        return this.hasConnection() ? 0 : 1;
    }

    public SuperWirelessToolDataObject getDataForTool(int i) {
        return new SuperWirelessToolDataObject(i, this.hasCustomName() ? this.getCustomName() : this.func_145838_q().func_149732_F(), this.getLocation(), this.hasConnection(), this.getTarget(), this.getColor(), this.getChannelUsage(), this.isHub(), this.getFreeSlots());
    }
}

