/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Upgrades;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.ITileDefinition;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.items.IGrowableCrystal;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.IConfigManager;
import appeng.me.GridAccessException;
import appeng.parts.automation.DefinitionUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileGrower
extends AENetworkPowerTile
implements IGridTickable,
IUpgradeableHost,
IConfigManagerHost {
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 27);
    private final UpgradeInventory upgrades;
    private final IConfigManager settings;
    private final Item redstoneDust = GameRegistry.findItem((String)"minecraft", (String)"redstone");
    private final Item netherQuartz = GameRegistry.findItem((String)"minecraft", (String)"quartz");
    private final IItemDefinition chargedCertusQuartz = AEApi.instance().definitions().materials().certusQuartzCrystalCharged();
    private final IItemDefinition fluixCrystal = AEApi.instance().definitions().materials().fluixCrystal();

    public TileGrower() {
        this.setInternalMaxPower(10000.0);
        this.getProxy().setIdlePowerUsage(0.0);
        ITileDefinition growerDefinition = AEApi.instance().definitions().blocks().grower();
        this.upgrades = new DefinitionUpgradeInventory(growerDefinition, this, 3);
        this.settings = new ConfigManager(this);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileGrower(NBTTagCompound data) {
        this.inv.writeToNBT(data, "inscriberInv");
        this.upgrades.writeToNBT(data, "upgrades");
        this.settings.writeToNBT(data);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileGrower(NBTTagCompound data) {
        this.inv.readFromNBT(data, "inscriberInv");
        this.upgrades.readFromNBT(data, "upgrades");
        this.settings.readFromNBT(data);
    }

    @Override
    public void getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        super.getDrops(w, x, y, z, drops);
        for (int h = 0; h < this.upgrades.func_70302_i_(); ++h) {
            ItemStack is = this.upgrades.func_70301_a(h);
            if (is == null) continue;
            drops.add(is);
        }
    }

    @Override
    public boolean func_94041_b(int i, ItemStack is) {
        return is != null && (is.func_77973_b() instanceof IGrowableCrystal || is.func_77973_b() == this.netherQuartz || is.func_77973_b() == this.redstoneDust || this.chargedCertusQuartz.isSameAs(is));
    }

    @Override
    public boolean func_102008_b(int i, ItemStack is, int side) {
        return !this.func_94041_b(i, is);
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        try {
            if (mc != InvOperation.markDirty) {
                this.markForUpdate();
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection whichSide) {
        return new int[27];
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, true, false);
    }

    public boolean simulatePower() {
        try {
            IEnergyGrid eg = this.getProxy().getEnergy();
            IEnergySource src = this;
            int speedFactor = 1 + this.upgrades.getInstalledUpgrades(Upgrades.SPEED);
            int powerConsumption = 10 * speedFactor;
            double powerThreshold = (double)powerConsumption - 0.01;
            double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            if (powerReq <= powerThreshold) {
                src = eg;
                powerReq = eg.extractAEPower((double)powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            }
            if (powerReq > powerThreshold) {
                return true;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return false;
    }

    public void consumePower() {
        try {
            IEnergyGrid eg = this.getProxy().getEnergy();
            IEnergySource src = this;
            int speedFactor = 1 + this.upgrades.getInstalledUpgrades(Upgrades.SPEED);
            int powerConsumption = 10 * speedFactor;
            double powerThreshold = (double)powerConsumption - 0.01;
            double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            if (powerReq <= powerThreshold) {
                src = eg;
                powerReq = eg.extractAEPower((double)powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            }
            if (powerReq > powerThreshold) {
                src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        boolean hasWork = false;
        if (this.simulatePower()) {
            for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
                ItemStack is = this.inv.func_70301_a(i);
                if (is == null) continue;
                Item item = is.func_77973_b();
                if (item instanceof IGrowableCrystal) {
                    IGrowableCrystal gc = (IGrowableCrystal)item;
                    ItemStack ns = null;
                    for (int j = 0; j < 1 + this.getInstalledUpgrades(Upgrades.SPEED); ++j) {
                        ns = gc.triggerGrowth(is);
                    }
                    this.func_70299_a(i, ns);
                    hasWork = true;
                    continue;
                }
                if (!this.chargedCertusQuartz.isSameAs(is)) continue;
                int redstonePos = -1;
                int netherPos = -1;
                boolean found = false;
                for (int j = 0; j < this.inv.func_70302_i_(); ++j) {
                    ItemStack isTemp = this.inv.func_70301_a(j);
                    if (isTemp != null) {
                        if (isTemp.func_77973_b() == this.redstoneDust) {
                            redstonePos = j;
                        } else if (isTemp.func_77973_b() == this.netherQuartz) {
                            netherPos = j;
                        }
                    }
                    if (redstonePos <= -1 || netherPos <= -1) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                int slot = -1;
                for (int j = 0; j < this.inv.func_70302_i_(); ++j) {
                    ItemStack isTemp = this.inv.func_70301_a(j);
                    if (isTemp != null) {
                        if (!this.fluixCrystal.isSameAs(isTemp) || isTemp.field_77994_a >= 64) continue;
                        slot = j;
                        break;
                    }
                    if (slot >= 0) continue;
                    slot = j;
                }
                if (slot <= -1) continue;
                this.func_70298_a(i, 1);
                this.func_70298_a(netherPos, 1);
                this.func_70298_a(redstonePos, 1);
                if (this.inv.func_70301_a(slot) != null) {
                    this.func_70298_a(slot, -2);
                } else {
                    this.func_70299_a(slot, (ItemStack)this.fluixCrystal.maybeStack(2).get());
                }
                hasWork = true;
            }
        } else {
            return TickRateModulation.SLOWER;
        }
        if (hasWork) {
            this.consumePower();
        }
        this.updateMeta(hasWork);
        return hasWork ? TickRateModulation.URGENT : TickRateModulation.SLEEP;
    }

    private void updateMeta(boolean hasWork) {
        if (hasWork) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 3);
        } else {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
        }
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.settings;
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("inv")) {
            return this.inv;
        }
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }
}

