/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SuperWirelessTool;
import appeng.api.config.SuperWirelessToolAdvanced;
import appeng.api.config.SuperWirelessToolGroupBy;
import appeng.api.config.YesNo;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.networking.IGridHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.core.features.AEFeature;
import appeng.core.sync.GuiBridge;
import appeng.items.AEBaseItem;
import appeng.items.contents.SuperWirelessKitObject;
import appeng.tile.networking.TileWirelessConnector;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ToolSuperWirelessKit
extends AEBaseItem
implements IGuiItem {
    public ToolSuperWirelessKit() {
        this.setFeature(EnumSet.of(AEFeature.Core));
        this.func_77625_d(1);
    }

    public void func_77663_a(ItemStack is, World w, Entity e, int p_77663_4_, boolean p_77663_5_) {
        if (!is.func_77942_o()) {
            this.setCleanNBT(is);
        }
    }

    private void setCleanNBT(ItemStack is) {
        NBTTagCompound newNBT = new NBTTagCompound();
        newNBT.func_74782_a("simple", (NBTBase)new NBTTagCompound());
        newNBT.func_74782_a("advanced", (NBTBase)new NBTTagCompound());
        NBTTagCompound newTag = new NBTTagCompound();
        newTag.func_74782_a("pins", (NBTBase)new NBTTagList());
        newTag.func_74782_a("names", (NBTBase)new NBTTagList());
        newTag.func_74782_a("pos", (NBTBase)new NBTTagCompound());
        newNBT.func_74782_a("super", (NBTBase)newTag);
        is.func_77982_d(newNBT);
    }

    public ItemStack func_77659_a(ItemStack is, World w, EntityPlayer p) {
        if (Platform.isServer()) {
            if (Platform.keyBindTab.isKeyDown(p)) {
                IConfigManager cm = ToolSuperWirelessKit.getConfigManager(is);
                Enum<?> newState = Platform.rotateEnum(cm.getSetting(Settings.SUPER_WIRELESS_TOOL), false, Settings.SUPER_WIRELESS_TOOL.getPossibleValues());
                cm.putSetting(Settings.SUPER_WIRELESS_TOOL, newState);
                p.func_145747_a((IChatComponent)new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.set", new Object[]{EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)("item.appliedenergistics2.ToolSuperWirelessKit.mode." + newState.toString().toLowerCase(Locale.US)))}));
            } else {
                SuperWirelessTool mode = (SuperWirelessTool)ToolSuperWirelessKit.getConfigManager(is).getSetting(Settings.SUPER_WIRELESS_TOOL);
                if (p.func_70093_af() && Platform.keyBindLCtrl.isKeyDown(p)) {
                    switch (mode) {
                        case Simple: {
                            is.func_77978_p().func_74782_a("simple", (NBTBase)new NBTTagCompound());
                            break;
                        }
                        case Advanced: {
                            is.func_77978_p().func_74782_a("advanced", (NBTBase)new NBTTagCompound());
                            break;
                        }
                        case Super: {
                            NBTTagCompound newTag = new NBTTagCompound();
                            newTag.func_74782_a("pins", (NBTBase)new NBTTagList());
                            newTag.func_74782_a("names", (NBTBase)new NBTTagList());
                            newTag.func_74782_a("pos", (NBTBase)new NBTTagCompound());
                            is.func_77978_p().func_74782_a("super", (NBTBase)newTag);
                        }
                    }
                    p.func_145747_a((IChatComponent)new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.empty", new Object[]{EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)("item.appliedenergistics2.ToolSuperWirelessKit.mode." + mode.toString().toLowerCase(Locale.US)))}));
                } else if (p.func_70093_af() && mode == SuperWirelessTool.Advanced) {
                    IConfigManager cm = ToolSuperWirelessKit.getConfigManager(is);
                    Enum<?> newState = Platform.rotateEnum(cm.getSetting(Settings.SUPER_WIRELESS_TOOL_ADVANCED), false, Settings.SUPER_WIRELESS_TOOL_ADVANCED.getPossibleValues());
                    cm.putSetting(Settings.SUPER_WIRELESS_TOOL_ADVANCED, newState);
                    p.func_145747_a((IChatComponent)new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.mode.advanced." + newState.toString().toLowerCase(Locale.US) + ".activated", new Object[0]));
                } else if (mode == SuperWirelessTool.Super) {
                    Platform.openGUI(p, null, ForgeDirection.UNKNOWN, GuiBridge.GUI_SUPER_WIRELESS_KIT);
                }
            }
        }
        return is;
    }

    public boolean performConnection(TileWirelessConnector wc, DimensionalCoord dc, EntityPlayer p) {
        if (wc.getLocation().getDimension() == dc.getDimension()) {
            if (wc.isHub() && wc.getFreeSlots() == 0) {
                p.func_145747_a((IChatComponent)new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.mode.simple.bound.targethubfull", new Object[0]));
                return false;
            }
            if (wc.setupConnection(dc)) {
                p.func_145747_a(new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.connected", new Object[]{dc.x, dc.y, dc.z}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN)));
                return true;
            }
            p.func_145747_a(new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.failed", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
        } else {
            p.func_145747_a((IChatComponent)new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.dimension", new Object[0]));
        }
        return false;
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer p, World w, int x, int y, int z, int side, float xOff, float yOff, float zOff) {
        if (Platform.isServer()) {
            SuperWirelessTool mode = (SuperWirelessTool)ToolSuperWirelessKit.getConfigManager(is).getSetting(Settings.SUPER_WIRELESS_TOOL);
            TileEntity te = w.func_147438_o(x, y, z);
            if (!(te instanceof IGridHost)) {
                return false;
            }
            IGridHost gh = (IGridHost)te;
            if (!((ISecurityGrid)gh.getGridNode(ForgeDirection.UNKNOWN).getGrid().getCache(ISecurityGrid.class)).hasPermission(p, SecurityPermissions.BUILD)) {
                p.func_145747_a((IChatComponent)new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.security.player", new Object[0]));
                return false;
            }
            switch (mode) {
                case Simple: {
                    if (!(te instanceof TileWirelessConnector)) break;
                    TileWirelessConnector wc = (TileWirelessConnector)te;
                    NBTTagCompound tag = is.func_77978_p().func_74775_l("simple");
                    if (tag.func_82582_d()) {
                        DimensionalCoord dc = wc.getLocation();
                        dc.writeToNBT(tag);
                        is.func_77978_p().func_74782_a("simple", (NBTBase)tag);
                        p.func_145747_a(new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.bound", new Object[]{dc.x, dc.y, dc.z}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN)));
                        break;
                    }
                    DimensionalCoord dc = DimensionalCoord.readFromNBT(tag);
                    if (!this.performConnection(wc, dc, p)) break;
                    is.func_77978_p().func_74782_a("simple", (NBTBase)new NBTTagCompound());
                    return true;
                }
                case Advanced: {
                    if (!(te instanceof TileWirelessConnector)) break;
                    TileWirelessConnector wc = (TileWirelessConnector)te;
                    DimensionalCoord sdc = wc.getLocation();
                    List<DimensionalCoord> dcl = DimensionalCoord.readAsListFromNBT(is.func_77978_p().func_74775_l("advanced"));
                    SuperWirelessToolAdvanced mod = (SuperWirelessToolAdvanced)ToolSuperWirelessKit.getConfigManager(is).getSetting(Settings.SUPER_WIRELESS_TOOL_ADVANCED);
                    if (mod == SuperWirelessToolAdvanced.Queueing) {
                        int j = 0;
                        for (DimensionalCoord sdcl : dcl) {
                            if (!sdc.isEqual(sdcl)) continue;
                            if (wc.isHub()) {
                                if (j <= wc.getFreeSlots()) continue;
                                p.func_145747_a(new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.bound.advanced.filled", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                                return false;
                            }
                            p.func_145747_a(new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.bound.advanced.filled", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                            return false;
                        }
                        if (Platform.keyBindLCtrl.isKeyDown(p) && wc.isHub()) {
                            int i;
                            for (i = 0; i < wc.getFreeSlots(); ++i) {
                                dcl.add(new DimensionalCoord(te));
                            }
                            p.func_145747_a((IChatComponent)new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.mode.advanced.queueing.hub", new Object[]{i}));
                        } else {
                            dcl.add(new DimensionalCoord(te));
                            p.func_145747_a((IChatComponent)new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.mode.advanced.queued", new Object[]{x, y, z}));
                        }
                        DimensionalCoord.writeListToNBT(is.func_77978_p().func_74775_l("advanced"), dcl);
                        return true;
                    }
                    if (dcl.isEmpty()) {
                        p.func_145747_a((IChatComponent)new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.mode.advanced.noconnectors", new Object[0]));
                        return false;
                    }
                    DimensionalCoord dc = dcl.get(0);
                    if (wc.getLocation().getDimension() != dc.getDimension()) {
                        p.func_145747_a((IChatComponent)new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.dimension", new Object[0]));
                        return false;
                    }
                    if (Platform.keyBindLCtrl.isKeyDown(p) && wc.isHub()) {
                        int i = 0;
                        while (wc.getFreeSlots() != 0 && !dcl.isEmpty() && this.performConnection(wc, dcl.get(0), p)) {
                            dcl.remove(0);
                            ++i;
                        }
                        p.func_145747_a((IChatComponent)new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.mode.advanced.binding.hub", new Object[]{i}));
                    } else if (this.performConnection(wc, dc, p)) {
                        dcl.remove(0);
                    }
                    NBTTagCompound tag = new NBTTagCompound();
                    DimensionalCoord.writeListToNBT(tag, dcl);
                    is.func_77978_p().func_74782_a("advanced", (NBTBase)tag);
                    break;
                }
                case Super: {
                    IGridHost igh = (IGridHost)te;
                    if (!is.func_77978_p().func_74764_b("super")) {
                        NBTTagCompound newTag = new NBTTagCompound();
                        newTag.func_74782_a("pins", (NBTBase)new NBTTagList());
                        newTag.func_74782_a("names", (NBTBase)new NBTTagList());
                        newTag.func_74782_a("pos", (NBTBase)new NBTTagCompound());
                        is.func_77978_p().func_74782_a("super", (NBTBase)newTag);
                    }
                    NBTTagCompound tag = is.func_77978_p().func_74775_l("super").func_74775_l("pos");
                    List<DimensionalCoord> dcl = DimensionalCoord.readAsListFromNBT(tag);
                    for (int i = 0; i < dcl.size(); ++i) {
                        DimensionalCoord dc = dcl.get(i);
                        TileEntity TempTe = w.func_147438_o(dc.x, dc.y, dc.z);
                        if (!(TempTe instanceof IGridHost)) continue;
                        IGridHost igh1 = (IGridHost)TempTe;
                        if (igh.getGridNode(ForgeDirection.UNKNOWN).getGrid() != igh1.getGridNode(ForgeDirection.UNKNOWN).getGrid()) continue;
                        p.func_145747_a(new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.bound.super.failed", new Object[]{i}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                        return false;
                    }
                    p.func_145747_a(new ChatComponentTranslation("item.appliedenergistics2.ToolSuperWirelessKit.bound.super", new Object[]{x, y, z, dcl.size() + 1}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN)));
                    dcl.add(new DimensionalCoord(te));
                    DimensionalCoord.writeListToNBT(tag, dcl);
                }
            }
        }
        return true;
    }

    public static IConfigManager getConfigManager(ItemStack target) {
        ConfigManager out = new ConfigManager((manager, settingName, newValue) -> {
            NBTTagCompound data = Platform.openNbtData(target);
            manager.writeToNBT(data);
        });
        out.registerSetting(Settings.SUPER_WIRELESS_TOOL, (Enum)SuperWirelessTool.Simple);
        out.registerSetting(Settings.SUPER_WIRELESS_TOOL_GROUP_BY, (Enum)SuperWirelessToolGroupBy.Single);
        out.registerSetting(Settings.SUPER_WIRELESS_TOOL_HIDE_BOUNDED, (Enum)YesNo.NO);
        out.registerSetting(Settings.SUPER_WIRELESS_TOOL_ADVANCED, (Enum)SuperWirelessToolAdvanced.Queueing);
        out.readFromNBT((NBTTagCompound)Platform.openNbtData(target).func_74737_b());
        return out;
    }

    @Override
    protected void addCheckedInformation(ItemStack is, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        SuperWirelessTool mode = (SuperWirelessTool)ToolSuperWirelessKit.getConfigManager(is).getSetting(Settings.SUPER_WIRELESS_TOOL);
        lines.add(StatCollector.func_74838_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.mode") + " " + EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)("item.appliedenergistics2.ToolSuperWirelessKit.mode." + mode.toString().toLowerCase(Locale.US))));
        lines.add(StatCollector.func_74838_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.clear"));
        switch (mode) {
            case Simple: {
                if (is.func_77978_p().func_74775_l("simple").func_82582_d()) {
                    lines.add(StatCollector.func_74838_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.mode.simple.empty"));
                    break;
                }
                DimensionalCoord dc = DimensionalCoord.readFromNBT(is.func_77978_p().func_74775_l("simple"));
                lines.add(StatCollector.func_74837_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.bound", (Object[])new Object[]{dc.x, dc.y, dc.z}));
                lines.add(StatCollector.func_74838_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.mode.simple.bound"));
                break;
            }
            case Advanced: {
                List<DimensionalCoord> dcl = DimensionalCoord.readAsListFromNBT(is.func_77978_p().func_74775_l("advanced"));
                lines.add(StatCollector.func_74838_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.mode.advanced.extra"));
                if (!dcl.isEmpty()) {
                    lines.add(StatCollector.func_74837_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.mode.advanced.next", (Object[])new Object[]{dcl.get((int)0).x, dcl.get((int)0).y, dcl.get((int)0).z}));
                }
                if (ToolSuperWirelessKit.getConfigManager(is).getSetting(Settings.SUPER_WIRELESS_TOOL_ADVANCED) == SuperWirelessToolAdvanced.Queueing) {
                    lines.add(StatCollector.func_74838_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.mode.advanced.queueing"));
                    lines.add(StatCollector.func_74838_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.mode.advanced.queueing.hubqols"));
                    if (dcl.isEmpty()) {
                        lines.add(StatCollector.func_74838_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.mode.advanced.queueing.empty"));
                        break;
                    }
                    lines.add(StatCollector.func_74838_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.mode.advanced.queueing.notempty"));
                    for (DimensionalCoord dc : dcl) {
                        lines.add(dc.x + "," + dc.y + "," + dc.z);
                    }
                } else {
                    lines.add(StatCollector.func_74838_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.mode.advanced.binding"));
                    lines.add(StatCollector.func_74838_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.mode.advanced.binding.hubqols"));
                    if (dcl.isEmpty()) {
                        lines.add(StatCollector.func_74838_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.mode.advanced.binding.empty"));
                        break;
                    }
                    lines.add(StatCollector.func_74838_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.mode.advanced.binding.notempty"));
                    for (DimensionalCoord dc : dcl) {
                        lines.add(dc.x + "," + dc.y + "," + dc.z);
                    }
                }
                break;
            }
            case Super: {
                NBTTagCompound stash = is.func_77978_p().func_74775_l("super");
                List<DimensionalCoord> dcl = DimensionalCoord.readAsListFromNBT((NBTTagCompound)stash.func_74781_a("pos"));
                if (dcl.isEmpty()) {
                    lines.add(StatCollector.func_74838_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.mode.super.networklistempty"));
                    break;
                }
                NBTTagList tagList = stash.func_150295_c("names", 10);
                lines.add(StatCollector.func_74838_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.mode.super.networklist"));
                for (int i = 0; i < dcl.size(); ++i) {
                    DimensionalCoord dc = dcl.get(i);
                    String customName = "";
                    for (int j = 0; j < tagList.func_74745_c(); ++j) {
                        NBTTagCompound tag = tagList.func_150305_b(i);
                        if (tag.func_74762_e("network") != i || !tag.func_74764_b("networkName")) continue;
                        customName = tag.func_74779_i("networkName");
                        break;
                    }
                    lines.add(StatCollector.func_74837_a((String)"item.appliedenergistics2.ToolSuperWirelessKit.mode.super.network", (Object[])new Object[]{customName.isEmpty() ? String.valueOf(i) : customName, dc.x, dc.y, dc.z}));
                }
                break;
            }
        }
    }

    @Override
    public IGuiItemObject getGuiObject(ItemStack is, World world, int x, int y, int z) {
        return new SuperWirelessKitObject(is, world);
    }
}

