/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila;

import appeng.helpers.ICustomNameObject;
import appeng.integration.modules.waila.tile.ChargerWailaDataProvider;
import appeng.integration.modules.waila.tile.CraftingMonitorWailaDataProvider;
import appeng.integration.modules.waila.tile.InterfaceDataProvider;
import appeng.integration.modules.waila.tile.PowerStateWailaDataProvider;
import appeng.integration.modules.waila.tile.PowerStorageWailaDataProvider;
import appeng.integration.modules.waila.tile.WirelessDataProvider;
import com.google.common.collect.Lists;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public final class TileWailaDataProvider
implements IWailaDataProvider {
    private static final String NBT_TILE_CUSTOM_NAME = "tileCustomName";
    private final List<IWailaDataProvider> providers;

    public TileWailaDataProvider() {
        ChargerWailaDataProvider charger = new ChargerWailaDataProvider();
        PowerStorageWailaDataProvider energyCell = new PowerStorageWailaDataProvider();
        PowerStateWailaDataProvider craftingBlock = new PowerStateWailaDataProvider();
        CraftingMonitorWailaDataProvider craftingMonitor = new CraftingMonitorWailaDataProvider();
        InterfaceDataProvider interfaceBlock = new InterfaceDataProvider();
        WirelessDataProvider wireless = new WirelessDataProvider();
        this.providers = Lists.newArrayList((Object[])new IWailaDataProvider[]{charger, energyCell, craftingBlock, craftingMonitor, interfaceBlock, wireless});
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        for (IWailaDataProvider provider : this.providers) {
            provider.getWailaHead(itemStack, currentToolTip, accessor, config);
        }
        return currentToolTip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        for (IWailaDataProvider provider : this.providers) {
            provider.getWailaBody(itemStack, currentToolTip, accessor, config);
        }
        if (accessor.getNBTData().func_74764_b(NBT_TILE_CUSTOM_NAME)) {
            currentToolTip.add(EnumChatFormatting.WHITE.toString() + EnumChatFormatting.ITALIC + accessor.getNBTData().func_74779_i(NBT_TILE_CUSTOM_NAME));
        }
        return currentToolTip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        for (IWailaDataProvider provider : this.providers) {
            provider.getWailaTail(itemStack, currentToolTip, accessor, config);
        }
        return currentToolTip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        ICustomNameObject customNameObject;
        for (IWailaDataProvider provider : this.providers) {
            provider.getNBTData(player, te, tag, world, x, y, z);
        }
        if (te instanceof ICustomNameObject && (customNameObject = (ICustomNameObject)te).hasCustomName() && !customNameObject.getCustomName().isEmpty()) {
            tag.func_74778_a(NBT_TILE_CUSTOM_NAME, customNameObject.getCustomName());
        }
        return tag;
    }
}

