/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.Settings;
import appeng.api.config.SuperWirelessToolGroupBy;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.container.AEBaseContainer;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketSuperWirelessToolData;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.SuperWirelessToolDataObject;
import appeng.items.contents.SuperWirelessKitObject;
import appeng.tile.networking.TileWirelessConnector;
import appeng.tile.networking.TileWirelessHub;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ContainerSuperWirelessKit
extends AEBaseContainer
implements IConfigManagerHost,
IConfigurableObject {
    private final SuperWirelessKitObject toolInv;
    private final IConfigManager clientCM;
    private IConfigManager serverCM;
    private IConfigManagerHost gui;
    private final ArrayList<SuperWirelessToolDataObject> data = new ArrayList();

    public ContainerSuperWirelessKit(InventoryPlayer ip, SuperWirelessKitObject te) {
        super(ip, null, null);
        this.toolInv = te;
        this.clientCM = new ConfigManager(this);
        this.clientCM.registerSetting(Settings.SUPER_WIRELESS_TOOL_GROUP_BY, SuperWirelessToolGroupBy.Single);
        this.clientCM.registerSetting(Settings.SUPER_WIRELESS_TOOL_HIDE_BOUNDED, YesNo.NO);
        if (Platform.isServer()) {
            this.serverCM = te.getConfigManager();
        }
        this.bindPlayerInventory(ip, -1000, -1000);
    }

    @Override
    public void func_75142_b() {
        ItemStack currentItem;
        if (Platform.isServer()) {
            for (Settings set : this.serverCM.getSettings()) {
                Enum<?> sideRemote;
                Enum<?> sideLocal = this.serverCM.getSetting(set);
                if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
                this.clientCM.putSetting(set, sideLocal);
                for (Object crafter : this.field_75149_d) {
                    try {
                        NetworkHandler.instance.sendTo(new PacketValueConfig(set.name(), sideLocal.name()), (EntityPlayerMP)crafter);
                    }
                    catch (IOException e) {
                        AELog.debug(e);
                    }
                }
            }
        }
        if ((currentItem = this.getPlayerInv().func_70448_g()) != this.toolInv.getItemStack()) {
            if (currentItem != null) {
                if (Platform.isSameItem(this.toolInv.getItemStack(), currentItem)) {
                    this.getPlayerInv().func_70299_a(this.getPlayerInv().field_70461_c, this.toolInv.getItemStack());
                } else {
                    this.setValidContainer(false);
                }
            } else {
                this.setValidContainer(false);
            }
        }
    }

    @Override
    public Object getTarget() {
        return this;
    }

    private IConfigManagerHost getGui() {
        return this.gui;
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        if (Platform.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public void func_75132_a(ICrafting p_75132_1_) {
        super.func_75132_a(p_75132_1_);
        this.updateData();
    }

    public void updateData() {
        NBTTagCompound stash = this.toolInv.getItemStack().func_77978_p().func_74775_l("super");
        List<DimensionalCoord> dcl = DimensionalCoord.readAsListFromNBT((NBTTagCompound)stash.func_74781_a("pos"));
        World w = this.toolInv.getWorld();
        this.data.clear();
        for (int i = 0; i < dcl.size(); ++i) {
            TileWirelessConnector wc;
            Object object;
            if (w.field_73011_w.field_76574_g != dcl.get(i).getDimension() || !((object = w.func_147438_o(dcl.get((int)i).x, dcl.get((int)i).y, dcl.get((int)i).z)) instanceof IGridHost)) continue;
            IGridHost gh = (IGridHost)object;
            for (IGridNode gn : gh.getGridNode(ForgeDirection.UNKNOWN).getGrid().getMachines(TileWirelessConnector.class)) {
                wc = (TileWirelessConnector)gn.getMachine();
                this.data.add(wc.getDataForTool(i));
            }
            object = gh.getGridNode(ForgeDirection.UNKNOWN).getGrid().getMachines(TileWirelessHub.class).iterator();
            while (object.hasNext()) {
                IGridNode gn;
                gn = (IGridNode)object.next();
                wc = (TileWirelessHub)gn.getMachine();
                this.data.add(wc.getDataForTool(i));
            }
        }
        NBTTagCompound nbtData = new NBTTagCompound();
        SuperWirelessToolDataObject.writeToNBTasList(this.data, nbtData);
        nbtData.func_74782_a("pins", (NBTBase)stash.func_150295_c("pins", 10));
        nbtData.func_74782_a("names", (NBTBase)stash.func_150295_c("names", 10));
        if (!nbtData.func_82582_d()) {
            for (ICrafting crafter : this.field_75149_d) {
                EntityPlayerMP emp = (EntityPlayerMP)crafter;
                try {
                    NetworkHandler.instance.sendTo(new PacketSuperWirelessToolData(nbtData), emp);
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void processCommand(NBTTagCompound command) {
        World w = this.toolInv.getWorld();
        NBTTagCompound stash = this.toolInv.getItemStack().func_77978_p().func_74775_l("super");
        switch (command.func_74779_i("command")) {
            case "renameSingle": {
                DimensionalCoord cord = DimensionalCoord.readFromNBT(command.func_74775_l("cord"));
                TileEntity te = w.func_147438_o(cord.x, cord.y, cord.z);
                if (!(te instanceof TileWirelessConnector)) break;
                TileWirelessConnector twc = (TileWirelessConnector)te;
                twc.setCustomName(command.func_74779_i("name"));
                break;
            }
            case "renameGroup": {
                String newName = command.func_74779_i("name");
                int network = command.func_74762_e("network");
                boolean isByColor = command.func_74764_b("color");
                int color = command.func_74762_e("color");
                NBTTagList names = stash.func_150295_c("names", 10);
                boolean noData = true;
                for (int i = 0; i < names.func_74745_c(); ++i) {
                    NBTTagCompound name = names.func_150305_b(i);
                    if (isByColor) {
                        if (!name.func_74764_b("network") || network != name.func_74762_e("network") || !name.func_74764_b("color") || name.func_74762_e("color") != color) continue;
                        name.func_74778_a("colorName", newName);
                        noData = false;
                        break;
                    }
                    if (name.func_74764_b("color") || !name.func_74764_b("network") || network != name.func_74762_e("network")) continue;
                    name.func_74778_a("networkName", newName);
                    noData = false;
                    break;
                }
                if (noData) {
                    if (command.func_74764_b("color")) {
                        NBTTagCompound name = new NBTTagCompound();
                        name.func_74768_a("network", network);
                        name.func_74768_a("color", color);
                        name.func_74778_a("colorName", newName);
                        names.func_74742_a((NBTBase)name);
                    } else {
                        NBTTagCompound pin = new NBTTagCompound();
                        pin.func_74768_a("network", network);
                        pin.func_74778_a("networkName", newName);
                        names.func_74742_a((NBTBase)pin);
                    }
                }
                stash.func_74782_a("names", (NBTBase)names);
                this.updateData();
                break;
            }
            case "pin": {
                int network = command.func_74762_e("network");
                int color = command.func_74762_e("color");
                NBTTagCompound cord = command.func_74775_l("cord");
                String type = command.func_74779_i("type");
                boolean pinMode = command.func_74767_n("pin");
                NBTTagList tgl = stash.func_150295_c("pins", 10);
                command.func_82580_o("command");
                command.func_82580_o("pin");
                boolean noTag = true;
                for (int i = 0; i < tgl.func_74745_c(); ++i) {
                    boolean toBreak = false;
                    switch (type) {
                        case "single": {
                            if (pinMode) {
                                toBreak = true;
                            }
                            if (!tgl.func_150305_b(i).func_74775_l("cord").equals((Object)cord)) break;
                            tgl.func_74744_a(i);
                            toBreak = true;
                            break;
                        }
                        case "network": {
                            if (tgl.func_150305_b(i).func_74762_e("network") != network) break;
                            if (pinMode) {
                                tgl.func_150304_a(i, (NBTBase)command);
                                noTag = false;
                            } else {
                                tgl.func_74744_a(i);
                            }
                            toBreak = true;
                            break;
                        }
                        case "color": {
                            if (tgl.func_150305_b(i).func_74762_e("network") != network || tgl.func_150305_b(i).func_74762_e("color") != color) break;
                            if (pinMode) {
                                tgl.func_150304_a(i, (NBTBase)command);
                                noTag = false;
                            } else {
                                tgl.func_74744_a(i);
                            }
                            toBreak = true;
                        }
                    }
                    if (toBreak) break;
                }
                if (!noTag || !pinMode) break;
                tgl.func_74742_a((NBTBase)command);
                break;
            }
            case "delete": {
                int nbt_network;
                int i;
                int nbt_network2;
                int i2;
                NBTTagList pins = stash.func_150295_c("pins", 10);
                int network = command.func_74762_e("network");
                for (i2 = 0; i2 < pins.func_74745_c(); ++i2) {
                    nbt_network2 = pins.func_150305_b(i2).func_74762_e("network");
                    if (nbt_network2 != network) continue;
                    pins.func_74744_a(i2);
                }
                for (i2 = 0; i2 < pins.func_74745_c(); ++i2) {
                    nbt_network2 = pins.func_150305_b(i2).func_74762_e("network");
                    if (nbt_network2 <= network) continue;
                    pins.func_150305_b(i2).func_74768_a("network", nbt_network2 - 1);
                }
                NBTTagList names = stash.func_150295_c("names", 10);
                for (i = 0; i < names.func_74745_c(); ++i) {
                    nbt_network = names.func_150305_b(i).func_74762_e("network");
                    if (nbt_network != network) continue;
                    names.func_74744_a(i);
                }
                for (i = 0; i < names.func_74745_c(); ++i) {
                    nbt_network = names.func_150305_b(i).func_74762_e("network");
                    if (nbt_network <= network) continue;
                    names.func_150305_b(i).func_74768_a("network", nbt_network - 1);
                }
                NBTTagCompound pos = stash.func_74775_l("pos");
                List<DimensionalCoord> dcl = DimensionalCoord.readAsListFromNBT(pos);
                for (int i3 = 0; i3 < dcl.size(); ++i3) {
                    if (i3 != network) continue;
                    dcl.remove(i3);
                    break;
                }
                NBTTagCompound newPos = new NBTTagCompound();
                DimensionalCoord.writeListToNBT(newPos, dcl);
                stash.func_74782_a("pos", (NBTBase)newPos);
                this.updateData();
                break;
            }
            case "recolor": {
                AEColor color;
                AEColor aEColor = color = command.func_74762_e("color") != -1 ? AEColor.values()[command.func_74762_e("color")] : null;
                if (command.func_74764_b("cords")) {
                    List<DimensionalCoord> dc = DimensionalCoord.readAsListFromNBT((NBTTagCompound)command.func_74781_a("cords"));
                    for (DimensionalCoord sdc : dc) {
                        TileEntity te = w.func_147438_o(sdc.x, sdc.y, sdc.z);
                        if (!(te instanceof TileWirelessConnector)) continue;
                        TileWirelessConnector tw = (TileWirelessConnector)te;
                        if (color != null) {
                            tw.recolourBlock(ForgeDirection.UNKNOWN, color, this.getPlayerInv().field_70458_d);
                            continue;
                        }
                        tw.madChameleonRecolor();
                    }
                }
                if (command.func_74764_b("group")) {
                    NBTTagList tagList = command.func_150295_c("group", 10);
                    int[] networksCache = new int[tagList.func_74745_c()];
                    AEColor[] colorsCache = new AEColor[tagList.func_74745_c()];
                    for (int i = 0; i < tagList.func_74745_c(); ++i) {
                        NBTTagCompound tag = tagList.func_150305_b(i);
                        networksCache[i] = tag.func_74762_e("network");
                        if (!tag.func_74764_b("color")) continue;
                        colorsCache[i] = AEColor.values()[tag.func_74762_e("color")];
                    }
                    for (SuperWirelessToolDataObject sd : this.data) {
                        for (int i = 0; i < networksCache.length; ++i) {
                            TileWirelessConnector tw;
                            TileEntity te;
                            if (networksCache[i] != sd.network) continue;
                            if (colorsCache[i] != null) {
                                if (sd.color != colorsCache[i] || !((te = w.func_147438_o(sd.cord.x, sd.cord.y, sd.cord.z)) instanceof TileWirelessConnector)) continue;
                                tw = (TileWirelessConnector)te;
                                if (color != null) {
                                    tw.recolourBlock(ForgeDirection.UNKNOWN, color, this.getPlayerInv().field_70458_d);
                                    continue;
                                }
                                tw.madChameleonRecolor();
                                continue;
                            }
                            te = w.func_147438_o(sd.cord.x, sd.cord.y, sd.cord.z);
                            if (!(te instanceof TileWirelessConnector)) continue;
                            tw = (TileWirelessConnector)te;
                            if (color != null) {
                                tw.recolourBlock(ForgeDirection.UNKNOWN, color, this.getPlayerInv().field_70458_d);
                                continue;
                            }
                            tw.madChameleonRecolor();
                        }
                    }
                }
                this.updateData();
                break;
            }
            case "bind": {
                int i;
                Object object;
                List<DimensionalCoord> networks = DimensionalCoord.readAsListFromNBT((NBTTagCompound)stash.func_74781_a("pos"));
                NBTTagList toBind = command.func_150295_c("toBind", 10);
                ArrayList<TileWirelessConnector> twToBind = new ArrayList<TileWirelessConnector>();
                for (int i4 = 0; i4 < toBind.func_74745_c(); ++i4) {
                    TileWirelessConnector wc;
                    AEColor color;
                    NBTTagCompound tag = toBind.func_150305_b(i4);
                    if (tag.func_74764_b("cord")) {
                        DimensionalCoord dc = DimensionalCoord.readFromNBT(tag.func_74775_l("cord"));
                        TileEntity te = w.func_147438_o(dc.x, dc.y, dc.z);
                        if (!(te instanceof TileWirelessConnector)) continue;
                        TileWirelessConnector wc2 = (TileWirelessConnector)te;
                        twToBind.add(wc2);
                        continue;
                    }
                    int network = tag.func_74762_e("network");
                    AEColor aEColor = color = tag.func_74764_b("color") ? AEColor.values()[tag.func_74762_e("color")] : null;
                    if (networks.size() < network) continue;
                    DimensionalCoord dc = networks.get(network);
                    object = w.func_147438_o(dc.x, dc.y, dc.z);
                    if (!(object instanceof IGridHost)) continue;
                    IGridHost gh = (IGridHost)object;
                    if (!tag.func_74764_b("incCon")) {
                        for (IGridNode gn : gh.getGridNode(ForgeDirection.UNKNOWN).getGrid().getMachines(TileWirelessConnector.class)) {
                            wc = (TileWirelessConnector)gn.getMachine();
                            if (wc.hasConnection()) continue;
                            if (color != null) {
                                if (wc.getColor() != color) continue;
                                twToBind.add(wc);
                                continue;
                            }
                            twToBind.add(wc);
                        }
                    }
                    if (tag.func_74764_b("incHub")) continue;
                    for (IGridNode gn : gh.getGridNode(ForgeDirection.UNKNOWN).getGrid().getMachines(TileWirelessHub.class)) {
                        wc = (TileWirelessHub)gn.getMachine();
                        if (((TileWirelessHub)wc).getFreeSlots() <= 0) continue;
                        if (color != null) {
                            if (wc.getColor() != color) continue;
                            twToBind.add(wc);
                            continue;
                        }
                        twToBind.add(wc);
                    }
                }
                NBTTagList target = command.func_150295_c("target", 10);
                ArrayList<TileWirelessConnector> twTarget = new ArrayList<TileWirelessConnector>();
                for (i = 0; i < target.func_74745_c(); ++i) {
                    TileWirelessConnector wc;
                    AEColor color;
                    NBTTagCompound tag = target.func_150305_b(i);
                    if (tag.func_74764_b("cord")) {
                        DimensionalCoord dc = DimensionalCoord.readFromNBT(tag.func_74775_l("cord"));
                        object = w.func_147438_o(dc.x, dc.y, dc.z);
                        if (!(object instanceof TileWirelessConnector)) continue;
                        TileWirelessConnector wc3 = (TileWirelessConnector)object;
                        twTarget.add(wc3);
                        continue;
                    }
                    int network = tag.func_74762_e("network");
                    AEColor aEColor = color = tag.func_74764_b("color") ? AEColor.values()[tag.func_74762_e("color")] : null;
                    if (networks.size() < network) continue;
                    DimensionalCoord dc = networks.get(network);
                    TileEntity tileEntity = w.func_147438_o(dc.x, dc.y, dc.z);
                    if (!(tileEntity instanceof IGridHost)) continue;
                    IGridHost gh = (IGridHost)tileEntity;
                    if (!tag.func_74764_b("incCon")) {
                        for (IGridNode gn : gh.getGridNode(ForgeDirection.UNKNOWN).getGrid().getMachines(TileWirelessConnector.class)) {
                            wc = (TileWirelessConnector)gn.getMachine();
                            if (wc.hasConnection()) continue;
                            if (color != null) {
                                if (wc.getColor() != color) continue;
                                twTarget.add(wc);
                                continue;
                            }
                            twTarget.add(wc);
                        }
                    }
                    if (tag.func_74764_b("incHub")) continue;
                    for (IGridNode gn : gh.getGridNode(ForgeDirection.UNKNOWN).getGrid().getMachines(TileWirelessHub.class)) {
                        wc = (TileWirelessHub)gn.getMachine();
                        if (((TileWirelessHub)wc).getFreeSlots() <= 0) continue;
                        if (color != null) {
                            if (wc.getColor() != color) continue;
                            twTarget.add(wc);
                            continue;
                        }
                        twTarget.add(wc);
                    }
                }
                i = 0;
                int ii = 0;
                while (twToBind.size() > i) {
                    while (((TileWirelessConnector)twTarget.get(ii)).getFreeSlots() > 0) {
                        if (((TileWirelessConnector)twToBind.get(i)).setupConnection(((TileWirelessConnector)twTarget.get(ii)).getLocation())) {
                            if (twToBind.size() > ++i) continue;
                            break;
                        }
                        ++ii;
                    }
                    ++ii;
                }
                this.updateData();
                break;
            }
            case "unbind": {
                List<DimensionalCoord> networks = DimensionalCoord.readAsListFromNBT((NBTTagCompound)stash.func_74781_a("pos"));
                NBTTagList toBind = command.func_150295_c("toBind", 10);
                for (int i = 0; i < toBind.func_74745_c(); ++i) {
                    TileWirelessConnector wc;
                    AEColor color;
                    NBTTagCompound tag = toBind.func_150305_b(i);
                    if (tag.func_74764_b("cord")) {
                        DimensionalCoord dc = DimensionalCoord.readFromNBT(tag.func_74775_l("cord"));
                        TileEntity ii = w.func_147438_o(dc.x, dc.y, dc.z);
                        if (!(ii instanceof TileWirelessConnector)) continue;
                        TileWirelessConnector wc4 = (TileWirelessConnector)ii;
                        wc4.breakConnection();
                        continue;
                    }
                    int network = tag.func_74762_e("network");
                    AEColor aEColor = color = tag.func_74764_b("color") ? AEColor.values()[tag.func_74762_e("color")] : null;
                    if (networks.size() < network) continue;
                    DimensionalCoord dc = networks.get(network);
                    TileEntity tileEntity = w.func_147438_o(dc.x, dc.y, dc.z);
                    if (!(tileEntity instanceof IGridHost)) continue;
                    IGridHost gh = (IGridHost)tileEntity;
                    if (!tag.func_74764_b("incCon")) {
                        for (IGridNode gn : gh.getGridNode(ForgeDirection.UNKNOWN).getGrid().getMachines(TileWirelessConnector.class)) {
                            wc = (TileWirelessConnector)gn.getMachine();
                            if (color != null) {
                                if (wc.getColor() != color) continue;
                                wc.breakConnection();
                                continue;
                            }
                            wc.breakConnection();
                        }
                    }
                    if (tag.func_74764_b("incHub")) continue;
                    for (IGridNode gn : gh.getGridNode(ForgeDirection.UNKNOWN).getGrid().getMachines(TileWirelessHub.class)) {
                        wc = (TileWirelessHub)gn.getMachine();
                        if (color != null) {
                            if (wc.getColor() != color) continue;
                            ((TileWirelessHub)wc).breakConnection();
                            continue;
                        }
                        ((TileWirelessHub)wc).breakConnection();
                    }
                }
                this.updateData();
                break;
            }
        }
    }
}

