/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.config.Settings;
import appeng.api.util.DimensionalCoord;
import appeng.items.tools.ToolNetworkVisualiser;
import appeng.tile.networking.TileWirelessConnector;
import appeng.tile.networking.TileWirelessHub;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class NetworkVisualiserRender {
    private static long expTime;
    private final double SIZE = 0.2;
    private final int staticList = GL11.glGenLists((int)1);
    private static boolean needListRefresh;
    private static ArrayList<ToolNetworkVisualiser.VNode> vNodeSet;
    private static ArrayList<ToolNetworkVisualiser.VLink> vLinkSet;
    private static final Set<ToolNetworkVisualiser.VLink> dense;
    private static final Set<ToolNetworkVisualiser.VLink> normal;
    private static ToolNetworkVisualiser.VisualisationModes mode;
    private static final Minecraft mc;
    private static boolean renderWireless;
    private static DimensionalCoord otherDc;
    private static final List<DimensionalCoord> hubConnections;
    private static DimensionalCoord prevPos;
    ArrayList<ToolNetworkVisualiser.VisualisationModes> renderNodesModes = new ArrayList<ToolNetworkVisualiser.VisualisationModes>(Arrays.asList(ToolNetworkVisualiser.VisualisationModes.NODES, ToolNetworkVisualiser.VisualisationModes.FULL, ToolNetworkVisualiser.VisualisationModes.NONUM));
    ArrayList<ToolNetworkVisualiser.VisualisationModes> renderLinksModes = new ArrayList<ToolNetworkVisualiser.VisualisationModes>(Arrays.asList(ToolNetworkVisualiser.VisualisationModes.CHANNELS, ToolNetworkVisualiser.VisualisationModes.FULL, ToolNetworkVisualiser.VisualisationModes.NONUM, ToolNetworkVisualiser.VisualisationModes.P2P));

    public static void networkVisualiser(ArrayList<ToolNetworkVisualiser.VNode> vNodeSetNew, ArrayList<ToolNetworkVisualiser.VLink> vLinkSetNew) {
        vNodeSet = vNodeSetNew;
        vLinkSet = vLinkSetNew;
        normal.clear();
        dense.clear();
        for (ToolNetworkVisualiser.VLink link : vLinkSet) {
            if (link.flags.contains((Object)ToolNetworkVisualiser.VLinkFlags.DENSE)) {
                dense.add(link);
                continue;
            }
            normal.add(link);
        }
        needListRefresh = true;
    }

    public static void doWirelessRender(DimensionalCoord dc) {
        otherDc = dc;
        renderWireless = true;
        expTime = System.currentTimeMillis() + 100L;
    }

    public static void doWirelessHubRender(List<DimensionalCoord> dcl) {
        hubConnections.clear();
        hubConnections.addAll(dcl);
        renderWireless = true;
        expTime = System.currentTimeMillis() + 100L;
    }

    @SubscribeEvent
    public void renderNetwork(RenderWorldLastEvent ev) {
        int networkDim;
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP p = mc.field_71439_g;
        double viewX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)ev.partialTicks;
        double viewY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)ev.partialTicks;
        double viewZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)ev.partialTicks;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-viewX), (double)(-viewY), (double)(-viewZ));
        this.doRenderWirelessPath();
        GL11.glPopMatrix();
        ItemStack is = mc.field_71439_g.field_71071_by.func_70448_g();
        if (!(is != null && is.func_77973_b() instanceof ToolNetworkVisualiser && is.func_77942_o() && is.func_77978_p().func_74764_b("dim"))) {
            return;
        }
        ToolNetworkVisualiser.VisualisationModes newMode = (ToolNetworkVisualiser.VisualisationModes)ToolNetworkVisualiser.getConfigManager(is).getSetting(Settings.NETWORK_VISUALISER);
        if (newMode != mode) {
            mode = newMode;
            needListRefresh = true;
        }
        if ((networkDim = is.func_77978_p().func_74762_e("dim")) != mc.field_71441_e.field_73011_w.field_76574_g) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-viewX), (double)(-viewY), (double)(-viewZ));
        this.doRender(Float.valueOf(ev.partialTicks), viewX, viewY, viewZ);
        GL11.glPopMatrix();
    }

    public void doRenderWirelessPath() {
        if (renderWireless) {
            MovingObjectPosition mop;
            if (expTime < System.currentTimeMillis()) {
                otherDc = null;
                hubConnections.clear();
                renderWireless = false;
            }
            if ((mop = NetworkVisualiserRender.mc.field_71476_x) != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                DimensionalCoord pos = new DimensionalCoord(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, 0);
                TileEntity te = NetworkVisualiserRender.mc.field_71441_e.func_147438_o(pos.x, pos.y, pos.z);
                if (prevPos == null || !pos.isEqual(prevPos)) {
                    prevPos = pos;
                    expTime = 0L;
                    return;
                }
                if (te instanceof TileWirelessHub && !hubConnections.isEmpty()) {
                    GL11.glPushAttrib((int)8192);
                    GL11.glDisable((int)2896);
                    GL11.glDisable((int)3553);
                    GL11.glDisable((int)2929);
                    GL11.glEnable((int)2848);
                    GL11.glHint((int)3154, (int)4354);
                    GL11.glLineWidth((float)4.0f);
                    Tessellator tess = Tessellator.field_78398_a;
                    tess.func_78371_b(1);
                    tess.func_78369_a(0.0f, 0.0f, 1.0f, 1.0f);
                    for (DimensionalCoord dc : hubConnections) {
                        tess.func_78377_a((double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5);
                        tess.func_78377_a((double)dc.x + 0.5, (double)dc.y + 0.5, (double)dc.z + 0.5);
                    }
                    tess.func_78381_a();
                    GL11.glPopAttrib();
                } else if (te instanceof TileWirelessConnector && otherDc != null) {
                    GL11.glPushAttrib((int)8192);
                    GL11.glDisable((int)2896);
                    GL11.glDisable((int)3553);
                    GL11.glDisable((int)2929);
                    GL11.glEnable((int)2848);
                    GL11.glHint((int)3154, (int)4354);
                    GL11.glLineWidth((float)4.0f);
                    Tessellator tess = Tessellator.field_78398_a;
                    tess.func_78371_b(1);
                    tess.func_78369_a(0.0f, 0.0f, 1.0f, 1.0f);
                    tess.func_78377_a((double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5);
                    tess.func_78377_a((double)NetworkVisualiserRender.otherDc.x + 0.5, (double)NetworkVisualiserRender.otherDc.y + 0.5, (double)NetworkVisualiserRender.otherDc.z + 0.5);
                    tess.func_78381_a();
                    GL11.glPopAttrib();
                }
            }
        }
    }

    public void doRender(Float partialTicks, double viewX, double viewY, double viewZ) {
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        if (needListRefresh) {
            needListRefresh = false;
            GL11.glNewList((int)this.staticList, (int)4864);
            if (this.renderNodesModes.contains((Object)mode)) {
                this.renderNodes();
            }
            GL11.glEnable((int)2848);
            GL11.glHint((int)3154, (int)4354);
            if (this.renderLinksModes.contains((Object)mode)) {
                this.renderLinks(dense, 16.0f, mode == ToolNetworkVisualiser.VisualisationModes.P2P);
                this.renderLinks(normal, 4.0f, mode == ToolNetworkVisualiser.VisualisationModes.P2P);
            }
            GL11.glEndList();
        }
        GL11.glCallList((int)this.staticList);
        if (mode == ToolNetworkVisualiser.VisualisationModes.FULL) {
            for (ToolNetworkVisualiser.VLink link : vLinkSet) {
                double linkZ;
                double linkY;
                double linkX;
                double distSq;
                if (link.channels <= 0 || !((distSq = (viewX - (linkX = (double)(link.node1.x + link.node2.x) / 2.0 + 0.5)) * (viewX - linkX) + (viewY - (linkY = (double)(link.node1.y + link.node2.y) / 2.0 + 0.5)) * (viewY - linkY) + (viewZ - (linkZ = (double)(link.node1.z + link.node2.z) / 2.0 + 0.5)) * (viewZ - linkZ)) < 256.0)) continue;
                this.renderFloatingText(String.valueOf(link.channels), linkX, linkY, linkZ, 0xFFFFFF);
            }
        }
        GL11.glPopAttrib();
    }

    private void renderNodes() {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(7);
        for (ToolNetworkVisualiser.VNode node : vNodeSet) {
            int[] nArray;
            if (node.flags.contains((Object)ToolNetworkVisualiser.VNodeFlags.MISSING)) {
                int[] nArray2 = new int[3];
                nArray2[0] = 255;
                nArray2[1] = 0;
                nArray = nArray2;
                nArray2[2] = 0;
            } else if (node.flags.contains((Object)ToolNetworkVisualiser.VNodeFlags.DENSE)) {
                int[] nArray3 = new int[3];
                nArray3[0] = 255;
                nArray3[1] = 255;
                nArray = nArray3;
                nArray3[2] = 0;
            } else {
                int[] nArray4 = new int[3];
                nArray4[0] = 0;
                nArray4[1] = 0;
                nArray = nArray4;
                nArray4[2] = 255;
            }
            int[] color = nArray;
            tess.func_78370_a(color[0], color[1], color[2], 255);
            tess.func_78377_a((double)node.x + 0.5 - 0.2, (double)node.y + 0.5 + 0.2, (double)node.z + 0.5 + 0.2);
            tess.func_78377_a((double)node.x + 0.5 + 0.2, (double)node.y + 0.5 + 0.2, (double)node.z + 0.5 + 0.2);
            tess.func_78377_a((double)node.x + 0.5 + 0.2, (double)node.y + 0.5 + 0.2, (double)node.z + 0.5 - 0.2);
            tess.func_78377_a((double)node.x + 0.5 - 0.2, (double)node.y + 0.5 + 0.2, (double)node.z + 0.5 - 0.2);
            tess.func_78370_a(color[0] / 2, color[1] / 2, color[2] / 2, 255);
            tess.func_78377_a((double)node.x + 0.5 + 0.2, (double)node.y + 0.5 - 0.2, (double)node.z + 0.5 - 0.2);
            tess.func_78377_a((double)node.x + 0.5 + 0.2, (double)node.y + 0.5 - 0.2, (double)node.z + 0.5 + 0.2);
            tess.func_78377_a((double)node.x + 0.5 - 0.2, (double)node.y + 0.5 - 0.2, (double)node.z + 0.5 + 0.2);
            tess.func_78377_a((double)node.x + 0.5 - 0.2, (double)node.y + 0.5 - 0.2, (double)node.z + 0.5 - 0.2);
            tess.func_78370_a(color[0] * 8 / 10, color[1] * 8 / 10, color[2] * 8 / 10, 255);
            tess.func_78377_a((double)node.x + 0.5 + 0.2, (double)node.y + 0.5 - 0.2, (double)node.z + 0.5 + 0.2);
            tess.func_78377_a((double)node.x + 0.5 + 0.2, (double)node.y + 0.5 + 0.2, (double)node.z + 0.5 + 0.2);
            tess.func_78377_a((double)node.x + 0.5 - 0.2, (double)node.y + 0.5 + 0.2, (double)node.z + 0.5 + 0.2);
            tess.func_78377_a((double)node.x + 0.5 - 0.2, (double)node.y + 0.5 - 0.2, (double)node.z + 0.5 + 0.2);
            tess.func_78377_a((double)node.x + 0.5 - 0.2, (double)node.y + 0.5 + 0.2, (double)node.z + 0.5 - 0.2);
            tess.func_78377_a((double)node.x + 0.5 + 0.2, (double)node.y + 0.5 + 0.2, (double)node.z + 0.5 - 0.2);
            tess.func_78377_a((double)node.x + 0.5 + 0.2, (double)node.y + 0.5 - 0.2, (double)node.z + 0.5 - 0.2);
            tess.func_78377_a((double)node.x + 0.5 - 0.2, (double)node.y + 0.5 - 0.2, (double)node.z + 0.5 - 0.2);
            tess.func_78370_a(color[0] * 6 / 10, color[1] * 6 / 10, color[2] * 6 / 10, 255);
            tess.func_78377_a((double)node.x + 0.5 + 0.2, (double)node.y + 0.5 + 0.2, (double)node.z + 0.5 - 0.2);
            tess.func_78377_a((double)node.x + 0.5 + 0.2, (double)node.y + 0.5 + 0.2, (double)node.z + 0.5 + 0.2);
            tess.func_78377_a((double)node.x + 0.5 + 0.2, (double)node.y + 0.5 - 0.2, (double)node.z + 0.5 + 0.2);
            tess.func_78377_a((double)node.x + 0.5 + 0.2, (double)node.y + 0.5 - 0.2, (double)node.z + 0.5 - 0.2);
            tess.func_78377_a((double)node.x + 0.5 - 0.2, (double)node.y + 0.5 - 0.2, (double)node.z + 0.5 + 0.2);
            tess.func_78377_a((double)node.x + 0.5 - 0.2, (double)node.y + 0.5 + 0.2, (double)node.z + 0.5 + 0.2);
            tess.func_78377_a((double)node.x + 0.5 - 0.2, (double)node.y + 0.5 + 0.2, (double)node.z + 0.5 - 0.2);
            tess.func_78377_a((double)node.x + 0.5 - 0.2, (double)node.y + 0.5 - 0.2, (double)node.z + 0.5 - 0.2);
        }
        tess.func_78381_a();
    }

    private void renderLinks(Set<ToolNetworkVisualiser.VLink> links, float width, boolean onlyP2P) {
        GL11.glLineWidth((float)width);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(1);
        for (ToolNetworkVisualiser.VLink link : links) {
            if (onlyP2P && !link.flags.contains((Object)ToolNetworkVisualiser.VLinkFlags.COMPRESSED)) continue;
            if (link.flags.contains((Object)ToolNetworkVisualiser.VLinkFlags.COMPRESSED)) {
                tess.func_78370_a(255, 0, 255, 255);
            } else if (link.flags.contains((Object)ToolNetworkVisualiser.VLinkFlags.DENSE)) {
                tess.func_78370_a(255, 255, 0, 255);
            } else {
                tess.func_78370_a(0, 0, 255, 255);
            }
            tess.func_78377_a((double)link.node1.x + 0.5, (double)link.node1.y + 0.5, (double)link.node1.z + 0.5);
            tess.func_78377_a((double)link.node2.x + 0.5, (double)link.node2.y + 0.5, (double)link.node2.z + 0.5);
        }
        tess.func_78381_a();
    }

    public void renderFloatingText(String text, Double x, Double y, Double z, int color) {
        RenderManager renderManager = RenderManager.field_78727_a;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        Tessellator tessellator = Tessellator.field_78398_a;
        float scale = 0.027f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int yOffset = -4;
        GL11.glDisable((int)3553);
        tessellator.func_78382_b();
        int textWidth = fontRenderer.func_78256_a(text);
        int stringMiddle = textWidth / 2;
        tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.5f);
        tessellator.func_78377_a((double)(-stringMiddle - 1), (double)(-1 + yOffset), 0.0);
        tessellator.func_78377_a((double)(-stringMiddle - 1), (double)(8 + yOffset), 0.0);
        tessellator.func_78377_a((double)(stringMiddle + 1), (double)(8 + yOffset), 0.0);
        tessellator.func_78377_a((double)(stringMiddle + 1), (double)(-1 + yOffset), 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        fontRenderer.func_78276_b(text, -textWidth / 2, yOffset, color);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        fontRenderer.func_78276_b(text, -textWidth / 2, yOffset, color);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    static {
        needListRefresh = true;
        vNodeSet = new ArrayList();
        vLinkSet = new ArrayList();
        dense = new HashSet<ToolNetworkVisualiser.VLink>();
        normal = new HashSet<ToolNetworkVisualiser.VLink>();
        mode = ToolNetworkVisualiser.VisualisationModes.FULL;
        mc = Minecraft.func_71410_x();
        renderWireless = false;
        hubConnections = new ArrayList<DimensionalCoord>();
    }
}

