/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.api.util.AEColor;
import appeng.api.util.IOrientable;
import appeng.block.AEBaseTileBlock;
import appeng.client.texture.WirelessTextures;
import appeng.core.features.AEFeature;
import appeng.helpers.NullRotation;
import appeng.tile.networking.TileWirelessConnector;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockWirelessConnector
extends AEBaseTileBlock {
    public BlockWirelessConnector() {
        super(Material.field_151573_f);
        this.setTileEntity(TileWirelessConnector.class);
        this.setFeature(EnumSet.of(AEFeature.Channels));
    }

    @Override
    public void setHasSubtypes(boolean b) {
        super.setHasSubtypes(true);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ItemStack is = new ItemStack((Block)this);
        TileWirelessConnector te = (TileWirelessConnector)world.func_147438_o(x, y, z);
        if (te != null && te.getColor() != AEColor.Transparent) {
            is.func_77964_b(te.getColor().ordinal() + 1);
        }
        ArrayList<ItemStack> arr = new ArrayList<ItemStack>();
        arr.add(is);
        return arr;
    }

    @Override
    public void addInformation(ItemStack is, EntityPlayer p, List<String> lines, boolean advancedItemTooltips) {
        if (is.func_77960_j() == 0) {
            lines.add(AEColor.values()[16].toString());
        } else {
            lines.add(AEColor.values()[is.func_77960_j() - 1].toString());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getCheckedSubBlocks(Item item, CreativeTabs tabs, List<ItemStack> itemStacks) {
        for (int i = 0; i < 17; ++i) {
            itemStacks.add(new ItemStack((Block)this, 1, i));
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        ItemStack is = new ItemStack((Block)this);
        TileWirelessConnector te = (TileWirelessConnector)world.func_147438_o(x, y, z);
        if (te != null && te.getColor() != AEColor.Transparent) {
            is.func_77964_b(te.getColor().ordinal() + 1);
        }
        return is;
    }

    @Override
    public void func_149689_a(World w, int x, int y, int z, EntityLivingBase player, ItemStack is) {
        TileWirelessConnector te = (TileWirelessConnector)w.func_147438_o(x, y, z);
        if (is.func_77960_j() > 0) {
            te.recolourBlock(ForgeDirection.UNKNOWN, AEColor.values()[is.func_77960_j() - 1], (EntityPlayer)player);
            w.func_72921_c(x, y, z, 0, 3);
        }
        super.func_149689_a(w, x, y, z, player, is);
    }

    @Override
    public void func_149749_a(World w, int x, int y, int z, Block a, int b) {
        ((TileWirelessConnector)w.func_147438_o(x, y, z)).breakConnection();
        super.func_149749_a(w, x, y, z, a, b);
    }

    @Override
    public IOrientable getOrientable(IBlockAccess w, int x, int y, int z) {
        return new NullRotation();
    }

    @Override
    public void setRenderStateByMeta(int metadata) {
        this.getRendererInstance().setTemporaryRenderIcon(this.func_149691_a(0, metadata));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int direction, int metadata) {
        IIcon iIcon;
        switch (metadata) {
            case 1: {
                iIcon = WirelessTextures.WirelessConnectorOnWhite.getIcon();
                break;
            }
            case 2: {
                iIcon = WirelessTextures.WirelessConnectorOnOrange.getIcon();
                break;
            }
            case 3: {
                iIcon = WirelessTextures.WirelessConnectorOnMagenta.getIcon();
                break;
            }
            case 4: {
                iIcon = WirelessTextures.WirelessConnectorOnLightBlue.getIcon();
                break;
            }
            case 5: {
                iIcon = WirelessTextures.WirelessConnectorOnYellow.getIcon();
                break;
            }
            case 6: {
                iIcon = WirelessTextures.WirelessConnectorOnLime.getIcon();
                break;
            }
            case 7: {
                iIcon = WirelessTextures.WirelessConnectorOnPink.getIcon();
                break;
            }
            case 8: {
                iIcon = WirelessTextures.WirelessConnectorOnGrey.getIcon();
                break;
            }
            case 9: {
                iIcon = WirelessTextures.WirelessConnectorOnLightGrey.getIcon();
                break;
            }
            case 10: {
                iIcon = WirelessTextures.WirelessConnectorOnCyan.getIcon();
                break;
            }
            case 11: {
                iIcon = WirelessTextures.WirelessConnectorOnPurple.getIcon();
                break;
            }
            case 12: {
                iIcon = WirelessTextures.WirelessConnectorOnBlue.getIcon();
                break;
            }
            case 13: {
                iIcon = WirelessTextures.WirelessConnectorOnBrown.getIcon();
                break;
            }
            case 14: {
                iIcon = WirelessTextures.WirelessConnectorOnGreen.getIcon();
                break;
            }
            case 15: {
                iIcon = WirelessTextures.WirelessConnectorOnRed.getIcon();
                break;
            }
            case 16: {
                iIcon = WirelessTextures.WirelessConnectorOnBlack.getIcon();
                break;
            }
            default: {
                iIcon = WirelessTextures.WirelessConnectorOnTransparent.getIcon();
            }
        }
        return iIcon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess w, int x, int y, int z, int s) {
        IIcon iIcon;
        if (w.func_72805_g(x, y, z) == 0) {
            IIcon iIcon2;
            switch (((TileWirelessConnector)Objects.requireNonNull(this.getTileEntity(w, x, y, z))).getColor()) {
                case White: {
                    iIcon2 = WirelessTextures.WirelessConnectorOffWhite.getIcon();
                    break;
                }
                case Orange: {
                    iIcon2 = WirelessTextures.WirelessConnectorOffOrange.getIcon();
                    break;
                }
                case Magenta: {
                    iIcon2 = WirelessTextures.WirelessConnectorOffMagenta.getIcon();
                    break;
                }
                case LightBlue: {
                    iIcon2 = WirelessTextures.WirelessConnectorOffLightBlue.getIcon();
                    break;
                }
                case Yellow: {
                    iIcon2 = WirelessTextures.WirelessConnectorOffYellow.getIcon();
                    break;
                }
                case Lime: {
                    iIcon2 = WirelessTextures.WirelessConnectorOffLime.getIcon();
                    break;
                }
                case Pink: {
                    iIcon2 = WirelessTextures.WirelessConnectorOffPink.getIcon();
                    break;
                }
                case Gray: {
                    iIcon2 = WirelessTextures.WirelessConnectorOffGrey.getIcon();
                    break;
                }
                case LightGray: {
                    iIcon2 = WirelessTextures.WirelessConnectorOffLightGrey.getIcon();
                    break;
                }
                case Cyan: {
                    iIcon2 = WirelessTextures.WirelessConnectorOffCyan.getIcon();
                    break;
                }
                case Purple: {
                    iIcon2 = WirelessTextures.WirelessConnectorOffPurple.getIcon();
                    break;
                }
                case Blue: {
                    iIcon2 = WirelessTextures.WirelessConnectorOffBlue.getIcon();
                    break;
                }
                case Brown: {
                    iIcon2 = WirelessTextures.WirelessConnectorOffBrown.getIcon();
                    break;
                }
                case Green: {
                    iIcon2 = WirelessTextures.WirelessConnectorOffGreen.getIcon();
                    break;
                }
                case Red: {
                    iIcon2 = WirelessTextures.WirelessConnectorOffRed.getIcon();
                    break;
                }
                case Black: {
                    iIcon2 = WirelessTextures.WirelessConnectorOffBlack.getIcon();
                    break;
                }
                default: {
                    iIcon2 = WirelessTextures.WirelessConnectorOffTransparent.getIcon();
                }
            }
            return iIcon2;
        }
        switch (((TileWirelessConnector)w.func_147438_o(x, y, z)).getColor()) {
            case White: {
                iIcon = WirelessTextures.WirelessConnectorOnWhite.getIcon();
                break;
            }
            case Orange: {
                iIcon = WirelessTextures.WirelessConnectorOnOrange.getIcon();
                break;
            }
            case Magenta: {
                iIcon = WirelessTextures.WirelessConnectorOnMagenta.getIcon();
                break;
            }
            case LightBlue: {
                iIcon = WirelessTextures.WirelessConnectorOnLightBlue.getIcon();
                break;
            }
            case Yellow: {
                iIcon = WirelessTextures.WirelessConnectorOnYellow.getIcon();
                break;
            }
            case Lime: {
                iIcon = WirelessTextures.WirelessConnectorOnLime.getIcon();
                break;
            }
            case Pink: {
                iIcon = WirelessTextures.WirelessConnectorOnPink.getIcon();
                break;
            }
            case Gray: {
                iIcon = WirelessTextures.WirelessConnectorOnGrey.getIcon();
                break;
            }
            case LightGray: {
                iIcon = WirelessTextures.WirelessConnectorOnLightGrey.getIcon();
                break;
            }
            case Cyan: {
                iIcon = WirelessTextures.WirelessConnectorOnCyan.getIcon();
                break;
            }
            case Purple: {
                iIcon = WirelessTextures.WirelessConnectorOnPurple.getIcon();
                break;
            }
            case Blue: {
                iIcon = WirelessTextures.WirelessConnectorOnBlue.getIcon();
                break;
            }
            case Brown: {
                iIcon = WirelessTextures.WirelessConnectorOnBrown.getIcon();
                break;
            }
            case Green: {
                iIcon = WirelessTextures.WirelessConnectorOnGreen.getIcon();
                break;
            }
            case Red: {
                iIcon = WirelessTextures.WirelessConnectorOnRed.getIcon();
                break;
            }
            case Black: {
                iIcon = WirelessTextures.WirelessConnectorOnBlack.getIcon();
                break;
            }
            default: {
                iIcon = WirelessTextures.WirelessConnectorOnTransparent.getIcon();
            }
        }
        return iIcon;
    }
}

