/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.client.usageticker;

import com.cleanroommc.bogosorter.common.ReadableNumberConverter;
import com.cleanroommc.bogosorter.compat.loader.Mods;
import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;
import xonin.backhand.api.core.BackhandUtils;

@EventBusSubscriber(side={Side.CLIENT})
public class UsageTicker {
    public static boolean enableMainHand = true;
    public static boolean enableOffHand = true;
    public static boolean enableArmor = true;
    public static boolean enableModule = true;
    private static List<Element> elements = new ArrayList<Element>();

    public static void reloadElements() {
        elements = new ArrayList<Element>();
        if (!enableModule) {
            return;
        }
        if (enableMainHand) {
            elements.add(new Element(EquipmentSlotType.MAINHAND));
        }
        if (Mods.Backhand.isLoaded() && enableOffHand) {
            elements.add(new Element(EquipmentSlotType.OFFHAND));
        }
        if (enableArmor) {
            elements.add(new Element(EquipmentSlotType.HEAD));
            elements.add(new Element(EquipmentSlotType.CHEST));
            elements.add(new Element(EquipmentSlotType.LEGS));
            elements.add(new Element(EquipmentSlotType.FEET));
        }
    }

    @EventBusSubscriber.Condition
    public static boolean enableModule() {
        return enableModule;
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null) {
                elements.forEach(e -> e.tick(mc.field_71439_g));
            }
        }
    }

    @SubscribeEvent
    public static void renderHUD(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            ScaledResolution res = event.resolution;
            float partialTicks = event.partialTicks;
            elements.forEach(e -> e.render(res, player, partialTicks));
        }
    }

    public static class Element {
        private static final int MAX_ANIM_TICKS = 60;
        private static final int ANIM_TICKS = 5;
        EquipmentSlotType slot;
        ItemStack currentStack = null;
        int currentCount;
        int showTicks;

        public Element(EquipmentSlotType slotType) {
            this.slot = slotType;
        }

        public void render(ScaledResolution resolution, EntityClientPlayerMP player, float partialTicks) {
            if (this.showTicks > 0) {
                boolean armor;
                float animProgress = this.showTicks < 5 ? Math.max(0.0f, (float)this.showTicks - partialTicks) / 5.0f : Math.min(5.0f, (float)(60 - this.showTicks) + partialTicks) / 5.0f;
                float anim = -animProgress * (animProgress - 2.0f) * 19.0f;
                float x = (float)resolution.func_78326_a() / 2.0f - (float)(Mods.Backhand.isLoaded() ? 30 : 0);
                float y = (float)resolution.func_78328_b() - anim;
                int barWidth = 190;
                boolean bl = armor = this.slot != EquipmentSlotType.MAINHAND && this.slot != EquipmentSlotType.OFFHAND;
                int slots = armor ? 4 : (Mods.Backhand.isLoaded() && enableOffHand ? 2 : 1);
                int index = slots - this.slot.ordinal() - 1;
                Minecraft mc = Minecraft.func_71410_x();
                x -= (float)barWidth / 2.0f - (float)(index * 22);
                x -= (float)(slots * 20);
                ItemStack stack = this.getRenderedStack(player);
                if (stack == null) {
                    return;
                }
                RenderItem renderer = new RenderItem();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)x, (float)y, (float)0.0f);
                GL11.glEnable((int)32826);
                RenderHelper.func_74520_c();
                renderer.func_82406_b(mc.field_71466_p, mc.field_71446_o, stack, 0, 0);
                renderer.func_94148_a(mc.field_71466_p, mc.field_71446_o, stack, 0, 0, stack.field_77994_a > 1 ? ReadableNumberConverter.INSTANCE.toSlimReadableForm(stack.field_77994_a) : null);
                RenderHelper.func_74518_a();
                GL11.glDisable((int)32826);
                GL11.glPopMatrix();
            }
        }

        public void tick(EntityClientPlayerMP player) {
            ItemStack stack = this.getStack(player);
            int count = this.getStackCount(player, stack);
            if ((stack = this.getDisplayedStack(stack, count)) == null) {
                this.showTicks = 0;
            } else if (this.stackChanged(stack, this.currentStack, count, this.currentCount)) {
                boolean animatingOut;
                boolean done = this.showTicks == 0;
                boolean animatingIn = this.showTicks > 55;
                boolean bl = animatingOut = this.showTicks < 5 && !done;
                if (animatingOut) {
                    this.showTicks = 60 - this.showTicks;
                } else if (!animatingIn) {
                    this.showTicks = !done ? 55 : 60;
                }
            } else if (this.showTicks > 0) {
                --this.showTicks;
            }
            this.currentStack = stack;
            this.currentCount = count;
        }

        private boolean stackChanged(ItemStack currentStack, ItemStack prevStack, int currentCount, int pastCount) {
            if (currentStack == null && prevStack == null) {
                return false;
            }
            if (currentStack == null) {
                return true;
            }
            if (prevStack == null) {
                return true;
            }
            return !prevStack.func_77969_a(currentStack) || currentCount != pastCount;
        }

        @Nullable
        public ItemStack getStack(EntityClientPlayerMP player) {
            if (this.slot == EquipmentSlotType.MAINHAND) {
                return player.field_71071_by.func_70448_g();
            }
            if (this.slot == EquipmentSlotType.OFFHAND) {
                return BackhandUtils.getOffhandItem((EntityPlayer)player);
            }
            return player.field_71071_by.func_70440_f(this.slot.ordinal() - 2);
        }

        public ItemStack getRenderedStack(EntityClientPlayerMP player) {
            ItemStack curStack = this.getStack(player);
            if (curStack == null) {
                return null;
            }
            int count = this.getStackCount(player, curStack);
            ItemStack disStack = this.getDisplayedStack(curStack, count);
            if (disStack == null) {
                return null;
            }
            if ((disStack = disStack.func_77946_l()) != curStack) {
                count = this.getStackCount(player, disStack);
            }
            disStack.field_77994_a = count;
            return disStack;
        }

        public ItemStack getDisplayedStack(ItemStack stack, int count) {
            if (stack == null) {
                return null;
            }
            if (this.slot == EquipmentSlotType.MAINHAND && !stack.func_77985_e()) {
                return null;
            }
            if (this.slot == EquipmentSlotType.OFFHAND && !stack.func_77985_e()) {
                return null;
            }
            if (count == stack.field_77994_a) {
                return null;
            }
            return stack;
        }

        private int getStackCount(EntityClientPlayerMP player, ItemStack stack) {
            if (stack == null) {
                return 0;
            }
            int total = 0;
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack invStack = player.field_71071_by.func_70301_a(i);
                if (invStack == null || !invStack.func_77969_a(stack)) continue;
                if (!ItemStack.func_77970_a((ItemStack)invStack, (ItemStack)stack) || invStack.func_77960_j() != stack.func_77960_j()) continue;
                total += invStack.field_77994_a;
            }
            return total;
        }
    }

    public static enum EquipmentSlotType {
        MAINHAND,
        OFFHAND,
        HEAD,
        CHEST,
        LEGS,
        FEET;

    }
}

