/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter;

import codechicken.lib.inventory.SlotDummy;
import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.api.ISlot;
import com.cleanroommc.bogosorter.common.network.CShortcut;
import com.cleanroommc.bogosorter.common.network.NetworkHandler;
import com.cleanroommc.bogosorter.common.sort.GuiSortingContext;
import com.cleanroommc.bogosorter.common.sort.SlotGroup;
import com.cleanroommc.bogosorter.compat.loader.Mods;
import com.cleanroommc.modularui.utils.item.ItemHandlerHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;

public class ShortcutHandler {
    public static boolean SetCanTakeStack;

    @SideOnly(value=Side.CLIENT)
    public static boolean moveSingleItem(GuiContainer guiContainer, boolean emptySlot) {
        Slot slot = guiContainer.field_147006_u;
        if (slot == null || slot.func_75211_c() == null) {
            return false;
        }
        NetworkHandler.sendToServer(new CShortcut(emptySlot ? CShortcut.Type.MOVE_SINGLE_EMPTY : CShortcut.Type.MOVE_SINGLE, slot.field_75222_d));
        return true;
    }

    public static void moveSingleItem(EntityPlayer player, Container container, ISlot slot, boolean emptySlot) {
        ShortcutHandler.moveItemStack(player, container, slot, emptySlot, 1);
    }

    public static void moveItemStack(EntityPlayer player, Container container, ISlot slot, boolean emptySlot, int amount) {
        if (slot == null || slot.bogo$getStack() == null) {
            return;
        }
        ItemStack stack = slot.bogo$getStack();
        amount = Math.min(amount, stack.func_77976_d());
        ItemStack toInsert = stack.func_77946_l();
        toInsert.field_77994_a = amount;
        if (BogoSortAPI.isValidSortable(container)) {
            SlotGroup otherSlots;
            GuiSortingContext sortingContext = GuiSortingContext.getOrCreate(container);
            SlotGroup slots = sortingContext.getSlotGroup(slot.bogo$getSlotNumber());
            SlotGroup slotGroup = otherSlots = BogoSortAPI.isPlayerSlot(slot) ? sortingContext.getNonPlayerSlotGroup() : sortingContext.getPlayerSlotGroup();
            if (otherSlots == null || slots == otherSlots) {
                return;
            }
            toInsert = emptySlot ? BogoSortAPI.insert(container, otherSlots.getSlots(), toInsert, true) : BogoSortAPI.insert(container, otherSlots.getSlots(), toInsert);
        } else {
            ArrayList<ISlot> otherSlots = new ArrayList<ISlot>();
            boolean isPlayer = BogoSortAPI.isPlayerSlot(slot);
            for (Slot slot1 : container.field_75151_b) {
                if (isPlayer == BogoSortAPI.isPlayerSlot(slot1) || isPlayer == ShortcutHandler.SlotDummy(slot1)) continue;
                otherSlots.add(BogoSortAPI.INSTANCE.getSlot(slot1));
            }
            ItemStack itemStack = toInsert = emptySlot ? BogoSortAPI.insert(container, otherSlots, toInsert, true) : BogoSortAPI.insert(container, otherSlots, toInsert);
        }
        if (toInsert == null) {
            toInsert = stack.func_77946_l();
            toInsert.field_77994_a -= amount;
            if (toInsert.field_77994_a == 0) {
                toInsert = null;
            }
            slot.bogo$putStack(toInsert);
            slot.bogo$onSlotChanged(stack, toInsert);
            toInsert = stack.func_77946_l();
            toInsert.field_77994_a = amount;
            slot.bogo$onTake(player, toInsert);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean moveAllItems(GuiContainer guiContainer, boolean sameItemOnly) {
        Container container = guiContainer.field_147002_h;
        Slot slot = guiContainer.field_147006_u;
        if (slot == null || !BogoSortAPI.isValidSortable(container)) {
            return false;
        }
        ISlot iSlot = BogoSortAPI.INSTANCE.getSlot(slot);
        if (sameItemOnly && iSlot.bogo$getStack() == null) {
            return false;
        }
        SetCanTakeStack = false;
        NetworkHandler.sendToServer(new CShortcut(sameItemOnly ? CShortcut.Type.MOVE_ALL_SAME : CShortcut.Type.MOVE_ALL, iSlot.bogo$getSlotNumber()));
        return true;
    }

    public static void moveAllItems(EntityPlayer player, Container container, ISlot slot, boolean sameItemOnly) {
        if (slot == null || !BogoSortAPI.isValidSortable(container)) {
            return;
        }
        if (slot.bogo$getStack() != null) {
            SlotGroup otherSlots;
            ItemStack stack = slot.bogo$getStack().func_77946_l();
            if (sameItemOnly && stack == null) {
                return;
            }
            GuiSortingContext sortingContext = GuiSortingContext.getOrCreate(container);
            SlotGroup slots = sortingContext.getSlotGroup(slot.bogo$getSlotNumber());
            SlotGroup slotGroup = otherSlots = BogoSortAPI.isPlayerSlot(slot) ? sortingContext.getNonPlayerSlotGroup() : sortingContext.getPlayerSlotGroup();
            if (slots == null || otherSlots == null || slots == otherSlots) {
                return;
            }
            for (ISlot slot1 : slots.getSlots()) {
                ItemStack stackInSlot = slot1.bogo$getStack();
                if (stackInSlot == null || sameItemOnly && !stackInSlot.func_77969_a(stack)) continue;
                ItemStack copy = stackInSlot.func_77946_l();
                ItemStack remainder = BogoSortAPI.insert(container, otherSlots.getSlots(), copy);
                if (remainder == null) {
                    slot1.bogo$putStack(null);
                    continue;
                }
                int inserted = stackInSlot.field_77994_a - remainder.field_77994_a;
                if (inserted <= 0) continue;
                slot1.bogo$putStack(remainder.func_77946_l());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean dropItems(GuiContainer guiContainer, boolean onlySameType) {
        Slot slot = guiContainer.field_147006_u;
        if (slot == null || slot.func_75211_c() == null) {
            return false;
        }
        if (!BogoSortAPI.isPlayerSlot(slot) && !BogoSortAPI.isValidSortable(guiContainer.field_147002_h)) {
            return false;
        }
        NetworkHandler.sendToServer(new CShortcut(onlySameType ? CShortcut.Type.DROP_ALL_SAME : CShortcut.Type.DROP_ALL, slot.field_75222_d));
        return true;
    }

    public static void dropItems(EntityPlayer player, Container container, ISlot slot, boolean onlySameType) {
        ItemStack stack = slot.bogo$getStack();
        if (onlySameType && stack == null) {
            return;
        }
        SlotGroup slots = GuiSortingContext.getOrCreate(container).getSlotGroup(slot.bogo$getSlotNumber());
        if (slots == null) {
            return;
        }
        for (ISlot slot1 : slots.getSlots()) {
            ItemStack stackInSlot = slot1.bogo$getStack();
            if (stackInSlot == null || onlySameType && !stackInSlot.func_77969_a(stack)) continue;
            slot1.bogo$putStack(null);
            player.func_71019_a(stackInSlot, true);
        }
    }

    public static ItemStack insertToSlots(List<ISlot> slots, ItemStack stack, boolean emptyOnly) {
        for (ISlot slot : slots) {
            stack = ShortcutHandler.insert(slot, stack, emptyOnly);
            if (stack != null) continue;
            return stack;
        }
        return stack;
    }

    public static ItemStack insert(ISlot slot, ItemStack stack, boolean emptyOnly) {
        ItemStack stackInSlot = slot.bogo$getStack();
        if (emptyOnly) {
            if (stackInSlot != null || !slot.bogo$isItemValid(stack)) {
                return stack;
            }
            int amount = Math.min(stack.field_77994_a, slot.bogo$getItemStackLimit(stack));
            if (amount <= 0) {
                return stack;
            }
            ItemStack newStack = stack.func_77946_l();
            newStack.field_77994_a = amount;
            stack.field_77994_a -= amount;
            slot.bogo$putStack(newStack);
            return stack.field_77994_a == 0 ? null : stack;
        }
        if (stackInSlot != null && ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stack)) {
            int amount = Math.min(slot.bogo$getItemStackLimit(stackInSlot), Math.min(stack.field_77994_a, slot.bogo$getMaxStackSize(stack) - stackInSlot.field_77994_a));
            if (amount <= 0) {
                return stack;
            }
            stack.field_77994_a -= amount;
            stackInSlot.field_77994_a += amount;
            slot.bogo$putStack(stackInSlot);
            return stack.field_77994_a == 0 ? null : stack;
        }
        return stack;
    }

    public static boolean SlotDummy(Slot slot) {
        if (Mods.CodeChickenCore.isLoaded() && slot instanceof SlotDummy) {
            return true;
        }
        return slot instanceof SlotCrafting;
    }
}

