/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.rfb.transformers;

import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RetroFuturaBootstrap;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import java.util.HashSet;
import java.util.jar.Manifest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadSuperclassTransformer
implements RfbClassTransformer {
    private static final Logger LOGGER = LogManager.getLogger((String)"lwjgl3ify");

    @NotNull
    public String id() {
        return "load-superclass";
    }

    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        return classLoader == RetroFuturaBootstrap.API.launchClassLoader();
    }

    public void transformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        if (!classNode.isPresent()) {
            return;
        }
        String superName = "";
        try {
            HashSet<String> visited = new HashSet<String>();
            visited.add(className);
            superName = classNode.getFastAccessor().binarySuperName().replace('/', '.');
            while (visited.add(superName) && !"java.lang.Object".equals(superName)) {
                Class outer = classLoader.findClass(superName);
                superName = outer.getSuperclass().getName();
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Could not load superclass {} of {}", new Object[]{superName, className, t});
        }
    }
}

