/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.structure;

import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.recursive_pineapple.matter_manipulator.common.structure.StructureWrapper;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import it.unimi.dsi.fastutil.chars.Char2IntArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class StructureWrapperInstanceInfo<MTE extends MTEEnhancedMultiBlockBase<?>> {
    public final StructureWrapper<MTE> structure;
    public Char2IntArrayMap actualCasingCounts = new Char2IntArrayMap();
    public boolean hasErrors = false;

    public StructureWrapperInstanceInfo(StructureWrapper<MTE> structure) {
        this.structure = structure;
    }

    public String getErrors() {
        ArrayList<String> lines = new ArrayList<String>();
        for (Char2ObjectMap.Entry e : this.structure.casings.char2ObjectEntrySet()) {
            int minCasings;
            int presentCasings = this.actualCasingCounts.get(e.getCharKey());
            if (presentCasings >= (minCasings = ((StructureWrapper.CasingInfo)e.getValue()).definitionCasingCount - ((StructureWrapper.CasingInfo)e.getValue()).maxHatches)) continue;
            this.hasErrors = true;
            String error = String.format("%sNot enough %s: need %d, but have %d.%s", EnumChatFormatting.DARK_RED, ((StructureWrapper.CasingInfo)e.getValue()).casing.getLocalizedName(), minCasings, presentCasings, EnumChatFormatting.RESET);
            lines.add(error);
        }
        return String.join((CharSequence)"\n", lines);
    }

    public boolean checkStructure(MTE instance) {
        this.actualCasingCounts.clear();
        this.hasErrors = false;
        if (!this.structure.checkStructure(instance)) {
            return false;
        }
        for (Char2ObjectMap.Entry e : this.structure.casings.char2ObjectEntrySet()) {
            this.actualCasingCounts.putIfAbsent(e.getCharKey(), ((StructureWrapper.CasingInfo)e.getValue()).definitionCasingCount);
        }
        this.getErrors();
        return !this.hasErrors;
    }

    public void construct(MTE instance, ItemStack trigger, boolean hintsOnly) {
        this.structure.construct(instance, trigger, hintsOnly);
    }

    public int survivalConstruct(MTE instance, ItemStack trigger, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.structure.survivalConstruct(instance, trigger, elementBudget, env);
    }
}

