/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.structure;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.recursive_pineapple.matter_manipulator.GlobalMMConfig;
import com.recursive_pineapple.matter_manipulator.MMMod;
import com.recursive_pineapple.matter_manipulator.common.structure.ICasing;
import com.recursive_pineapple.matter_manipulator.common.structure.IStructureProvider;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.chars.Char2IntArrayMap;
import it.unimi.dsi.fastutil.chars.Char2IntMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.ints.IntBinaryOperator;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import org.joml.Vector3i;

public class StructureWrapper<MTE extends MTEEnhancedMultiBlockBase<?>> {
    public static final String STRUCTURE_PIECE_MAIN = "main";
    public final IStructureProvider<MTE> provider;
    public String[][] definitionText;
    public IStructureDefinition<MTE> structureDefinition;
    public Vector3i offset;
    public Vector3i size;
    public Char2ObjectArrayMap<CasingInfo<MTE>> casings;
    public Char2IntArrayMap casingCounts;

    public StructureWrapper(IStructureProvider<MTE> provider) {
        this.provider = provider;
    }

    public void loadStructure() {
        this.structureDefinition = null;
        try {
            this.definitionText = this.provider.getDefinition();
            this.casings = new Char2ObjectArrayMap();
            this.casingCounts = new Char2IntArrayMap();
            int width = 0;
            int height = 0;
            int length = this.definitionText.length;
            int z = 0;
            for (String[] a : this.definitionText) {
                int y = 0;
                height = Math.max(height, a.length);
                for (String b : a) {
                    width = Math.max(width, b.length());
                    for (int x = 0; x < b.length(); ++x) {
                        char c = b.charAt(x);
                        if (c == ' ' || c == '-' || c == '+') continue;
                        this.casingCounts.mergeInt(c, 1, Integer::sum);
                        if (c != '~') continue;
                        this.offset = new Vector3i(x, y, z);
                    }
                    ++y;
                }
                ++z;
            }
            this.size = new Vector3i(width, height, length);
            if (this.offset == null) {
                throw new IllegalStateException("Structure definition for " + this.provider + " did not contain a tilde! This is required so that the wrapper knows where the controller is.");
            }
            this.structureDefinition = this.provider.compile(this.definitionText);
            for (Char2IntMap.Entry e : this.casingCounts.char2IntEntrySet()) {
                CasingInfo casing = (CasingInfo)this.casings.get(e.getCharKey());
                if (casing == null) continue;
                casing.definitionCasingCount = e.getIntValue();
            }
        }
        catch (Throwable t) {
            MMMod.LOG.error("Could not compile structure", t);
        }
    }

    public boolean checkStructure(MTE instance) {
        this.loadStructure();
        if (!GlobalMMConfig.DEVENV) {
            return this.checkStructureImpl(instance);
        }
        try {
            return this.checkStructureImpl(instance);
        }
        catch (NoSuchMethodError ignored) {
            MMMod.LOG.info("Caught an exception that was probably caused by a hotswap.", (Throwable)ignored);
            this.loadStructure();
            return this.checkStructureImpl(instance);
        }
    }

    private boolean checkStructureImpl(MTE instance) {
        IGregTechTileEntity tTile = instance.getBaseMetaTileEntity();
        return this.structureDefinition.check(instance, STRUCTURE_PIECE_MAIN, tTile.getWorld(), instance.getExtendedFacing(), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), this.offset.x, this.offset.y, this.offset.z, !((MTEEnhancedMultiBlockBase)instance).mMachine);
    }

    public void construct(MTE instance, ItemStack trigger, boolean hintsOnly) {
        if (!GlobalMMConfig.DEVENV) {
            this.constructImpl(instance, trigger, hintsOnly);
        } else {
            try {
                this.constructImpl(instance, trigger, hintsOnly);
            }
            catch (NoSuchMethodError ignored) {
                MMMod.LOG.info("Caught an exception that was probably caused by a hotswap.", (Throwable)ignored);
                this.loadStructure();
                this.constructImpl(instance, trigger, hintsOnly);
            }
        }
    }

    private void constructImpl(MTE instance, ItemStack trigger, boolean hintsOnly) {
        IGregTechTileEntity tTile = instance.getBaseMetaTileEntity();
        this.structureDefinition.buildOrHints(instance, trigger, STRUCTURE_PIECE_MAIN, tTile.getWorld(), instance.getExtendedFacing(), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), this.offset.x, this.offset.y, this.offset.z, hintsOnly);
    }

    public int survivalConstruct(MTE instance, ItemStack trigger, int elementBudget, ISurvivalBuildEnvironment env) {
        if (((MTEEnhancedMultiBlockBase)instance).mMachine) {
            return -1;
        }
        if (!GlobalMMConfig.DEVENV) {
            return this.survivalConstructImpl(instance, trigger, elementBudget, env);
        }
        try {
            return this.survivalConstructImpl(instance, trigger, elementBudget, env);
        }
        catch (NoSuchMethodError ignored) {
            MMMod.LOG.info("Caught an exception that was probably caused by a hotswap.", (Throwable)ignored);
            this.loadStructure();
            return this.survivalConstructImpl(instance, trigger, elementBudget, env);
        }
    }

    private int survivalConstructImpl(MTE instance, ItemStack trigger, int elementBudget, ISurvivalBuildEnvironment env) {
        IGregTechTileEntity tTile = instance.getBaseMetaTileEntity();
        int built = this.structureDefinition.survivalBuild(instance, trigger, STRUCTURE_PIECE_MAIN, tTile.getWorld(), instance.getExtendedFacing(), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), this.offset.x, this.offset.y, this.offset.z, elementBudget, env, false);
        if (built > 0) {
            instance.checkStructure(true, tTile);
        }
        return built;
    }

    public IStructureElement<MTE> getStructureElement(char c) {
        CasingInfo casing = (CasingInfo)this.casings.get(c);
        if (casing.maxHatches > 0) {
            IntBinaryOperator sum = Integer::sum;
            IStructureElement adder = StructureUtility.onElementPass(instance -> ((IStructureProvider)instance).getWrapperInstanceInfo().actualCasingCounts.mergeInt(c, 1, sum), casing.casing.asElement());
            return HatchElementBuilder.builder().atLeast(casing.hatches).casingIndex(casing.casing.getTextureId()).dot(casing.dot).buildAndChain(new IStructureElement[]{adder});
        }
        return casing.casing.asElement();
    }

    public int getCasingMin(char c) {
        return this.getCasingMax(c) - ((CasingInfo)this.casings.get((char)c)).maxHatches;
    }

    public int getCasingMin(ICasing casing) {
        int sum = 0;
        for (Char2ObjectMap.Entry e : this.casings.char2ObjectEntrySet()) {
            if (((CasingInfo)e.getValue()).casing != casing) continue;
            sum += this.getCasingMin(e.getCharKey());
        }
        return sum;
    }

    public int getCasingMax(char c) {
        return ((CasingInfo)this.casings.get((char)c)).definitionCasingCount;
    }

    public int getCasingMax(ICasing casing) {
        int sum = 0;
        for (Char2ObjectMap.Entry e : this.casings.char2ObjectEntrySet()) {
            if (((CasingInfo)e.getValue()).casing != casing) continue;
            sum += this.getCasingMax(e.getCharKey());
        }
        return sum;
    }

    public StructureWrapper<MTE> addCasing(char c, ICasing casing) {
        Objects.requireNonNull(casing);
        CasingInfo casingInfo = new CasingInfo();
        casingInfo.casing = casing;
        this.casings.put(c, casingInfo);
        return this;
    }

    public StructureWrapper<MTE> addCasingWithHatches(char c, ICasing casing, int dot, int maxHatches, List<IHatchElement<? super MTE>> hatches) {
        Objects.requireNonNull(casing);
        Objects.requireNonNull(hatches);
        CasingInfo casingInfo = new CasingInfo();
        casingInfo.casing = casing;
        casingInfo.dot = dot;
        casingInfo.maxHatches = maxHatches;
        casingInfo.hatches = hatches.toArray(new IHatchElement[0]);
        this.casings.put(c, casingInfo);
        return this;
    }

    public StructureDefinition.Builder<MTE> getStructureBuilder(List<Pair<String, String[][]>> pieces) {
        StructureDefinition.Builder builder = StructureDefinition.builder();
        CharIterator charIterator = this.casings.keySet().iterator();
        while (charIterator.hasNext()) {
            char c = ((Character)charIterator.next()).charValue();
            builder.addElement(c, this.getStructureElement(c));
        }
        for (Pair pair : pieces) {
            builder.addShape((String)pair.left(), (String[][])pair.right());
        }
        return builder;
    }

    public IStructureDefinition<MTE> buildStructure(String[][] definition) {
        return this.getStructureBuilder(Arrays.asList(Pair.of((Object)STRUCTURE_PIECE_MAIN, (Object)definition))).build();
    }

    public StructureWrapper<MTE> addCasingInfoExact(MultiblockTooltipBuilder tt, ICasing casing) {
        tt.addCasingInfoExactly(casing.getLocalizedName(), this.getCasingMax(casing), false);
        return this;
    }

    public StructureWrapper<MTE> addCasingInfoRange(MultiblockTooltipBuilder tt, ICasing casing) {
        tt.addCasingInfoRange(casing.getLocalizedName(), this.getCasingMin(casing), this.getCasingMax(casing), false);
        return this;
    }

    public StructureWrapper<MTE> addCasingInfoAuto(MultiblockTooltipBuilder tt, ICasing casing) {
        if (this.getCasingMax(casing) != this.getCasingMin(casing)) {
            this.addCasingInfoRange(tt, casing);
        } else {
            this.addCasingInfoExact(tt, casing);
        }
        return this;
    }

    public static class CasingInfo<MTE> {
        public int definitionCasingCount;
        public int maxHatches;
        public int dot;
        public ICasing casing;
        public IHatchElement<? super MTE>[] hatches;
    }
}

