/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.structure;

import com.google.common.collect.ArrayListMultimap;
import com.recursive_pineapple.matter_manipulator.common.structure.ICasing;
import com.recursive_pineapple.matter_manipulator.common.structure.StructureWrapper;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import gregtech.api.enums.HatchElement;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.util.MultiblockTooltipBuilder;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.client.resources.I18n;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;

public class MultiblockTooltipBuilder2<MTE extends MTEEnhancedMultiBlockBase<?>>
extends MultiblockTooltipBuilder {
    public final StructureWrapper<MTE> structure;
    private final Object2ObjectArrayMap<IHatchElement<? super MTE>, String> hatchNameOverrides = new Object2ObjectArrayMap();
    private final Object2ObjectArrayMap<IHatchElement<? super MTE>, String> hatchInfoOverrides = new Object2ObjectArrayMap();
    private final List<IHatchElement<? super MTE>> hatchOrder = new ArrayList<IHatchElement<? super MTE>>();
    private boolean hasMultiampHatches = false;
    private boolean printMultiampSupport = true;

    public MultiblockTooltipBuilder2(StructureWrapper<MTE> structure) {
        this.structure = structure;
    }

    public MultiblockTooltipBuilder2<MTE> beginStructureBlock(boolean hollow) {
        super.beginStructureBlock(this.structure.size.x, this.structure.size.y, this.structure.size.z, hollow);
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> beginStructureBlock() {
        super.beginStructureBlock(this.structure.size.x, this.structure.size.y, this.structure.size.z, false);
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> addCasing(ICasing casing) {
        this.structure.addCasingInfoAuto(this, casing);
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> addHatchNameOverride(IHatchElement<? super MTE> hatch, String newName) {
        this.hatchNameOverrides.put(hatch, (Object)newName);
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> addHatchLocationOverride(IHatchElement<? super MTE> hatch, String newLocation) {
        this.hatchInfoOverrides.put(hatch, (Object)newLocation);
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> disableMultiAmpHatchLine() {
        this.printMultiampSupport = false;
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> setHatchOrder(List<IHatchElement<? super MTE>> hatches) {
        this.hatchOrder.clear();
        this.hatchOrder.addAll(hatches);
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> addHatch(ICasing casing, IHatchElement<? super MTE> hatch, int ... dots) {
        String override = (String)this.hatchNameOverrides.get(hatch);
        String info = (String)this.hatchInfoOverrides.get(hatch);
        if (info == null) {
            info = I18n.func_135052_a((String)"mm.structure.hatch-info", (Object[])new Object[]{casing.getLocalizedName()});
        }
        if (dots != null && dots.length > 0) {
            info = info + I18n.func_135052_a((String)"mm.structure.hatch-dots", (Object[])new Object[]{String.join((CharSequence)", ", MMUtils.mapToList(new IntArrayList(dots), i -> i.toString()))});
        }
        if (override != null) {
            this.addOtherStructurePart(override, info, dots);
        } else if (hatch instanceof HatchElement) {
            HatchElement gtHatch = (HatchElement)hatch;
            switch (gtHatch) {
                case Dynamo: {
                    this.addDynamoHatch(info, dots);
                    break;
                }
                case Energy: {
                    this.addEnergyHatch(info, dots);
                    break;
                }
                case ExoticEnergy: {
                    this.addDynamoHatch(info, dots);
                    this.addEnergyHatch(info, dots);
                    this.hasMultiampHatches = true;
                    break;
                }
                case InputBus: {
                    this.addInputBus(info, dots);
                    break;
                }
                case InputHatch: {
                    this.addInputHatch(info, dots);
                    break;
                }
                case Maintenance: {
                    this.addMaintenanceHatch(info, dots);
                    break;
                }
                case Muffler: {
                    this.addMufflerHatch(info, dots);
                    break;
                }
                case OutputBus: {
                    this.addOutputBus(info, dots);
                    break;
                }
                case OutputHatch: {
                    this.addOutputHatch(info, dots);
                    break;
                }
            }
        } else if (hatch instanceof TTMultiblockBase.HatchElement) {
            TTMultiblockBase.HatchElement ttHatch = (TTMultiblockBase.HatchElement)hatch;
            switch (ttHatch) {
                case DynamoMulti: {
                    this.addDynamoHatch(info, dots);
                    this.hasMultiampHatches = true;
                    break;
                }
                case EnergyMulti: {
                    this.addEnergyHatch(info, dots);
                    this.hasMultiampHatches = true;
                    break;
                }
                case InputData: {
                    this.addOtherStructurePart(I18n.func_135052_a((String)"tt.keyword.Structure.DataConnector", (Object[])new Object[0]), info, dots);
                    break;
                }
                case OutputData: {
                    this.addOtherStructurePart(I18n.func_135052_a((String)"tt.keyword.Structure.DataConnector", (Object[])new Object[0]), info, dots);
                    break;
                }
                case Uncertainty: {
                    this.addOtherStructurePart(I18n.func_135052_a((String)"gt.blockmachines.hatch.certain.tier.07.name", (Object[])new Object[0]), info, dots);
                    break;
                }
            }
        }
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> addAllCasingInfo() {
        this.addAllCasingInfo(null);
        return this;
    }

    public MultiblockTooltipBuilder2<MTE> addAllCasingInfo(List<ICasing> casingOrder) {
        ObjectArraySet addedCasings = new ObjectArraySet();
        CharArrayList casings = new CharArrayList((CharCollection)this.structure.casings.keySet());
        if (casingOrder != null && !casingOrder.isEmpty()) {
            CharComparator comparator = (a, b) -> {
                int i1 = casingOrder.indexOf(((StructureWrapper.CasingInfo)this.structure.casings.get((char)a)).casing);
                int i2 = casingOrder.indexOf(((StructureWrapper.CasingInfo)this.structure.casings.get((char)b)).casing);
                if (i1 == -1 || i2 == -1) {
                    return -Integer.compare(i1, i2);
                }
                return Integer.compare(i1, i2);
            };
            casings.sort(comparator);
        } else {
            casings.sort(null);
        }
        ArrayListMultimap hatches = ArrayListMultimap.create();
        CharListIterator charListIterator = casings.iterator();
        while (charListIterator.hasNext()) {
            char c = ((Character)charListIterator.next()).charValue();
            StructureWrapper.CasingInfo casingInfo = (StructureWrapper.CasingInfo)this.structure.casings.get(c);
            if (addedCasings.add((Object)casingInfo.casing)) {
                this.structure.addCasingInfoAuto(this, casingInfo.casing);
            }
            if (casingInfo.hatches == null) continue;
            for (IHatchElement hatch : casingInfo.hatches) {
                hatches.put((Object)Pair.of((Object)casingInfo.casing, hatch), (Object)casingInfo.dot);
            }
        }
        ArrayList<Pair> hatchesSorted = new ArrayList<Pair>((Collection<Pair>)hatches.keys());
        if (!this.hatchOrder.isEmpty()) {
            hatchesSorted.sort((p1, p2) -> {
                int i1 = this.hatchOrder.indexOf(p1.right());
                int i2 = this.hatchOrder.indexOf(p2.right());
                if (i1 == -1 || i2 == -1) {
                    return -Integer.compare(i1, i2);
                }
                return Integer.compare(i1, i2);
            });
        } else {
            ToIntFunction<Pair> comparator = p -> {
                Object patt8446$temp = p.right();
                if (patt8446$temp instanceof HatchElement) {
                    HatchElement gtHatch = (HatchElement)patt8446$temp;
                    return gtHatch.ordinal();
                }
                Object patt8564$temp = p.right();
                if (patt8564$temp instanceof TTMultiblockBase.HatchElement) {
                    TTMultiblockBase.HatchElement ttHatch = (TTMultiblockBase.HatchElement)patt8564$temp;
                    return ttHatch.ordinal() + 100;
                }
                return 200;
            };
            Comparator<Pair> customComparator = Comparator.nullsFirst(Comparator.comparing(p -> (String)this.hatchNameOverrides.get(p.right())));
            hatchesSorted.sort(Comparator.comparingInt(comparator).thenComparing(customComparator));
        }
        for (Pair hatch : hatchesSorted) {
            IntArrayList dots = new IntArrayList((IntCollection)new IntArraySet(hatches.get((Object)hatch)));
            dots.sort(null);
            this.addHatch((ICasing)hatch.left(), (IHatchElement)hatch.right(), dots.toIntArray());
        }
        if (this.printMultiampSupport && this.hasMultiampHatches) {
            this.addTecTechHatchInfo();
        }
        return this;
    }
}

