/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.items.manipulator;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.features.ILocatable;
import appeng.api.implementations.parts.IPartCable;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.DimensionalCoord;
import appeng.tile.misc.TileSecurity;
import appeng.tile.networking.TileWireless;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.gtnewhorizon.structurelib.util.XSTR;
import com.recursive_pineapple.matter_manipulator.asm.Optional;
import com.recursive_pineapple.matter_manipulator.common.building.AEAnalysisResult;
import com.recursive_pineapple.matter_manipulator.common.building.AEPartData;
import com.recursive_pineapple.matter_manipulator.common.building.BlockAnalyzer;
import com.recursive_pineapple.matter_manipulator.common.building.BlockSpec;
import com.recursive_pineapple.matter_manipulator.common.building.GTAnalysisResult;
import com.recursive_pineapple.matter_manipulator.common.building.ImmutableBlockSpec;
import com.recursive_pineapple.matter_manipulator.common.building.PendingBlock;
import com.recursive_pineapple.matter_manipulator.common.data.WeightedSpecList;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.ItemMatterManipulator;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Location;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.MMConfig;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Transform;
import com.recursive_pineapple.matter_manipulator.common.persist.NBTJsonAdapter;
import com.recursive_pineapple.matter_manipulator.common.persist.StaticEnumJsonAdapter;
import com.recursive_pineapple.matter_manipulator.common.persist.UIDJsonAdapter;
import com.recursive_pineapple.matter_manipulator.common.persist.WeightedListJsonAdapter;
import com.recursive_pineapple.matter_manipulator.common.uplink.IUplinkMulti;
import com.recursive_pineapple.matter_manipulator.common.utils.ImmutableBlockMeta;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.common.blocks.BlockMachines;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class MMState {
    static final Gson GSON = new GsonBuilder().registerTypeAdapter(GameRegistry.UniqueIdentifier.class, (Object)new UIDJsonAdapter()).registerTypeAdapter(NBTTagCompound.class, (Object)new NBTJsonAdapter()).registerTypeAdapter(ForgeDirection.class, new StaticEnumJsonAdapter<ForgeDirection>(ForgeDirection.class)).registerTypeAdapter(WeightedSpecList.class, (Object)new WeightedListJsonAdapter()).create();
    @SerializedName(value="jv")
    private int jsonVersion = 0;
    @SerializedName(value="dv")
    private int dataVersion = 0;
    public MMConfig config = new MMConfig();
    public Long encKey;
    public Long uplinkAddress;
    public double charge;
    @Optional(value={"appliedenergistics2"})
    public transient TileSecurity securityTerminal;
    @Optional(value={"appliedenergistics2"})
    public transient IGridNode gridNode;
    @Optional(value={"appliedenergistics2"})
    public transient IGrid grid;
    @Optional(value={"appliedenergistics2"})
    public transient IStorageGrid storageGrid;
    @Optional(value={"appliedenergistics2"})
    public transient IMEMonitor<IAEItemStack> itemStorage;
    @Optional(value={"appliedenergistics2"})
    private transient IWirelessAccessPoint prevAccessPoint;
    public transient IUplinkMulti uplink;

    public static MMState load(NBTTagCompound tag) {
        JsonObject obj = (JsonObject)MMUtils.toJsonObject((NBTBase)tag);
        MMState.migrateJson(obj);
        MMState state = (MMState)GSON.fromJson((JsonElement)obj, MMState.class);
        if (state == null) {
            state = new MMState();
        }
        if (state.config == null) {
            state.config = new MMConfig();
        }
        state.migrate();
        return state;
    }

    public NBTTagCompound save() {
        return (NBTTagCompound)MMUtils.toNbt(GSON.toJsonTree((Object)this));
    }

    private static void migrateJson(JsonObject obj) {
        int version;
        int n = version = obj.has("jv") ? obj.get("jv").getAsInt() : 0;
        if (version == 0) {
            JsonElement jsonElement = obj.get("config");
            if (jsonElement instanceof JsonObject) {
                JsonObject config = (JsonObject)jsonElement;
                config.remove("corners");
                config.remove("edges");
                config.remove("faces");
                config.remove("volumes");
                config.remove("cables");
                config.remove("replaceWhitelist");
                config.remove("replaceWith");
            }
            version = 1;
        }
        obj.addProperty("jv", (Number)version);
    }

    private void migrate() {
    }

    public boolean hasMEConnection() {
        if (!Mods.AppliedEnergistics2.isModLoaded()) {
            return false;
        }
        return this.encKey != null && this.securityTerminal != null && this.gridNode != null && this.grid != null && this.storageGrid != null && this.itemStorage != null;
    }

    @Optional(value={"appliedenergistics2"})
    public boolean connectToMESystem() {
        this.grid = null;
        this.storageGrid = null;
        this.itemStorage = null;
        if (this.encKey == null) {
            return false;
        }
        ILocatable grid = AEApi.instance().registries().locatable().getLocatableBy(this.encKey.longValue());
        if (grid instanceof TileSecurity) {
            TileSecurity security;
            this.securityTerminal = security = (TileSecurity)grid;
            this.gridNode = security.getGridNode(ForgeDirection.UNKNOWN);
            if (this.gridNode != null) {
                this.grid = this.gridNode.getGrid();
                this.storageGrid = (IStorageGrid)this.grid.getCache(IStorageGrid.class);
                if (this.storageGrid != null) {
                    this.itemStorage = this.storageGrid.getItemInventory();
                }
            }
        }
        return this.hasMEConnection();
    }

    public boolean canInteractWithAE(EntityPlayer player) {
        if (!Mods.AppliedEnergistics2.isModLoaded()) {
            return false;
        }
        if (this.grid == null) {
            return false;
        }
        IEnergyGrid eg = (IEnergyGrid)this.grid.getCache(IEnergyGrid.class);
        if (!eg.isNetworkPowered()) {
            return false;
        }
        ISecurityGrid sec = (ISecurityGrid)this.grid.getCache(ISecurityGrid.class);
        if (!sec.hasPermission(player, SecurityPermissions.EXTRACT) || !sec.hasPermission(player, SecurityPermissions.INJECT)) {
            return false;
        }
        if (this.checkAEDistance(player, this.prevAccessPoint)) {
            return true;
        }
        for (IGridNode node : this.grid.getMachines(TileWireless.class)) {
            if (!this.checkAEDistance(player, (IWirelessAccessPoint)node.getMachine())) continue;
            this.prevAccessPoint = (IWirelessAccessPoint)node.getMachine();
            return true;
        }
        this.prevAccessPoint = null;
        return false;
    }

    @Optional(value={"appliedenergistics2"})
    private boolean checkAEDistance(EntityPlayer player, IWirelessAccessPoint accessPoint) {
        if (accessPoint != null && accessPoint.getGrid() == this.grid && accessPoint.isActive()) {
            DimensionalCoord coord = accessPoint.getLocation();
            if (coord.getWorld().field_73011_w.field_76574_g != player.field_70170_p.field_73011_w.field_76574_g) {
                return false;
            }
            double distance = player.func_70092_e((double)coord.x, (double)coord.y, (double)coord.z);
            return Math.pow(accessPoint.getRange(), 2.0) >= distance;
        }
        return false;
    }

    public boolean connectToUplink() {
        this.uplink = null;
        if (this.uplinkAddress != null && this.uplinkAddress != 0L) {
            this.uplink = IUplinkMulti.getUplink(this.uplinkAddress);
            if (this.uplink != null && !this.uplink.isActive()) {
                this.uplink = null;
            }
        }
        return this.hasUplinkConnection();
    }

    public boolean hasUplinkConnection() {
        return this.uplink != null;
    }

    public Transform getTransform() {
        if (this.config.transform == null) {
            this.config.transform = new Transform();
        }
        return this.config.transform;
    }

    public List<PendingBlock> getPendingBlocks(ItemMatterManipulator.ManipulatorTier tier, World world) {
        List<PendingBlock> list;
        switch (this.config.placeMode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case COPYING: 
            case MOVING: {
                list = this.getAnalysis(world);
                break;
            }
            case GEOMETRY: {
                list = this.getGeomPendingBlocks(world);
                break;
            }
            case EXCHANGING: {
                list = this.getExchangeBlocks(tier, world);
                break;
            }
            case CABLES: {
                list = this.getCableBlocks(world);
            }
        }
        return list;
    }

    private List<PendingBlock> getAnalysis(World world) {
        Location coordA = this.config.coordA;
        Location coordB = this.config.coordB;
        Location coordC = this.config.coordC;
        if (!Location.areCompatible(coordA, coordB, coordC) || !coordA.isInWorld(world)) {
            return new ArrayList<PendingBlock>();
        }
        BlockAnalyzer.RegionAnalysis analysis = BlockAnalyzer.analyzeRegion(world, coordA, coordB, this.config.placeMode == PlaceMode.COPYING);
        if (this.config.placeMode == PlaceMode.COPYING) {
            Transform t = this.getTransform();
            t.cacheRotation();
            for (PendingBlock block : analysis.blocks) {
                Vector3i v = t.apply(block.toVec());
                block.x = v.x;
                block.y = v.y;
                block.z = v.z;
                block.transform(t);
            }
            for (PendingBlock block : analysis.blocks) {
                block.x += coordC.x;
                block.y += coordC.y;
                block.z += coordC.z;
            }
            if (this.config.arraySpan != null) {
                int sx = this.config.arraySpan.x;
                int sy = this.config.arraySpan.y;
                int sz = this.config.arraySpan.z;
                ArrayList<PendingBlock> base = new ArrayList<PendingBlock>(analysis.blocks);
                analysis.blocks.clear();
                for (int y = Math.min(sy, 0); y <= Math.max(sy, 0); ++y) {
                    for (int z = Math.min(sz, 0); z <= Math.max(sz, 0); ++z) {
                        for (int x = Math.min(sx, 0); x <= Math.max(sx, 0); ++x) {
                            int dx = x * (analysis.deltas.x + (analysis.deltas.x < 0 ? -1 : 1));
                            int dy = y * (analysis.deltas.y + (analysis.deltas.y < 0 ? -1 : 1));
                            int dz = z * (analysis.deltas.z + (analysis.deltas.z < 0 ? -1 : 1));
                            Vector3i d = new Vector3i(dx, dy, dz);
                            t.apply(d);
                            for (PendingBlock original : base) {
                                PendingBlock dup = original.clone(false);
                                dup.x += d.x;
                                dup.y += d.y;
                                dup.z += d.z;
                                analysis.blocks.add(dup);
                            }
                        }
                    }
                }
            }
            analysis.deltas = t.apply(analysis.deltas);
            t.uncacheRotation();
        } else {
            for (PendingBlock block : analysis.blocks) {
                block.x += coordC.x;
                block.y += coordC.y;
                block.z += coordC.z;
            }
        }
        return analysis.blocks;
    }

    private List<PendingBlock> getExchangeBlocks(ItemMatterManipulator.ManipulatorTier tier, World world) {
        Location coordA = this.config.coordA;
        Location coordB = this.config.coordB;
        if (!Location.areCompatible(coordA, coordB) || !coordA.isInWorld(world)) {
            return new ArrayList<PendingBlock>();
        }
        if (this.config.replaceWhitelist == null || this.config.replaceWhitelist.specs.isEmpty()) {
            return new ArrayList<PendingBlock>();
        }
        Vector3i deltas = MMUtils.getRegionDeltas(coordA, coordB);
        ArrayList<PendingBlock> pending = new ArrayList<PendingBlock>();
        XSTR rng = new XSTR((long)this.config.hashCode());
        BlockSpec existing = new BlockSpec();
        boolean replacingAir = this.config.replaceWhitelist.contains(BlockSpec.air());
        for (Vector3i voxel : MMUtils.getBlocksInBB(coordA, deltas)) {
            ImmutableBlockSpec replacement;
            int x = voxel.x;
            int y = voxel.y;
            int z = voxel.z;
            if (!replacingAir && world.func_147437_c(x, y, z)) continue;
            BlockSpec.fromBlock(existing, world, x, y, z);
            if (existing.shouldBeSkipped() || !replacingAir && existing.isAir()) continue;
            if (Mods.AppliedEnergistics2.isModLoaded()) {
                MMUtils.getAECable(existing, world, x, y, z);
            }
            if (!this.config.replaceWhitelist.contains(existing)) continue;
            ImmutableBlockSpec block = replacement = this.config.replaceWith.get((Random)rng);
            if (tier.hasCap(ItemMatterManipulator.ALLOW_CABLES) && Mods.AppliedEnergistics2.isModLoaded() && MMUtils.isAECable(replacement)) {
                block = ((ImmutableBlockMeta)MMUtils.AE_BLOCK_CABLE.get()).asSpec();
            }
            PendingBlock rep = block.instantiate(world, x, y, z);
            rep.analyze(world.func_147438_o(x, y, z), -1);
            rep.migrate();
            if (tier.hasCap(ItemMatterManipulator.ALLOW_CABLES) && Mods.AppliedEnergistics2.isModLoaded() && MMUtils.isAECable(replacement)) {
                this.placingAECable(rep, replacement);
            }
            pending.add(rep);
        }
        return pending;
    }

    @Optional(value={"appliedenergistics2"})
    private void placingAECable(PendingBlock pendingBlock, ImmutableBlockSpec cable) {
        if (pendingBlock.ae == null) {
            pendingBlock.ae = new AEAnalysisResult();
        }
        AEAnalysisResult ae = (AEAnalysisResult)pendingBlock.ae;
        if (ae.mAEParts == null) {
            ae.mAEParts = new AEPartData[7];
        }
        ae.mAEParts[ForgeDirection.UNKNOWN.ordinal()] = new AEPartData(((IPartItem)cable.getItem()).createPartFromItemStack(cable.getStack()));
    }

    private List<PendingBlock> getCableBlocks(World world) {
        Location coordA = this.config.coordA;
        Location coordB = this.config.coordB;
        if (!Location.areCompatible(coordA, coordB) || !coordA.isInWorld(world)) {
            return new ArrayList<PendingBlock>();
        }
        Vector3i a = coordA.toVec();
        Vector3i b = MMState.pinToAxes(a, coordB.toVec());
        ArrayList<PendingBlock> out = new ArrayList<PendingBlock>();
        if (this.config.cables == null) {
            BlockSpec pooled = new BlockSpec();
            for (Vector3i voxel : MMState.getLineVoxels(a.x, a.y, a.z, b.x, b.y, b.z)) {
                if (Mods.AppliedEnergistics2.isModLoaded() && MMUtils.getAECable(pooled, world, voxel.x, voxel.y, voxel.z)) {
                    PendingBlock pendingBlock = ((ImmutableBlockMeta)MMUtils.AE_BLOCK_CABLE.get()).asSpec().instantiate(world, voxel.x, voxel.y, voxel.z);
                    pendingBlock.analyze(world.func_147438_o(voxel.x, voxel.y, voxel.z), -1);
                    this.clearAECable(pendingBlock);
                    out.add(pendingBlock);
                    continue;
                }
                out.add(BlockSpec.AIR.instantiate(world, voxel.x, voxel.y, voxel.z));
            }
        } else {
            Block block = Block.func_149634_a((Item)this.config.cables.getItem());
            if (Mods.GregTech.isModLoaded()) {
                this.getGTCables(a, b, out, block, world, this.config.cables);
            }
            if (Mods.AppliedEnergistics2.isModLoaded()) {
                this.getAECables(a, b, out, block, world, this.config.cables);
            }
        }
        return out;
    }

    @Optional(value={"gregtech"})
    private void getGTCables(Vector3i a, Vector3i b, List<PendingBlock> out, Block block, World world, ImmutableBlockSpec cable) {
        if (block instanceof BlockMachines) {
            int end = 0;
            int start = 0;
            switch (new Vector3i((Vector3ic)b).sub((Vector3ic)a).maxComponent()) {
                case 0: {
                    start = b.x < a.x ? ForgeDirection.EAST.flag : ForgeDirection.WEST.flag;
                    end = b.x > a.x ? ForgeDirection.EAST.flag : ForgeDirection.WEST.flag;
                    break;
                }
                case 1: {
                    start = b.y < a.y ? ForgeDirection.UP.flag : ForgeDirection.DOWN.flag;
                    end = b.y > a.y ? ForgeDirection.UP.flag : ForgeDirection.DOWN.flag;
                    break;
                }
                case 2: {
                    start = b.z < a.z ? ForgeDirection.SOUTH.flag : ForgeDirection.NORTH.flag;
                    end = b.z > a.z ? ForgeDirection.SOUTH.flag : ForgeDirection.NORTH.flag;
                }
            }
            List<Vector3i> voxels = MMState.getLineVoxels(a.x, a.y, a.z, b.x, b.y, b.z);
            for (int i = 0; i < voxels.size(); ++i) {
                Vector3i voxel = voxels.get(i);
                GTAnalysisResult gt = GTAnalysisResult.analyze(world.func_147438_o(voxel.x, voxel.y, voxel.z));
                if (gt == null) {
                    gt = new GTAnalysisResult();
                }
                if (i > 0) {
                    gt.mConnections = (byte)(gt.mConnections | start);
                }
                if (i < voxels.size() - 1) {
                    gt.mConnections = (byte)(gt.mConnections | end);
                }
                PendingBlock pendingBlock = cable.instantiate(world, voxel.x, voxel.y, voxel.z);
                pendingBlock.gt = gt;
                out.add(pendingBlock);
            }
        }
    }

    @Optional(value={"appliedenergistics2"})
    private void getAECables(Vector3i a, Vector3i b, List<PendingBlock> out, Block block, World world, ImmutableBlockSpec cableSpec) {
        IPartItem partItem;
        Object object;
        Item item = cableSpec.getItem();
        if (item instanceof IPartItem && (object = (partItem = (IPartItem)item).createPartFromItemStack(cableSpec.getStack())) instanceof IPartCable) {
            IPartCable cable = (IPartCable)object;
            for (Vector3i voxel : MMState.getLineVoxels(a.x, a.y, a.z, b.x, b.y, b.z)) {
                AEAnalysisResult ae;
                int x = voxel.x;
                int y = voxel.y;
                int z = voxel.z;
                if (MMUtils.AE_BLOCK_CABLE.matches(world.func_147439_a(x, y, z), 0)) {
                    ae = AEAnalysisResult.analyze(world.func_147438_o(voxel.x, voxel.y, voxel.z));
                    ae.mAEParts[ForgeDirection.UNKNOWN.ordinal()] = new AEPartData((IPart)cable);
                } else {
                    ae = new AEAnalysisResult();
                    ae.mAEParts = new AEPartData[7];
                    ae.mAEParts[ForgeDirection.UNKNOWN.ordinal()] = new AEPartData((IPart)cable);
                }
                PendingBlock pendingBlock = cableSpec.instantiate(world, x, y, z);
                pendingBlock.ae = ae;
                out.add(pendingBlock);
            }
        }
    }

    @Optional(value={"appliedenergistics2"})
    private void clearAECable(PendingBlock pendingBlock) {
        if (pendingBlock.ae == null) {
            return;
        }
        AEAnalysisResult ae = (AEAnalysisResult)pendingBlock.ae;
        if (ae.mAEParts == null) {
            return;
        }
        ae.mAEParts[ForgeDirection.UNKNOWN.ordinal()] = null;
    }

    private List<PendingBlock> getGeomPendingBlocks(World world) {
        Location coordA = this.config.coordA;
        Location coordB = this.config.coordB;
        Location coordC = this.config.coordC;
        if (!Location.areCompatible(coordA, coordB) || !coordA.isInWorld(world)) {
            return new ArrayList<PendingBlock>();
        }
        if (!(!this.config.shape.requiresC() || Location.areCompatible(coordA, coordC) && coordA.isInWorld(world))) {
            return new ArrayList<PendingBlock>();
        }
        int x1 = this.config.coordA.x;
        int y1 = this.config.coordA.y;
        int z1 = this.config.coordA.z;
        int x2 = this.config.coordB.x;
        int y2 = this.config.coordB.y;
        int z2 = this.config.coordB.z;
        int minX = Math.min(x1, x2);
        int minY = Math.min(y1, y2);
        int minZ = Math.min(z1, z2);
        int maxX = Math.max(x1, x2);
        int maxY = Math.max(y1, y2);
        int maxZ = Math.max(z1, z2);
        ArrayList<PendingBlock> pending = new ArrayList<PendingBlock>();
        switch (this.config.shape) {
            case LINE: {
                this.iterateLine(pending, x1, y1, z1, x2, y2, z2);
                break;
            }
            case CUBE: {
                this.iterateCube(pending, minX, minY, minZ, maxX, maxY, maxZ);
                break;
            }
            case SPHERE: {
                this.iterateSphere(pending, minX, minY, minZ, maxX, maxY, maxZ);
                break;
            }
            case CYLINDER: {
                this.iterateCylinder(pending, coordA.toVec(), coordB.toVec(), coordC.toVec());
            }
        }
        return pending;
    }

    private static List<Vector3i> getLineVoxels(int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<Vector3i> voxels = new ArrayList<Vector3i>();
        int dx = Math.abs(x1 - x2);
        int dy = Math.abs(y1 - y2);
        int dz = Math.abs(z1 - z2);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int sz = z1 < z2 ? 1 : -1;
        voxels.add(new Vector3i(x1, y1, z1));
        if (dx >= dy && dx >= dz) {
            int p1 = 2 * dy - dx;
            int p2 = 2 * dz - dx;
            while (x1 != x2) {
                x1 += sx;
                if (p1 >= 0) {
                    y1 += sy;
                    p1 -= 2 * dx;
                }
                if (p2 >= 0) {
                    z1 += sz;
                    p2 -= 2 * dx;
                }
                p1 += 2 * dy;
                p2 += 2 * dz;
                voxels.add(new Vector3i(x1, y1, z1));
            }
        } else if (dy >= dx && dy >= dz) {
            int p1 = 2 * dx - dy;
            int p2 = 2 * dz - dy;
            while (y1 != y2) {
                y1 += sy;
                if (p1 >= 0) {
                    x1 += sx;
                    p1 -= 2 * dy;
                }
                if (p2 >= 0) {
                    z1 += sz;
                    p2 -= 2 * dy;
                }
                p1 += 2 * dx;
                p2 += 2 * dz;
                voxels.add(new Vector3i(x1, y1, z1));
            }
        } else {
            int p1 = 2 * dy - dz;
            int p2 = 2 * dx - dz;
            while (z1 != z2) {
                z1 += sz;
                if (p1 >= 0) {
                    y1 += sy;
                    p1 -= 2 * dz;
                }
                if (p2 >= 0) {
                    x1 += sx;
                    p2 -= 2 * dz;
                }
                p1 += 2 * dy;
                p2 += 2 * dx;
                voxels.add(new Vector3i(x1, y1, z1));
            }
        }
        return voxels;
    }

    private void iterateLine(ArrayList<PendingBlock> pending, int x1, int y1, int z1, int x2, int y2, int z2) {
        XSTR rng = new XSTR((long)this.config.hashCode());
        for (Vector3i voxel : MMState.getLineVoxels(x1, y1, z1, x2, y2, z2)) {
            pending.add(this.config.edges.get((Random)rng).instantiate(this.config.coordA.worldId, voxel.x, voxel.y, voxel.z));
        }
    }

    private void iterateCube(ArrayList<PendingBlock> pending, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        XSTR rng = new XSTR((long)this.config.hashCode());
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    ImmutableBlockSpec immutableBlockSpec;
                    int insideCount = 0;
                    if (x > minX && x < maxX) {
                        ++insideCount;
                    }
                    if (y > minY && y < maxY) {
                        ++insideCount;
                    }
                    if (z > minZ && z < maxZ) {
                        ++insideCount;
                    }
                    switch (insideCount) {
                        case 0: {
                            immutableBlockSpec = this.config.corners.get((Random)rng);
                            break;
                        }
                        case 1: {
                            immutableBlockSpec = this.config.edges.get((Random)rng);
                            break;
                        }
                        case 2: {
                            immutableBlockSpec = this.config.faces.get((Random)rng);
                            break;
                        }
                        case 3: {
                            immutableBlockSpec = this.config.volumes.get((Random)rng);
                            break;
                        }
                        default: {
                            immutableBlockSpec = BlockSpec.AIR;
                        }
                    }
                    ImmutableBlockSpec spec = immutableBlockSpec;
                    pending.add(spec.instantiate(this.config.coordA.worldId, x, y, z).setOrders(insideCount, insideCount));
                }
            }
        }
    }

    private void iterateSphere(ArrayList<PendingBlock> pending, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        XSTR rng = new XSTR((long)this.config.hashCode());
        int sx = maxX - minX + 1;
        int sy = maxY - minY + 1;
        int sz = maxZ - minZ + 1;
        double rx = (double)sx / 2.0;
        double ry = (double)sy / 2.0;
        double rz = (double)sz / 2.0;
        boolean[][][] present = new boolean[sx + 2][sy + 2][sz + 2];
        for (int x = 0; x < sx; ++x) {
            for (int y = 0; y < sy; ++y) {
                for (int z = 0; z < sz; ++z) {
                    double distance = Math.sqrt((rx > 1.0 ? Math.pow(((double)x - rx + 0.5) / rx, 2.0) : 0.0) + (ry > 1.0 ? Math.pow(((double)y - ry + 0.5) / ry, 2.0) : 0.0) + (rz > 1.0 ? Math.pow(((double)z - rz + 0.5) / rz, 2.0) : 0.0));
                    if (!(distance <= 1.0)) continue;
                    PendingBlock block = this.config.volumes.get((Random)rng).instantiate(this.config.coordA.worldId, x + minX, y + minY, z + minZ).setOrders(1, 1);
                    present[x + 1][y + 1][z + 1] = true;
                    pending.add(block);
                }
            }
        }
        ArrayList<ForgeDirection> directions = new ArrayList<ForgeDirection>();
        if (rx > 1.0) {
            directions.add(ForgeDirection.EAST);
            directions.add(ForgeDirection.WEST);
        }
        if (ry > 1.0) {
            directions.add(ForgeDirection.UP);
            directions.add(ForgeDirection.DOWN);
        }
        if (rz > 1.0) {
            directions.add(ForgeDirection.NORTH);
            directions.add(ForgeDirection.SOUTH);
        }
        block3: for (PendingBlock block : pending) {
            for (ForgeDirection dir : directions) {
                if (present[block.x - minX + 1 + dir.offsetX][block.y - minY + 1 + dir.offsetY][block.z - minZ + 1 + dir.offsetZ]) continue;
                block.setBlock(this.config.faces.get((Random)rng));
                block.buildOrder = 0;
                block.renderOrder = 0;
                continue block3;
            }
        }
    }

    private void iterateCylinder(ArrayList<PendingBlock> pending, Vector3i coordA, Vector3i coordB, Vector3i coordC) {
        int h;
        Vector3i vecH;
        Vector3i vecB;
        Vector3i vecA;
        XSTR rng = new XSTR((long)this.config.hashCode());
        Vector3i b2 = MMState.pinToPlanes(coordA, coordB);
        Vector3i height = MMState.pinToLine(coordA, b2, coordC).sub((Vector3ic)coordA);
        Vector3i delta = new Vector3i((Vector3ic)b2).sub((Vector3ic)coordA);
        delta.x += MMUtils.signum(delta.x);
        delta.y += MMUtils.signum(delta.y);
        delta.z += MMUtils.signum(delta.z);
        int dA = 0;
        int dB = 0;
        int dH = 0;
        switch (delta.minComponent()) {
            case 0: {
                dA = delta.y;
                dB = delta.z;
                dH = height.x;
                vecA = new Vector3i(0, MMUtils.signum(delta.y), 0);
                vecB = new Vector3i(0, 0, MMUtils.signum(delta.z));
                vecH = new Vector3i(MMUtils.signum(height.x), 0, 0);
                break;
            }
            case 1: {
                dA = delta.x;
                dB = delta.z;
                dH = height.y;
                vecA = new Vector3i(MMUtils.signum(delta.x), 0, 0);
                vecB = new Vector3i(0, 0, MMUtils.signum(delta.z));
                vecH = new Vector3i(0, MMUtils.signum(height.y), 0);
                break;
            }
            case 2: {
                dA = delta.x;
                dB = delta.y;
                dH = height.z;
                vecA = new Vector3i(MMUtils.signum(delta.x), 0, 0);
                vecB = new Vector3i(0, MMUtils.signum(delta.y), 0);
                vecH = new Vector3i(0, 0, MMUtils.signum(height.z));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        int absA = Math.abs(dA);
        int absB = Math.abs(dB);
        int absH = Math.abs(dH) + 1;
        float rA = (float)absA / 2.0f;
        float rB = (float)absB / 2.0f;
        boolean[][][] present = new boolean[absA + 2][absH + 2][absB + 2];
        for (int a = 0; a < absA; ++a) {
            for (int b = 0; b < absB; ++b) {
                double distance = Math.pow(((double)((float)a - rA) + 0.5) / (double)rA, 2.0) + Math.pow(((double)((float)b - rB) + 0.5) / (double)rB, 2.0);
                if (!(distance <= 1.0)) continue;
                for (h = 0; h < absH; ++h) {
                    PendingBlock block = this.config.volumes.get((Random)rng).instantiate(this.config.coordA.worldId, a, h, b).setOrders(2, 0);
                    present[a + 1][h + 1][b + 1] = true;
                    pending.add(block);
                }
            }
        }
        for (PendingBlock block : pending) {
            int adj = 0;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!present[block.x + 1 + dir.offsetX][block.y + 1 + dir.offsetY][block.z + 1 + dir.offsetZ]) continue;
                adj = (byte)(adj | dir.flag);
            }
            if (adj == 63) continue;
            if ((adj & 0x3C) == 60) {
                block.setBlock(this.config.edges.get((Random)rng));
                block.buildOrder = 1;
                block.renderOrder = 1;
                continue;
            }
            block.setBlock(this.config.faces.get((Random)rng));
            block.buildOrder = 2;
            block.renderOrder = 0;
        }
        for (PendingBlock block : pending) {
            int a = block.x;
            int b = block.z;
            h = block.y;
            block.x = a * vecA.x + b * vecB.x + h * vecH.x + coordA.x;
            block.y = a * vecA.y + b * vecB.y + h * vecH.y + coordA.y;
            block.z = a * vecA.z + b * vecB.z + h * vecH.z + coordA.z;
        }
    }

    public static Vector3i pinToPlanes(Vector3i origin, Vector3i point) {
        int dX = Math.abs(point.x - origin.x);
        int dY = Math.abs(point.y - origin.y);
        int dZ = Math.abs(point.z - origin.z);
        int shortest = MMUtils.min(dX, dY, dZ);
        if (shortest == dX) {
            return new Vector3i(origin.x, point.y, point.z);
        }
        if (shortest == dY) {
            return new Vector3i(point.x, origin.y, point.z);
        }
        return new Vector3i(point.x, point.y, origin.z);
    }

    public static Vector3i pinToLine(Vector3i origin, Vector3i b, Vector3i point) {
        Vector3i vector3i;
        switch (new Vector3i((Vector3ic)b).sub((Vector3ic)origin).minComponent()) {
            case 0: {
                vector3i = new Vector3i(point.x, origin.y, origin.z);
                break;
            }
            case 1: {
                vector3i = new Vector3i(origin.x, point.y, origin.z);
                break;
            }
            case 2: {
                vector3i = new Vector3i(origin.x, origin.y, point.z);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return vector3i;
    }

    public static Vector3i pinToAxes(Vector3i origin, Vector3i point) {
        Vector3i vector3i;
        switch (new Vector3i((Vector3ic)point).sub((Vector3ic)origin).maxComponent()) {
            case 0: {
                vector3i = new Vector3i(point.x, origin.y, origin.z);
                break;
            }
            case 1: {
                vector3i = new Vector3i(origin.x, point.y, origin.z);
                break;
            }
            case 2: {
                vector3i = new Vector3i(origin.x, origin.y, point.z);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return vector3i;
    }

    public static enum PlaceMode {
        GEOMETRY,
        MOVING,
        COPYING,
        EXCHANGING,
        CABLES;

    }

    public static enum Shape {
        LINE,
        CUBE,
        SPHERE,
        CYLINDER;


        public boolean requiresC() {
            boolean bl;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case LINE: 
                case CUBE: 
                case SPHERE: {
                    bl = false;
                    break;
                }
                case CYLINDER: {
                    bl = true;
                }
            }
            return bl;
        }
    }

    public static enum BlockRemoveMode {
        NONE,
        REPLACEABLE,
        ALL;

    }

    public static enum BlockSelectMode {
        CORNERS,
        EDGES,
        FACES,
        VOLUMES,
        ALL;

    }

    public static enum PendingAction {
        MOVING_COORDS,
        MARK_COPY_A,
        MARK_COPY_B,
        MARK_CUT_A,
        MARK_CUT_B,
        MARK_PASTE,
        GEOM_SELECTING_BLOCK,
        EXCH_SET_TARGET,
        EXCH_ADD_REPLACE,
        EXCH_SET_REPLACE,
        PICK_CABLE,
        MARK_ARRAY;

    }
}

