/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.orderer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.Configs;
import logisticspipes.gui.orderer.GuiOrderer;
import logisticspipes.gui.popup.GuiDiskPopup;
import logisticspipes.gui.popup.GuiRequestPopup;
import logisticspipes.gui.popup.RequestMonitorPopup;
import logisticspipes.interfaces.IChainAddList;
import logisticspipes.interfaces.IDiskProvider;
import logisticspipes.interfaces.ISpecialItemRenderer;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.block.ClearCraftingGridPacket;
import logisticspipes.network.packets.block.CraftingCycleRecipe;
import logisticspipes.network.packets.orderer.DiskRequestConectPacket;
import logisticspipes.network.packets.orderer.OrdererRefreshRequestPacket;
import logisticspipes.network.packets.orderer.RequestComponentPacket;
import logisticspipes.network.packets.orderer.RequestSubmitListPacket;
import logisticspipes.network.packets.orderer.RequestSubmitPacket;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.resources.IResource;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LinkedLogisticsOrderList;
import logisticspipes.utils.ChainAddArrayList;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.GuiCheckBox;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.IItemSearch;
import logisticspipes.utils.gui.ISubGuiControler;
import logisticspipes.utils.gui.ItemDisplay;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import logisticspipes.utils.gui.SearchBar;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.gui.extention.GuiExtention;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.string.ChatColor;
import logisticspipes.utils.string.StringUtils;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiRequestTable
extends LogisticsBaseGuiScreen
implements IItemSearch,
ISpecialItemRenderer,
IDiskProvider {
    private static final int[] AMOUNT_CHANGE_MODE = new int[]{1, 10, 64, 64};
    protected DisplayOptions displayOptions = DisplayOptions.Both;
    public final PipeBlockRequestTable _table;
    private SmallGuiButton Macrobutton;
    public final EntityPlayer _entityPlayer;
    public ItemDisplay itemDisplay;
    private SearchBar search;
    protected final String _title = "Request items";
    public int dimension;
    private boolean showRequest = true;
    private int startLeft;
    private int startXSize;
    private final BitSet handledExtention = new BitSet();
    private int orderIdForButton;
    private final GuiButton[] sycleButtons = new GuiButton[2];
    private final IChainAddList<GuiButton> moveWhileSmall = new ChainAddArrayList<GuiButton>();
    private final IChainAddList<GuiButton> hideWhileSmall = new ChainAddArrayList<GuiButton>();
    private GuiButton hideShowButton;

    public GuiRequestTable(EntityPlayer entityPlayer, PipeBlockRequestTable table) {
        super(410, 240, 0, 0);
        int x;
        int y;
        this._table = table;
        this._entityPlayer = entityPlayer;
        this.dimension = GuiOrderer.cachetime + 100L < System.currentTimeMillis() ? MainProxy.getDimensionForWorld(this._table.getWorld()) : GuiOrderer.dimensioncache;
        DummyContainer dummy = new DummyContainer((IInventory)entityPlayer.field_71071_by, this._table.matrix);
        int i = 0;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                dummy.addNormalSlot(i++, this._table.inv, this.field_147003_i + x * 18 + 20, this.field_147009_r + y * 18 + 80);
            }
        }
        i = 0;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                dummy.addDummySlot(i++, this.field_147003_i + x * 18 + 20, this.field_147009_r + y * 18 + 15);
            }
        }
        dummy.addCallableSlotHandler(0, this._table.resultInv, this.field_147003_i + 101, this.field_147009_r + 33, () -> this._table.getResultForClick(entityPlayer));
        dummy.addNormalSlot(0, this._table.toSortInv, this.field_147003_i + 164, this.field_147009_r + 51);
        dummy.addNormalSlot(0, this._table.diskInv, this.field_147003_i + 164, this.field_147009_r + 25);
        dummy.addNormalSlotsForPlayerInventory(20, 150);
        this.field_147002_h = dummy;
        this.refreshItems();
    }

    @Override
    public void func_73866_w_() {
        boolean reHide = false;
        if (!this.showRequest) {
            this.field_147003_i = this.startLeft;
            this.field_146999_f = this.startXSize;
            this.showRequest = true;
            reHide = true;
        }
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(this.hideWhileSmall.addChain(new GuiButton(0, this.right - 55, this.bottom - 25, 50, 20, "Request")));
        this.field_146292_n.add(this.hideWhileSmall.addChain(new SmallGuiButton(1, this.right - 15, this.field_147009_r + 5, 10, 10, ">")));
        this.field_146292_n.add(this.hideWhileSmall.addChain(new SmallGuiButton(2, this.right - 90, this.field_147009_r + 5, 10, 10, "<")));
        this.field_146292_n.add(this.hideWhileSmall.addChain(new SmallGuiButton(10, this.right - 148, this.bottom - 15, 26, 10, "---")));
        this.field_146292_n.add(this.hideWhileSmall.addChain(new SmallGuiButton(4, this.right - 148, this.bottom - 26, 15, 10, "--")));
        this.field_146292_n.add(this.hideWhileSmall.addChain(new SmallGuiButton(5, this.right - 132, this.bottom - 26, 10, 10, "-")));
        this.field_146292_n.add(this.hideWhileSmall.addChain(new SmallGuiButton(6, this.right - 86, this.bottom - 26, 10, 10, "+")));
        this.field_146292_n.add(this.hideWhileSmall.addChain(new SmallGuiButton(7, this.right - 74, this.bottom - 26, 15, 10, "++")));
        this.field_146292_n.add(this.hideWhileSmall.addChain(new SmallGuiButton(11, this.right - 86, this.bottom - 15, 26, 10, "+++")));
        this.field_146292_n.add(this.hideWhileSmall.addChain(new SmallGuiButton(34, this.right - 86, this.bottom - 41, 10, 10, "X")));
        this.field_146292_n.add(this.hideWhileSmall.addChain(new GuiCheckBox(8, this.field_147003_i + 209, this.bottom - 60, 14, 14, Configs.DISPLAY_POPUP)));
        this.field_146292_n.add(this.hideWhileSmall.addChain(new SmallGuiButton(3, this.field_147003_i + 210, this.bottom - 15, 46, 10, "Refresh")));
        this.field_146292_n.add(this.hideWhileSmall.addChain(new SmallGuiButton(13, this.field_147003_i + 210, this.bottom - 28, 46, 10, "Content")));
        this.field_146292_n.add(this.hideWhileSmall.addChain(new SmallGuiButton(9, this.field_147003_i + 210, this.bottom - 41, 46, 10, "Both")));
        this.field_146292_n.add(this.hideWhileSmall.addChain(new SmallGuiButton(20, this.right - 116, this.bottom - 41, 26, 10, "Sort")));
        this.field_146292_n.add(this.moveWhileSmall.addChain(new SmallGuiButton(14, this.field_147003_i + 96, this.field_147009_r + 53, 10, 10, "+")));
        this.field_146292_n.add(this.moveWhileSmall.addChain(new SmallGuiButton(15, this.field_147003_i + 108, this.field_147009_r + 53, 15, 10, "++")));
        this.field_146292_n.add(this.moveWhileSmall.addChain(new SmallGuiButton(16, this.field_147003_i + 96, this.field_147009_r + 64, 26, 10, "+++")));
        this.field_146292_n.add(this.moveWhileSmall.addChain(new SmallGuiButton(30, this.field_147003_i + 125, this.field_147009_r + 21, 10, 10, "X")));
        this.field_146292_n.add(this.moveWhileSmall.addChain(new SmallGuiButton(31, this.field_147003_i + 96, this.field_147009_r + 10, 10, 10, "~", 3)));
        this.field_146292_n.add(this.moveWhileSmall.addChain(new SmallGuiButton(32, this.field_147003_i + 108, this.field_147009_r + 10, 15, 10, "~~", 3)));
        this.field_146292_n.add(this.moveWhileSmall.addChain(new SmallGuiButton(33, this.field_147003_i + 96, this.field_147009_r + 21, 26, 10, "~~~", 3)));
        this.hideShowButton = new SmallGuiButton(17, this.field_147003_i + 173, this.field_147009_r + 5, 36, 10, "Hide");
        this.field_146292_n.add(this.hideShowButton);
        this.Macrobutton = new SmallGuiButton(18, this.right - 55, this.bottom - 60, 50, 10, "Disk");
        this.field_146292_n.add(this.Macrobutton);
        this.Macrobutton.field_146124_l = false;
        this.sycleButtons[0] = this.addButton(new SmallGuiButton(21, this.field_147003_i + 124, this.field_147009_r + 30, 15, 10, "/\\"));
        this.addButton(new SmallGuiButton(21, this.field_147003_i + 124, this.field_147009_r + 30, 15, 10, "/\\")).field_146125_m = false;
        this.sycleButtons[1] = this.addButton(new SmallGuiButton(22, this.field_147003_i + 124, this.field_147009_r + 42, 15, 10, "\\/"));
        this.addButton(new SmallGuiButton(22, this.field_147003_i + 124, this.field_147009_r + 42, 15, 10, "\\/")).field_146125_m = false;
        if (this.search == null) {
            this.search = new SearchBar(this.field_146297_k.field_71466_p, this, this.field_147003_i + 205, this.bottom - 78, 200, 15);
        }
        this.search.reposition(this.field_147003_i + 205, this.bottom - 78, 200, 15);
        if (this.itemDisplay == null) {
            this.itemDisplay = new ItemDisplay(this, this.field_146297_k.field_71466_p, this, this, this.field_147003_i + 205, this.field_147009_r + 18, 200, this.field_147000_g - 100, AMOUNT_CHANGE_MODE, true);
        }
        this.itemDisplay.reposition(this.field_147003_i + 205, this.field_147009_r + 18, 200, this.field_147000_g - 100);
        this.startLeft = this.field_147003_i;
        this.startXSize = this.field_146999_f;
        if (reHide) {
            this.showRequest = false;
            this.field_146999_f = this.startXSize - 210;
            this.field_147003_i = this.startLeft + 105;
            for (GuiButton button : this.moveWhileSmall) {
                button.field_146128_h += 105;
            }
            this.hideShowButton.field_146128_h += 90;
            this.hideShowButton.field_146126_j = "Show";
            for (GuiButton button : this.hideWhileSmall) {
                button.field_146125_m = false;
            }
            this.Macrobutton.field_146125_m = false;
        }
    }

    @Override
    public void func_146976_a(float f, int i, int j) {
        int a;
        int y;
        int x;
        for (GuiButton sycleButton : this.sycleButtons) {
            sycleButton.field_146125_m = this._table.targetType != null;
        }
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.field_147003_i, this.field_147009_r, this.right - (this.showRequest ? 0 : 105), this.bottom, this.field_73735_i, true);
        this.drawRect(this.field_147003_i + 162, this.field_147009_r + 23, this.field_147003_i + 182, this.field_147009_r + 43, Color.BLACK);
        this.drawRect(this.field_147003_i + 164, this.field_147009_r + 25, this.field_147003_i + 180, this.field_147009_r + 41, Color.DARKER_GREY);
        if (this.showRequest) {
            this.field_146297_k.field_71466_p.func_78276_b("Request items", this.field_147003_i + 180 + this.field_146297_k.field_71466_p.func_78256_a("Request items") / 2, this.field_147009_r + 6, 0x404040);
            this.itemDisplay.renderPageNumber(this.right - 47, this.field_147009_r + 6);
            if (this.field_146292_n.get(9) instanceof GuiCheckBox && ((GuiCheckBox)((Object)this.field_146292_n.get(9))).getState()) {
                this.field_146297_k.field_71466_p.func_78276_b("Popup", this.field_147003_i + 225, this.bottom - 56, 0x404040);
            } else {
                this.field_146297_k.field_71466_p.func_78276_b("Popup", this.field_147003_i + 225, this.bottom - 56, Color.getValue(Color.GREY));
            }
            this.itemDisplay.renderAmount(this.right - 103, this.bottom - 24, this.getStackAmount());
            this.search.renderSearchBar();
            this.itemDisplay.renderSortMode(this.right - 103, this.bottom - 52);
            this.itemDisplay.renderItemArea(this.field_73735_i);
        }
        for (x = 0; x < 9; ++x) {
            for (y = 0; y < 3; ++y) {
                GuiGraphics.drawSlotBackground(this.field_146297_k, this.field_147003_i + x * 18 + 19, this.field_147009_r + y * 18 + 79);
            }
        }
        for (x = 0; x < 3; ++x) {
            for (y = 0; y < 3; ++y) {
                GuiGraphics.drawSlotBackground(this.field_146297_k, this.field_147003_i + x * 18 + 19, this.field_147009_r + y * 18 + 14);
            }
        }
        this.field_146297_k.field_71466_p.func_78276_b("Sort:", this.field_147003_i + 136, this.field_147009_r + 55, 0xFFFFFF);
        GuiGraphics.drawSlotBackground(this.field_146297_k, this.field_147003_i + 100, this.field_147009_r + 32);
        GuiGraphics.drawSlotBackground(this.field_146297_k, this.field_147003_i + 163, this.field_147009_r + 50);
        this.drawRect(this.field_147003_i + 75, this.field_147009_r + 38, this.field_147003_i + 95, this.field_147009_r + 43, Color.DARKER_GREY);
        for (a = 0; a < 10; ++a) {
            this.drawRect(this.field_147003_i + 97 - a, this.field_147009_r + 40 - a, this.field_147003_i + 98 - a, this.field_147009_r + 41 + a, Color.DARKER_GREY);
        }
        for (a = 0; a < 15; ++a) {
            this.drawRect(this.field_147003_i + 164 + a, this.field_147009_r + 51 + a, this.field_147003_i + 166 + a, this.field_147009_r + 53 + a, Color.DARKER_GREY);
            this.drawRect(this.field_147003_i + 164 + a, this.field_147009_r + 65 - a, this.field_147003_i + 166 + a, this.field_147009_r + 67 - a, Color.DARKER_GREY);
        }
        GuiGraphics.drawPlayerInventoryBackground(this.field_146297_k, this.field_147003_i + 20, this.field_147009_r + 150);
        for (final Map.Entry<Integer, Pair<IResource, LinkedLogisticsOrderList>> entry : this._table.watchedRequests.entrySet()) {
            if (this.handledExtention.get(entry.getKey())) continue;
            this.handledExtention.set(entry.getKey());
            this.extentionControllerLeft.addExtention(new GuiExtention(){
                private final Map<Pair<Integer, Integer>, IOrderInfoProvider> ordererPosition = new HashMap<Pair<Integer, Integer>, IOrderInfoProvider>();
                private int height;
                private int width = 4;
                private GuiButton localControlledButton;

                @Override
                public void renderForground(int left, int top) {
                    if (!GuiRequestTable.this._table.watchedRequests.containsKey(entry.getKey())) {
                        GuiRequestTable.this.extentionControllerLeft.removeExtention(this);
                        if (this.isFullyExtended() && this.localControlledButton != null) {
                            GuiRequestTable.this.field_146292_n.remove(this.localControlledButton);
                            this.localControlledButton = null;
                            GuiRequestTable.this.orderIdForButton = -1;
                        }
                        return;
                    }
                    this.ordererPosition.clear();
                    GL11.glEnable((int)32826);
                    OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                    GL11.glEnable((int)2896);
                    GL11.glEnable((int)2929);
                    RenderHelper.func_74520_c();
                    ItemStack stack = null;
                    IResource resource = (IResource)((Pair)entry.getValue()).getValue1();
                    String s = null;
                    if (resource != null) {
                        stack = resource.getDisplayItem().makeNormalStack();
                        field_146296_j.func_82406_b(GuiRequestTable.this.field_146297_k.field_71466_p, GuiRequestTable.this.getMC().field_71446_o, stack, left + 5, top + 5);
                        field_146296_j.func_94148_a(GuiRequestTable.this.field_146297_k.field_71466_p, GuiRequestTable.this.getMC().field_71446_o, stack, left + 5, top + 5, "");
                        s = StringUtils.getFormatedStackSize(stack.field_77994_a, false);
                    } else {
                        s = "List";
                    }
                    GL11.glDisable((int)2896);
                    GL11.glDisable((int)2929);
                    field_146296_j.field_77023_b = 0.0f;
                    GuiRequestTable.this.field_146297_k.field_71466_p.func_78261_a(s, left + 22 - GuiRequestTable.this.field_146297_k.field_71466_p.func_78256_a(s), top + 14, 0xFFFFFF);
                    if (this.isFullyExtended()) {
                        if (this.localControlledButton == null || GuiRequestTable.this.orderIdForButton != (Integer)entry.getKey()) {
                            if (this.localControlledButton != null) {
                                GuiRequestTable.this.field_146292_n.remove(this.localControlledButton);
                            }
                            this.localControlledButton = new SmallGuiButton(100, GuiRequestTable.this.field_147003_i - 35, GuiRequestTable.this.field_147009_r + 10, 30, 10, "more");
                            GuiRequestTable.this.field_146292_n.add(this.localControlledButton);
                            GuiRequestTable.this.orderIdForButton = (Integer)entry.getKey();
                        }
                        List<IOrderInfoProvider> list = ((LinkedLogisticsOrderList)((Pair)entry.getValue()).getValue2()).getList();
                        this.calculateSize(left, top, list);
                        String ident = "ID: " + entry.getKey();
                        GuiRequestTable.this.field_146297_k.field_71466_p.func_78261_a(ident, left + 25, top + 7, 0xFFFFFF);
                        int x = left + 6;
                        int y = top + 25;
                        for (IOrderInfoProvider order : list) {
                            stack = order.getAsDisplayItem().makeNormalStack();
                            if (stack.field_77994_a <= 0) continue;
                            GL11.glEnable((int)2896);
                            GL11.glEnable((int)2929);
                            RenderHelper.func_74520_c();
                            field_146296_j.func_82406_b(GuiRequestTable.this.field_146297_k.field_71466_p, GuiRequestTable.this.getMC().field_71446_o, stack, x, y);
                            field_146296_j.func_94148_a(GuiRequestTable.this.field_146297_k.field_71466_p, GuiRequestTable.this.getMC().field_71446_o, stack, x, y, "");
                            s = StringUtils.getFormatedStackSize(stack.field_77994_a, false);
                            GL11.glDisable((int)2896);
                            GL11.glDisable((int)2929);
                            field_146296_j.field_77023_b = 0.0f;
                            GuiRequestTable.this.field_146297_k.field_71466_p.func_78261_a(s, x + 17 - GuiRequestTable.this.field_146297_k.field_71466_p.func_78256_a(s), y + 9, 0xFFFFFF);
                            this.ordererPosition.put(new Pair<Integer, Integer>(x, y), order);
                            if ((x += 18) <= left + this.getFinalWidth() - 18) continue;
                            x = left + 6;
                            y += 18;
                        }
                    } else if (this.isExtending()) {
                        List<IOrderInfoProvider> list = ((LinkedLogisticsOrderList)((Pair)entry.getValue()).getValue2()).getList();
                        this.calculateSize(left, top, list);
                    }
                    if (!this.isFullyExtended() && this.localControlledButton != null) {
                        GuiRequestTable.this.field_146292_n.remove(this.localControlledButton);
                        this.localControlledButton = null;
                        GuiRequestTable.this.orderIdForButton = -1;
                    }
                    RenderHelper.func_74518_a();
                }

                private void calculateSize(int left, int top, List<IOrderInfoProvider> list) {
                    ItemStack stack;
                    int x = left + 6;
                    int y = 50;
                    int line = 1;
                    this.width = 4;
                    for (IOrderInfoProvider order : list) {
                        stack = order.getAsDisplayItem().makeNormalStack();
                        if (stack.field_77994_a <= 0 || line++ % 16 != 0) continue;
                        ++this.width;
                    }
                    for (IOrderInfoProvider order : list) {
                        stack = order.getAsDisplayItem().makeNormalStack();
                        if (stack.field_77994_a <= 0 || (x += 18) <= left + this.getFinalWidth() - 18) continue;
                        x = left + 6;
                        y += 18;
                    }
                    this.height = y;
                    if (x == left + 6) {
                        this.height -= 18;
                    }
                }

                @Override
                public int getFinalWidth() {
                    return Math.max(85, this.width * 18 + 8);
                }

                @Override
                public int getFinalHeight() {
                    return Math.max(50, this.height);
                }

                @Override
                public void handleMouseOverAt(int xPos, int yPos) {
                    if (this.isFullyExtended()) {
                        for (Pair<Integer, Integer> key : this.ordererPosition.keySet()) {
                            if (xPos < key.getValue1() || xPos >= key.getValue1() + 18 || yPos < key.getValue2() || yPos >= key.getValue2() + 18) continue;
                            IOrderInfoProvider order = this.ordererPosition.get(key);
                            ArrayList<String> list = new ArrayList<String>();
                            list.add((Object)((Object)ChatColor.BLUE) + "Request Type: " + (Object)((Object)ChatColor.YELLOW) + order.getType().name());
                            list.add((Object)((Object)ChatColor.BLUE) + "Send to Router ID: " + (Object)((Object)ChatColor.YELLOW) + order.getRouterId());
                            GuiGraphics.displayItemToolTip(new Object[]{xPos - 10, yPos, order.getAsDisplayItem().makeNormalStack(), true, list}, GuiRequestTable.this.field_73735_i, GuiRequestTable.this.field_147003_i, GuiRequestTable.this.field_147009_r, false);
                        }
                    } else if (((Pair)entry.getValue()).getValue1() != null) {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add((Object)((Object)ChatColor.BLUE) + "Request ID: " + (Object)((Object)ChatColor.YELLOW) + entry.getKey());
                        GuiGraphics.displayItemToolTip(new Object[]{xPos - 10, yPos, ((IResource)((Pair)entry.getValue()).getValue1()).getDisplayItem().makeNormalStack(), true, list}, GuiRequestTable.this.field_73735_i, GuiRequestTable.this.field_147003_i, GuiRequestTable.this.field_147009_r, false);
                    }
                }
            });
        }
        super.renderExtentions();
    }

    public void refreshItems() {
        switch (this.displayOptions) {
            case Both: {
                int integer = 0;
                break;
            }
            case SupplyOnly: {
                int integer = 1;
                break;
            }
            case CraftOnly: {
                int integer = 2;
                break;
            }
            default: {
                int integer = 3;
            }
        }
        MainProxy.sendPacketToServer(PacketHandler.getPacket(OrdererRefreshRequestPacket.class).setInteger(integer += this.dimension * 10).setTilePos(this._table.container));
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton.field_146127_k == 0 && this.itemDisplay.getSelectedItem() != null) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(RequestSubmitPacket.class).setDimension(this.dimension).setStack(this.itemDisplay.getSelectedItem().getItem().makeStack(this.itemDisplay.getRequestCount())).setTilePos(this._table.container));
            this.refreshItems();
        } else if (guibutton.field_146127_k == 1) {
            this.itemDisplay.nextPage();
        } else if (guibutton.field_146127_k == 2) {
            this.itemDisplay.prevPage();
        } else if (guibutton.field_146127_k == 3) {
            this.refreshItems();
        } else if (guibutton.field_146127_k == 10) {
            this.itemDisplay.sub(3);
        } else if (guibutton.field_146127_k == 4) {
            this.itemDisplay.sub(2);
        } else if (guibutton.field_146127_k == 5) {
            this.itemDisplay.sub(1);
        } else if (guibutton.field_146127_k == 6) {
            this.itemDisplay.add(1);
        } else if (guibutton.field_146127_k == 7) {
            this.itemDisplay.add(2);
        } else if (guibutton.field_146127_k == 11) {
            this.itemDisplay.add(3);
        } else if (guibutton.field_146127_k == 8) {
            GuiCheckBox button = (GuiCheckBox)guibutton;
            Configs.DISPLAY_POPUP = button.change();
            Configs.savePopupState();
        } else if (guibutton.field_146127_k == 13 && this.itemDisplay.getSelectedItem() != null) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(RequestComponentPacket.class).setDimension(this.dimension).setStack(this.itemDisplay.getSelectedItem().getItem().makeStack(this.itemDisplay.getRequestCount())).setTilePos(this._table.container));
        } else if (guibutton.field_146127_k == 9) {
            String displayString = "";
            switch (this.displayOptions) {
                case Both: {
                    this.displayOptions = DisplayOptions.CraftOnly;
                    displayString = "Craft";
                    break;
                }
                case CraftOnly: {
                    this.displayOptions = DisplayOptions.SupplyOnly;
                    displayString = "Supply";
                    break;
                }
                case SupplyOnly: {
                    this.displayOptions = DisplayOptions.Both;
                    displayString = "Both";
                }
            }
            guibutton.field_146126_j = displayString;
            this.refreshItems();
        } else if (guibutton.field_146127_k == 14) {
            this.requestMatrix(1);
        } else if (guibutton.field_146127_k == 15) {
            this.requestMatrix(10);
        } else if (guibutton.field_146127_k == 16) {
            this.requestMatrix(64);
        } else if (guibutton.field_146127_k == 17) {
            boolean bl = this.showRequest = !this.showRequest;
            if (this.showRequest) {
                this.field_146999_f = this.startXSize;
                this.field_147003_i = this.startLeft;
                for (GuiButton button : this.moveWhileSmall) {
                    button.field_146128_h -= 105;
                }
                this.hideShowButton.field_146128_h -= 90;
            } else {
                this.field_146999_f = this.startXSize - 210;
                this.field_147003_i = this.startLeft + 105;
                for (GuiButton button : this.moveWhileSmall) {
                    button.field_146128_h += 105;
                }
                this.hideShowButton.field_146128_h += 90;
            }
            this.hideShowButton.field_146126_j = this.showRequest ? "Hide" : "Show";
            for (GuiButton button : this.hideWhileSmall) {
                button.field_146125_m = this.showRequest;
            }
            this.Macrobutton.field_146125_m = this.showRequest;
            this.orderIdForButton = -1;
        } else if (guibutton.field_146127_k == 100) {
            this.extentionControllerLeft.retract();
            this.setSubGui(new RequestMonitorPopup(this._table, this.orderIdForButton));
        } else if (guibutton.field_146127_k == 18) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(DiskRequestConectPacket.class).setPosX(this._table.getX()).setPosY(this._table.getY()).setPosZ(this._table.getZ()));
            this.setSubGui(new GuiDiskPopup(this));
        } else if (guibutton.field_146127_k == 20) {
            this.itemDisplay.cycle();
        } else if (guibutton.field_146127_k == 21 || guibutton.field_146127_k == 22) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(CraftingCycleRecipe.class).setDown(guibutton.field_146127_k == 22).setTilePos(this._table.container));
        } else if (guibutton.field_146127_k == 30) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(ClearCraftingGridPacket.class).setTilePos(this._table.container));
            this._table.cacheRecipe();
        } else if (guibutton.field_146127_k >= 31 && guibutton.field_146127_k <= 33) {
            int mult = AMOUNT_CHANGE_MODE[guibutton.field_146127_k - 31];
            ArrayList<ItemIdentifierStack> list = new ArrayList<ItemIdentifierStack>(9);
            for (Map.Entry<ItemIdentifier, Integer> e : this._table.matrix.getItemsAndCount().entrySet()) {
                list.add(e.getKey().makeStack(e.getValue() * mult));
            }
            for (Pair entry : this._table.inv) {
                if (entry.getValue1() == null) continue;
                int size = ((ItemStack)entry.getValue1()).field_77994_a;
                ItemIdentifier ident = ItemIdentifier.get((ItemStack)entry.getValue1());
                for (ItemIdentifierStack stack : list) {
                    if (!stack.getItem().equals(ident)) continue;
                    int toUse = Math.min(size, stack.getStackSize());
                    stack.lowerStackSize(toUse);
                    size -= toUse;
                }
            }
            list.removeIf(itemIdentifierStack -> itemIdentifierStack.getStackSize() <= 0);
            if (!list.isEmpty()) {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(RequestSubmitListPacket.class).setIdentList(list).setTilePos(this._table.container));
                this.refreshItems();
            }
        } else if (guibutton.field_146127_k == 34) {
            this.itemDisplay.resetAmount();
        }
    }

    private void requestMatrix(int multiplier) {
        ArrayList<ItemIdentifierStack> list = new ArrayList<ItemIdentifierStack>(9);
        for (Map.Entry<ItemIdentifier, Integer> e : this._table.matrix.getItemsAndCount().entrySet()) {
            list.add(e.getKey().makeStack(e.getValue() * multiplier));
        }
        MainProxy.sendPacketToServer(PacketHandler.getPacket(RequestSubmitListPacket.class).setIdentList(list).setTilePos(this._table.container));
        this.refreshItems();
    }

    protected int getStackAmount() {
        return 64;
    }

    public void handlePacket(Collection<ItemIdentifierStack> allItems) {
        this.itemDisplay.setItemList(allItems);
    }

    @Override
    public void specialItemRendering(ItemIdentifier item, int x, int y) {
    }

    @Override
    public void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        if (super.hasSubGui()) {
            return;
        }
        GuiGraphics.displayItemToolTip(this.itemDisplay.getToolTip(), (Gui)this, this.field_73735_i, this.field_147003_i, this.field_147009_r);
        this.Macrobutton.field_146124_l = this._table.diskInv.func_70301_a(0) != null && this._table.diskInv.func_70301_a(0).func_77973_b().equals((Object)LogisticsPipes.LogisticsItemDisk);
    }

    @Override
    public boolean itemSearched(ItemIdentifier item) {
        NBTTagCompound fluidTag;
        if (this.search.isEmpty()) {
            return true;
        }
        if (item.tag != null && "IC2".equals(item.getModName()) && "itemFluidCell".equals(item.item.func_77658_a()) && item.tag.func_74764_b("Fluid") && (fluidTag = item.tag.func_74775_l("Fluid")).func_74764_b("FluidName") && fluidTag.func_74764_b("Amount")) {
            String fluidName = fluidTag.func_74779_i("FluidName");
            int fluidAmount = fluidTag.func_74762_e("Amount");
            Fluid fluid = FluidRegistry.getFluid((String)fluidName);
            if (this.isSearched(fluid.getLocalizedName(new FluidStack(fluid, fluidAmount)).toLowerCase(Locale.US), this.search.getContent().toLowerCase(Locale.US))) {
                return true;
            }
        }
        if (this.isSearched(item.getFriendlyName().toLowerCase(Locale.US), this.search.getContent().toLowerCase(Locale.US))) {
            return true;
        }
        Map enchantIdLvlMap = EnchantmentHelper.func_82781_a((ItemStack)item.unsafeMakeNormalStack(1));
        for (Map.Entry e : enchantIdLvlMap.entrySet()) {
            String enchantname;
            if ((Integer)e.getKey() >= Enchantment.field_77331_b.length || Enchantment.field_77331_b[(Integer)e.getKey()] == null || (enchantname = Enchantment.field_77331_b[(Integer)e.getKey()].func_77316_c(((Integer)e.getValue()).intValue())) == null || !this.isSearched(enchantname.toLowerCase(Locale.US), this.search.getContent().toLowerCase(Locale.US))) continue;
            return true;
        }
        return false;
    }

    private boolean isSearched(String value, String search) {
        boolean flag = true;
        for (String s : search.split(" ")) {
            if (value.contains(s)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    @Override
    protected void func_73864_a(int i, int j, int k) {
        if (this.showRequest) {
            this.itemDisplay.handleClick(i, j, k);
            this.search.handleClick(i, j, k);
        }
        super.func_73864_a(i, j, k);
    }

    @Override
    public void handleMouseInputSub() {
        if (this.showRequest) {
            this.itemDisplay.handleMouse();
        }
        super.handleMouseInputSub();
    }

    public void handleRequestAnswer(Collection<IResource> items, boolean error, ISubGuiControler control, EntityPlayer player) {
        while (control.hasSubGui()) {
            control = control.getSubGui();
        }
        if (error) {
            control.setSubGui(new GuiRequestPopup(this._entityPlayer, "You are missing:", items));
        } else {
            control.setSubGui(new GuiRequestPopup(this._entityPlayer, "Request successful!", items));
        }
    }

    public void handleSimulateAnswer(Collection<IResource> used, Collection<IResource> missing, ISubGuiControler control, EntityPlayer player) {
        while (control.hasSubGui()) {
            control = control.getSubGui();
        }
        control.setSubGui(new GuiRequestPopup(this._entityPlayer, "Components: ", used, "Missing: ", missing));
    }

    protected void func_73869_a(char c, int i) {
        if (i == 30 && Keyboard.isKeyDown((int)29)) {
            this.itemDisplay.setMaxAmount();
        } else if (i == 32 && Keyboard.isKeyDown((int)29)) {
            this.itemDisplay.resetAmount();
        } else if (i == 201) {
            this.itemDisplay.prevPage();
        } else if (i == 209) {
            this.itemDisplay.nextPage();
        } else if (i == 1 || !this.search.handleKey(c, i)) {
            super.func_73869_a(c, i);
        }
    }

    @Override
    public void resetSubGui() {
        super.resetSubGui();
        this.refreshItems();
    }

    @Override
    public ItemStack getDisk() {
        return this._table.diskInv.func_70301_a(0);
    }

    @Override
    public int getX() {
        return this._table.getX();
    }

    @Override
    public int getY() {
        return this._table.getY();
    }

    @Override
    public int getZ() {
        return this._table.getZ();
    }

    @Override
    public ItemDisplay getItemDisplay() {
        return this.itemDisplay;
    }

    private static enum DisplayOptions {
        Both,
        SupplyOnly,
        CraftOnly;

    }
}

