/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftCore;
import buildcraft.api.blocks.IColorRemovable;
import buildcraft.api.core.EnumColor;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.NBTUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemPaintbrush
extends ItemBuildCraft {
    public ItemPaintbrush() {
        this.func_77664_n();
        this.func_77625_d(1);
        this.func_77656_e(63);
    }

    private int getColor(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return -1;
        }
        NBTTagCompound compound = NBTUtils.getItemData(stack);
        return compound.func_74764_b("color") ? (int)compound.func_74771_c("color") : -1;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage > this.func_77612_l()) {
            stack.func_77982_d(null);
            super.setDamage(stack, 0);
        } else {
            super.setDamage(stack, damage);
        }
    }

    @Override
    public String[] getIconNames() {
        String[] names = new String[17];
        names[0] = "paintbrush/clean";
        for (int i = 0; i < 16; ++i) {
            names[1 + i] = "paintbrush/" + EnumColor.fromId(i).name().toLowerCase(Locale.ENGLISH);
        }
        return names;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        super.func_94581_a(par1IconRegister);
        IIcon[] brushColors = new IIcon[16];
        System.arraycopy(this.icons, 1, brushColors, 0, 16);
        EnumColor.setIconArray(brushColors);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        this.field_77791_bV = this.icons[(this.getColor(stack) + 1) % this.icons.length];
        return this.field_77791_bV;
    }

    public String func_77653_i(ItemStack stack) {
        String base = super.func_77653_i(stack);
        int dye = this.getColor(stack);
        if (dye >= 0) {
            return base + " (" + EnumColor.fromId(dye).getLocalizedName() + ")";
        }
        return base;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        int dye = this.getColor(stack);
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return false;
        }
        if (dye >= 0) {
            ForgeDirection lookSide;
            int painted = 0;
            int maxPainted = BuildCraftCore.maxPaintedBlocks;
            Vec3 look = player.func_70040_Z();
            double absX = Math.abs(look.field_72450_a);
            double absY = Math.abs(look.field_72448_b);
            double absZ = Math.abs(look.field_72449_c);
            if (absX > absY && absX > absZ) {
                lookSide = look.field_72450_a > 0.0 ? ForgeDirection.EAST : ForgeDirection.WEST;
            } else if (absY > absX && absY > absZ) {
                lookSide = look.field_72448_b > 0.0 ? ForgeDirection.UP : ForgeDirection.DOWN;
            } else {
                ForgeDirection forgeDirection = lookSide = look.field_72449_c > 0.0 ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
            }
            while (block.recolourBlock(world, x, y, z, ForgeDirection.getOrientation((int)side), 15 - dye)) {
                player.func_71038_i();
                this.setDamage(stack, this.getDamage(stack) + 1);
                dye = this.getColor(stack);
                if (++painted >= maxPainted && maxPainted != -1) {
                    return !world.field_72995_K;
                }
                if (!player.func_70093_af() || dye <= 0) {
                    return !world.field_72995_K;
                }
                switch (lookSide) {
                    case UP: {
                        ++y;
                        break;
                    }
                    case DOWN: {
                        --y;
                        break;
                    }
                    case NORTH: {
                        --z;
                        break;
                    }
                    case SOUTH: {
                        ++z;
                        break;
                    }
                    case WEST: {
                        --x;
                        break;
                    }
                    case EAST: {
                        ++x;
                    }
                }
                if (y <= 0 || y > 256) {
                    return !world.field_72995_K;
                }
                block = world.func_147439_a(x, y, z);
                if (block != null) continue;
                return !world.field_72995_K;
            }
        } else if (block instanceof IColorRemovable && ((IColorRemovable)block).removeColorFromBlock(world, x, y, z, ForgeDirection.getOrientation((int)side))) {
            player.func_71038_i();
            return !world.field_72995_K;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List itemList) {
        itemList.add(new ItemStack((Item)this));
        for (int i = 0; i < 16; ++i) {
            ItemStack stack = new ItemStack((Item)this);
            NBTUtils.getItemData(stack).func_74774_a("color", (byte)i);
            itemList.add(stack);
        }
    }

    @Override
    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }
}

