/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.test.list.mechanics;

import chylex.hee.init.ItemList;
import chylex.hee.mechanics.brewing.PotionTypes;
import chylex.hee.system.test.Assert;
import chylex.hee.system.test.data.MethodType;
import chylex.hee.system.test.data.RunTime;
import chylex.hee.system.test.data.UnitTest;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import org.apache.commons.lang3.tuple.Pair;

public class EnhancedBrewingTests {
    private final List<Pair<Item, PotionEffect>> stages = new ArrayList<Pair<Item, PotionEffect>>();
    private Potion[] potionList;
    private Item[] specialIngredients;
    private ItemStack isWater;
    private ItemStack isAwkward;
    private ItemStack isVanillaHeal;
    private ItemStack isVanillaSpeed;
    private ItemStack isCustomHeal;
    private ItemStack isCustomSpeed;
    private ItemStack isCustomSpeedT2;
    private ItemStack isCustomSpeedL2;
    private ItemStack isCustomSpeedL3;

    @UnitTest(type=MethodType.PREPARATION, runTime=RunTime.LOADCOMPLETE)
    public void prepPotions() {
        this.potionList = new Potion[]{Potion.field_76432_h, Potion.field_76433_i, Potion.field_76424_c, Potion.field_76421_d, Potion.field_76420_g, Potion.field_76437_t, Potion.field_76439_r, Potion.field_76441_p, Potion.field_76428_l, Potion.field_76436_u, Potion.field_76426_n, Potion.field_76427_o};
        this.specialIngredients = new Item[]{ItemList.instability_orb, ItemList.ectoplasm, ItemList.silverfish_blood};
        this.isWater = new ItemStack((Item)Items.field_151068_bn);
        this.isAwkward = new ItemStack((Item)Items.field_151068_bn, 1, 16);
        this.isVanillaHeal = new ItemStack((Item)Items.field_151068_bn, 1, 8197);
        this.isVanillaSpeed = new ItemStack((Item)Items.field_151068_bn, 1, 8194);
        this.isCustomHeal = PotionTypes.setCustomPotionEffect(this.isVanillaHeal.func_77946_l(), new PotionEffect(Potion.field_76432_h.field_76415_H, 1, 0));
        this.isCustomSpeed = PotionTypes.setCustomPotionEffect(this.isVanillaSpeed.func_77946_l(), new PotionEffect(Potion.field_76424_c.field_76415_H, 1200, 0));
        this.isCustomSpeedT2 = PotionTypes.setCustomPotionEffect(this.isVanillaSpeed.func_77946_l(), new PotionEffect(Potion.field_76424_c.field_76415_H, 1200, 1));
        this.isCustomSpeedL2 = PotionTypes.setCustomPotionEffect(this.isVanillaSpeed.func_77946_l(), new PotionEffect(Potion.field_76424_c.field_76415_H, 2700, 0));
        this.isCustomSpeedL3 = PotionTypes.setCustomPotionEffect(this.isVanillaSpeed.func_77946_l(), new PotionEffect(Potion.field_76424_c.field_76415_H, 4200, 0));
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testValidation() {
        for (Item item : this.specialIngredients) {
            Assert.state(PotionTypes.isSpecialIngredient(item), "Unexpected state, invalid special ingredient: " + item.func_77658_a());
        }
        Assert.state(PotionTypes.isPotionItem(Items.field_151069_bo), "Unexpected state, invalid potion item: " + Items.field_151069_bo.func_77658_a());
        Assert.state(PotionTypes.isPotionItem((Item)Items.field_151068_bn), "Unexpected state, invalid potion item: " + Items.field_151068_bn.func_77658_a());
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testPotionData() {
        Assert.equal(PotionTypes.getPotionData(this.isAwkward).getPotionType(), null, "Unexpected potion data, expected $2, got $1.");
        Assert.equal(PotionTypes.getPotionData(this.isVanillaHeal).getPotionType(), Potion.field_76432_h, "Unexpected potion data, expected $2, got $1.");
        Assert.equal(PotionTypes.getPotionData(this.isCustomHeal).getPotionType(), Potion.field_76432_h, "Unexpected potion data, expected $2, got $1.");
        Assert.equal(PotionTypes.getPotionData(this.isVanillaSpeed).getPotionType(), Potion.field_76424_c, "Unexpected potion data, expected $2, got $1.");
        Assert.equal(PotionTypes.getPotionData(this.isCustomSpeed).getPotionType(), Potion.field_76424_c, "Unexpected potion data, expected $2, got $1.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testPotionEffects() {
        Assert.equal(PotionTypes.getEffectIfValid(this.isAwkward), null, "Unexpected potion effect, expected $2, got $1.");
        Assert.equal(PotionTypes.getEffectIfValid(this.isVanillaHeal), new PotionEffect(Potion.field_76432_h.field_76415_H, 1, 0), "Unexpected potion effect, expected $2, got $1.");
        Assert.equal(PotionTypes.getEffectIfValid(this.isCustomHeal), new PotionEffect(Potion.field_76432_h.field_76415_H, 1, 0), "Unexpected potion effect, expected $2, got $1.");
        Assert.equal(PotionTypes.getEffectIfValid(this.isCustomSpeed), new PotionEffect(Potion.field_76424_c.field_76415_H, 1200, 0), "Unexpected potion effect, expected $2, got $1.");
        Assert.equal(PotionTypes.getEffectIfValid(this.isCustomSpeedT2), new PotionEffect(Potion.field_76424_c.field_76415_H, 1200, 1), "Unexpected potion effect, expected $2, got $1.");
        Assert.equal(PotionTypes.getEffectIfValid(this.isCustomSpeedL2), new PotionEffect(Potion.field_76424_c.field_76415_H, 2700, 0), "Unexpected potion effect, expected $2, got $1.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testRequiredPowder() {
        Assert.equal(PotionTypes.getRequiredPowder(Items.field_151075_bm, this.isWater), 0, "Unexpected powder requirement, expected $2, got $1.");
        Assert.equal(PotionTypes.getRequiredPowder(ItemList.instability_orb, this.isAwkward), 8, "Unexpected powder requirement, expected $2, got $1.");
        Assert.equal(PotionTypes.getRequiredPowder(Items.field_151114_aO, this.isCustomHeal), 2, "Unexpected powder requirement, expected $2, got $1.");
        Assert.equal(PotionTypes.getRequiredPowder(Items.field_151114_aO, this.isCustomSpeed), 2, "Unexpected powder requirement, expected $2, got $1.");
        Assert.equal(PotionTypes.getRequiredPowder(Items.field_151114_aO, this.isCustomSpeedT2), 4, "Unexpected powder requirement, expected $2, got $1.");
        Assert.equal(PotionTypes.getRequiredPowder(Items.field_151137_ax, this.isCustomSpeed), 1, "Unexpected powder requirement, expected $2, got $1.");
        Assert.equal(PotionTypes.getRequiredPowder(Items.field_151137_ax, this.isCustomSpeedL2), 1, "Unexpected powder requirement, expected $2, got $1.");
        Assert.equal(PotionTypes.getRequiredPowder(Items.field_151137_ax, this.isCustomSpeedL3), 2, "Unexpected powder requirement, expected $2, got $1.");
        Assert.equal(PotionTypes.getRequiredPowder(Items.field_151016_H, this.isCustomSpeed), 3, "Unexpected powder requirement, expected $2, got $1.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testBrewingHeal2() {
        this.stages.clear();
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151075_bm, (Object)null));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151060_bw, (Object)new PotionEffect(Potion.field_76432_h.field_76415_H, 1, 0)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151114_aO, (Object)new PotionEffect(Potion.field_76432_h.field_76415_H, 1, 1)));
        this.runBrewingTest(this.isWater.func_77946_l(), false, false);
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testBrewingHeal4Fail() {
        this.stages.clear();
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151075_bm, (Object)null));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151060_bw, (Object)new PotionEffect(Potion.field_76432_h.field_76415_H, 1, 0)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151114_aO, (Object)new PotionEffect(Potion.field_76432_h.field_76415_H, 1, 1)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151114_aO, (Object)new PotionEffect(Potion.field_76432_h.field_76415_H, 1, 2)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151114_aO, (Object)new PotionEffect(Potion.field_76432_h.field_76415_H, 1, 3)));
        this.runBrewingTest(this.isWater.func_77946_l(), false, true);
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testBrewingHeal4Enhanced() {
        this.stages.clear();
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151075_bm, (Object)null));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151060_bw, (Object)new PotionEffect(Potion.field_76432_h.field_76415_H, 1, 0)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151114_aO, (Object)new PotionEffect(Potion.field_76432_h.field_76415_H, 1, 1)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151114_aO, (Object)new PotionEffect(Potion.field_76432_h.field_76415_H, 1, 2)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151114_aO, (Object)new PotionEffect(Potion.field_76432_h.field_76415_H, 1, 3)));
        this.runBrewingTest(this.isWater.func_77946_l(), true, false);
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testBrewingSpeedLong() {
        this.stages.clear();
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151075_bm, (Object)null));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151102_aT, (Object)new PotionEffect(Potion.field_76424_c.field_76415_H, 1200, 0)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151137_ax, (Object)new PotionEffect(Potion.field_76424_c.field_76415_H, 2700, 0)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151137_ax, (Object)new PotionEffect(Potion.field_76424_c.field_76415_H, 4200, 0)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151137_ax, (Object)new PotionEffect(Potion.field_76424_c.field_76415_H, 5700, 0)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151137_ax, (Object)new PotionEffect(Potion.field_76424_c.field_76415_H, 7200, 0)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151137_ax, (Object)new PotionEffect(Potion.field_76424_c.field_76415_H, 8700, 0)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151137_ax, (Object)new PotionEffect(Potion.field_76424_c.field_76415_H, 10200, 0)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151137_ax, (Object)new PotionEffect(Potion.field_76424_c.field_76415_H, 11700, 0)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151137_ax, (Object)new PotionEffect(Potion.field_76424_c.field_76415_H, 13200, 0)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151137_ax, (Object)new PotionEffect(Potion.field_76424_c.field_76415_H, 14400, 0)));
        this.runBrewingTest(this.isWater.func_77946_l(), false, false);
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testBrewingSpeedLongOverFail() {
        ItemStack startIS = PotionTypes.setCustomPotionEffect(this.isCustomSpeed.func_77946_l(), new PotionEffect(Potion.field_76424_c.field_76415_H, 11700, 0));
        this.stages.clear();
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151137_ax, (Object)new PotionEffect(Potion.field_76424_c.field_76415_H, 13200, 0)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151137_ax, (Object)new PotionEffect(Potion.field_76424_c.field_76415_H, 14400, 0)));
        this.stages.add((Pair<Item, PotionEffect>)Pair.of((Object)Items.field_151137_ax, (Object)new PotionEffect(Potion.field_76424_c.field_76415_H, 14401, 0)));
        this.runBrewingTest(startIS, false, true);
    }

    private void runBrewingTest(ItemStack is, boolean enhanced, boolean shouldFail) {
        for (Pair<Item, PotionEffect> stage : this.stages) {
            ItemStack ingredient = new ItemStack((Item)stage.getLeft());
            if (!PotionTypes.canBeApplied(ingredient, is, enhanced)) {
                if (shouldFail) {
                    return;
                }
                Assert.fail("Unexpected brewing state, cannot apply ingredient " + ((Item)stage.getLeft()).func_77658_a() + " to " + is + ".");
            }
            is = PotionTypes.applyIngredientUnsafe(ingredient, is);
            Assert.equal(PotionTypes.getEffectIfValid(is), stage.getRight(), "Unexpected brewing state effect, expected $2, got $1.");
        }
        if (shouldFail) {
            Assert.fail("Brewing was supposed to fail, but proceeded to get " + is + ".");
        }
    }
}

