/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.forbidden.tiles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fox.spiteful.forbidden.Config;
import fox.spiteful.forbidden.tiles.TileEntityWrathCage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.Thaumcraft;

public class WrathSpawnerLogic {
    final TileEntityWrathCage mobSpawnerEntity;
    public boolean mobSet = false;
    public int spawnDelay = 20;
    private String mobID = "Pig";
    Aspect aspect = Aspect.GREED;
    private boolean slothful = false;
    private int fuel = 0;
    public double field_98287_c;
    public double field_98284_d;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 300;
    private int spawnCount = 3;
    private Entity renderEntity;
    private int maxNearbyEntities = 6;
    private int activatingRangeFromPlayer = 16;
    private int spawnRange = 4;

    WrathSpawnerLogic(TileEntityWrathCage par1TileEntityMobSpawner) {
        this.mobSpawnerEntity = par1TileEntityMobSpawner;
    }

    public String getEntityNameToSpawn() {
        return this.mobID;
    }

    public Aspect getAspect() {
        return this.aspect;
    }

    public void setMobID(String par1Str) {
        this.mobID = par1Str;
        this.aspect = Config.spawnerMobs.containsKey(this.mobID) ? Config.spawnerMobs.get(this.mobID) : Aspect.GREED;
    }

    public void mobIsSet(boolean inp) {
        this.mobSet = inp;
    }

    public boolean isMobSet() {
        return this.mobSet;
    }

    public void updateSpawnerBlock(int par1) {
        this.mobSpawnerEntity.func_145831_w().func_147452_c(this.mobSpawnerEntity.field_145851_c, this.mobSpawnerEntity.field_145848_d, this.mobSpawnerEntity.field_145849_e, Blocks.field_150474_ac, par1, 0);
    }

    public World getSpawnerWorld() {
        return this.mobSpawnerEntity.func_145831_w();
    }

    public int getSpawnerX() {
        return this.mobSpawnerEntity.field_145851_c;
    }

    public int getSpawnerY() {
        return this.mobSpawnerEntity.field_145848_d;
    }

    public int getSpawnerZ() {
        return this.mobSpawnerEntity.field_145849_e;
    }

    public void updateSpawner() {
        if (!this.mobSet) {
            return;
        }
        if (this.getSpawnerWorld().field_72995_K && (this.fuel > 0 || Config.wrathCost <= 0)) {
            double d1 = (float)this.getSpawnerX() + this.getSpawnerWorld().field_73012_v.nextFloat();
            double d2 = (float)this.getSpawnerY() + this.getSpawnerWorld().field_73012_v.nextFloat();
            double d0 = (float)this.getSpawnerZ() + this.getSpawnerWorld().field_73012_v.nextFloat();
            Thaumcraft.proxy.sparkle((float)d1, (float)d2, (float)d0, 8848388);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.field_98284_d = this.field_98287_c;
            this.field_98287_c = (this.field_98287_c + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        } else if (Config.wrathCage) {
            if (Config.wrathCost > 0 && this.fuel <= 0) {
                if (this.mobSpawnerEntity.special >= Config.wrathCost) {
                    this.mobSpawnerEntity.special -= Config.wrathCost;
                    this.slothful = false;
                    this.fuel = Config.wrathEff;
                    this.mobSpawnerEntity.func_145831_w().func_147471_g(this.getSpawnerX(), this.getSpawnerY(), this.getSpawnerZ());
                } else if (this.mobSpawnerEntity.wrath >= Config.wrathCost) {
                    this.mobSpawnerEntity.wrath -= Config.wrathCost;
                    this.slothful = false;
                    this.fuel = Config.wrathEff;
                    this.mobSpawnerEntity.func_145831_w().func_147471_g(this.getSpawnerX(), this.getSpawnerY(), this.getSpawnerZ());
                } else if (this.mobSpawnerEntity.sloth >= Config.wrathCost) {
                    this.mobSpawnerEntity.sloth -= Config.wrathCost;
                    this.slothful = true;
                    this.fuel = Config.wrathEff;
                    this.mobSpawnerEntity.func_145831_w().func_147471_g(this.getSpawnerX(), this.getSpawnerY(), this.getSpawnerZ());
                }
            }
            if (this.spawnDelay == -1) {
                this.updateDelay();
            }
            if (this.fuel <= 0 && Config.wrathCost > 0) {
                return;
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
                return;
            }
            for (int i = 0; i < this.spawnCount && (this.fuel > 0 || Config.wrathCost <= 0); ++i) {
                Entity entity = EntityList.func_75620_a((String)this.getEntityNameToSpawn(), (World)this.getSpawnerWorld());
                if (entity == null) {
                    return;
                }
                int j = this.getSpawnerWorld().func_72872_a(entity.getClass(), AxisAlignedBB.func_72330_a((double)this.getSpawnerX(), (double)this.getSpawnerY(), (double)this.getSpawnerZ(), (double)(this.getSpawnerX() + 1), (double)(this.getSpawnerY() + 1), (double)(this.getSpawnerZ() + 1)).func_72314_b((double)(this.spawnRange * 2), 4.0, (double)(this.spawnRange * 2))).size();
                if (j >= this.maxNearbyEntities) {
                    this.updateDelay();
                    return;
                }
                double d0 = (double)this.getSpawnerX() + (this.getSpawnerWorld().field_73012_v.nextDouble() - this.getSpawnerWorld().field_73012_v.nextDouble()) * (double)this.spawnRange;
                double d3 = this.getSpawnerY() + this.getSpawnerWorld().field_73012_v.nextInt(3) - 1;
                double d4 = (double)this.getSpawnerZ() + (this.getSpawnerWorld().field_73012_v.nextDouble() - this.getSpawnerWorld().field_73012_v.nextDouble()) * (double)this.spawnRange;
                EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                entity.func_70012_b(d0, d3, d4, this.getSpawnerWorld().field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (this.entityCanSpawn(entityliving)) {
                    this.spawnMob(entity);
                    this.getSpawnerWorld().func_72926_e(2004, this.getSpawnerX(), this.getSpawnerY(), this.getSpawnerZ(), 0);
                    if (entityliving != null) {
                        entityliving.func_70656_aK();
                        --this.fuel;
                    }
                    this.updateDelay();
                    continue;
                }
                if (entityliving == null) continue;
                entityliving.field_70128_L = true;
            }
        }
    }

    public boolean entityCanSpawn(EntityLiving entity) {
        return entity.field_70170_p.func_72855_b(entity.field_70121_D) && entity.field_70170_p.func_72945_a((Entity)entity, entity.field_70121_D).isEmpty() && !entity.field_70170_p.func_72953_d(entity.field_70121_D);
    }

    private void updateDelay() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + this.getSpawnerWorld().field_73012_v.nextInt(i);
        }
        if (this.slothful) {
            this.spawnDelay += 200;
        }
        this.updateSpawnerBlock(1);
    }

    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        this.mobID = par1NBTTagCompound.func_74779_i("EntityId");
        this.aspect = Config.spawnerMobs.containsKey(this.mobID) ? Config.spawnerMobs.get(this.mobID) : Aspect.GREED;
        this.mobSet = par1NBTTagCompound.func_74767_n("MobSet");
        this.slothful = par1NBTTagCompound.func_74767_n("Slothful");
        this.fuel = par1NBTTagCompound.func_74765_d("Fuel");
        this.spawnDelay = par1NBTTagCompound.func_74765_d("Delay");
        if (par1NBTTagCompound.func_74764_b("MaxNearbyEntities")) {
            this.maxNearbyEntities = par1NBTTagCompound.func_74765_d("MaxNearbyEntities");
        }
        if (par1NBTTagCompound.func_74764_b("SpawnRange")) {
            this.spawnRange = par1NBTTagCompound.func_74765_d("SpawnRange");
        }
        if (this.getSpawnerWorld() != null && this.getSpawnerWorld().field_72995_K) {
            this.renderEntity = null;
        }
    }

    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74778_a("EntityId", this.getEntityNameToSpawn());
        par1NBTTagCompound.func_74757_a("MobSet", this.mobSet);
        par1NBTTagCompound.func_74757_a("Slothful", this.slothful);
        par1NBTTagCompound.func_74777_a("Fuel", (short)this.fuel);
        par1NBTTagCompound.func_74777_a("Delay", (short)this.spawnDelay);
        par1NBTTagCompound.func_74777_a("MaxNearbyEntities", (short)this.maxNearbyEntities);
        par1NBTTagCompound.func_74777_a("SpawnRange", (short)this.spawnRange);
    }

    public Entity spawnMob(Entity par1Entity) {
        if (par1Entity instanceof EntityLivingBase && par1Entity.field_70170_p != null) {
            ((EntityLiving)par1Entity).func_110161_a((IEntityLivingData)null);
            this.getSpawnerWorld().func_72838_d(par1Entity);
        }
        return par1Entity;
    }

    public boolean setDelayToMin(int par1) {
        if (par1 == 1 && this.getSpawnerWorld().field_72995_K) {
            this.spawnDelay = this.minSpawnDelay;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getEntityForRender() {
        if (this.renderEntity == null) {
            Entity entity = EntityList.func_75620_a((String)this.getEntityNameToSpawn(), (World)null);
            this.renderEntity = entity = this.spawnMob(entity);
        }
        return this.renderEntity;
    }
}

