/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shukaro.warptheory.handlers.IWorldTickWarpEvent;
import shukaro.warptheory.util.BlockCoord;
import shukaro.warptheory.util.MiscHelper;
import shukaro.warptheory.util.RandomBlockHelper;
import thaumcraft.common.config.ConfigBlocks;

public class WarpMushrooms
extends IWorldTickWarpEvent {
    public WarpMushrooms(int minWarp) {
        super("biomeMushrooms", minWarp, world -> 16 + world.field_73012_v.nextInt(16));
    }

    @Override
    public boolean canDo(World world, EntityPlayer player) {
        for (String n : MiscHelper.getWarpTag(player).func_150296_c()) {
            if (!n.startsWith("biome") || n.equals(this.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int triggerEvent(int eventAmount, World world, EntityPlayer player) {
        BlockCoord target = RandomBlockHelper.randomBlock(world, player, 16, block -> MiscHelper.hasNonSolidNeighbor(world, block));
        if (target == null) {
            return 0;
        }
        BlockCoord below = target.copy().offset(0);
        if (target.isAir((IBlockAccess)world) && below.isTopSolid((IBlockAccess)world)) {
            int mushroomRandom = world.field_73012_v.nextInt(99);
            if (mushroomRandom == 0) {
                world.func_147465_d(target.x, target.y, target.z, ConfigBlocks.blockCustomPlant, 5, 3);
            } else if (mushroomRandom % 2 == 0) {
                world.func_147449_b(target.x, target.y, target.z, (Block)Blocks.field_150338_P);
            } else {
                world.func_147449_b(target.x, target.y, target.z, (Block)Blocks.field_150337_Q);
            }
            world.func_72908_a((double)target.x, (double)target.y, (double)target.z, "dig.grass", 1.0f, 1.0f);
            return 1;
        }
        BlockCoord above = target.copy().offset(1);
        if ((target.getBlock(world) == Blocks.field_150349_c || target.getBlock(world) == Blocks.field_150346_d) && above.isAir((IBlockAccess)world)) {
            world.func_147449_b(target.x, target.y, target.z, (Block)Blocks.field_150391_bh);
            world.func_72908_a((double)target.x, (double)target.y, (double)target.z, "dig.grass", 1.0f, 1.0f);
            return 1;
        }
        AxisAlignedBB boundingBox = AxisAlignedBB.func_72330_a((double)((double)target.x - 1.0), (double)((double)target.y - 1.0), (double)((double)target.z - 1.0), (double)((double)target.x + 1.0), (double)((double)target.y + 1.0), (double)((double)target.z + 1.0));
        for (Entity entity : world.func_72872_a(EntityCow.class, boundingBox)) {
            if (entity.getClass() != EntityCow.class) continue;
            EntityMooshroom mooshroom = new EntityMooshroom(world);
            mooshroom.func_82149_j(entity);
            mooshroom.func_70873_a(((EntityCow)entity).func_70874_b());
            if (!world.func_72838_d((Entity)mooshroom)) continue;
            world.func_72956_a((Entity)mooshroom, "dig.grass", 1.0f, 1.0f);
            mooshroom.func_70642_aH();
            entity.func_70106_y();
            return 1;
        }
        return 0;
    }
}

