/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.module;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Logger;
import wanion.lib.WanionLib;
import wanion.lib.common.Instantiator;
import wanion.lib.module.AbstractModuleThread;
import wanion.lib.module.LoadStage;
import wanion.lib.module.SpecifiedLoadStage;

public abstract class AbstractModule {
    protected final Manager manager;
    private final String moduleName;

    protected AbstractModule(@Nonnull String moduleName, @Nonnull Instantiator<AbstractModuleThread> moduleThreadInstantiator) {
        this.moduleName = moduleName;
        this.manager = new Manager(moduleThreadInstantiator);
    }

    protected abstract void init();

    final void start(@Nonnull LoadStage loadStage, @Nonnull Manager manager) {
        List<AbstractModuleThread> threadList = manager.getInstances(loadStage);
        if (threadList.isEmpty()) {
            return;
        }
        ExecutorService moduleThreadExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        Logger logger = WanionLib.getLogger();
        try {
            long initialTime = System.nanoTime();
            List futureOfThreads = moduleThreadExecutor.invokeAll(threadList);
            long took = System.nanoTime() - initialTime;
            for (Future threadModuleSay : futureOfThreads) {
                logger.info((String)threadModuleSay.get());
            }
            logger.info("All " + threadList.size() + " " + this.moduleName + "s took " + took / 1000000L + "ms to finish. at load stage " + loadStage.name());
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Something really bad happened on " + this.moduleName + " at load stage " + loadStage.name());
            e.printStackTrace();
        }
    }

    public static class Manager {
        private final Map<LoadStage, Set<Class<? extends AbstractModuleThread>>> loadStageMap;
        private final Instantiator<AbstractModuleThread> instantiator;

        public Manager(@Nonnull Instantiator<AbstractModuleThread> instantiator) {
            this.instantiator = instantiator;
            this.loadStageMap = new EnumMap<LoadStage, Set<Class<? extends AbstractModuleThread>>>(LoadStage.class);
            for (LoadStage loadStage : LoadStage.values()) {
                this.loadStageMap.put(loadStage, new LinkedHashSet());
            }
        }

        public boolean add(@Nonnull Class<? extends AbstractModuleThread> moduleThreadClass) {
            LoadStage loadStage = moduleThreadClass.isAnnotationPresent(SpecifiedLoadStage.class) ? moduleThreadClass.getAnnotation(SpecifiedLoadStage.class).stage() : LoadStage.POST_INIT;
            Set<Class<? extends AbstractModuleThread>> classSet = this.loadStageMap.get((Object)loadStage);
            return !classSet.contains(moduleThreadClass) && classSet.add(moduleThreadClass);
        }

        public boolean isEmpty() {
            return this.loadStageMap.values().stream().allMatch(Set::isEmpty);
        }

        public boolean isEmpty(LoadStage loadStage) {
            return this.loadStageMap.get((Object)loadStage).isEmpty();
        }

        public List<AbstractModuleThread> getInstances(LoadStage loadStage) {
            ArrayList<AbstractModuleThread> abstractModuleThreads = new ArrayList<AbstractModuleThread>();
            this.loadStageMap.get((Object)loadStage).forEach(t -> {
                try {
                    abstractModuleThreads.add(this.instantiator.instantiate((Class<AbstractModuleThread>)t));
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            });
            return abstractModuleThreads;
        }
    }
}

