/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.List;
import makamys.coretweaks.Config;
import makamys.coretweaks.CoreTweaks;
import makamys.coretweaks.IModEventListener;
import makamys.coretweaks.bugfix.DoubleEatFixer;
import makamys.coretweaks.command.CoreTweaksCommand;
import makamys.coretweaks.ducks.IChunkProviderClient;
import makamys.coretweaks.optimization.ClientChunkMap;
import makamys.coretweaks.optimization.JarDiscovererCache;
import makamys.coretweaks.optimization.transformercache.lite.TransformerCache;
import makamys.coretweaks.repackage.makamys.mclib.core.MCLib;
import makamys.coretweaks.repackage.makamys.mclib.core.MCLibModules;
import makamys.coretweaks.tweak.LoadLastWorldButton;
import makamys.coretweaks.util.KeyboardUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.LongHashMap;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.ClientCommandHandler;

@Mod(modid="coretweaks", version="0.3.3.3-GTNH")
public class CoreTweaksMod {
    private static List<IModEventListener> listeners = new ArrayList<IModEventListener>();

    @Mod.EventHandler
    public void onConstruction(FMLConstructionEvent event) {
        MCLib.init();
        Config.reload();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                listeners.forEach(l -> l.onShutdown());
            }
        }, "CoreTweaks shutdown thread"));
        if (Config.transformerCache.isActive() && Config.transformerCacheMode == Config.TransformerCache.LITE) {
            this.registerListener(TransformerCache.instance);
        }
        if (Config.jarDiscovererCache.isActive()) {
            this.registerListener(JarDiscovererCache.instance);
        }
        if (Config.mainMenuContinueButton.isActive()) {
            LoadLastWorldButton.instance = new LoadLastWorldButton();
            this.registerListener(LoadLastWorldButton.instance);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MCLibModules.updateCheckAPI.submitModTask("coretweaks", "https://raw.githubusercontent.com/makamys/GTNewHorizons/master/updatejson/update.json");
        listeners.forEach(l -> l.onPreInit(event));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)this);
        if (Config.coreTweaksCommand.isActive()) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new CoreTweaksCommand());
        }
        if (CoreTweaks.textureLoader != null) {
            FMLCommonHandler.instance().bus().register((Object)CoreTweaks.textureLoader);
        }
        if (Config.fixDoubleEat.isActive()) {
            FMLCommonHandler.instance().bus().register((Object)new DoubleEatFixer());
        }
        listeners.forEach(l -> l.onInit(event));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        listeners.forEach(l -> l.onPostInit(event));
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        Config.reload();
        listeners.forEach(l -> l.onServerAboutToStart(event));
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        listeners.forEach(l -> l.onServerStarting(event));
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        listeners.forEach(l -> l.onServerStarted(event));
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        listeners.forEach(l -> l.onServerStopping(event));
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent event) {
        listeners.forEach(l -> l.onServerStopped(event));
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        ChunkProviderClient cp;
        LongHashMap cm;
        IChunkProvider provider;
        WorldClient world;
        if (Config.clientChunkMap.isActive() && (world = Minecraft.func_71410_x().field_71441_e) != null && (provider = world.func_72863_F()) != null && provider instanceof ChunkProviderClient && (cm = ((IChunkProviderClient)(cp = (ChunkProviderClient)provider)).getChunkMapping()) instanceof ClientChunkMap) {
            EntityLivingBase player = Minecraft.func_71410_x().field_71451_h;
            ((ClientChunkMap)cm).setCenter((int)player.field_70165_t / 16, (int)player.field_70161_v / 16);
        }
        KeyboardUtil.tick();
    }

    public void registerListener(IModEventListener listener) {
        listeners.add(listener);
    }
}

