/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.nei.FastTransferManager;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.util.NBTHelper;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;

public class DefaultOverlayHandler
implements IOverlayHandler {
    private static Class<?> gtItem;
    public int offsetx;
    public int offsety;

    public DefaultOverlayHandler(int x, int y) {
        this.offsetx = x;
        this.offsety = y;
    }

    public DefaultOverlayHandler() {
        this(5, 11);
    }

    @Override
    public void overlayRecipe(GuiContainer gui, IRecipeHandler handler, int recipeIndex, boolean maxTransfer) {
        this.transferRecipe(gui, handler, recipeIndex, maxTransfer ? Integer.MAX_VALUE : 1);
    }

    @Override
    public int transferRecipe(GuiContainer gui, IRecipeHandler handler, int recipeIndex, int multiplier) {
        List<PositionedStack> ingredients = handler.getIngredientStacks(recipeIndex);
        List<DistributedIngred> ingredStacks = this.getPermutationIngredients(ingredients);
        if (!this.clearIngredients(gui)) {
            return 0;
        }
        this.findInventoryQuantities(gui, ingredStacks);
        List<IngredientDistribution> assignedIngredients = this.assignIngredients(ingredients, ingredStacks);
        if (assignedIngredients == null) {
            return 0;
        }
        this.assignIngredSlots(gui, ingredients, assignedIngredients);
        multiplier = Math.min(multiplier == 0 ? 64 : multiplier, this.calculateRecipeQuantity(assignedIngredients));
        if (multiplier != 0) {
            this.moveIngredients(gui, assignedIngredients, multiplier);
        }
        return multiplier;
    }

    @Override
    public boolean canFillCraftingGrid(GuiContainer firstGui, IRecipeHandler handler, int recipeIndex) {
        return this.presenceOverlay(firstGui, handler, recipeIndex).stream().allMatch(state -> state.isPresent());
    }

    @Override
    public boolean canCraft(GuiContainer firstGui, IRecipeHandler handler, int recipeIndex) {
        return this.canFillCraftingGrid(firstGui, handler, recipeIndex);
    }

    @Override
    public boolean craft(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex, int multiplier) {
        int transfer;
        EntityClientPlayerMP thePlayer = NEIClientUtils.mc().field_71439_g;
        boolean craft = false;
        block0: while (multiplier > 0 && (transfer = this.transferRecipe(firstGui, recipe, recipeIndex, multiplier)) > 0) {
            multiplier -= transfer;
            for (Slot slot : firstGui.field_147002_h.field_75151_b) {
                if (!slot.func_75216_d() || !(slot instanceof SlotCrafting) || !slot.func_82869_a((EntityPlayer)thePlayer)) continue;
                FastTransferManager.clickSlot(firstGui, slot.field_75222_d, 0, 1);
                craft = true;
                continue block0;
            }
        }
        return craft;
    }

    private boolean clearIngredients(GuiContainer gui) {
        EntityClientPlayerMP thePlayer = NEIClientUtils.mc().field_71439_g;
        for (Slot slot : gui.field_147002_h.field_75151_b) {
            if (!slot.func_75216_d() || this.canMoveFrom(slot, gui) || slot instanceof SlotCrafting || !slot.func_82869_a((EntityPlayer)thePlayer)) continue;
            FastTransferManager.clickSlot(gui, slot.field_75222_d, 0, 1);
            if (!slot.func_75216_d()) continue;
            return false;
        }
        return true;
    }

    private void moveIngredients(GuiContainer gui, List<IngredientDistribution> assignedIngredients, int multiplier) {
        block0: for (IngredientDistribution distrib : assignedIngredients) {
            if (distrib.slots.length == 0) continue;
            ItemStack pstack = distrib.permutation;
            int transferCap = multiplier * pstack.field_77994_a;
            int transferred = 0;
            int destSlotIndex = 0;
            Slot dest = distrib.slots[0];
            int slotTransferred = 0;
            int slotTransferCap = pstack.func_77976_d();
            for (Slot slot : gui.field_147002_h.field_75151_b) {
                ItemStack stack;
                if (!slot.func_75216_d() || !this.canMoveFrom(slot, gui) || !this.canStack(pstack, stack = slot.func_75211_c())) continue;
                int amount = Math.min(transferCap - transferred, stack.field_77994_a);
                FastTransferManager.clickSlot(gui, slot.field_75222_d);
                for (int c = 0; c < amount; ++c) {
                    FastTransferManager.clickSlot(gui, dest.field_75222_d, 1);
                    ++transferred;
                    if (++slotTransferred < slotTransferCap) continue;
                    if (++destSlotIndex == distrib.slots.length) {
                        dest = null;
                        break;
                    }
                    dest = distrib.slots[destSlotIndex];
                    slotTransferred = 0;
                }
                FastTransferManager.clickSlot(gui, slot.field_75222_d);
                if (transferred < transferCap && dest != null) continue;
                continue block0;
            }
        }
    }

    private int calculateRecipeQuantity(List<IngredientDistribution> assignedIngredients) {
        int quantity = Integer.MAX_VALUE;
        for (IngredientDistribution distrib : assignedIngredients) {
            DistributedIngred istack = distrib.distrib;
            if (istack.numSlots == 0) {
                return 0;
            }
            int allSlots = istack.invAmount;
            int maxStackSize = istack.stack.func_77976_d();
            if (allSlots / istack.numSlots > maxStackSize) {
                allSlots = istack.numSlots * maxStackSize;
            }
            int newQuantity = allSlots / istack.distributed;
            if (maxStackSize == 1) continue;
            quantity = Math.min(quantity, newQuantity);
        }
        if (quantity == Integer.MAX_VALUE) {
            quantity = 1;
        }
        return quantity;
    }

    private Slot[][] assignIngredSlots(GuiContainer gui, List<PositionedStack> ingredients, List<IngredientDistribution> assignedIngredients) {
        Slot[][] recipeSlots = this.mapIngredSlots(gui, ingredients);
        HashMap<Slot, Integer> distribution = new HashMap<Slot, Integer>();
        Slot[][] slotArray = recipeSlots;
        int n = slotArray.length;
        for (int i = 0; i < n; ++i) {
            Slot[] recipeSlot;
            for (Slot slot : recipeSlot = slotArray[i]) {
                if (distribution.containsKey(slot)) continue;
                distribution.put(slot, -1);
            }
        }
        HashSet avaliableSlots = new HashSet(distribution.keySet());
        HashSet<Integer> remainingIngreds = new HashSet<Integer>();
        ArrayList assignedSlots = new ArrayList();
        for (int i = 0; i < ingredients.size(); ++i) {
            remainingIngreds.add(i);
            assignedSlots.add(new LinkedList());
        }
        while (!avaliableSlots.isEmpty() && !remainingIngreds.isEmpty()) {
            Iterator iterator = remainingIngreds.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                boolean assigned = false;
                DistributedIngred istack = assignedIngredients.get((int)i).distrib;
                for (Slot slot : recipeSlots[i]) {
                    if (!avaliableSlots.contains(slot)) continue;
                    avaliableSlots.remove(slot);
                    if (slot.func_75216_d()) continue;
                    ++istack.numSlots;
                    ((LinkedList)assignedSlots.get(i)).add(slot);
                    assigned = true;
                    break;
                }
                if (assigned && istack.numSlots * istack.stack.func_77976_d() < istack.invAmount) continue;
                iterator.remove();
            }
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            assignedIngredients.get((int)i).slots = ((LinkedList)assignedSlots.get(i)).toArray(new Slot[0]);
        }
        return recipeSlots;
    }

    private List<IngredientDistribution> assignIngredients(List<PositionedStack> ingredients, List<DistributedIngred> ingredStacks) {
        ArrayList<IngredientDistribution> assignedIngredients = new ArrayList<IngredientDistribution>();
        for (PositionedStack posstack : ingredients) {
            DistributedIngred biggestIngred = null;
            ItemStack permutation = null;
            int biggestSize = 0;
            block1: for (ItemStack pstack : posstack.items) {
                for (DistributedIngred istack : ingredStacks) {
                    int relsize;
                    if (!this.canStack(pstack, istack.stack) || istack.invAmount - istack.distributed < pstack.field_77994_a || istack.recipeAmount == 0 || pstack.field_77994_a == 0 || (relsize = (istack.invAmount - istack.invAmount / istack.recipeAmount * istack.distributed) / pstack.field_77994_a) <= biggestSize) continue;
                    biggestSize = relsize;
                    biggestIngred = istack;
                    permutation = pstack;
                    continue block1;
                }
            }
            if (biggestIngred == null) {
                return null;
            }
            biggestIngred.distributed += permutation.field_77994_a;
            assignedIngredients.add(new IngredientDistribution(biggestIngred, permutation));
        }
        return assignedIngredients;
    }

    private void findInventoryQuantities(GuiContainer gui, List<DistributedIngred> ingredStacks) {
        for (Slot slot : gui.field_147002_h.field_75151_b) {
            ItemStack pstack;
            DistributedIngred istack;
            if (!slot.func_75216_d() || !this.canMoveFrom(slot, gui) || (istack = this.findIngred(ingredStacks, pstack = slot.func_75211_c())) == null) continue;
            istack.invAmount += pstack.field_77994_a;
        }
    }

    private List<DistributedIngred> getPermutationIngredients(List<PositionedStack> ingredients) {
        ArrayList<DistributedIngred> ingredStacks = new ArrayList<DistributedIngred>();
        for (PositionedStack posstack : ingredients) {
            for (ItemStack pstack : posstack.items) {
                DistributedIngred istack = this.findIngred(ingredStacks, pstack);
                if (istack == null) {
                    istack = new DistributedIngred(pstack);
                    ingredStacks.add(istack);
                }
                istack.recipeAmount += pstack.field_77994_a;
            }
        }
        return ingredStacks;
    }

    public boolean canMoveFrom(Slot slot, GuiContainer gui) {
        return slot.field_75224_c instanceof InventoryPlayer;
    }

    public Slot[][] mapIngredSlots(GuiContainer gui, List<PositionedStack> ingredients) {
        Slot[][] recipeSlotList = new Slot[ingredients.size()][];
        for (int i = 0; i < ingredients.size(); ++i) {
            LinkedList<Slot> recipeSlots = new LinkedList<Slot>();
            PositionedStack pstack = ingredients.get(i);
            for (Slot slot : gui.field_147002_h.field_75151_b) {
                if (slot.field_75223_e != pstack.relx + this.offsetx || slot.field_75221_f != pstack.rely + this.offsety) continue;
                recipeSlots.add(slot);
                break;
            }
            recipeSlotList[i] = recipeSlots.toArray(new Slot[0]);
        }
        return recipeSlotList;
    }

    public DistributedIngred findIngred(List<DistributedIngred> ingredStacks, ItemStack pstack) {
        for (DistributedIngred istack : ingredStacks) {
            if (!this.canStack(istack.stack, pstack)) continue;
            return istack;
        }
        return null;
    }

    protected boolean canStack(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return true;
        }
        if (NEIServerUtils.areStacksSameTypeCrafting(stack2, stack1)) {
            if (NBTHelper.matchTag((NBTBase)stack1.func_77978_p(), (NBTBase)stack2.func_77978_p())) {
                return true;
            }
            if ((gtItem != null && gtItem.isInstance(stack1.func_77973_b()) || stack1.func_77976_d() == 1 && stack2.func_77976_d() == 1) && stack1.field_77990_d == null ^ stack2.field_77990_d == null) {
                return true;
            }
        }
        return false;
    }

    static {
        try {
            ClassLoader loader = DefaultOverlayHandler.class.getClassLoader();
            gtItem = ReflectionHelper.getClass((ClassLoader)loader, (String[])new String[]{"gregtech.api.items.MetaBaseItem", "gregtech.api.items.GT_MetaBase_Item"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class IngredientDistribution {
        public DistributedIngred distrib;
        public ItemStack permutation;
        public Slot[] slots;

        public IngredientDistribution(DistributedIngred distrib, ItemStack permutation) {
            this.distrib = distrib;
            this.permutation = permutation;
        }
    }

    public static class DistributedIngred {
        public ItemStack stack;
        public int invAmount;
        public int distributed;
        public int numSlots;
        public int recipeAmount;

        public DistributedIngred(ItemStack item) {
            this.stack = InventoryUtils.copyStack((ItemStack)item, (int)1);
        }
    }
}

