/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.ItemStackAmount;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.RestartableTask;
import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.RecipeHandlerRef;
import codechicken.nei.recipe.chain.RecipeChainIterator;
import codechicken.nei.recipe.chain.RecipeChainMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class AutoCraftingManager {
    private static RecipeChainMath math;
    private static final RestartableTask task;

    private AutoCraftingManager() {
    }

    public static void runProcessing(RecipeChainMath math) {
        task.stop();
        AutoCraftingManager.math = math;
        if (AutoCraftingManager.math != null) {
            task.restart();
        }
    }

    public static boolean processing() {
        return math != null && !task.interrupted();
    }

    static {
        task = new RestartableTask("NEI Bookmark AutoCraft Processing"){
            private static final ItemStack ROOT_ITEM = new ItemStack((Block)Blocks.field_150480_ab);
            private static final Recipe.RecipeId ROOT_RECIPE_ID = Recipe.RecipeId.of(ROOT_ITEM, "recipe-autocrafting", Collections.emptyList());

            @Override
            public void execute() {
                GuiContainer guiContainer = NEIClientUtils.getGuiContainer();
                InventoryPlayer playerInventory = guiContainer.field_146297_k.field_71439_g.field_71071_by;
                ItemStackAmount inventory = ItemStackAmount.of(Arrays.asList(playerInventory.field_70462_a));
                RecipeChainMath math = this.createMasterRoot(math);
                List<BookmarkItem> initialItems = this.prepareInitialItems(math, inventory);
                boolean processed = false;
                boolean changed = false;
                do {
                    changed = false;
                    RecipeChainIterator iterator = new RecipeChainIterator(math, initialItems);
                    iterator.updateInventory(playerInventory.field_70462_a);
                    while (iterator.hasNext() && !this.interrupted(guiContainer)) {
                        Object recipes = iterator.next();
                        boolean craft = false;
                        for (Map.Entry entry : recipes.entrySet()) {
                            RecipeHandlerRef handler = RecipeHandlerRef.of((Recipe.RecipeId)entry.getKey());
                            if (handler != null && handler.canCraft(guiContainer)) {
                                long multiplier;
                                for (multiplier = ((Long)entry.getValue()).longValue(); multiplier > 0L && !this.interrupted(guiContainer) && handler.craft(guiContainer, (int)Math.min(64L, multiplier)); multiplier -= 64L) {
                                }
                                boolean bl = craft = multiplier != (Long)entry.getValue();
                            }
                            if (!this.interrupted(guiContainer)) continue;
                            break;
                        }
                        if (!craft) continue;
                        changed = true;
                        processed = true;
                        iterator.updateInventory(playerInventory.field_70462_a);
                    }
                } while (changed && !this.interrupted(guiContainer));
                if (processed && !changed && !this.interrupted(guiContainer)) {
                    NEIClientUtils.playClickSound();
                }
            }

            @Override
            public void clearTasks() {
                super.clearTasks();
                math = null;
            }

            private boolean interrupted(GuiContainer guiContainer) {
                return this.interrupted() || guiContainer != NEIClientUtils.getGuiContainer();
            }

            private RecipeChainMath createMasterRoot(RecipeChainMath math) {
                ArrayList<BookmarkItem> rootIngredients = new ArrayList<BookmarkItem>();
                for (BookmarkItem item : math.recipeResults) {
                    if (!math.outputRecipes.containsKey(item.recipeId)) continue;
                    long amount = item.factor * math.outputRecipes.get(item.recipeId);
                    rootIngredients.add(BookmarkItem.of(-1, item.getItemStack(amount), item.getStackSize(amount), ROOT_RECIPE_ID, true, BookmarkItem.generatePermutations(item.itemStack, null)));
                }
                math.outputRecipes.clear();
                math.outputRecipes.put(ROOT_RECIPE_ID, 1L);
                math.recipeResults.add(BookmarkItem.of(-1, ROOT_ITEM, 1L, ROOT_RECIPE_ID, false));
                math.recipeIngredients.addAll(rootIngredients);
                return math;
            }

            private List<BookmarkItem> prepareInitialItems(RecipeChainMath math, ItemStackAmount inventory) {
                ArrayList<BookmarkItem> initialItems = new ArrayList<BookmarkItem>();
                for (BookmarkItem item : math.initialItems) {
                    long invStackSize = inventory.getOrDefault(item.itemStack, 0L);
                    long amount = Math.max(0L, item.amount - invStackSize * (long)item.fluidCellAmount);
                    if (amount <= 0L) continue;
                    initialItems.add(item.copyWithAmount(amount));
                }
                return initialItems;
            }
        };
    }
}

