/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.enhancedlootbags.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import eu.usrv.enhancedlootbags.EnhancedLootBags;
import eu.usrv.enhancedlootbags.GuiHandler;
import eu.usrv.enhancedlootbags.StatHelper;
import eu.usrv.enhancedlootbags.core.LootGroupsHandler;
import eu.usrv.enhancedlootbags.core.serializer.LootGroups;
import eu.usrv.yamcore.auxiliary.LogHelper;
import eu.usrv.yamcore.auxiliary.PlayerChatHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemLootBag
extends Item {
    private IIcon _mIcoDefault;
    private final Map<Integer, IIcon> _mGroupIcons = new HashMap<Integer, IIcon>();
    private final LootGroupsHandler _mLGHandler;
    private LogHelper _mLogger = EnhancedLootBags.Logger;

    public ItemLootBag(LootGroupsHandler pLGHandler) {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this._mLGHandler = pLGHandler;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 15;
    }

    public int func_77619_b() {
        return 15;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister pIconRegister) {
        this._mIcoDefault = pIconRegister.func_94245_a(String.format("%s:lootbag_generic", "enhancedlootbags"));
        this._mGroupIcons.clear();
        for (LootGroups.LootGroup tGrp : this._mLGHandler.getLootGroups().getLootTable()) {
            tGrp.getGroupIconResource().ifPresent(icon -> this._mGroupIcons.put(tGrp.getGroupID(), pIconRegister.func_94245_a(icon)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return this._mGroupIcons.getOrDefault(meta, this._mIcoDefault);
    }

    public String func_77653_i(ItemStack pStack) {
        LootGroups.LootGroup tGrp;
        String tReturn = StatHelper.get("string.lootbag_templatename");
        String tInnerName = "?Error";
        tInnerName = pStack.func_77960_j() == 0 ? StatHelper.get("string.default") : ((tGrp = this._mLGHandler.getGroupByIDClient(pStack.func_77960_j())) == null ? "Error" : StatCollector.func_74838_a((String)tGrp.getGroupName()));
        return String.format(tReturn, tInnerName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (LootGroups.LootGroup tGrp : this._mLGHandler.getLootGroupsClient().getLootTable()) {
            ItemStack s1 = new ItemStack((Item)this, 1, tGrp.getGroupID());
            par3List.add(s1);
            if (!EnhancedLootBags.ELBCfg.AllowFortuneBags) continue;
            ItemStack s2 = s1.func_77946_l();
            s2.func_77966_a(Enchantment.field_77346_s, 3);
            par3List.add(s2);
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        LootGroups.LootGroup tGrp = this._mLGHandler.getGroupByIDClient(stack.func_77960_j());
        return tGrp == null ? EnumRarity.common : tGrp.getGroupRarity();
    }

    public ItemStack func_77659_a(ItemStack pStack, World pWorld, EntityPlayer pPlayer) {
        if (!pWorld.field_72995_K) {
            int tFortuneLevel;
            if (pPlayer.field_71075_bZ.field_75098_d && pPlayer.func_70093_af()) {
                pPlayer.openGui((Object)EnhancedLootBags.instance, GuiHandler.GUI_LOOTBAG, pWorld, (int)pPlayer.field_70165_t, (int)pPlayer.field_70163_u, (int)pPlayer.field_70161_v);
                return pStack;
            }
            int tGroupID = pStack.func_77960_j();
            LootGroups.LootGroup tGrp = this._mLGHandler.getMergedGroupFromID(tGroupID, tFortuneLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)pStack));
            if (tGrp != null) {
                int q = tGrp.getMinItems();
                if (tGrp.getMaxItems() > tGrp.getMinItems()) {
                    q = pWorld.field_73012_v.nextInt(tGrp.getMaxItems()) + 1;
                }
                while (q > 0) {
                    List<ItemStack> isList = this.getRandomLootItems(pPlayer, tGrp);
                    if (isList.isEmpty()) {
                        PlayerChatHelper.SendNotifyWarning((EntityPlayer)pPlayer, (String)StatHelper.get("string.try_again"));
                        return pStack;
                    }
                    q -= isList.size();
                    for (ItemStack tStack : isList) {
                        try {
                            EntityItem eti = new EntityItem(pWorld, pPlayer.field_70165_t, pPlayer.field_70163_u, pPlayer.field_70161_v, tStack.func_77946_l());
                            eti.field_145804_b = 0;
                            pWorld.func_72838_d((Entity)eti);
                        }
                        catch (Exception e) {
                            this._mLogger.error((Object)"Unable to spawn dropitem in world");
                            e.printStackTrace();
                        }
                    }
                }
                pWorld.func_72956_a((Entity)pPlayer, String.format("%s:lootbag_open", "enhancedlootbags"), 0.75f, 1.0f);
                --pStack.field_77994_a;
            } else {
                PlayerChatHelper.SendNotifyWarning((EntityPlayer)pPlayer, (String)StatHelper.get("string.sorry_damaged"));
            }
        }
        return pStack;
    }

    private List<ItemStack> getRandomLootItems(EntityPlayer player, LootGroups.LootGroup pGrp) {
        ArrayList<ItemStack> tReturnList = new ArrayList<ItemStack>();
        ArrayList<LootGroups.LootGroup.Drop> tPendingDrops = new ArrayList<LootGroups.LootGroup.Drop>();
        int tMaxRuns = 0;
        LootGroups.LootGroup.Drop tSelectedDrop = null;
        do {
            double tRnd = EnhancedLootBags.Rnd.nextDouble() * (double)pGrp.getMaxWeight();
            for (LootGroups.LootGroup.Drop tDr : pGrp.getDrops()) {
                if (!((tRnd -= (double)tDr.getChance()) <= 0.0)) continue;
                tSelectedDrop = tDr;
                break;
            }
            if (tSelectedDrop == null) continue;
            List<LootGroups.LootGroup.Drop> tPossibleItemDrops = this._mLGHandler.getItemGroupDrops(pGrp, tSelectedDrop);
            for (LootGroups.LootGroup.Drop dr : tPossibleItemDrops) {
                if (!this._mLGHandler.isDropAllowedForPlayer(player, pGrp, dr, true)) continue;
                tPendingDrops.add(dr);
            }
            for (LootGroups.LootGroup.Drop td : tPendingDrops) {
                ItemStack tStackAll;
                int tAmount = td.getAmount();
                if (td.getIsRandomAmount()) {
                    tAmount = EnhancedLootBags.Rnd.nextInt(tAmount) + 1;
                }
                if ((tStackAll = td.getItemStack(tAmount)) == null) {
                    this._mLogger.error((Object)String.format("Skipping loot %s; Unable to get ItemStack. Make sure this item exists!", td.getItemName()));
                    continue;
                }
                while (tStackAll.field_77994_a > tStackAll.func_77976_d()) {
                    tReturnList.add(tStackAll.func_77979_a(tStackAll.func_77976_d()));
                }
                tReturnList.add(tStackAll);
            }
        } while (tReturnList.isEmpty() && ++tMaxRuns < 10);
        return tReturnList;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack pItemStack, EntityPlayer pEntityPlayer, List pTooltipList, boolean pSomeBooleanValue) {
        if (EnhancedLootBags.ELBCfg.AllowFortuneBags) {
            int tFortuneLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)pItemStack);
            if (tFortuneLevel == 0) {
                pTooltipList.add(StatHelper.get("string.not_fortuned"));
            } else {
                pTooltipList.add(String.format(StatHelper.get("string.fortuned"), tFortuneLevel == 3 ? 100 : 33 * tFortuneLevel));
            }
        }
    }
}

