/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.notifications;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import dev.rndmorris.salisarcana.SalisArcana;
import dev.rndmorris.salisarcana.config.ConfigModuleRoot;
import dev.rndmorris.salisarcana.notifications.VersionInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Comparator;
import java.util.List;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class Updater {
    public boolean hasCheckedVersion = !ConfigModuleRoot.enableVersionChecking;
    private static final String versionURL = "https://api.modrinth.com/v2/project/y1bqIjK6/version";

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!this.hasCheckedVersion) {
            this.hasCheckedVersion = true;
            VersionInfo newVersion = this.checkForNewVersion();
            if (newVersion != null) {
                event.player.func_145747_a((IChatComponent)new ChatComponentTranslation("salisarcana:update_available", new Object[]{newVersion.getVersionNumber()}));
                ChatComponentTranslation message = new ChatComponentTranslation("salisarcana:update_link", new Object[0]);
                message.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://modrinth.com/mod/salis-arcana/version/" + newVersion.getVersionNumber()));
                event.player.func_145747_a((IChatComponent)message);
            }
        }
    }

    private VersionInfo checkForNewVersion() {
        try {
            URL url = new URL(versionURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                SalisArcana.LOG.error("Version Check Failed: HTTP GET Request Failed with Error Code : {}", new Object[]{conn.getResponseCode()});
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            Gson gson = new Gson();
            List versions = (List)gson.fromJson((Reader)reader, new TypeToken<List<VersionInfo>>(){}.getType());
            reader.close();
            conn.disconnect();
            versions.sort(Comparator.comparing(VersionInfo::getVersionNumber).reversed());
            VersionInfo latestVersion = (VersionInfo)versions.get(0);
            if (!latestVersion.getVersionNumber().equals("1.1.10-GTNH")) {
                return latestVersion;
            }
        }
        catch (Exception e) {
            SalisArcana.LOG.error((Object)e);
        }
        return null;
    }
}

