/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ArrayHelper {
    public static String[] appendToArray(String[] array, String newValue) {
        ArrayList<String> list = new ArrayList<String>();
        if (array != null) {
            Collections.addAll(list, array);
        }
        list.add(newValue);
        return list.toArray(new String[0]);
    }

    public static boolean tryAssign(boolean[] arr, int index, boolean value) {
        if (0 <= index && index < arr.length) {
            arr[index] = value;
            return true;
        }
        return false;
    }

    public static <E> TryGetResult<E> tryGet(E[] arr, int index) {
        if (0 <= index && index < arr.length) {
            return TryGetResult.success(arr[index]);
        }
        return TryGetResult.failure();
    }

    @Nonnull
    public static <T> List<T> toList(@Nullable T[] arr) {
        return ArrayHelper.toList(arr, ArrayList::new);
    }

    @Nonnull
    public static <T> List<T> toList(@Nullable T[] arr, Supplier<List<T>> listType) {
        List<T> result = listType.get();
        if (arr != null) {
            Collections.addAll(result, arr);
        }
        return result;
    }

    public static final class TryGetResult<E> {
        private final boolean success;
        private final E data;

        public TryGetResult(boolean success, E data) {
            this.success = success;
            this.data = data;
        }

        public static <E> TryGetResult<E> failure() {
            return new TryGetResult<Object>(false, null);
        }

        public static <E> TryGetResult<E> success(E data) {
            return new TryGetResult<E>(true, data);
        }

        public String toString() {
            return "TryGetResult[" + "success=" + this.success + "," + "data=" + this.data + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.success ? 1 : 0);
            result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (((TryGetResult)arg0).success != this.success) {
                return false;
            }
            return Objects.equals(((TryGetResult)arg0).data, this.data);
            {
            }
        }

        public boolean success() {
            return this.success;
        }

        public E data() {
            return this.data;
        }
    }
}

